/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.presentation;

import com.indy.emf.uri.navigator.duplicated.LevelMdIConResourceLabelProvider;
import com.indy.environment.tool.EnvUtil;
import com.indy.ui.custom.out.CustomResourceItemProviderAdapterFactory;
import com.indy.ui.custom.out.EditorInputManager;
import com.indy.ui.custom.out.IMetaDataModelProvider;
import com.indy.ui.custom.out.PropertiesBrowserPage;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.tools.CustomCompositeImageDescriptor;
import com.indy.ui.custom.out.widgets.NoTitleViewerPane;
import com.semarchy.xdi.designer.core.models.ActionProcessRefCapability;
import com.semarchy.xdi.designer.core.models.IRebuildableUI;
import com.semarchy.xdi.designer.core.models.IWithDisposable;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.models.MetaDataLinkCapability;
import com.semarchy.xdi.designer.core.models.OutdatedModelDiagnostic;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdFactory;
import com.stambia.md.MdLink;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.NoCommandStackNotification;
import com.stambia.md.Template;
import com.stambia.md.impl.ConfigurationImpl;
import com.stambia.md.presentation.MdEditorPlugin;
import com.stambia.md.presentation.Messages;
import com.stambia.md.presentation.internal.DependenciesResourceChangeListener;
import com.stambia.md.provider.MdItemProviderAdapterFactory;
import com.stambia.tech.Level;
import com.stambia.tech.PropertyType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class MdEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker,
ITabbedPropertySheetPageContributor,
IMetaDataModelProvider {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected IPropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected TreeViewer treeViewer;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper(){

        public void deleteMarkers(Object object, boolean includeSubtypes, int depth) {
            super.deleteMarkers(object, includeSubtypes, depth);
        }
    };
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == MdEditor.this.contentOutlinePage) {
                    MdEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MdEditor.this);
                    MdEditor.this.setCurrentViewer((Viewer)MdEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == MdEditor.this.propertySheetPage) {
                    MdEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MdEditor.this);
                    MdEditor.this.handleActivate();
                }
            } else if (p == MdEditor.this) {
                MdEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new HashSet<Resource>();
    protected Collection<Resource> addedResources = new HashSet<Resource>();
    protected Collection<Resource> changedResources = new HashSet<Resource>();
    protected Collection<Resource> savedResources = new HashSet<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    private DependenciesResourceChangeListener dependenciesCacheListener = null;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = MdEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            MdEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            MdEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!MdEditor.this.updateProblemIndication) return;
                        MdEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MdEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;
                    protected Collection<Resource> addedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).MdEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                        this.addedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1) {
                            IFile file;
                            URI uri;
                            Resource resource;
                            if ((delta.getKind() & 6) != 0) {
                                IFile file2 = (IFile)delta.getResource();
                                URI uri2 = Util.convertIFileToEMFURI((IFile)file2);
                                Resource resource2 = this.resourceSet.getResource(uri2, false);
                                if (resource2 != null) {
                                    if ((delta.getKind() & 2) != 0) {
                                        this.removedResources.add(resource2);
                                    } else if (!(this).MdEditor.this.savedResources.remove(resource2)) {
                                        this.changedResources.add(resource2);
                                    }
                                }
                            } else if ((delta.getKind() & 1) != 0 && (resource = this.resourceSet.getResource(uri = Util.convertIFileToEMFURI((IFile)(file = (IFile)delta.getResource())), false)) != null) {
                                this.addedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }

                    public Collection<Resource> getAddedResources() {
                        return this.addedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                MdEditor.this.addedResources.addAll(visitor.getAddedResources());
                if (!visitor.getRemovedResources().isEmpty()) {
                    MdEditor.this.removedResources.addAll(visitor.getRemovedResources());
                    if (MdEditor.this.removedResources.contains(MdEditor.this.getEditingDomain().getResourceSet().getResources().get(0))) {
                        MdEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MdEditor.this.getSite().getPage().closeEditor((IEditorPart)MdEditor.this, false);
                            }
                        });
                        return;
                    }
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    MdEditor.this.changedResources.addAll(visitor.getChangedResources());
                    if (MdEditor.this.getSite().getPage().getActiveEditor() == MdEditor.this) {
                        MdEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MdEditor.this.handleActivate();
                            }
                        });
                    }
                }
            }
            catch (CoreException exception) {
                MdEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected static Collection<Object> clipBoard;
    public static final String CONTEXT_ID = "com.indy.md.ui.editor.context1";
    TabbedPropertySheetPage tpsp;
    PropertiesBrowserPage pbp;
    private ISelectionChangedListener contentOutlinePageSelectionListener;
    IExtensionActivationListener mdIconListener = new IExtensionActivationListener(){

        public void onExtensionActivation(String aViewerId, String[] theNavigatorExtensionIds, boolean isActive) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MdEditor.this.init(MdEditor.this.getEditorSite(), MdEditor.this.getEditorInput());
                }
            });
        }
    };

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        this.addedResources.removeAll(this.removedResources);
        this.addedResources.removeAll(this.changedResources);
        for (Resource r : this.addedResources) {
            if (r.isLoaded()) {
                r.unload();
            }
            try {
                r.load(Collections.EMPTY_MAP);
            }
            catch (IOException exception) {
                if (this.resourceToDiagnosticMap.containsKey(r)) continue;
                this.resourceToDiagnosticMap.put(r, this.analyzeResourceProblems(r, exception));
            }
        }
        this.addedResources.clear();
        if (!this.removedResources.isEmpty()) {
            for (Resource r : this.removedResources) {
                if (r.isLoaded()) {
                    r.unload();
                }
                try {
                    r.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(r)) continue;
                    this.resourceToDiagnosticMap.put(r, this.analyzeResourceProblems(r, exception));
                }
            }
            this.removedResources.clear();
        }
        if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        boolean handleReload = false;
        if (this.getEditingDomain().getResourceSet().getResources().size() > 0 && this.changedResources.contains(this.getEditingDomain().getResourceSet().getResources().get(0)) && (!this.isDirty() || this.handleDirtyConflict())) {
            handleReload = true;
        }
        if (!this.isDirty() || handleReload) {
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "com.indy.md.ui.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                diagnostic.getSeverity();
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    MdEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        MdEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)MdEditor.getString("_UI_FileConflict_label"), (String)MdEditor.getString("_WARN_FileConflict"));
    }

    public MdEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new CustomResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MdItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        TransactionalEditingDomainImpl domain = new TransactionalEditingDomainImpl((AdapterFactory)this.adapterFactory){

            public Collection<Object> getClipboard() {
                return clipBoard;
            }

            public void setClipboard(Collection<Object> _clipboard) {
                clipBoard = _clipboard;
            }
        };
        domain.getResourceSet().setURIConverter((URIConverter)new InternalResourceURIConverter());
        ((TransactionalEditingDomainImpl.FactoryImpl)TransactionalEditingDomain.Factory.INSTANCE).mapResourceSet((TransactionalEditingDomain)domain);
        domain.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                if (!MdEditor.this.getContainer().isDisposed()) {
                    final Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                    if (mostRecentCommand != null && mostRecentCommand.getClass().isAnnotationPresent(NoCommandStackNotification.class)) {
                        return;
                    }
                    MdEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MdEditor.this.firePropertyChange(257);
                            if (mostRecentCommand != null && mostRecentCommand instanceof CreateChildCommand) {
                                MdEditor.this.setSelectionToViewer(((CreateChildCommand)mostRecentCommand).getResult());
                            }
                            if ((this).MdEditor.this.propertySheetPage != null && (this).MdEditor.this.propertySheetPage.getControl() != null && !(this).MdEditor.this.propertySheetPage.getControl().isDisposed()) {
                                try {
                                    ((TabbedPropertySheetPage)(this).MdEditor.this.propertySheetPage).refresh();
                                }
                                catch (NullPointerException nullPointerException) {}
                            }
                        }
                    });
                }
            }
        });
        this.editingDomain = (AdapterFactoryEditingDomain)domain;
        domain.addResourceSetListener(new ResourceSetListener(){

            public NotificationFilter getFilter() {
                return NotificationFilter.createFeatureFilter((EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Values()).or(NotificationFilter.createNotifierTypeFilter((EClassifier)MdPackage.eINSTANCE.getMdNode()).and(NotificationFilter.createFeatureFilter((EStructuralFeature)MdPackage.eINSTANCE.getElement_Name())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)MdPackage.eINSTANCE.getElement_Position())));
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                return null;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                final ArrayList<WeakReference<ConfigurationImpl>> toRefresh = new ArrayList<WeakReference<ConfigurationImpl>>();
                for (Notification n : event.getNotifications()) {
                    ConfigurationImpl node = null;
                    if (n.getNotifier() instanceof Attribute) {
                        EObject c = ((EObject)n.getNotifier()).eContainer();
                        if (c instanceof Configuration) {
                            node = (ConfigurationImpl)c;
                        }
                    } else if (n.getNotifier() instanceof Configuration) {
                        node = (ConfigurationImpl)n.getNotifier();
                        if (n.getFeature() == MdPackage.eINSTANCE.getElement_Position()) {
                            boolean updateLabel = false;
                            Level l = node.getLevel();
                            if (l != null) {
                                boolean bl = updateLabel = l.getXpathDisplayName() != null && !l.getXpathDisplayName().isEmpty() || l.getXpathIcon() != null && !l.getXpathIcon().isEmpty() || !l.getIcons().isEmpty();
                            }
                            if (!updateLabel) continue;
                        }
                    }
                    toRefresh.add(new WeakReference<ConfigurationImpl>(node));
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (WeakReference ref : toRefresh) {
                            ConfigurationImpl c = (ConfigurationImpl)ref.get();
                            if (c == null) continue;
                            c.clearCachedIcons();
                            TreeViewer v = (TreeViewer)MdEditor.this.getViewer();
                            if (v == null || v.getControl().isDisposed()) continue;
                            v.refresh((Object)c, true);
                        }
                    }
                });
            }

            public boolean isAggregatePrecommitListener() {
                return false;
            }

            public boolean isPrecommitOnly() {
                return false;
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        });
        ICacheService s = (ICacheService)PlatformUI.getWorkbench().getService(ICacheService.class);
        if (s != null) {
            this.dependenciesCacheListener = new DependenciesResourceChangeListener(this.getEditingDomain().getResourceSet());
            s.addEventListener((ICacheService.ICacheSourceEventListener)this.dependenciesCacheListener);
        }
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (MdEditor.this.currentViewer != null) {
                        MdEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        MdEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer){

            protected Collection<?> extractDragSource(Object object) {
                Collection result = super.extractDragSource(object);
                if (result instanceof List && ((List)result).size() > 0) {
                    Object firstElement = ((List)result).get(0);
                    EObject firstObject = null;
                    if (firstElement instanceof IFile) {
                        firstObject = Util.getRootElement((IFile)((IFile)firstElement), (ResourceSet)MdEditor.this.editingDomain.getResourceSet());
                    } else if (firstElement instanceof PlatformObject) {
                        firstObject = (EObject)((PlatformObject)((List)result).get(0)).getAdapter(EObject.class);
                    }
                    if (firstObject != null) {
                        if (firstObject instanceof MetaDataLinkCapability) {
                            MetaDataLinkCapability mdlc = (MetaDataLinkCapability)firstObject;
                            MdLink mdl = MdFactory.eINSTANCE.createMdLink();
                            mdl.setName(mdlc.getMetaDataLinkName());
                            ArrayList<MdLink> list = new ArrayList<MdLink>();
                            list.add(mdl);
                            mdl.setTarget((EObject)mdlc);
                            return list;
                        }
                        if (firstObject instanceof ActionProcessRefCapability) {
                            ActionProcessRefCapability aprc = (ActionProcessRefCapability)firstObject;
                            Template tpl = MdFactory.eINSTANCE.createTemplate();
                            tpl.setTarget((EObject)aprc);
                            ArrayList<Template> list = new ArrayList<Template>();
                            list.add(tpl);
                            return list;
                        }
                    }
                }
                return result;
            }
        });
    }

    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(2, "com.indy.md.ui.editor", 0, MdEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)false));
            boolean addedWarning = false;
            for (Resource.Diagnostic d : resource.getWarnings()) {
                Diagnostic diagnostic = null;
                if (d instanceof Throwable) {
                    diagnostic = BasicDiagnostic.toDiagnostic((Throwable)((Throwable)d));
                } else if (!(d instanceof OutdatedModelDiagnostic)) {
                    diagnostic = new BasicDiagnostic(2, "org.eclipse.emf.ecore.resource", 0, d.getMessage(), new Object[]{d});
                }
                if (diagnostic == null) continue;
                basicDiagnostic.add(diagnostic);
                addedWarning = true;
            }
            if (!addedWarning && resource.getErrors().isEmpty()) {
                return Diagnostic.OK_INSTANCE;
            }
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "com.indy.md.ui.editor", 0, MdEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected TreeViewer creatMainTreeViewer(Composite composite) {
        return new TreeViewer(composite);
    }

    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty() && !((Resource)this.getEditingDomain().getResourceSet().getResources().get(0)).getContents().isEmpty()) {
            this.treeViewer = this.creatMainTreeViewer(this.getContainer());
            this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){
                AtomicBoolean refresh;
                {
                    this.refresh = new AtomicBoolean(false);
                }

                public void notifyChanged(Notification notification) {
                    if (notification.getEventType() == -9999 && !this.refresh.getAndSet(true)) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Display.getDefault().timerExec(500, new Runnable(){

                                    @Override
                                    public void run() {
                                        refresh.set(false);
                                        if (((this).this).MdEditor.this.treeViewer.getControl() != null && !((this).this).MdEditor.this.treeViewer.getControl().isDisposed()) {
                                            TabContents d;
                                            ((this).this).MdEditor.this.treeViewer.refresh();
                                            PropertiesBrowserPage page = (PropertiesBrowserPage)MdEditor.this.getAdapter(PropertiesBrowserPage.class);
                                            if (page instanceof TabbedPropertySheetPage && (d = page.getCurrentTab()) != null) {
                                                ISection[] iSectionArray = d.getSections();
                                                int n = iSectionArray.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    ISection section = iSectionArray[n2];
                                                    if (section instanceof IRebuildableUI) {
                                                        ((IRebuildableUI)section).forceRebuildUI();
                                                    }
                                                    ++n2;
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                        });
                    }
                    super.notifyChanged(notification);
                }
            });
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    for (Object o : ((IStructuredSelection)event.getSelection()).toList()) {
                        if (MdEditor.this.treeViewer.getExpandedState(o)) {
                            MdEditor.this.treeViewer.setExpandedState(o, false);
                            continue;
                        }
                        MdEditor.this.treeViewer.setExpandedState(o, true);
                    }
                }
            });
            new AdapterFactoryTreeEditor(this.treeViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.treeViewer.setInput(this.getEditingDomain().getResourceSet().getResources().get(0));
            this.createContextMenuFor((StructuredViewer)this.treeViewer);
            int pageIndex = this.addPage((Control)(this.treeViewer.getControl().getParent() instanceof CTabFolder ? this.treeViewer.getControl() : this.treeViewer.getControl().getParent().getParent()));
            this.setPageText(pageIndex, MdEditor.getString("_UI_TreePage_label"));
            NoTitleViewerPane viewerPane = new NoTitleViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    Tree tree = new Tree(composite, 2);
                    TreeViewer newTreeViewer = new TreeViewer(tree);
                    return newTreeViewer;
                }

                public void requestActivation() {
                    super.requestActivation();
                    MdEditor.this.setCurrentViewerPane((ViewerPane)this);
                }
            };
            viewerPane.createControl(this.getContainer());
            this.selectionViewer = (TreeViewer)viewerPane.getViewer();
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            this.selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    for (Object o : ((IStructuredSelection)event.getSelection()).toList()) {
                        if (MdEditor.this.selectionViewer.getExpandedState(o)) {
                            MdEditor.this.selectionViewer.setExpandedState(o, false);
                            continue;
                        }
                        MdEditor.this.selectionViewer.setExpandedState(o, true);
                    }
                }
            });
            viewerPane.setTitle((Object)this.editingDomain.getResourceSet());
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            if (EnvUtil.isAdvancedDeveloperMode()) {
                int pageIndex2 = this.addPage(viewerPane.getControl());
                this.setPageText(pageIndex2, MdEditor.getString("_UI_SelectionPage_label"));
            }
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EObject obj;
                    URI uri;
                    MdEditor.this.setActivePage(0);
                    if (MdEditor.this.getEditorInput() instanceof URIEditorInput && (uri = ((URIEditorInput)MdEditor.this.getEditorInput()).getURI()).fragment() != null && (obj = MdEditor.this.editingDomain.getResourceSet().getEObject(uri, false)) != null) {
                        ((StructuredViewer)MdEditor.this.getViewer()).reveal((Object)obj);
                        MdEditor.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)obj));
                    }
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    MdEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MdEditor.this.updateProblemIndication();
            }
        });
        try {
            ((IContextService)this.getSite().getService(IContextService.class)).activateContext(CONTEXT_ID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, MdEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key == EditingDomain.class) {
            return this.editingDomain;
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    MdEditor.this.contentOutlineViewer = this.getTreeViewer();
                    MdEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    MdEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)MdEditor.this.adapterFactory));
                    MdEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)MdEditor.this.adapterFactory));
                    MdEditor.this.contentOutlineViewer.setInput((Object)MdEditor.this.editingDomain.getResourceSet());
                    MdEditor.this.createContextMenuFor((StructuredViewer)MdEditor.this.contentOutlineViewer);
                    if (!MdEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        MdEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(MdEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    MdEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    MdEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePageSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MdEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            };
            this.contentOutlinePage.addSelectionChangedListener(this.contentOutlinePageSelectionListener);
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null || ((PropertiesBrowserPage)this.propertySheetPage).isDisposed()) {
            this.propertySheetPage = new PropertiesBrowserPage(this){

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    if (MdEditor.this.getActionBarContributor() != null) {
                        MdEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                    }
                }
            };
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            if (this.currentViewerPane.getViewer() == this.selectionViewer) {
                ArrayList selectionList = new ArrayList();
                selectionList.add(selectedElement);
                while (selectedElements.hasNext()) {
                    selectionList.add(selectedElements.next());
                }
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            } else if (this.currentViewerPane.getViewer().getInput() != selectedElement) {
                this.currentViewerPane.getViewer().setInput(selectedElement);
                this.currentViewerPane.setTitle(selectedElement);
            }
        }
    }

    public boolean isDirty() {
        if (this.editingDomain == null) {
            return false;
        }
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Resource resource = (Resource)MdEditor.this.editingDomain.getResourceSet().getResources().get(0);
                if (!MdEditor.this.editingDomain.isReadOnly(resource)) {
                    try {
                        MdEditor.this.savedResources.add(resource);
                        resource.save(saveOptions);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        MdEditor.this.resourceToDiagnosticMap.put(resource, MdEditor.this.analyzeResourceProblems(resource, exception));
                        throw new InvocationTargetException(exception, exception.getMessage());
                    }
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            MdEditorPlugin.INSTANCE.log(exception);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.MdEditor_15, (String)(String.valueOf(Messages.MdEditor_16) + exception.getMessage()));
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            MdEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        if (editorInput instanceof URIEditorInput && ((URIEditorInput)editorInput).getURI().isPlatformPlugin()) {
            CustomCompositeImageDescriptor.INSTANCE.setImages(this.getConfigurationElement(), CustomCompositeImageDescriptor.LOCKER_IMAGE_URL);
            this.setTitleImage(CustomCompositeImageDescriptor.INSTANCE.createImage());
        }
        URI uri = null;
        if (editorInput instanceof FileEditorInput) {
            uri = Util.convertIFileToEMFURI((IFile)((FileEditorInput)editorInput).getFile());
        } else if (editorInput instanceof URIEditorInput) {
            uri = ((URIEditorInput)editorInput).getURI();
        }
        if (uri != null) {
            IViewPart projectExplorer;
            String id;
            ICacheService s = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
            if (s != null && (id = s.getSourceId(uri)) != null) {
                ((TransactionalEditingDomain)this.getEditingDomain()).setID(id);
            }
            if ((projectExplorer = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer")) != null) {
                boolean showProductIcons = ((ProjectExplorer)projectExplorer).getCommonViewer().getNavigatorContentService().getActivationService().isNavigatorExtensionActive("com.indy.emf.uri.mdLevelNavigatorContent");
                ((ProjectExplorer)projectExplorer).getCommonViewer().getNavigatorContentService().getActivationService().addExtensionActivationListener(this.mdIconListener);
                if (showProductIcons) {
                    IFile file = Util.convertEMFURIToFile((URI)uri);
                    LevelMdIConResourceLabelProvider provider = new LevelMdIConResourceLabelProvider();
                    Image icon = provider.getImage((Object)file);
                    this.setTitleImage(icon);
                } else {
                    try {
                        Image mdImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.md.ui.editor/icons/full/obj16/MdModelFile.gif")).createImage();
                        this.setTitleImage(mdImage);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void setFocus() {
        if (this.currentViewerPane != null) {
            this.currentViewerPane.setFocus();
        } else {
            this.getControl(this.getActivePage()).setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionChangedListeners != null) {
            this.selectionChangedListeners.remove(listener);
        }
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : new ArrayList<ISelectionChangedListener>(this.selectionChangedListeners)) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(MdEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(MdEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(MdEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return MdEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return MdEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        ICacheService s = (ICacheService)PlatformUI.getWorkbench().getService(ICacheService.class);
        if (s != null && this.dependenciesCacheListener != null) {
            s.removeEventListener((ICacheService.ICacheSourceEventListener)this.dependenciesCacheListener);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        try {
            ((TransactionalEditingDomain)this.editingDomain).dispose();
            for (Resource resource : new ArrayList(this.editingDomain.getResourceSet().getResources())) {
                try {
                    if (resource instanceof IWithDisposable) {
                        ((IWithDisposable)resource).releaseDisposable();
                    }
                    resource.unload();
                    this.editingDomain.getResourceSet().getResources().remove((Object)resource);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.updateProblemIndication = false;
            this.getSite().getPage().removePartListener(this.partListener);
            this.adapterFactory.dispose();
            if (this.getActionBarContributor() != null && this.getActionBarContributor().getActiveEditor() == this) {
                EditingDomainActionBarContributor edabc = this.getActionBarContributor();
                edabc.setActiveEditor(null);
            }
            if (this.propertySheetPage != null) {
                this.propertySheetPage.dispose();
                this.propertySheetPage = null;
            }
            if (this.contentOutlinePage != null) {
                if (this.contentOutlinePageSelectionListener != null) {
                    this.contentOutlinePage.removeSelectionChangedListener(this.contentOutlinePageSelectionListener);
                }
                this.contentOutlinePage.dispose();
                this.contentOutlinePage = null;
            }
            this.editingDomain = null;
            this.resourceChangeListener = null;
            this.problemIndicationAdapter = null;
            this.resourceToDiagnosticMap = null;
            if (this.savedResources != null) {
                this.savedResources.clear();
            }
            this.savedResources = null;
            if (this.changedResources != null) {
                this.changedResources.clear();
            }
            this.changedResources = null;
            if (this.removedResources != null) {
                this.removedResources.clear();
            }
            this.removedResources = null;
            this.partListener = null;
            this.markerHelper = null;
            this.editorSelection = null;
            if (this.currentViewer != null && this.selectionChangedListener != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            this.selectionChangedListener = null;
            this.selectionChangedListeners.clear();
            this.selectionChangedListeners = null;
            this.selectionViewer = null;
            this.currentViewer = null;
            this.currentViewerPane = null;
            this.treeViewer = null;
            this.contentOutlinePageSelectionListener = null;
            this.contentOutlineStatusLineManager = null;
            this.contentOutlineViewer = null;
            this.adapterFactory = null;
            this.getEditorSite().setSelectionProvider(null);
            super.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean showOutlineView() {
        return true;
    }

    public String getContributorId() {
        return "com.indy.md.ui.diagram";
    }

    public String getTitleToolTip() {
        String res;
        if (this.getEditorInput() != null && (res = EditorInputManager.getTooltip((IEditorInput)this.getEditorInput())) != null) {
            return res;
        }
        return super.getTitleToolTip();
    }

    public Collection<URI> getUsedMetadataModels() {
        HashSet<URI> res = new HashSet<URI>();
        HashSet<String> modelIds = new HashSet<String>();
        String rootId = null;
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            EObject o = EMFResourceUtil.getRootElement((Resource)((Resource)this.getEditingDomain().getResourceSet().getResources().get(0)));
            if (o instanceof MdNode) {
                rootId = ((MdNode)o).getId();
            }
            if (o != null) {
                TreeIterator it = o.eAllContents();
                while (it.hasNext()) {
                    EObject n = (EObject)it.next();
                    if (n instanceof Configuration) {
                        for (Attribute att : ((Configuration)n).getAttribute()) {
                            String i;
                            if (att.getTechProperty() == null || att.getTechProperty().getType() != PropertyType.REFERENCE) continue;
                            if (att.getTechProperty().isUnbounded()) {
                                for (EObject r : att.getRefs()) {
                                    String i2 = CacheHelper.extractFileID((EObject)r);
                                    if (i2 == null) continue;
                                    modelIds.add(i2);
                                }
                                continue;
                            }
                            if (att.getRef() == null || (i = CacheHelper.extractFileID((EObject)att.getRef())) == null) continue;
                            modelIds.add(i);
                        }
                        continue;
                    }
                    if (n instanceof MdLink) {
                        String i;
                        if (((MdLink)n).getTarget() == null || (i = CacheHelper.extractFileID((EObject)((MdLink)n).getTarget())) == null) continue;
                        modelIds.add(i);
                        continue;
                    }
                    it.prune();
                }
            }
        }
        modelIds.remove(rootId);
        for (String s : modelIds) {
            URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(s);
            if (uri == null) continue;
            res.add(uri);
        }
        return res;
    }

    public IMetaDataModelProvider.Mode getMode() {
        return IMetaDataModelProvider.Mode.MD;
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

