/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.presentation;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.PropertiesBrowserPage;
import com.indy.ui.custom.out.action.editor.EmfActionsReplacer;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdNode;
import com.stambia.md.presentation.LevelFilterPopup;
import com.stambia.md.presentation.MdEditor;
import com.stambia.md.presentation.Messages;
import com.stambia.tech.Level;
import com.stambia.tech.Tech;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class MdEditorForm
extends MdEditor {
    private static final boolean oldMode = Boolean.valueOf(Activator.getDefault().readProperty("useOldEmfEditor", "false"));
    private static Image filter;
    private EmfActionsReplacer copyPasteActionManager;
    private PropertiesBrowserPage page;
    private FormToolkit toolkit;
    private ISelectionChangedListener treeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (!event.getSelection().isEmpty()) {
                MdEditorForm.this.page.selectionChanged((IWorkbenchPart)MdEditorForm.this, event.getSelection());
            }
        }
    };
    private ISelectionChangedListener actionReplacerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Viewer v = MdEditorForm.this.getViewer();
            if (!MdEditorForm.this.copyPasteActionManager.isInited()) {
                MdEditorForm.this.copyPasteActionManager.init(MdEditorForm.this.getEditorSite(), Arrays.asList(v), MdEditorForm.this.page);
            } else {
                v.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    };
    LevelCodeFilter patternFilter = new LevelCodeFilter();

    static {
        try {
            filter = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.md.ui.edit/icons/full/custom/file.filter.png")).createImage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected TreeViewer creatMainTreeViewer(Composite composite) {
        if (oldMode) {
            return super.creatMainTreeViewer(composite);
        }
        this.patternFilter.init();
        FilteredTree tf = new FilteredTree(composite, 2818, this.patternFilter, true){
            private String previousFilterText;
            private boolean narrowingDown;
            private volatile boolean instantRefresh;
            {
                this.instantRefresh = false;
            }

            protected long getRefreshJobDelay() {
                if (this.instantRefresh) {
                    this.instantRefresh = false;
                    return 10L;
                }
                return super.getRefreshJobDelay();
            }

            protected Composite createFilterControls(Composite parent) {
                Composite main = super.createFilterControls(parent);
                GridLayout filterLayout = null;
                filterLayout = new GridLayout(3, false);
                main.setLayout((Layout)filterLayout);
                filterLayout.marginHeight = 0;
                filterLayout.marginWidth = 0;
                ToolBar tb = new ToolBar(main, 0x800100);
                new ToolItem(tb, 2);
                final ToolItem it2 = new ToolItem(tb, 8);
                it2.setImage(filter);
                it2.setToolTipText(Messages.MdEditorForm_2);
                it2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LevelFilterPopup pop = new LevelFilterPopup((MdNode)((DocumentRoot)((Resource)MdEditorForm.this.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0)).getNode());
                        Point pt = new Point(it2.getBounds().x + it2.getBounds().width + 1, it2.getBounds().y);
                        pop.openPopup(this.getShell(), it2.getParent().toDisplay(pt), this.getViewer(), (this).MdEditorForm.this.patternFilter);
                    }
                });
                tb.setLayoutData((Object)new GridData(1, 2, false, false));
                return main;
            }

            protected void textChanged() {
                boolean bl = this.narrowingDown = this.previousFilterText == null || this.previousFilterText.equals("") || this.getFilterString().startsWith(this.previousFilterText);
                if ((this.previousFilterText == null || this.previousFilterText.equals("") || this.previousFilterText.equals(this.initialText)) && (this.getFilterString() == null || this.getFilterString().isEmpty() || this.getFilterString().equals(this.initialText))) {
                    this.instantRefresh = true;
                }
                super.textChanged();
            }

            protected WorkbenchJob doCreateRefreshJob() {
                return new WorkbenchJob("Refresh Filter"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        boolean initial;
                        if (treeViewer.getControl().isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        String text = this.getFilterString();
                        if (text == null) {
                            return Status.OK_STATUS;
                        }
                        boolean bl = initial = initialText != null && initialText.equals(text);
                        if (initial) {
                            (this).MdEditorForm.this.patternFilter.setPattern(null);
                        } else if (text != null) {
                            (this).MdEditorForm.this.patternFilter.setPattern("*" + text);
                        }
                        ArrayList previousSelection = new ArrayList(((IStructuredSelection)this.getViewer().getSelection()).toList());
                        Composite redrawFalseControl = treeComposite != null ? treeComposite : treeViewer.getControl();
                        try {
                            redrawFalseControl.setRedraw(false);
                            if (!narrowingDown) {
                                TreeItem[] is = treeViewer.getTree().getItems();
                                int i = 0;
                                while (i < is.length) {
                                    TreeItem item = is[i];
                                    if (item.getExpanded()) {
                                        treeViewer.setExpandedState(item.getData(), false);
                                    }
                                    ++i;
                                }
                            }
                            treeViewer.refresh(true);
                            if (text.length() > 0 && !initial) {
                                TreeItem[] items = this.getViewer().getTree().getItems();
                                int treeHeight = this.getViewer().getTree().getBounds().height;
                                int numVisibleItems = treeHeight / this.getViewer().getTree().getItemHeight();
                                long stopTime = 200L + System.currentTimeMillis();
                                boolean cancel = false;
                                if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                                    cancel = true;
                                }
                                this.updateToolbar(true);
                                if (cancel) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                            } else {
                                this.updateToolbar(false);
                            }
                        }
                        finally {
                            TreeItem[] items = this.getViewer().getTree().getItems();
                            if (items.length > 0 && this.getViewer().getTree().getSelectionCount() == 0) {
                                treeViewer.getTree().setTopItem(items[0]);
                            }
                            redrawFalseControl.setRedraw(true);
                            this.getViewer().setSelection((ISelection)new StructuredSelection(previousSelection), true);
                        }
                        return Status.OK_STATUS;
                    }

                    private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                        boolean canceled = false;
                        int i = 0;
                        while (!canceled && i < items.length) {
                            boolean visible;
                            TreeItem item = items[i];
                            int n = numItemsLeft[0];
                            numItemsLeft[0] = n - 1;
                            boolean bl = visible = n >= 0;
                            if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                                canceled = true;
                            } else {
                                Object itemData = item.getData();
                                if (itemData != null) {
                                    if (!item.getExpanded()) {
                                        treeViewer.setExpandedState(itemData, true);
                                    }
                                    TreeItem[] children = item.getItems();
                                    if (items.length > 0) {
                                        canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                                    }
                                }
                            }
                            ++i;
                        }
                        return canceled;
                    }
                };
            }
        };
        return tf.getViewer();
    }

    protected Composite createPageContainer(Composite parent) {
        if (oldMode) {
            return super.createPageContainer(parent);
        }
        Composite main = super.createPageContainer(parent);
        this.toolkit = new FormToolkit(main.getDisplay());
        SashForm sash = new SashForm(main, 256);
        this.toolkit.paintBordersFor((Composite)sash);
        Composite princpal = new Composite((Composite)sash, 0);
        this.toolkit.paintBordersFor((Composite)sash);
        this.page = new PropertiesBrowserPage((ITabbedPropertySheetPageContributor)this);
        this.page.init(new IPageSite(){

            public boolean hasService(Class api) {
                return MdEditorForm.this.getSite().hasService(api);
            }

            public Object getService(Class api) {
                return MdEditorForm.this.getSite().getService(api);
            }

            public Object getAdapter(Class adapter) {
                return MdEditorForm.this.getSite().getAdapter(adapter);
            }

            public void setSelectionProvider(ISelectionProvider provider) {
            }

            public IWorkbenchWindow getWorkbenchWindow() {
                return MdEditorForm.this.getSite().getWorkbenchWindow();
            }

            public Shell getShell() {
                return MdEditorForm.this.getSite().getShell();
            }

            public ISelectionProvider getSelectionProvider() {
                return MdEditorForm.this.getSite().getSelectionProvider();
            }

            public IWorkbenchPage getPage() {
                return MdEditorForm.this.getSite().getPage();
            }

            public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
            }

            public IActionBars getActionBars() {
                return null;
            }
        });
        this.page.createControl((Composite)sash);
        this.page.getControl().setLayoutData(null);
        sash.setWeights(new int[]{50, 50});
        return princpal;
    }

    @Override
    public void createPages() {
        super.createPages();
        if (oldMode) {
            return;
        }
        this.copyPasteActionManager = new EmfActionsReplacer();
    }

    @Override
    public void dispose() {
        if (oldMode) {
            super.dispose();
            return;
        }
        Viewer v = this.getViewer();
        if (v != null) {
            v.removeSelectionChangedListener(this.treeListener);
            v.removeSelectionChangedListener(this.actionReplacerListener);
        }
        this.copyPasteActionManager.dispose();
        if (this.page != null) {
            this.page.dispose();
            this.page.init(null);
            this.page = null;
        }
        super.dispose();
    }

    @Override
    public void setCurrentViewer(Viewer viewer) {
        if (oldMode) {
            super.setCurrentViewer(viewer);
            return;
        }
        Viewer cur = this.getViewer();
        if (cur != viewer) {
            if (cur != null && cur instanceof TreeViewer) {
                cur.removeSelectionChangedListener(this.treeListener);
                cur.removeSelectionChangedListener(this.actionReplacerListener);
            }
            viewer.addSelectionChangedListener(this.treeListener);
            viewer.addSelectionChangedListener(this.actionReplacerListener);
            super.setCurrentViewer(viewer);
            if (cur != null && viewer != null) {
                viewer.setSelection(cur.getSelection());
            }
        }
    }

    @Override
    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (pageIndex == 0) {
            this.setCurrentViewer((Viewer)this.treeViewer);
        }
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == PropertiesBrowserPage.class) {
            return this.page;
        }
        return super.getAdapter(key);
    }

    class LevelCodeFilter
    extends PatternFilter {
        Set<String> lvlCodes = null;
        boolean enabled = true;
        String pattern;
        boolean inited = false;
        String techId = null;

        LevelCodeFilter() {
        }

        public void setPattern(String patternString) {
            this.pattern = patternString;
            super.setPattern(patternString);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (this.enabled && element instanceof MdNode && this.lvlCodes != null) {
                Level lvl = ((MdNode)element).getLevel();
                return this.lvlCodes.contains(lvl.getCode()) && super.isLeafMatch(viewer, element);
            }
            return super.isLeafMatch(viewer, element);
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
        }

        void init() {
            if (!this.inited) {
                this.lvlCodes = new HashSet<String>();
                this.techId = ((Tech)((DocumentRoot)((Resource)MdEditorForm.this.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0)).getNode().getLevel().eContainer()).getId();
                try {
                    try {
                        for (Level l : ((Tech)((DocumentRoot)((Resource)MdEditorForm.this.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0)).getNode().getLevel().eContainer()).getLevel()) {
                            if (l.isFiltered()) continue;
                            this.lvlCodes.add(l.getCode());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.inited = true;
                    }
                }
                finally {
                    this.inited = true;
                }
            }
        }
    }
}

