/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.presentation.custom;

import com.indy.administration.AdministrationHelper;
import com.semarchy.xdi.designer.core.indexation.IMdTechRegistry;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IComponentService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.stambia.md.MdNode;
import com.stambia.md.presentation.MdEditorPlugin;
import com.stambia.md.presentation.Messages;
import com.stambia.md.presentation.custom.MdChooseTypeCreationPage2;
import com.stambia.md.provider.MdEditPlugin;
import com.stambia.tech.FileType;
import com.stambia.tech.Level;
import com.stambia.tech.Tech;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class MdChooseTypeCreationPage
extends WizardPage {
    protected AdvancedFilter advancedFilter = new AdvancedFilter();
    protected StructuredViewer treeViewer;
    protected MdTypeTreeNode[] root;
    protected MdTypeTreeNode selectedElement;
    protected ImageRegistry connectorsImageRegistry = new ImageRegistry();

    public MdTypeTreeNode getSelectedElement() {
        return this.selectedElement;
    }

    public MdChooseTypeCreationPage(String pageName) {
        super(pageName);
    }

    protected MdTypeTreeNode createTreeNode(Object obj) {
        return new MdTypeTreeNode(obj);
    }

    protected MdTypeTreeNode createTreeNode(IComponentService.IComponent component, Level level, EObject refObject) {
        return new MdTypeTreeNode(component, level, refObject);
    }

    public void dispose() {
        this.connectorsImageRegistry.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.setControl((Control)composite);
        Label containerLabel = new Label(composite, 16384);
        containerLabel.setText(MdEditorPlugin.INSTANCE.getString("_UI_ChooseTypeMetaData"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalSpan = 2;
        containerLabel.setLayoutData((Object)data);
        this.setPageComplete(false);
        IRunnableWithProgress rwp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                MdChooseTypeCreationPage.this.buildTree(monitor);
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, rwp);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.createFilters(composite);
        this.createViewer(composite, this.root);
        this.treeViewer.getControl().setFocus();
        composite.redraw();
    }

    protected void createFilters(Composite composite) {
        Button b = new Button(composite, 32);
        b.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        b.setText(Messages.MdChooseTypeCreationPage_1);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MdChooseTypeCreationPage.this.advancedFilter.setEnabled(((Button)e.widget).getSelection());
                Object[] expdanced = null;
                if (MdChooseTypeCreationPage.this.treeViewer instanceof TreeViewer) {
                    expdanced = ((TreeViewer)MdChooseTypeCreationPage.this.treeViewer).getExpandedElements();
                    ((TreeViewer)MdChooseTypeCreationPage.this.treeViewer).setExpandedElements(new Object[0]);
                }
                MdChooseTypeCreationPage.this.treeViewer.refresh();
                if (MdChooseTypeCreationPage.this.treeViewer instanceof TreeViewer) {
                    ((TreeViewer)MdChooseTypeCreationPage.this.treeViewer).setExpandedElements(expdanced);
                }
            }
        });
    }

    protected void createViewer(Composite composite, Object viewerInput) {
        TreeViewer treeViewer = new TreeViewer(composite);
        treeViewer.getTree().setLinesVisible(false);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.horizontalSpan = 6;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        treeViewer.getControl().setLayoutData((Object)gridData2);
        treeViewer.getTree().setHeaderVisible(false);
        treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof MdChooseTypeCreationPage2.LightDescriptor) {
                    return MdChooseTypeCreationPage.this.connectorsImageRegistry.get(((MdChooseTypeCreationPage2.LightDescriptor)((Object)element)).id);
                }
                Level level = ((MdTypeTreeNode)((Object)element)).getLevel();
                Object obj = null;
                obj = level != null && level.getIcon() != null && !level.getIcon().equals("") ? level.getIconURL() : MdEditPlugin.INSTANCE.getImage("full/custom/neutral");
                Image im = ExtendedImageRegistry.getInstance().getImage(obj);
                return im;
            }

            public String getText(Object element) {
                String retour;
                if (element instanceof MdTypeTreeNode && (retour = (String)((MdTypeTreeNode)((Object)element)).getValue()) != null) {
                    return retour;
                }
                return super.getText(element);
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MdChooseTypeCreationPage.this.selectedElement = (MdTypeTreeNode)((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
                if (MdChooseTypeCreationPage.this.selectedElement.refObject != null) {
                    MdChooseTypeCreationPage.this.setPageComplete(!MdChooseTypeCreationPage.this.selectedElement.isLockedByAdministrationMode);
                } else {
                    MdChooseTypeCreationPage.this.setPageComplete(false);
                }
            }
        });
        treeViewer.setAutoExpandLevel(-1);
        this.treeViewer = treeViewer;
        this.treeViewer.addFilter((ViewerFilter)this.advancedFilter);
        this.treeViewer.setInput(viewerInput);
    }

    private TreeNode[] buildTree(IProgressMonitor monitor) {
        IInternalResourceRegistry internalResourceRegistry = (IInternalResourceRegistry)E4InjectorHelper.getService(IInternalResourceRegistry.class);
        ArrayList<MdTypeTreeNode> tech = new ArrayList<MdTypeTreeNode>();
        HashSet<String> nodeIdentifiers = new HashSet<String>();
        try {
            IMdTechRegistry techRegistry = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getMdTechRegistry();
            monitor.beginTask(Messages.MdChooseTypeCreationPage_4, techRegistry.getTechUris().size());
            for (URI uri : techRegistry.getTechUris()) {
                try {
                    monitor.subTask(uri.toString());
                    ResourceSetImpl rs = new ResourceSetImpl();
                    rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
                    rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", true);
                    Resource resource = rs.getResource(uri, true);
                    Tech techRoot = (Tech)EMFResourceUtil.getRootElement((Resource)resource);
                    IComponentService.IComponent component = internalResourceRegistry.getProvidingComponent(techRoot.getId());
                    ArrayList<MdTypeTreeNode> childrenList = new ArrayList<MdTypeTreeNode>();
                    monitor.worked(1);
                    for (Level level : new ArrayList(techRoot.getLevel())) {
                        if (!level.isIsFile()) continue;
                        if (level.getParent().size() == 0) {
                            childrenList.add(this.createTreeNode(component, level, (EObject)techRoot));
                            nodeIdentifiers.add(String.valueOf(techRoot.getId()) + "/" + level.getCode());
                            continue;
                        }
                        for (String code : level.getParent()) {
                            for (URI s : techRegistry.getMdUriFor(code)) {
                                try {
                                    Resource resource2 = rs.getResource(s, true);
                                    MdNode node = (MdNode)EMFResourceUtil.getRootElement((Resource)resource2);
                                    childrenList.add(this.createTreeNode(component, level, (EObject)node));
                                    nodeIdentifiers.add(String.valueOf(((Tech)node.getLevel().eContainer()).getId()) + "/" + level.getCode() + "/" + node.getId());
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                    if (childrenList.size() <= 0) continue;
                    TreeNode[] children = new MdTypeTreeNode[childrenList.size()];
                    childrenList.toArray(children);
                    MdTypeTreeNode treeNode = this.createTreeNode(uri.trimFileExtension().lastSegment());
                    tech.add(treeNode);
                    treeNode.setChildren(children);
                    TreeNode[] treeNodeArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object c = treeNodeArray[n2];
                        c.setParent((TreeNode)treeNode);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (MdChooseTypeCreationPage2.LightDescriptor ld : this.readLightDesc()) {
            if (!nodeIdentifiers.add(ld.id)) continue;
            boolean found = false;
            for (MdTypeTreeNode n : tech) {
                if (n.getChildren() == null || n.getChildren().length <= 0 || !n.getValue().equals(ld.getValue())) continue;
                found = true;
                TreeNode[] newChilds = Arrays.copyOf(n.getChildren(), n.getChildren().length + 1);
                newChilds[newChilds.length - 1] = ld;
                ld.setParent(n);
                n.setChildren(newChilds);
                break;
            }
            if (!found) {
                MdTypeTreeNode c = this.createTreeNode(ld.getCategory());
                c.setChildren(new TreeNode[]{ld});
                ld.setParent(c);
                tech.add(c);
            }
            try {
                URL url = new URL(ld.icon);
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                Image im = desc.createImage(false);
                boolean noDispose = false;
                if (im == null) {
                    im = ExtendedImageRegistry.getInstance().getImage(MdEditPlugin.INSTANCE.getImage("full/custom/neutral"));
                    noDispose = true;
                }
                Image img = new Image(im.getDevice(), im, 2);
                this.connectorsImageRegistry.put(ld.id, img);
                if (noDispose) continue;
                im.dispose();
            }
            catch (Exception exception) {
                Image im = ExtendedImageRegistry.getInstance().getImage(MdEditPlugin.INSTANCE.getImage("full/custom/neutral"));
                Image img = new Image(im.getDevice(), im, 2);
                this.connectorsImageRegistry.put(ld.id, img);
            }
        }
        this.root = new MdTypeTreeNode[tech.size()];
        tech.toArray(this.root);
        return this.root;
    }

    public void setSelectedNode(IComponentService.IComponent component, Level level, Tech tech) {
        this.selectedElement = this.createTreeNode(component, level, (EObject)tech);
    }

    protected List<MdChooseTypeCreationPage2.LightDescriptor> readLightDesc() {
        return Collections.emptyList();
    }

    public EObject getEObject() {
        if (this.getSelectedElement() != null && this.getSelectedElement().getRefObject() != null) {
            return this.getSelectedElement().getRefObject();
        }
        return null;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("com.indy.ui.help.redirects/designer/metadata/metadata");
    }

    public class AdvancedFilter
    extends ViewerFilter {
        private boolean enabled = false;

        boolean isVisible(MdTypeTreeNode node) {
            FileType t = node.getLevel().getIsFile();
            if (this.enabled) {
                return t == FileType.TRUE || t == FileType.ADVANCED;
            }
            return t == FileType.TRUE;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof MdChooseTypeCreationPage2.LightDescriptor) {
                if (this.enabled) {
                    return true;
                }
                return !((MdChooseTypeCreationPage2.LightDescriptor)((Object)element)).advanced;
            }
            if (((MdTypeTreeNode)((Object)element)).getLevel() == null) {
                boolean hasChildren = false;
                Object[] objectArray = ((ITreeContentProvider)MdChooseTypeCreationPage.this.treeViewer.getContentProvider()).getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (this.isVisible((MdTypeTreeNode)((Object)o))) {
                        hasChildren = true;
                        break;
                    }
                    ++n2;
                }
                if (!hasChildren) {
                    return false;
                }
            }
            if (((MdTypeTreeNode)((Object)element)).getLevel() != null) {
                return this.isVisible((MdTypeTreeNode)((Object)element));
            }
            return true;
        }

        public void setEnabled(boolean b) {
            this.enabled = b;
        }
    }

    protected static class MdTypeTreeNode
    extends TreeNode {
        protected Level level;
        boolean isLockedByAdministrationMode;
        protected EObject refObject;

        public Level getLevel() {
            return this.level;
        }

        public EObject getRefObject() {
            return this.refObject;
        }

        public MdTypeTreeNode(Object value) {
            super(value);
            this.isLockedByAdministrationMode = false;
        }

        public MdTypeTreeNode(IComponentService.IComponent component, Level level, EObject refObject) {
            super(null);
            this.level = level;
            this.refObject = refObject;
            this.isLockedByAdministrationMode = !AdministrationHelper.componentAuthorized((IComponentService.IComponent)component);
        }

        public Object getValue() {
            if (this.refObject != null) {
                if (this.refObject instanceof Tech) {
                    return this.level.getDisplayName();
                }
                if (this.refObject instanceof MdNode) {
                    return ((MdNode)this.refObject).getName() == null ? this.level.getDisplayName() : ((MdNode)this.refObject).getName();
                }
            }
            return super.getValue();
        }
    }
}

