/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.presentation.custom;

import com.indy.engine.core.module.IModuleService;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.IModelUpgrader;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdRootNode;
import com.stambia.tech.Property;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.osgi.service.component.annotations.Component;

@Component(service={IModelUpgrader.class}, property={"type=md", "kind=module"})
public class MdModelModuleChanger
implements IModelUpgrader {
    public void upgradeModels(Collection<URI> models, Map<Object, Object> upgradeInformations, PrintWriter out, boolean trace) throws Exception {
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        domain.getResourceSet().setURIConverter((URIConverter)new InternalResourceURIConverter());
        domain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", null);
        try {
            for (URI r : models) {
                IModuleService.IModule module = (IModuleService.IModule)upgradeInformations.get(r);
                Resource re = domain.getResourceSet().getResource(r, true);
                MdRootNode rootMd = ((DocumentRoot)re.getContents().get(0)).getNode();
                String attributeName = rootMd.evaluateXpathExpression("INTERNAL_MODULE_ATTRIBUTE_NAME");
                Property p = rootMd.getLevel().getAttributeByShortCode(attributeName);
                if (p != null) {
                    try {
                        rootMd.setAttribute(attributeName, module.getName(), true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                re.save(saveOptions);
                re.unload();
                domain.getResourceSet().getResources().remove((Object)re);
            }
        }
        finally {
            domain.dispose();
        }
    }
}

