/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.presentation.custom;

import com.indy.md.ui.editor.preference.MdPreferenceConstants;
import com.indy.md.ui.editor.ui.MdWizard;
import com.indy.ui.custom.out.PropertiesBrowserPage;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.Util;
import com.stambia.md.presentation.MdEditorPlugin;
import com.stambia.md.presentation.custom.Messages;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.md.util.MdNodeInitializer;
import com.stambia.tech.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WizardAction
extends Action {
    private String configuration;
    private MdNode parent;
    private MdNode child;
    private Level level;

    public void setParent(MdNode parent) {
        this.parent = parent;
    }

    public void setChild(MdNode child) {
        this.child = child;
    }

    public WizardAction(Level level) {
        this.level = level;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    protected MdWizard createWizard(Level lvl) throws Exception {
        return MdWizard.retrieveWizard(this.level, new Util.ParameterWrapper[0]);
    }

    public void run() {
        MdNode node = this.child;
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)(node != null ? node : this.parent));
        InternalTransactionalEditingDomain internalDomain = (InternalTransactionalEditingDomain)ted;
        InternalTransaction tx = null;
        if (MdPreferenceConstants.getBoolean("activeTransactionOnWizardAndProperties")) {
            try {
                tx = internalDomain.startTransaction(false, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (node == null && this.parent != null) {
            final MdNode n = node = MdFactoryHelper.createMdNode((String)this.level.getCode());
            CompoundCommand cc = new CompoundCommand();
            cc.append((Command)new AddCommand((EditingDomain)ted, (EObject)this.parent, (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), (Object)node));
            cc.append((Command)new RecordingCommand(ted){

                protected void doExecute() {
                    MdNodeInitializer.initialize((MdNode)n, (Configuration)WizardAction.this.parent);
                }
            });
            ted.getCommandStack().execute((Command)cc);
        }
        MdWizard wizard = null;
        try {
            wizard = this.createWizard(this.level);
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.WizardAction_0, (String)(String.valueOf(Messages.WizardAction_1) + ex.getMessage()));
            MdEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "com.indy.md.ui.editor", ex.getMessage(), (Throwable)ex));
        }
        int result = 1;
        if (wizard != null) {
            wizard.setConfiguration(((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName());
            wizard.setNode(node);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            result = dialog.open();
        }
        if (MdPreferenceConstants.getBoolean("activeTransactionOnWizardAndProperties")) {
            if (result == 0) {
                try {
                    tx.commit();
                }
                catch (RollbackException e) {
                    e.printStackTrace();
                }
            } else {
                PropertiesBrowserPage embededPropsPage;
                tx.rollback();
                IEditorPart p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IPropertySheetPage sheet = (IPropertySheetPage)p.getAdapter(IPropertySheetPage.class);
                if (sheet instanceof TabbedPropertySheetPage && sheet.getControl() != null && !sheet.getControl().isDisposed() && ((TabbedPropertySheetPage)sheet).getCurrentTab() != null) {
                    ((TabbedPropertySheetPage)sheet).refresh();
                }
                if ((embededPropsPage = (PropertiesBrowserPage)p.getAdapter(PropertiesBrowserPage.class)) != null && embededPropsPage.getControl() != null && !embededPropsPage.getControl().isDisposed()) {
                    embededPropsPage.refresh();
                }
            }
        }
    }
}

