/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.impl;

import java.io.Serializable;
import org.apache.chemistry.opencmis.client.bindings.cache.Cache;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.CacheImpl;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.MapCacheLevelImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;

public class RepositoryInfoCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Cache cache;

    public RepositoryInfoCache(BindingSession session) {
        assert (session != null);
        int repCount = session.get("org.apache.chemistry.opencmis.binding.cache.repositories.size", 10);
        if (repCount < 1) {
            repCount = 10;
        }
        this.cache = new CacheImpl("Repository Info Cache");
        this.cache.initialize(new String[]{String.valueOf(MapCacheLevelImpl.class.getName()) + " " + "capacity" + "=" + repCount});
    }

    public void put(RepositoryInfo repositoryInfo) {
        if (repositoryInfo == null || repositoryInfo.getId() == null) {
            return;
        }
        this.cache.put(repositoryInfo, repositoryInfo.getId());
    }

    public RepositoryInfo get(String repositoryId) {
        return (RepositoryInfo)this.cache.get(repositoryId);
    }

    public void remove(String repositoryId) {
        this.cache.remove(repositoryId);
    }

    public String toString() {
        return this.cache.toString();
    }
}

