/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AtomEntryWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

public class VersioningServiceImpl
extends AbstractAtomPubService
implements VersioningService {
    public VersioningServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    @Override
    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        if (objectId == null || objectId.getValue() == null || objectId.getValue().length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        String link = this.loadCollection(repositoryId, "checkedout");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or checkedout collection not supported!");
        }
        UrlBuilder url = new UrlBuilder(link);
        if (this.getSession().get("org.apache.chemistry.opencmis.workaround.includeObjectIdOnCheckout", false)) {
            url.addParameter("objectId", objectId.getValue());
        }
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createIdObject(objectId.getValue()), this.getCmisVersion(repositoryId));
        Response resp = this.post(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws XMLStreamException, IOException {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        objectId.setValue(entry.getId());
        this.lockLinks();
        try {
            this.removeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                if (!(element.getObject() instanceof AtomLink)) continue;
                this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
            }
        }
        finally {
            this.unlockLinks();
        }
        if (contentCopied != null) {
            contentCopied.setValue(null);
        }
    }

    @Override
    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        String wcLink;
        String link = this.loadLink(repositoryId, objectId, "self", "application/atom+xml;type=entry");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "self", "application/atom+xml;type=entry");
        }
        if ((wcLink = this.getLink(repositoryId, objectId, "working-copy", "application/atom+xml;type=entry")) != null) {
            link = wcLink;
        }
        this.delete(new UrlBuilder(link));
    }

    @Override
    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        Acl newACL;
        AtomEntryWriter entryWriter;
        Response resp;
        AtomEntry entry;
        String wcLink;
        if (objectId == null || objectId.getValue() == null || objectId.getValue().length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        String link = this.loadLink(repositoryId, objectId.getValue(), "self", "application/atom+xml;type=entry");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId.getValue(), "self", "application/atom+xml;type=entry");
        }
        if ((wcLink = this.getLink(repositoryId, objectId.getValue(), "working-copy", "application/atom+xml;type=entry")) != null) {
            link = wcLink;
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("checkinComment", checkinComment);
        url.addParameter("major", major);
        url.addParameter("checkin", "true");
        if (this.getSession().get("org.apache.chemistry.opencmis.workaround.addNameOnCheckIn", false) && (properties == null || properties.getPropertyList().isEmpty())) {
            properties = new PropertiesImpl();
            try {
                PropertyData<?> nameProp;
                String name = null;
                ObjectData obj = this.getObjectInternal(repositoryId, AbstractAtomPubService.IdentifierType.ID, objectId.getValue(), ReturnVersion.THIS, "cmis:objectId,cmis:name", Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, Boolean.FALSE, null);
                if (obj != null && obj.getProperties() != null && obj.getProperties().getProperties() != null && obj.getProperties().getProperties().get("cmis:name") != null && (nameProp = obj.getProperties().getProperties().get("cmis:name")).getFirstValue() instanceof String) {
                    name = (String)nameProp.getFirstValue();
                }
                if (name == null) {
                    throw new CmisRuntimeException("Could not determine the name of the PWC!");
                }
                ((PropertiesImpl)properties).addProperty(new PropertyStringImpl("cmis:name", name));
            }
            catch (CmisBaseException e) {
                throw new CmisRuntimeException("Could not determine the name of the PWC: " + e.toString(), e);
            }
        }
        if ((entry = this.parse((resp = this.put(url, "application/atom+xml;type=entry", new Output(entryWriter = new AtomEntryWriter(this.createObject(properties, null, policies), this.getCmisVersion(repositoryId), contentStream)){
            private final /* synthetic */ AtomEntryWriter val$entryWriter;
            {
                this.val$entryWriter = atomEntryWriter;
            }

            @Override
            public void write(OutputStream out) throws XMLStreamException, IOException {
                this.val$entryWriter.write(out);
            }
        })).getStream(), AtomEntry.class)).getId() == null) {
            throw new CmisConnectionException("Received Atom entry is not a CMIS entry!");
        }
        objectId.setValue(entry.getId());
        AccessControlListImpl originalAces = null;
        this.lockLinks();
        try {
            this.removeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                ObjectData object;
                if (element.getObject() instanceof AtomLink) {
                    this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (!(element.getObject() instanceof ObjectData) || (object = (ObjectData)element.getObject()).getAcl() == null) continue;
                originalAces = new AccessControlListImpl(object.getAcl().getAces());
                originalAces.setExact(object.isExactAcl());
            }
        }
        finally {
            this.unlockLinks();
        }
        if (originalAces != null && this.isAclMergeRequired(addAces, removeAces) && (newACL = this.mergeAcls(originalAces, addAces, removeAces)) != null) {
            this.updateAcl(repositoryId, entry.getId(), newACL, null);
        }
    }

    @Override
    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        ArrayList<ObjectData> result = new ArrayList<ObjectData>();
        String link = this.loadLink(repositoryId, objectId, "version-history", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "version-history", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("filter", filter);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        if (!feed.getEntries().isEmpty()) {
            for (AtomEntry entry : feed.getEntries()) {
                ObjectData version = null;
                this.lockLinks();
                try {
                    this.removeLinks(repositoryId, entry.getId());
                    for (AtomElement element : entry.getElements()) {
                        if (element.getObject() instanceof AtomLink) {
                            this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                            continue;
                        }
                        if (!(element.getObject() instanceof ObjectData)) continue;
                        version = (ObjectData)element.getObject();
                    }
                }
                finally {
                    this.unlockLinks();
                }
                if (version == null) continue;
                result.add(version);
            }
        }
        return result;
    }

    @Override
    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        ReturnVersion returnVersion = ReturnVersion.LATEST;
        if (major != null && major.booleanValue()) {
            returnVersion = ReturnVersion.LASTESTMAJOR;
        }
        if (this.getSession().get("org.apache.chemistry.opencmis.workaround.getLatestVersionWithVersionSeriesId", false)) {
            if (versionSeriesId != null) {
                objectId = versionSeriesId;
            } else {
                PropertyData<?> versionSeriesProp;
                ObjectData obj = this.getObjectInternal(repositoryId, AbstractAtomPubService.IdentifierType.ID, objectId, null, "cmis:objectId,cmis:versionSeriesId", Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, Boolean.FALSE, extension);
                if (obj.getProperties() != null && obj.getProperties().getProperties() != null && (versionSeriesProp = obj.getProperties().getProperties().get("cmis:versionSeriesId")) != null && versionSeriesProp.getFirstValue() instanceof String) {
                    objectId = (String)versionSeriesProp.getFirstValue();
                }
            }
        }
        return this.getObjectInternal(repositoryId, AbstractAtomPubService.IdentifierType.ID, objectId, returnVersion, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeACL, extension);
    }

    @Override
    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        return this.getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, Boolean.FALSE, extension).getProperties();
    }
}

