/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import org.apache.chemistry.opencmis.client.bindings.impl.ClientVersion;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApacheClientHttpInvoker
implements HttpInvoker {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractApacheClientHttpInvoker.class);
    protected static final String HTTP_CLIENT = "org.apache.chemistry.opencmis.client.bindings.spi.http.ApacheClientHttpInvoker.httpClient";
    protected static final int BUFFER_SIZE = 0x200000;

    @Override
    public Response invokeGET(UrlBuilder url, BindingSession session) {
        return this.invoke(url, "GET", null, null, null, session, null, null);
    }

    @Override
    public Response invokeGET(UrlBuilder url, BindingSession session, BigInteger offset, BigInteger length) {
        return this.invoke(url, "GET", null, null, null, session, offset, length);
    }

    @Override
    public Response invokePOST(UrlBuilder url, String contentType, Output writer, BindingSession session) {
        return this.invoke(url, "POST", contentType, null, writer, session, null, null);
    }

    @Override
    public Response invokePUT(UrlBuilder url, String contentType, Map<String, String> headers, Output writer, BindingSession session) {
        return this.invoke(url, "PUT", contentType, headers, writer, session, null, null);
    }

    @Override
    public Response invokeDELETE(UrlBuilder url, BindingSession session) {
        return this.invoke(url, "DELETE", null, null, null, session, null, null);
    }

    protected Response invoke(UrlBuilder url, String method, String contentType, Map<String, String> headers, final Output writer, BindingSession session, BigInteger offset, BigInteger length) {
        int respCode = -1;
        try {
            Object compression;
            Map<String, List<String>> httpHeaders;
            AuthenticationProvider authProvider;
            DefaultHttpClient httpclient;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {}: {} {}", new Object[]{session.getSessionId(), method, url});
            }
            if ((httpclient = (DefaultHttpClient)session.get(HTTP_CLIENT)) == null) {
                session.writeLock();
                try {
                    httpclient = (DefaultHttpClient)session.get(HTTP_CLIENT);
                    if (httpclient == null) {
                        httpclient = this.createHttpClient(url, session);
                        session.put(HTTP_CLIENT, httpclient, true);
                    }
                }
                finally {
                    session.writeUnlock();
                }
            }
            HttpGet request = null;
            if ("GET".equals(method)) {
                request = new HttpGet(url.toString());
            } else if ("POST".equals(method)) {
                request = new HttpPost(url.toString());
            } else if ("PUT".equals(method)) {
                request = new HttpPut(url.toString());
            } else if ("DELETE".equals(method)) {
                request = new HttpDelete(url.toString());
            } else {
                throw new CmisRuntimeException("Invalid HTTP method!");
            }
            if (contentType != null) {
                request.setHeader("Content-Type", contentType);
            }
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    request.addHeader(header.getKey(), header.getValue());
                }
            }
            if ((authProvider = CmisBindingsHelper.getAuthenticationProvider(session)) != null && (httpHeaders = authProvider.getHTTPHeaders(url.toString())) != null) {
                for (Map.Entry<String, List<String>> header : httpHeaders.entrySet()) {
                    if (header.getKey() == null || !CollectionsHelper.isNotEmpty((Collection)header.getValue())) continue;
                    String key = header.getKey();
                    if (key.equalsIgnoreCase("user-agent")) {
                        request.setHeader("User-Agent", header.getValue().get(0));
                        continue;
                    }
                    for (String value : header.getValue()) {
                        if (value == null) continue;
                        request.addHeader(key, value);
                    }
                }
            }
            if (offset != null || length != null) {
                StringBuilder sb = new StringBuilder("bytes=");
                if (offset == null || offset.signum() == -1) {
                    offset = BigInteger.ZERO;
                }
                sb.append(offset.toString());
                sb.append('-');
                if (length != null && length.signum() == 1) {
                    sb.append(offset.add(length.subtract(BigInteger.ONE)).toString());
                }
                request.setHeader("Range", sb.toString());
            }
            if ((compression = session.get("org.apache.chemistry.opencmis.binding.compression")) != null && Boolean.parseBoolean(compression.toString())) {
                request.setHeader("Accept-Encoding", "gzip,deflate");
            }
            if (session.get("org.apache.chemistry.opencmis.binding.acceptLanguage") instanceof String) {
                request.setHeader("Accept-Language", session.get("org.apache.chemistry.opencmis.binding.acceptLanguage").toString());
            }
            if (writer != null) {
                boolean clientCompressionFlag;
                Object clientCompression = session.get("org.apache.chemistry.opencmis.binding.clientcompression");
                boolean bl = clientCompressionFlag = clientCompression != null && Boolean.parseBoolean(clientCompression.toString());
                if (clientCompressionFlag) {
                    request.setHeader("Content-Encoding", "gzip");
                }
                AbstractHttpEntity streamEntity = new AbstractHttpEntity(){

                    public boolean isChunked() {
                        return true;
                    }

                    public boolean isRepeatable() {
                        return false;
                    }

                    public long getContentLength() {
                        return -1L;
                    }

                    public boolean isStreaming() {
                        return false;
                    }

                    public InputStream getContent() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public void writeTo(OutputStream outstream) throws IOException {
                        OutputStream connOut = null;
                        connOut = clientCompressionFlag ? new GZIPOutputStream(outstream, 4096) : outstream;
                        BufferedOutputStream out = new BufferedOutputStream(connOut, 0x200000);
                        try {
                            writer.write(out);
                        }
                        catch (IOException ioe) {
                            throw ioe;
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                        ((OutputStream)out).flush();
                        if (connOut instanceof GZIPOutputStream) {
                            ((GZIPOutputStream)connOut).finish();
                        }
                    }
                };
                ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)streamEntity);
            }
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            respCode = response.getStatusLine().getStatusCode();
            InputStream inputStream = null;
            InputStream errorStream = null;
            if (respCode == 200 || respCode == 201 || respCode == 203 || respCode == 206) {
                inputStream = entity != null ? entity.getContent() : new ByteArrayInputStream(new byte[0]);
            } else {
                errorStream = entity != null ? entity.getContent() : new ByteArrayInputStream(new byte[0]);
            }
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            Header[] headerArray = response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                ArrayList<String> values = (ArrayList<String>)responseHeaders.get(header.getName());
                if (values == null) {
                    values = new ArrayList<String>();
                    responseHeaders.put(header.getName(), values);
                }
                values.add(header.getValue());
                ++n2;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Session {}: {} {} > Headers: {}", new Object[]{session.getSessionId(), method, url, ((Object)responseHeaders).toString()});
            }
            if (authProvider != null) {
                authProvider.putResponseHeaders(url.toString(), respCode, responseHeaders);
            }
            return new Response(respCode, response.getStatusLine().getReasonPhrase(), responseHeaders, inputStream, errorStream);
        }
        catch (Exception e) {
            throw new CmisConnectionException(url.toString(), respCode, (Throwable)e);
        }
    }

    protected HttpParams createDefaultHttpParams(BindingSession session) {
        int readTimeout;
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)((String)session.get("org.apache.chemistry.opencmis.binding.useragent", ClientVersion.OPENCMIS_USER_AGENT)));
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)true);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)true);
        int connectTimeout = session.get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
        if (connectTimeout >= 0) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectTimeout);
        }
        if ((readTimeout = session.get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeout);
        }
        return params;
    }

    protected void verify(HostnameVerifier verifier, String host, SSLSocket sslSocket) throws IOException {
        try {
            if (verifier instanceof X509HostnameVerifier) {
                ((X509HostnameVerifier)verifier).verify(host, sslSocket);
            } else if (!verifier.verify(host, sslSocket.getSession())) {
                throw new SSLException("Hostname in certificate didn't match: <" + host + ">");
            }
        }
        catch (IOException ioe) {
            this.closeSocket(sslSocket);
            throw ioe;
        }
    }

    protected void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract DefaultHttpClient createHttpClient(UrlBuilder var1, BindingSession var2);
}

