/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.async;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.async.AbstractAsyncSession;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;

public abstract class AbstractExecutorServiceAsyncSession<E extends ExecutorService>
extends AbstractAsyncSession {
    public AbstractExecutorServiceAsyncSession(Session session) {
        super(session);
    }

    public abstract E getExecutorService();

    public <T> Future<T> submit(SessionCallable<T> task) {
        return this.getExecutorService().submit(task);
    }

    @Override
    public Future<ObjectType> getTypeDefinition(String typeId) {
        return this.submit(new GetTypeDefinitonCallable(this.session, typeId));
    }

    @Override
    public Future<ObjectType> createType(TypeDefinition type) {
        return this.submit(new CreateTypeCallable(this.session, type));
    }

    @Override
    public Future<ObjectType> updateType(TypeDefinition type) {
        return this.submit(new UpdateTypeCallable(this.session, type));
    }

    @Override
    public Future<?> deleteType(String typeId) {
        return this.submit(new DeleteTypeCallable(this.session, typeId));
    }

    @Override
    public Future<CmisObject> getObject(ObjectId objectId, OperationContext context) {
        return this.submit(new GetObjectCallable(this.session, objectId, context));
    }

    @Override
    public Future<CmisObject> getObject(String objectId, OperationContext context) {
        return this.submit(new GetObjectCallable(this.session, objectId, context));
    }

    @Override
    public Future<CmisObject> getObjectByPath(String path, OperationContext context) {
        return this.submit(new GetObjectByPathCallable(this.session, path, context));
    }

    @Override
    public Future<CmisObject> getObjectByPath(String parentPath, String name, OperationContext context) {
        return this.submit(new GetObjectByPathCallable(this.session, parentPath, name, context));
    }

    @Override
    public Future<Document> getLatestDocumentVersion(ObjectId objectId, boolean major, OperationContext context) {
        return this.submit(new GetLatestDocumentVersionCallable(this.session, objectId, major, context));
    }

    @Override
    public Future<Document> getLatestDocumentVersion(String objectId, boolean major, OperationContext context) {
        return this.submit(new GetLatestDocumentVersionCallable(this.session, objectId, major, context));
    }

    @Override
    public Future<ObjectId> createDocument(Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        return this.submit(new CreateDocumentCallable(this.session, properties, folderId, contentStream, versioningState, policies, addAces, removeAces));
    }

    @Override
    public Future<ObjectId> createDocumentFromSource(ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        return this.submit(new CreateDocumentFromSourceCallable(this.session, source, properties, folderId, versioningState, policies, addAces, removeAces));
    }

    @Override
    public Future<ObjectId> createFolder(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        return this.submit(new CreateFolderCallable(this.session, properties, folderId, policies, addAces, removeAces));
    }

    @Override
    public Future<ObjectId> createPolicy(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        return this.submit(new CreatePolicyCallable(this.session, properties, folderId, policies, addAces, removeAces));
    }

    @Override
    public Future<ObjectId> createItem(Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        return this.submit(new CreateItemCallable(this.session, properties, folderId, policies, addAces, removeAces));
    }

    @Override
    public Future<ObjectId> createRelationship(Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        return this.submit(new CreateRelationshipCallable(this.session, properties, policies, addAces, removeAces));
    }

    @Override
    public Future<ContentStream> getContentStream(ObjectId docId, String streamId, BigInteger offset, BigInteger length) {
        return this.submit(new GetContentStreamCallable(this.session, docId, streamId, offset, length));
    }

    @Override
    public Future<ContentStream> storeContentStream(ObjectId docId, String streamId, BigInteger offset, BigInteger length, OutputStream target) {
        return this.submit(new StoreContentStreamCallable(this.session, docId, streamId, offset, length, target));
    }

    @Override
    public Future<?> delete(ObjectId objectId, boolean allVersions) {
        return this.submit(new DeleteCallable(this.session, objectId, allVersions));
    }

    @Override
    public Future<List<String>> deleteTree(ObjectId folderId, boolean allVersions, UnfileObject unfile, boolean continueOnFailure) {
        return this.submit(new DeleteTreeCallable(this.session, folderId, allVersions, unfile, continueOnFailure));
    }

    @Override
    public Future<Acl> applyAcl(ObjectId objectId, List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        return this.getExecutorService().submit(new ApplyAclCallable(this.session, objectId, addAces, removeAces, aclPropagation));
    }

    @Override
    public Future<Acl> setAcl(ObjectId objectId, List<Ace> aces) {
        return this.submit(new SetAclCallable(this.session, objectId, aces));
    }

    @Override
    public Future<?> applyPolicy(ObjectId objectId, ObjectId ... policyIds) {
        return this.submit(new ApplyPolicyCallable(this.session, objectId, policyIds));
    }

    @Override
    public Future<?> removePolicy(ObjectId objectId, ObjectId ... policyIds) {
        return this.submit(new RemovePolicyCallable(this.session, objectId, policyIds));
    }

    public void shutdown() {
        if (this.getExecutorService() != null) {
            this.getExecutorService().shutdown();
        }
    }

    public List<Runnable> shutdownNow() {
        if (this.getExecutorService() != null) {
            return this.getExecutorService().shutdownNow();
        }
        return Collections.emptyList();
    }

    public boolean isShutdown() {
        if (this.getExecutorService() != null) {
            return this.getExecutorService().isShutdown();
        }
        return true;
    }

    public boolean isTerminated() {
        if (this.getExecutorService() != null) {
            return this.getExecutorService().isTerminated();
        }
        return true;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.getExecutorService() != null) {
            return this.getExecutorService().awaitTermination(timeout, unit);
        }
        return true;
    }

    protected static class ApplyAclCallable
    extends SessionCallable<Acl> {
        private ObjectId objectId;
        private List<Ace> addAces;
        private List<Ace> removeAces;
        private AclPropagation aclPropagation;

        public ApplyAclCallable(Session session, ObjectId objectId, List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
            super(session);
            this.objectId = objectId;
            this.addAces = addAces;
            this.removeAces = removeAces;
            this.aclPropagation = aclPropagation;
        }

        @Override
        public Acl call() throws Exception {
            return this.session.applyAcl(this.objectId, this.addAces, this.removeAces, this.aclPropagation);
        }
    }

    protected static class ApplyPolicyCallable
    extends SessionCallable<Object> {
        private ObjectId objectId;
        private ObjectId[] policyIds;

        public ApplyPolicyCallable(Session session, ObjectId objectId, ObjectId ... policyIds) {
            super(session);
            this.objectId = objectId;
            this.policyIds = policyIds;
        }

        @Override
        public Object call() throws Exception {
            this.session.applyPolicy(this.objectId, this.policyIds);
            return null;
        }
    }

    protected static class CreateDocumentCallable
    extends SessionCallable<ObjectId> {
        private Map<String, ?> properties;
        private ObjectId folderId;
        private ContentStream contentStream;
        private VersioningState versioningState;
        private List<Policy> policies;
        private List<Ace> addAces;
        private List<Ace> removeAces;

        public CreateDocumentCallable(Session session, Map<String, ?> properties, ObjectId folderId, ContentStream contentStream, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
            super(session);
            this.properties = properties;
            this.folderId = folderId;
            this.contentStream = contentStream;
            this.versioningState = versioningState;
            this.policies = policies;
            this.addAces = addAces;
            this.removeAces = removeAces;
        }

        @Override
        public ObjectId call() throws Exception {
            return this.session.createDocument(this.properties, this.folderId, this.contentStream, this.versioningState, this.policies, this.addAces, this.removeAces);
        }
    }

    protected static class CreateDocumentFromSourceCallable
    extends SessionCallable<ObjectId> {
        private ObjectId source;
        private Map<String, ?> properties;
        private ObjectId folderId;
        private VersioningState versioningState;
        private List<Policy> policies;
        private List<Ace> addAces;
        private List<Ace> removeAces;

        public CreateDocumentFromSourceCallable(Session session, ObjectId source, Map<String, ?> properties, ObjectId folderId, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
            super(session);
            this.source = source;
            this.properties = properties;
            this.folderId = folderId;
            this.versioningState = versioningState;
            this.policies = policies;
            this.addAces = addAces;
            this.removeAces = removeAces;
        }

        @Override
        public ObjectId call() throws Exception {
            return this.session.createDocumentFromSource(this.source, this.properties, this.folderId, this.versioningState, this.policies, this.addAces, this.removeAces);
        }
    }

    protected static class CreateFolderCallable
    extends SessionCallable<ObjectId> {
        private Map<String, ?> properties;
        private ObjectId folderId;
        private List<Policy> policies;
        private List<Ace> addAces;
        private List<Ace> removeAces;

        public CreateFolderCallable(Session session, Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
            super(session);
            this.properties = properties;
            this.folderId = folderId;
            this.policies = policies;
            this.addAces = addAces;
            this.removeAces = removeAces;
        }

        @Override
        public ObjectId call() throws Exception {
            return this.session.createFolder(this.properties, this.folderId, this.policies, this.addAces, this.removeAces);
        }
    }

    protected static class CreateItemCallable
    extends SessionCallable<ObjectId> {
        private Map<String, ?> properties;
        private ObjectId folderId;
        private List<Policy> policies;
        private List<Ace> addAces;
        private List<Ace> removeAces;

        public CreateItemCallable(Session session, Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
            super(session);
            this.properties = properties;
            this.folderId = folderId;
            this.policies = policies;
            this.addAces = addAces;
            this.removeAces = removeAces;
        }

        @Override
        public ObjectId call() throws Exception {
            return this.session.createItem(this.properties, this.folderId, this.policies, this.addAces, this.removeAces);
        }
    }

    protected static class CreatePolicyCallable
    extends SessionCallable<ObjectId> {
        private Map<String, ?> properties;
        private ObjectId folderId;
        private List<Policy> policies;
        private List<Ace> addAces;
        private List<Ace> removeAces;

        public CreatePolicyCallable(Session session, Map<String, ?> properties, ObjectId folderId, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
            super(session);
            this.properties = properties;
            this.folderId = folderId;
            this.policies = policies;
            this.addAces = addAces;
            this.removeAces = removeAces;
        }

        @Override
        public ObjectId call() throws Exception {
            return this.session.createPolicy(this.properties, this.folderId, this.policies, this.addAces, this.removeAces);
        }
    }

    protected static class CreateRelationshipCallable
    extends SessionCallable<ObjectId> {
        private Map<String, ?> properties;
        private List<Policy> policies;
        private List<Ace> addAces;
        private List<Ace> removeAces;

        public CreateRelationshipCallable(Session session, Map<String, ?> properties, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
            super(session);
            this.properties = properties;
            this.policies = policies;
            this.addAces = addAces;
            this.removeAces = removeAces;
        }

        @Override
        public ObjectId call() throws Exception {
            return this.session.createRelationship(this.properties, this.policies, this.addAces, this.removeAces);
        }
    }

    protected static class CreateTypeCallable
    extends SessionCallable<ObjectType> {
        private TypeDefinition type;

        public CreateTypeCallable(Session session, TypeDefinition type) {
            super(session);
            this.type = type;
        }

        @Override
        public ObjectType call() throws Exception {
            return this.session.createType(this.type);
        }
    }

    protected static class DeleteCallable
    extends SessionCallable<Object> {
        private ObjectId objectId;
        private boolean allVersions;

        public DeleteCallable(Session session, ObjectId objectId, boolean allVersions) {
            super(session);
            this.objectId = objectId;
            this.allVersions = allVersions;
        }

        @Override
        public Object call() throws Exception {
            this.session.delete(this.objectId, this.allVersions);
            return null;
        }
    }

    protected static class DeleteTreeCallable
    extends SessionCallable<List<String>> {
        private ObjectId folderId;
        private boolean allVersions;
        private UnfileObject unfile;
        private boolean continueOnFailure;

        public DeleteTreeCallable(Session session, ObjectId folderId, boolean allVersions, UnfileObject unfile, boolean continueOnFailure) {
            super(session);
            this.folderId = folderId;
            this.allVersions = allVersions;
            this.unfile = unfile;
            this.continueOnFailure = continueOnFailure;
        }

        @Override
        public List<String> call() throws Exception {
            return this.session.deleteTree(this.folderId, this.allVersions, this.unfile, this.continueOnFailure);
        }
    }

    protected static class DeleteTypeCallable
    extends SessionCallable<Object> {
        private String typeId;

        public DeleteTypeCallable(Session session, String typeId) {
            super(session);
            this.typeId = typeId;
        }

        @Override
        public Object call() throws Exception {
            this.session.deleteType(this.typeId);
            return null;
        }
    }

    protected static class GetContentStreamCallable
    extends SessionCallable<ContentStream> {
        private ObjectId docId;
        private String streamId;
        private BigInteger offset;
        private BigInteger length;

        public GetContentStreamCallable(Session session, ObjectId docId, String streamId, BigInteger offset, BigInteger length) {
            super(session);
            this.docId = docId;
            this.streamId = streamId;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public ContentStream call() throws Exception {
            return this.session.getContentStream(this.docId, this.streamId, this.offset, this.length);
        }
    }

    protected static class GetLatestDocumentVersionCallable
    extends SessionCallable<Document> {
        private ObjectId objectId;
        private String objectIdStr;
        private boolean major;
        private OperationContext context;

        public GetLatestDocumentVersionCallable(Session session, ObjectId objectId) {
            this(session, objectId, false, null);
        }

        public GetLatestDocumentVersionCallable(Session session, ObjectId objectId, boolean major, OperationContext context) {
            super(session);
            this.objectId = objectId;
            this.major = major;
            this.context = context;
        }

        public GetLatestDocumentVersionCallable(Session session, String objectId) {
            this(session, objectId, false, null);
        }

        public GetLatestDocumentVersionCallable(Session session, String objectId, boolean major, OperationContext context) {
            super(session);
            this.objectIdStr = objectId;
            this.major = major;
            this.context = context;
        }

        @Override
        public Document call() throws Exception {
            if (this.objectId != null) {
                if (this.context != null) {
                    return this.session.getLatestDocumentVersion(this.objectId, this.major, this.context);
                }
                return this.session.getLatestDocumentVersion(this.objectId);
            }
            if (this.context != null) {
                return this.session.getLatestDocumentVersion(this.objectIdStr, this.major, this.context);
            }
            return this.session.getLatestDocumentVersion(this.objectIdStr);
        }
    }

    protected static class GetObjectByPathCallable
    extends SessionCallable<CmisObject> {
        private String path;
        private String parentPath;
        private String name;
        private OperationContext context;

        public GetObjectByPathCallable(Session session, String path) {
            this(session, path, (OperationContext)null);
        }

        public GetObjectByPathCallable(Session session, String path, OperationContext context) {
            super(session);
            this.path = path;
            this.context = context;
        }

        public GetObjectByPathCallable(Session session, String parentPath, String name) {
            this(session, parentPath, name, null);
        }

        public GetObjectByPathCallable(Session session, String parentPath, String name, OperationContext context) {
            super(session);
            this.parentPath = parentPath;
            this.name = name;
            this.context = context;
        }

        @Override
        public CmisObject call() throws Exception {
            if (this.parentPath != null) {
                if (this.context != null) {
                    return this.session.getObjectByPath(this.parentPath, this.name, this.context);
                }
                return this.session.getObjectByPath(this.parentPath, this.name);
            }
            if (this.context != null) {
                return this.session.getObjectByPath(this.path, this.context);
            }
            return this.session.getObjectByPath(this.path);
        }
    }

    protected static class GetObjectCallable
    extends SessionCallable<CmisObject> {
        private ObjectId objectId;
        private String objectIdStr;
        private OperationContext context;

        public GetObjectCallable(Session session, ObjectId objectId) {
            this(session, objectId, null);
        }

        public GetObjectCallable(Session session, ObjectId objectId, OperationContext context) {
            super(session);
            this.objectId = objectId;
            this.context = context;
        }

        public GetObjectCallable(Session session, String objectId) {
            this(session, objectId, null);
        }

        public GetObjectCallable(Session session, String objectId, OperationContext context) {
            super(session);
            this.objectIdStr = objectId;
            this.context = context;
        }

        @Override
        public CmisObject call() throws Exception {
            if (this.objectId != null) {
                if (this.context != null) {
                    return this.session.getObject(this.objectId, this.context);
                }
                return this.session.getObject(this.objectId);
            }
            if (this.context != null) {
                return this.session.getObject(this.objectIdStr, this.context);
            }
            return this.session.getObject(this.objectIdStr);
        }
    }

    protected static class GetTypeDefinitonCallable
    extends SessionCallable<ObjectType> {
        private String typeId;

        public GetTypeDefinitonCallable(Session session, String typeId) {
            super(session);
            this.typeId = typeId;
        }

        @Override
        public ObjectType call() throws Exception {
            return this.session.getTypeDefinition(this.typeId);
        }
    }

    protected static class RemovePolicyCallable
    extends SessionCallable<Object> {
        private ObjectId objectId;
        private ObjectId[] policyIds;

        public RemovePolicyCallable(Session session, ObjectId objectId, ObjectId ... policyIds) {
            super(session);
            this.objectId = objectId;
            this.policyIds = policyIds;
        }

        @Override
        public Object call() throws Exception {
            this.session.removePolicy(this.objectId, this.policyIds);
            return null;
        }
    }

    public static abstract class SessionCallable<V>
    implements Callable<V> {
        protected Session session;

        public SessionCallable(Session session) {
            if (session == null) {
                throw new IllegalArgumentException("Session must be set!");
            }
            this.session = session;
        }
    }

    protected static class SetAclCallable
    extends SessionCallable<Acl> {
        private ObjectId objectId;
        private List<Ace> aces;

        public SetAclCallable(Session session, ObjectId objectId, List<Ace> aces) {
            super(session);
            this.objectId = objectId;
            this.aces = aces;
        }

        @Override
        public Acl call() throws Exception {
            return this.session.setAcl(this.objectId, this.aces);
        }
    }

    protected static class StoreContentStreamCallable
    extends GetContentStreamCallable {
        private OutputStream target;

        public StoreContentStreamCallable(Session session, ObjectId docId, String streamId, BigInteger offset, BigInteger length, OutputStream target) {
            super(session, docId, streamId, offset, length);
            this.target = target;
        }

        @Override
        public ContentStream call() throws Exception {
            ContentStream contentStream = super.call();
            try {
                if (contentStream != null && contentStream.getStream() != null && this.target != null) {
                    IOUtils.copy(contentStream.getStream(), this.target);
                }
            }
            finally {
                IOUtils.closeQuietly(contentStream);
            }
            return contentStream;
        }
    }

    protected static class UpdateTypeCallable
    extends SessionCallable<ObjectType> {
        private TypeDefinition type;

        public UpdateTypeCallable(Session session, TypeDefinition type) {
            super(session);
            this.type = type;
        }

        @Override
        public ObjectType call() throws Exception {
            return this.session.updateType(this.type);
        }
    }
}

