/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.repository;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.ChangeEventImpl;
import org.apache.chemistry.opencmis.client.runtime.ChangeEventsImpl;
import org.apache.chemistry.opencmis.client.runtime.DocumentImpl;
import org.apache.chemistry.opencmis.client.runtime.FolderImpl;
import org.apache.chemistry.opencmis.client.runtime.ItemImpl;
import org.apache.chemistry.opencmis.client.runtime.PolicyImpl;
import org.apache.chemistry.opencmis.client.runtime.PropertyImpl;
import org.apache.chemistry.opencmis.client.runtime.QueryResultImpl;
import org.apache.chemistry.opencmis.client.runtime.RelationshipImpl;
import org.apache.chemistry.opencmis.client.runtime.RenditionImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.DocumentTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.FolderTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.ItemTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.PolicyTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.RelationshipTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.SecondaryTypeImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.ItemTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.SecondaryTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PartialContentStreamImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;

public class ObjectFactoryImpl
implements ObjectFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private Session session;

    @Override
    public void initialize(Session session, Map<String, String> parameters) {
        assert (session != null);
        this.session = session;
    }

    protected BindingsObjectFactory getBindingsObjectFactory() {
        return this.session.getBinding().getObjectFactory();
    }

    @Override
    public RepositoryInfo convertRepositoryInfo(RepositoryInfo repositoryInfo) {
        return repositoryInfo;
    }

    @Override
    public Acl convertAces(List<Ace> aces) {
        if (aces == null) {
            return null;
        }
        BindingsObjectFactory bof = this.getBindingsObjectFactory();
        ArrayList<Ace> bindingAces = new ArrayList<Ace>();
        for (Ace ace : aces) {
            bindingAces.add(bof.createAccessControlEntry(ace.getPrincipalId(), ace.getPermissions()));
        }
        return bof.createAccessControlList(bindingAces);
    }

    @Override
    public Ace createAce(String principal, List<String> permissions) {
        BindingsObjectFactory bof = this.getBindingsObjectFactory();
        Ace ace = bof.createAccessControlEntry(principal, permissions);
        return ace;
    }

    @Override
    public Acl createAcl(List<Ace> aces) {
        BindingsObjectFactory bof = this.getBindingsObjectFactory();
        Acl acl = bof.createAccessControlList(aces);
        return acl;
    }

    @Override
    public List<String> convertPolicies(List<Policy> policies) {
        if (policies == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Policy policy : policies) {
            if (policy == null || policy.getId() == null) continue;
            result.add(policy.getId());
        }
        return result;
    }

    @Override
    public Rendition convertRendition(String objectId, RenditionData rendition) {
        if (rendition == null) {
            throw new IllegalArgumentException("Rendition must be set!");
        }
        long length = rendition.getBigLength() == null ? -1L : rendition.getBigLength().longValue();
        int height = rendition.getBigHeight() == null ? -1 : rendition.getBigHeight().intValue();
        int width = rendition.getBigWidth() == null ? -1 : rendition.getBigWidth().intValue();
        return new RenditionImpl(this.session, objectId, rendition.getStreamId(), rendition.getRenditionDocumentId(), rendition.getKind(), length, rendition.getMimeType(), rendition.getTitle(), height, width);
    }

    @Override
    public ContentStream createContentStream(String filename, long length, String mimetype, InputStream stream) {
        return this.createContentStream(filename, length, mimetype, stream, false);
    }

    @Override
    public ContentStream createContentStream(String filename, long length, String mimetype, InputStream stream, boolean partial) {
        if (partial) {
            return new PartialContentStreamImpl(filename, length < 0L ? null : BigInteger.valueOf(length), mimetype, stream);
        }
        return new ContentStreamImpl(filename, length < 0L ? null : BigInteger.valueOf(length), mimetype, stream);
    }

    @Override
    public ContentStream convertContentStream(ContentStream contentStream) {
        if (contentStream == null) {
            return null;
        }
        BigInteger length = contentStream.getLength() < 0L ? null : BigInteger.valueOf(contentStream.getLength());
        return this.getBindingsObjectFactory().createContentStream(contentStream.getFileName(), length, contentStream.getMimeType(), contentStream.getStream());
    }

    @Override
    public ObjectType convertTypeDefinition(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof DocumentTypeDefinition) {
            return new DocumentTypeImpl(this.session, (DocumentTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof FolderTypeDefinition) {
            return new FolderTypeImpl(this.session, (FolderTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof RelationshipTypeDefinition) {
            return new RelationshipTypeImpl(this.session, (RelationshipTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof PolicyTypeDefinition) {
            return new PolicyTypeImpl(this.session, (PolicyTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof ItemTypeDefinition) {
            return new ItemTypeImpl(this.session, (ItemTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof SecondaryTypeDefinition) {
            return new SecondaryTypeImpl(this.session, (SecondaryTypeDefinition)typeDefinition);
        }
        if (typeDefinition == null) {
            throw new CmisRuntimeException("No base type supplied!");
        }
        throw new CmisRuntimeException("Unknown base type! Received " + typeDefinition.getClass().getName());
    }

    @Override
    public ObjectType getTypeFromObjectData(ObjectData objectData) {
        if (objectData == null || objectData.getProperties() == null || objectData.getProperties().getProperties() == null) {
            return null;
        }
        PropertyData<?> typeProperty = objectData.getProperties().getProperties().get("cmis:objectTypeId");
        if (!(typeProperty instanceof PropertyId)) {
            return null;
        }
        return this.session.getTypeDefinition((String)typeProperty.getFirstValue());
    }

    @Override
    public <T> Property<T> createProperty(PropertyDefinition<T> type, List<T> values) {
        return new PropertyImpl<T>(type, values);
    }

    protected <T> Property<T> convertProperty(ObjectType objectType, Collection<SecondaryType> secondaryTypes, PropertyData<T> pd) {
        ObjectType reloadedObjectType;
        if (pd.getId() == null || pd.getId().length() == 0) {
            StringBuilder sb = null;
            if (CollectionsHelper.isNotEmpty(secondaryTypes)) {
                sb = new StringBuilder(128);
                sb.append(" or a secondary type of the object (");
                this.addSecondaryTypeIds(secondaryTypes, sb);
                sb.append(')');
            }
            throw new CmisRuntimeException("Cannot convert a property because it has no ID! The property is supposed to be part of the type '" + objectType.getId() + "'" + (sb == null ? "" : sb.toString()) + ". The value of this property is: " + pd.getValues());
        }
        PropertyDefinition<?> definition = objectType.getPropertyDefinitions().get(pd.getId());
        if (definition == null && secondaryTypes != null) {
            for (SecondaryType secondaryType : secondaryTypes) {
                if (secondaryType != null && secondaryType.getPropertyDefinitions() != null && (definition = secondaryType.getPropertyDefinitions().get(pd.getId())) != null) break;
            }
        }
        if (definition == null && (definition = (reloadedObjectType = this.session.getTypeDefinition(objectType.getId(), false)).getPropertyDefinitions().get(pd.getId())) == null && secondaryTypes != null) {
            for (SecondaryType secondaryType : secondaryTypes) {
                ObjectType reloadedSecondaryType;
                if (secondaryType != null && (reloadedSecondaryType = this.session.getTypeDefinition(secondaryType.getId(), false)).getPropertyDefinitions() != null && (definition = reloadedSecondaryType.getPropertyDefinitions().get(pd.getId())) != null) break;
            }
        }
        if (definition == null) {
            StringBuilder sb = null;
            if (CollectionsHelper.isNotEmpty(secondaryTypes)) {
                sb = new StringBuilder(128);
                sb.append(" or any secondary type of the object (");
                this.addSecondaryTypeIds(secondaryTypes, sb);
                sb.append(')');
            }
            throw new CmisRuntimeException("Cannot convert property '" + pd.getId() + "' because it does not exist in the object type. The property is supposed to be part of the type '" + objectType.getId() + "'" + (sb == null ? "" : sb.toString()) + ". The value of this property is: " + pd.getValues());
        }
        return this.createProperty(definition, pd.getValues());
    }

    private void addSecondaryTypeIds(Collection<SecondaryType> secondaryTypes, StringBuilder sb) {
        boolean first = true;
        for (SecondaryType secondaryType : secondaryTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append('\'');
            sb.append(secondaryType.getId());
            sb.append('\'');
        }
    }

    @Override
    public Map<String, Property<?>> convertProperties(ObjectType objectType, Collection<SecondaryType> secondaryTypes, Properties properties) {
        if (objectType == null) {
            throw new IllegalArgumentException("Object type must set!");
        }
        if (objectType.getPropertyDefinitions() == null) {
            throw new IllegalArgumentException("Object type has no property defintions!");
        }
        if (properties == null || properties.getProperties() == null) {
            throw new IllegalArgumentException("Properties must be set!");
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<String, PropertyData<?>> entry : properties.getProperties().entrySet()) {
            Property<?> apiProperty = this.convertProperty(objectType, secondaryTypes, entry.getValue());
            result.put(entry.getKey(), apiProperty);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Properties convertProperties(Map<String, ?> properties, ObjectType type, Collection<SecondaryType> secondaryTypes, Set<Updatability> updatabilityFilter) {
        if (properties == null) {
            return null;
        }
        if (type == null) {
            Object typeId = properties.get("cmis:objectTypeId");
            if (typeId instanceof String) {
                type = this.session.getTypeDefinition(typeId.toString());
            } else if (typeId instanceof List && !((List)typeId).isEmpty() && ((List)typeId).get(0) instanceof String) {
                type = this.session.getTypeDefinition(((List)typeId).get(0).toString());
            } else {
                throw new IllegalArgumentException("Type or type property must be set!");
            }
        }
        Collection<Object> allSecondaryTypes = null;
        Object secondaryTypeIds = properties.get("cmis:secondaryObjectTypeIds");
        if (secondaryTypeIds instanceof List) {
            allSecondaryTypes = new ArrayList();
            for (Object secondaryTypeId : (List)secondaryTypeIds) {
                if (!(secondaryTypeId instanceof String)) {
                    throw new IllegalArgumentException("Secondary types property contains an invalid entry: " + secondaryTypeId);
                }
                ObjectType secondaryType = this.session.getTypeDefinition(secondaryTypeId.toString());
                if (!(secondaryType instanceof SecondaryType)) {
                    throw new IllegalArgumentException("Secondary types property contains a type that is not a secondary type: " + secondaryTypeId);
                }
                allSecondaryTypes.add((SecondaryType)secondaryType);
            }
        }
        if (secondaryTypes != null && allSecondaryTypes == null) {
            allSecondaryTypes = secondaryTypes;
        }
        BindingsObjectFactory bof = this.getBindingsObjectFactory();
        ArrayList propertyList = new ArrayList();
        for (Map.Entry<String, ?> property : properties.entrySet()) {
            void var14_19;
            Object var16_21;
            PropertyDefinition<?> definition;
            if (property == null || property.getKey() == null) continue;
            String id = property.getKey();
            Object value = property.getValue();
            if (value instanceof Property) {
                Property p = (Property)value;
                if (!id.equals(p.getId())) {
                    throw new IllegalArgumentException("Property id mismatch: '" + id + "' != '" + p.getId() + "'!");
                }
                Object object = value = p.getDefinition().getCardinality() == Cardinality.SINGLE ? p.getFirstValue() : p.getValues();
            }
            if ((definition = type.getPropertyDefinitions().get(id)) == null && allSecondaryTypes != null) {
                for (SecondaryType secondaryType : allSecondaryTypes) {
                    if (secondaryType != null && secondaryType.getPropertyDefinitions() != null && (definition = secondaryType.getPropertyDefinitions().get(id)) != null) break;
                }
            }
            if (definition == null) {
                throw new IllegalArgumentException("Property '" + id + "' is not valid for this type or one of the secondary types!");
            }
            if (updatabilityFilter != null && !updatabilityFilter.contains((Object)definition.getUpdatability())) continue;
            if (value == null) {
                Object var14_16 = null;
            } else if (value instanceof List) {
                if (definition.getCardinality() != Cardinality.MULTI) {
                    throw new IllegalArgumentException("Property '" + id + "' is not a multi value property!");
                }
                List list = (List)value;
                Class<?> valueClazz = null;
                for (Object e : list) {
                    if (e == null) {
                        throw new IllegalArgumentException("Property '" + id + "' contains null values!");
                    }
                    if (valueClazz == null) {
                        valueClazz = e.getClass();
                        continue;
                    }
                    if (valueClazz.isInstance(e)) continue;
                    throw new IllegalArgumentException("Property '" + id + "' is inhomogeneous!");
                }
            } else {
                if (definition.getCardinality() != Cardinality.SINGLE) {
                    throw new IllegalArgumentException("Property '" + id + "' is not a single value property!");
                }
                List<?> list = Collections.singletonList(value);
            }
            PropertyData<String> propertyData = null;
            Object v1 = var16_21 = CollectionsHelper.isNullOrEmpty(var14_19) ? null : var14_19.get(0);
            if (definition instanceof PropertyStringDefinition) {
                if (var16_21 == null) {
                    propertyData = bof.createPropertyStringData(id, (List<String>)null);
                } else if (var16_21 instanceof String) {
                    propertyData = bof.createPropertyStringData(id, (List<String>)var14_19);
                } else {
                    this.throwWrongTypeError(var16_21, "string", String.class, id);
                }
            } else if (definition instanceof PropertyIdDefinition) {
                if (var16_21 == null) {
                    propertyData = bof.createPropertyIdData(id, (List<String>)null);
                } else if (var16_21 instanceof String) {
                    propertyData = bof.createPropertyIdData(id, (List<String>)var14_19);
                } else {
                    this.throwWrongTypeError(var16_21, "string", String.class, id);
                }
            } else if (definition instanceof PropertyHtmlDefinition) {
                if (var16_21 == null) {
                    propertyData = bof.createPropertyHtmlData(id, (List<String>)var14_19);
                } else if (var16_21 instanceof String) {
                    propertyData = bof.createPropertyHtmlData(id, (List<String>)var14_19);
                } else {
                    this.throwWrongTypeError(var16_21, "html", String.class, id);
                }
            } else if (definition instanceof PropertyUriDefinition) {
                if (var16_21 == null) {
                    propertyData = bof.createPropertyUriData(id, (List<String>)null);
                } else if (var16_21 instanceof String) {
                    propertyData = bof.createPropertyUriData(id, (List<String>)var14_19);
                } else {
                    this.throwWrongTypeError(var16_21, "uri", String.class, id);
                }
            } else if (definition instanceof PropertyIntegerDefinition) {
                if (var16_21 == null) {
                    propertyData = bof.createPropertyIntegerData(id, (List<BigInteger>)null);
                } else if (var16_21 instanceof BigInteger) {
                    propertyData = bof.createPropertyIntegerData(id, (List<BigInteger>)var14_19);
                } else if (var16_21 instanceof Byte || var16_21 instanceof Short || var16_21 instanceof Integer || var16_21 instanceof Long) {
                    list = new ArrayList<BigInteger>(var14_19.size());
                    for (Object v : var14_19) {
                        list.add(BigInteger.valueOf(((Number)v).longValue()));
                    }
                    propertyData = bof.createPropertyIntegerData(id, list);
                } else {
                    this.throwWrongTypeError(var16_21, "integer", BigInteger.class, id);
                }
            } else if (definition instanceof PropertyBooleanDefinition) {
                if (var16_21 == null) {
                    propertyData = bof.createPropertyBooleanData(id, (List<Boolean>)null);
                } else if (var16_21 instanceof Boolean) {
                    propertyData = bof.createPropertyBooleanData(id, (List<Boolean>)var14_19);
                } else {
                    this.throwWrongTypeError(var16_21, "boolean", Boolean.class, id);
                }
            } else if (definition instanceof PropertyDecimalDefinition) {
                if (var16_21 == null) {
                    propertyData = bof.createPropertyDecimalData(id, (List<BigDecimal>)null);
                } else if (var16_21 instanceof BigDecimal) {
                    propertyData = bof.createPropertyDecimalData(id, (List<BigDecimal>)var14_19);
                } else if (var16_21 instanceof Float || var16_21 instanceof Double || var16_21 instanceof Byte || var16_21 instanceof Short || var16_21 instanceof Integer || var16_21 instanceof Long) {
                    list = new ArrayList(var14_19.size());
                    for (Object v : var14_19) {
                        list.add((BigInteger)((Object)new BigDecimal(v.toString())));
                    }
                    propertyData = bof.createPropertyDecimalData(id, list);
                } else {
                    this.throwWrongTypeError(var16_21, "decimal", BigDecimal.class, id);
                }
            } else if (definition instanceof PropertyDateTimeDefinition) {
                if (var16_21 == null) {
                    propertyData = bof.createPropertyDateTimeData(id, (List<GregorianCalendar>)null);
                } else if (var16_21 instanceof GregorianCalendar) {
                    propertyData = bof.createPropertyDateTimeData(id, (List<GregorianCalendar>)var14_19);
                } else if (var16_21 instanceof Date) {
                    list = new ArrayList(var14_19.size());
                    for (Object d : var14_19) {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTimeZone(DateTimeHelper.GMT);
                        cal.setTime((Date)d);
                        list.add((BigInteger)((Object)cal));
                    }
                    propertyData = bof.createPropertyDateTimeData(id, list);
                } else {
                    this.throwWrongTypeError(var16_21, "datetime", GregorianCalendar.class, id);
                }
            }
            if (propertyData == null) {
                throw new IllegalArgumentException("Property '" + id + "' doesn't match the property defintion!");
            }
            propertyList.add(propertyData);
        }
        return bof.createPropertiesData(propertyList);
    }

    @Override
    public List<PropertyData<?>> convertQueryProperties(Properties properties) {
        if (properties == null || properties.getProperties() == null) {
            throw new IllegalArgumentException("Properties must be set!");
        }
        return new ArrayList(properties.getPropertyList());
    }

    @Override
    public CmisObject convertObject(ObjectData objectData, OperationContext context) {
        if (objectData == null) {
            throw new IllegalArgumentException("Object data is null!");
        }
        if (objectData.getId() == null) {
            throw new IllegalArgumentException("Object ID property not set!");
        }
        if (objectData.getBaseTypeId() == null) {
            throw new IllegalArgumentException("Base type ID property not set!");
        }
        ObjectType type = this.getTypeFromObjectData(objectData);
        switch (objectData.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                return new DocumentImpl((SessionImpl)this.session, type, objectData, context);
            }
            case CMIS_FOLDER: {
                return new FolderImpl((SessionImpl)this.session, type, objectData, context);
            }
            case CMIS_POLICY: {
                return new PolicyImpl((SessionImpl)this.session, type, objectData, context);
            }
            case CMIS_RELATIONSHIP: {
                return new RelationshipImpl((SessionImpl)this.session, type, objectData, context);
            }
            case CMIS_ITEM: {
                return new ItemImpl((SessionImpl)this.session, type, objectData, context);
            }
            case CMIS_SECONDARY: {
                throw new CmisRuntimeException("Secondary type is used as object type: " + (Object)((Object)objectData.getBaseTypeId()));
            }
        }
        throw new CmisRuntimeException("Unsupported base type: " + (Object)((Object)objectData.getBaseTypeId()));
    }

    @Override
    public QueryResult convertQueryResult(ObjectData objectData) {
        if (objectData == null) {
            throw new IllegalArgumentException("Object data is null!");
        }
        return new QueryResultImpl(this.session, objectData);
    }

    @Override
    public ChangeEvent convertChangeEvent(ObjectData objectData) {
        ChangeType changeType = null;
        GregorianCalendar changeTime = null;
        String objectId = null;
        HashMap properties = null;
        List<String> policyIds = null;
        Acl acl = null;
        if (objectData.getChangeEventInfo() != null) {
            changeType = objectData.getChangeEventInfo().getChangeType();
            changeTime = objectData.getChangeEventInfo().getChangeTime();
        }
        if (objectData.getProperties() != null && objectData.getProperties().getPropertyList() != null) {
            List objectIdList;
            properties = new HashMap(objectData.getProperties().getPropertyList().size());
            for (PropertyData<?> property : objectData.getProperties().getPropertyList()) {
                properties.put(property.getId(), property.getValues());
            }
            if (properties.containsKey("cmis:objectId") && CollectionsHelper.isNotEmpty(objectIdList = (List)properties.get("cmis:objectId"))) {
                objectId = objectIdList.get(0).toString();
            }
            if (objectData.getPolicyIds() != null && objectData.getPolicyIds().getPolicyIds() != null) {
                policyIds = objectData.getPolicyIds().getPolicyIds();
            }
            if (objectData.getAcl() != null) {
                acl = objectData.getAcl();
            }
        }
        return new ChangeEventImpl(changeType, changeTime, objectId, properties, policyIds, acl);
    }

    @Override
    public ChangeEvents convertChangeEvents(String changeLogToken, ObjectList objectList) {
        if (objectList == null) {
            return null;
        }
        ArrayList<ChangeEvent> events = new ArrayList<ChangeEvent>();
        if (objectList.getObjects() != null) {
            for (ObjectData objectData : objectList.getObjects()) {
                if (objectData == null) continue;
                events.add(this.convertChangeEvent(objectData));
            }
        }
        boolean hasMoreItems = objectList.hasMoreItems() == null ? false : objectList.hasMoreItems();
        long totalNumItems = objectList.getNumItems() == null ? -1L : objectList.getNumItems().longValue();
        return new ChangeEventsImpl(changeLogToken, events, hasMoreItems, totalNumItems);
    }

    private void throwWrongTypeError(Object obj, String type, Class<?> clazz, String id) {
        String expectedTypes = BigInteger.class.isAssignableFrom(clazz) ? "<BigInteger, Byte, Short, Integer, Long>" : (BigDecimal.class.isAssignableFrom(clazz) ? "<BigDecimal, Double, Float, Byte, Short, Integer, Long>" : (GregorianCalendar.class.isAssignableFrom(clazz) ? "<java.util.GregorianCalendar, java.util.Date>" : clazz.getName()));
        String message = "Property '" + id + "' is a " + type + " property. Expected type '" + expectedTypes + "' but received a '" + obj.getClass().getName() + "' property.";
        throw new IllegalArgumentException(message);
    }
}

