/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.util.ContentStreamUtils;
import org.apache.chemistry.opencmis.client.util.OperationContextUtils;
import org.apache.chemistry.opencmis.commons.data.MutableContentStream;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public class AppendOutputStream
extends OutputStream {
    public static final OperationContext DOCUMENT_OPERATION_CONTEXT = OperationContextUtils.createMinimumOperationContext("cmis:contentStreamFileName", "cmis:contentStreamMimeType", "cmis:changeToken");
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private Session session;
    private String repId;
    private String documentId;
    private String changeToken;
    private boolean overwrite;
    private String filename;
    private String mimeType;
    private byte[] buffer;
    private int pos;
    private boolean isClosed;

    public AppendOutputStream(Session session, Document doc, boolean overwrite, String filename, String mimeType) {
        this(session, doc, overwrite, filename, mimeType, 65536);
    }

    public AppendOutputStream(Session session, Document doc, boolean overwrite, String filename, String mimeType, int bufferSize) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        if (doc == null) {
            throw new IllegalArgumentException("Document must be set!");
        }
        if (bufferSize < 0) {
            throw new IllegalArgumentException("Buffer size must be positive!");
        }
        this.filename = filename == null ? doc.getContentStreamFileName() : filename;
        this.mimeType = mimeType == null ? doc.getContentStreamMimeType() : mimeType;
        this.session = session;
        this.repId = session.getRepositoryInfo().getId();
        this.documentId = doc.getId();
        this.changeToken = doc.getChangeToken();
        this.overwrite = overwrite;
        this.buffer = new byte[bufferSize];
        this.pos = 0;
        this.isClosed = false;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is already closed!");
        }
        if (this.pos + 1 > this.buffer.length) {
            this.send(new byte[]{(byte)(b & 0xFF)}, 0, 1, false);
        } else {
            this.buffer[this.pos++] = (byte)(b & 0xFF);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is already closed!");
        }
        if (b == null) {
            throw new IllegalArgumentException("Data must not be null!");
        }
        if (off < 0 || off > b.length) {
            throw new IndexOutOfBoundsException("Invalid offset!");
        }
        if (len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("Invalid length!");
        }
        if (len == 0) {
            return;
        }
        if (this.pos + len > this.buffer.length) {
            this.send(b, off, len, false);
        } else {
            System.arraycopy(b, off, this.buffer, this.pos, len);
            this.pos += len;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(false);
    }

    public void flush(boolean isLastChunk) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is already closed!");
        }
        this.send(isLastChunk);
    }

    protected void send(boolean isLastChunk) throws IOException {
        this.send(null, 0, 0, isLastChunk);
    }

    protected void send(byte[] extraBytes, int extraOff, int extraLen, boolean isLastChunk) throws IOException {
        MutableContentStream contentStream = null;
        if (extraBytes == null) {
            if (this.pos == 0) {
                return;
            }
            contentStream = ContentStreamUtils.createByteArrayContentStream(this.filename, this.buffer, 0, this.pos, this.mimeType);
        } else {
            contentStream = this.pos == 0 ? ContentStreamUtils.createByteArrayContentStream(this.filename, extraBytes, extraOff, extraLen, this.mimeType) : ContentStreamUtils.createContentStream(this.filename, this.pos + extraLen, this.mimeType, (InputStream)new ContentStreamUtils.AutoCloseInputStream(new SequenceInputStream(new ByteArrayInputStream(this.buffer, 0, this.pos), new ByteArrayInputStream(extraBytes, extraOff, extraLen))));
        }
        Holder<String> objectIdHolder = new Holder<String>(this.documentId);
        Holder<String> changeTokenHolder = this.changeToken != null ? new Holder<String>(this.changeToken) : null;
        try {
            if (this.overwrite) {
                this.session.getBinding().getObjectService().setContentStream(this.repId, objectIdHolder, Boolean.TRUE, changeTokenHolder, this.session.getObjectFactory().convertContentStream(contentStream), null);
                this.overwrite = false;
            } else {
                this.session.getBinding().getObjectService().appendContentStream(this.repId, objectIdHolder, changeTokenHolder, this.session.getObjectFactory().convertContentStream(contentStream), isLastChunk, null);
            }
        }
        catch (Exception e) {
            this.isClosed = true;
            throw new IOException("Could not append to document: " + e.toString(), e);
        }
        if (objectIdHolder.getValue() != null) {
            this.documentId = objectIdHolder.getValue();
        }
        if (changeTokenHolder != null) {
            this.changeToken = changeTokenHolder.getValue();
        }
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean isLastChunk) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is already closed!");
        }
        if (this.pos > 0) {
            this.flush(isLastChunk);
        }
    }
}

