/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.shared.configuration;

import com.indy.engine.shared.configuration.Messages;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableHandler {
    public static String updateString(String str) throws VariableResolutionException {
        String regexp = "\\$\\{([^\\:}]*):([^}\\:]*)\\}|\\$\\{([^:}]*)\\:([^:}]*)\\:(.*)\\}";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(str);
        String result = str;
        HashSet<String> alreadyMatched = new HashSet<String>();
        while (matcher.find()) {
            String value;
            String name;
            String type;
            boolean group5notnull;
            String def = null;
            boolean group1notnull = matcher.group(1) != null;
            boolean group2notnull = matcher.group(2) != null;
            boolean group3notnull = matcher.group(3) != null;
            boolean group4notnull = matcher.group(4) != null;
            boolean bl = group5notnull = matcher.group(5) != null;
            if (!(!group1notnull || !group2notnull || group3notnull && group4notnull && group5notnull)) {
                type = matcher.group(1);
                name = matcher.group(2);
            } else if ((!group1notnull || !group2notnull) && group3notnull && group4notnull && group5notnull) {
                type = matcher.group(3);
                name = matcher.group(4);
                def = matcher.group(5);
            } else {
                throw new VariableResolutionException(Messages.getString("VariableHandler.0"));
            }
            if (!type.equals("environment.variable") && !type.equals("java.property")) {
                throw new VariableResolutionException(Messages.getString("VariableHandler.1"));
            }
            if (type.equals("environment.variable")) {
                if (alreadyMatched.contains(matcher.group(0))) continue;
                value = System.getenv(name);
                if (value == null) {
                    value = def;
                }
                if (value == null) {
                    throw new VariableResolutionException(String.valueOf(Messages.getString("VariableHandler.2")) + name + Messages.getString("VariableHandler.3"));
                }
                result = result.replace(matcher.group(0), value);
                alreadyMatched.add(matcher.group(0));
                continue;
            }
            if (!type.equals("java.property") || alreadyMatched.contains(matcher.group(0))) continue;
            value = System.getProperty(name);
            if (value == null) {
                value = def;
            }
            if (value == null) {
                throw new VariableResolutionException(String.valueOf(Messages.getString("VariableHandler.4")) + name + Messages.getString("VariableHandler.5"));
            }
            result = result.replace(matcher.group(0), value);
            alreadyMatched.add(matcher.group(0));
        }
        return result;
    }

    public static class VariableResolutionException
    extends Exception {
        public VariableResolutionException(String message) {
            super(message);
        }
    }
}

