/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.uberbuilder.executor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UberRunner {
    public static final Logger LOGGER = Logger.getLogger(UberRunner.class.getName());
    private static final String P_DEBUG = "-debug";
    private static final String P_TMP_FOLDER = "-deploymentFolder";
    private File runtimeDeploymentFolder;

    private UberRunner(boolean debug, File runtimeDeploymentFolder) {
        this.runtimeDeploymentFolder = runtimeDeploymentFolder;
        if (debug) {
            Handler consoleHandler = null;
            Handler[] handlerArray = LOGGER.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                if (h instanceof ConsoleHandler) {
                    consoleHandler = (ConsoleHandler)h;
                    break;
                }
                ++n2;
            }
            if (consoleHandler == null) {
                consoleHandler = new ConsoleHandler();
                LOGGER.addHandler(consoleHandler);
            }
            consoleHandler.setLevel(Level.FINEST);
            consoleHandler.setFormatter(new SimpleFormatter());
            LOGGER.setUseParentHandlers(false);
            LOGGER.setLevel(Level.FINEST);
        }
    }

    private void deployRuntime() throws IOException, URISyntaxException {
        Path runtimeJar = this.getRuntimeJarPath();
        LOGGER.log(Level.FINEST, String.format("deploying runtime from %s into %s", runtimeJar, this.runtimeDeploymentFolder));
        this.unzip(runtimeJar, this.runtimeDeploymentFolder.toPath());
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        boolean debug = args != null && argsList.contains(P_DEBUG);
        File deploymentFolder = null;
        if (debug) {
            String s = System.getProperty("java.io.tmpdir");
            File f = new File(String.valueOf(s) + "/com.indy.runtime.uber-" + UUID.randomUUID().toString());
            f.mkdirs();
            deploymentFolder = f;
            LOGGER.log(Level.FINEST, String.format("debug mode will not cleanup the deployment folder %s", deploymentFolder));
        } else {
            try {
                deploymentFolder = Files.createTempDirectory("com.indy.runtime.uber", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-303);
            }
        }
        String javaHome = System.getProperty("java.home");
        String javaBin = String.valueOf(javaHome) + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        LinkedList<String> command = new LinkedList<String>();
        command.add(javaBin);
        command.add("-cp");
        command.add(String.valueOf(System.getProperty("user.dir")) + "/" + classpath);
        command.add(Executor.class.getName());
        command.addAll(Arrays.asList(args));
        command.add(P_TMP_FOLDER);
        command.add("\"" + deploymentFolder.getAbsolutePath() + "\"");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(deploymentFolder);
        Process process = builder.inheritIO().start();
        int processExitCode = process.waitFor();
        if (!debug) {
            try {
                StringBuilder lockedFiles = new StringBuilder();
                Files.walk(deploymentFolder.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(p -> {
                    if (!p.delete()) {
                        lockedFiles.append(String.valueOf(p.getAbsolutePath()) + "\n");
                    }
                });
                if (lockedFiles.length() > 0) {
                    System.out.println("WARNING : the following have not been successfully deleted : \n" + lockedFiles.toString());
                }
            }
            catch (IOException e) {
                System.err.println("Failed to delete deployment folder " + deploymentFolder);
                e.printStackTrace();
            }
        }
        System.exit(processExitCode);
    }

    private void execute(String[] args) throws Exception {
        LOGGER.log(Level.FINEST, "Executing UberRunner...");
        Operation op = null;
        try {
            op = Operation.valueOf(args[0]);
            if (op == null) {
                throw new Exception("Unknown operation");
            }
        }
        catch (Exception ex) {
            throw new Exception("The first argument must be within " + Operation.values(), ex);
        }
        System.setProperty("stambia.classpath.v1.core", String.valueOf(this.runtimeDeploymentFolder.getAbsolutePath().replace("\\", "/")) + "/runtime/lib/core/**/*.jar;" + this.runtimeDeploymentFolder.getAbsolutePath().replace("\\", "/") + "/runtime/modules/core/*.jar");
        System.setProperty("stambia.classpath.v1.internal", String.valueOf(this.runtimeDeploymentFolder.getAbsolutePath().replace("\\", "/")) + "/runtime/lib/internal/*.jar");
        System.setProperty("xdi.designer.module.path.v1", String.valueOf(this.runtimeDeploymentFolder.getAbsolutePath().replace("\\", "/")) + "/runtime/modules");
        System.setProperty("com.indy.engine.installation.folder", String.valueOf(this.runtimeDeploymentFolder.getAbsolutePath()) + "/runtime");
        LOGGER.log(Level.FINEST, "System Properties :");
        LOGGER.log(Level.FINEST, String.format("stambia.classpath.v1.core=%s", System.getProperty("stambia.classpath.v1.core")));
        LOGGER.log(Level.FINEST, String.format("stambia.classpath.v1.internal=%s", System.getProperty("stambia.classpath.v1.internal")));
        LOGGER.log(Level.FINEST, String.format("xdi.designer.module.path.v1=%s", System.getProperty("xdi.designer.module.path.v1")));
        LOGGER.log(Level.FINEST, String.format("com.indy.engine.installation.folder=%s", System.getProperty("com.indy.engine.installation.folder")));
        Throwable throwable = null;
        Object var4_6 = null;
        try (URLClassLoader runtimeRootClassLoader = new URLClassLoader(new URL[]{new File(this.runtimeDeploymentFolder, "runtime/lib/indyEngineCoreModule.jar").toURI().toURL(), new File(this.runtimeDeploymentFolder, "runtime/lib/indyEngineLauncher.jar").toURI().toURL()});){
            if (args == null || args.length == 0) {
                throw new Exception("No argument provided");
            }
            ArrayList<String> _args = new ArrayList<String>();
            _args.add("-mainclass");
            _args.add(op.className);
            _args.add("-conf");
            _args.add(String.valueOf(this.runtimeDeploymentFolder.getAbsolutePath()) + "/runtime/properties/engineParameters.xml");
            _args.addAll(Arrays.asList(Arrays.copyOfRange(args, 1, args.length)));
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = runtimeRootClassLoader.loadClass("com.indy.engine.launcher.MainLauncher");
                Method met = clazz.getMethod("main", String[].class);
                StringBuffer buf = new StringBuffer();
                _args.forEach(s -> {
                    StringBuffer stringBuffer2 = buf.append(" " + s);
                });
                Thread.currentThread().setContextClassLoader(runtimeRootClassLoader);
                LOGGER.log(Level.FINEST, String.format("Executing %s.main(%s)", clazz.getName(), buf.toString()));
                met.invoke(null, new Object[]{_args.toArray(new String[_args.size()])});
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Path getRuntimeJarPath() throws URISyntaxException {
        String debugLocation = System.getProperty("xdi.uberjar.debug.location");
        if (debugLocation != null && !debugLocation.isEmpty()) {
            return new File(debugLocation).toPath();
        }
        URL url = UberRunner.class.getProtectionDomain().getCodeSource().getLocation();
        return new File(url.toURI()).toPath();
    }

    private void unzip(Path zipFile, Path destinationFolder) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(zipFile, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                Path toPath = destinationFolder.resolve(entry.getName());
                if (!entry.getName().startsWith("runtime")) continue;
                if (entry.isDirectory()) {
                    Files.createDirectories(toPath, new FileAttribute[0]);
                    continue;
                }
                Files.copy(zipInputStream, toPath, new CopyOption[0]);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /* synthetic */ UberRunner(boolean bl, File file, UberRunner uberRunner) {
        this(bl, file);
    }

    public static class Executor {
        public static void main(String[] args) {
            List<String> argsList = new ArrayList<String>(Arrays.asList(args));
            boolean debug = args != null && argsList.contains(UberRunner.P_DEBUG);
            argsList.remove(UberRunner.P_DEBUG);
            int i = argsList.indexOf(UberRunner.P_TMP_FOLDER);
            String folderPath = ((String)argsList.get(i + 1)).replace("\"", "");
            argsList = argsList.subList(0, i);
            File deploymentFolder = new File(folderPath);
            UberRunner runner = new UberRunner(debug, deploymentFolder, null);
            try {
                runner.deployRuntime();
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(-101);
            }
            try {
                runner.execute(argsList.toArray(new String[argsList.size()]));
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(-202);
            }
        }
    }

    public static enum Operation {
        StartDelivery("com.indy.engine.StartDelivery");

        private String className;

        private Operation(String className) {
            this.className = className;
        }
    }
}

