/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.gene;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenerationMap {
    private HashMap<String, String> generated = new HashMap();
    private HashMap<String, Boolean> handledConnectionByActionId = new HashMap();
    private HashMap<String, Set<String>> parametersKeysById = new HashMap();

    public void store(String key, String code) {
        this.generated.put(key, code);
        if (key.contains(".parameter.")) {
            String k = key.substring(0, key.indexOf("."));
            Set<String> l = this.parametersKeysById.get(k);
            if (l == null) {
                l = new HashSet<String>();
                this.parametersKeysById.put(k, l);
            }
            l.add(key);
        }
    }

    public List<String> getStoredParameterKeys(String nodeId, Collection<String> excludedKeys) {
        Collection paramKeys = this.parametersKeysById.get(nodeId);
        if (paramKeys == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> res = new ArrayList<String>(paramKeys);
        res.removeAll(excludedKeys);
        return res;
    }

    public boolean isStored(String key) {
        return this.generated.get(key) != null;
    }

    public String getCode(String key) {
        return this.generated.get(key);
    }

    public Map<String, String> getAll() {
        return this.generated;
    }

    public boolean isConnectionHandled(String actionId) {
        return this.handledConnectionByActionId.get(actionId) == Boolean.TRUE;
    }

    public void setConnectionHandled(String actionId) {
        this.handledConnectionByActionId.put(actionId, Boolean.TRUE);
    }
}

