/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.gene.process;

import com.indy.xsl.gene.process.GenerationEventHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

public class Graph {
    private static Graph currentGraph = null;
    private static HashMap<String, String> variablesUUID = new HashMap();
    private static HashMap<String, String> parametersUUID = new HashMap();
    static final Pattern genPattern = Pattern.compile("[%\\{]");
    static final MessageDigest MD5Digest;
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();
    private Collection<String> globalVariables = Collections.EMPTY_LIST;
    private HashMap<String, Node> nodeMap = new HashMap();
    private HashMap<String, List<Node>> nodeMapBySrcId = new HashMap();
    private Node root;
    private HashMap<Node, List<Edge>> edgesCache = new HashMap();
    private HashMap<Node, Boolean> cacheStartingNodes = new HashMap();
    private HashMap<Node, List<Edge>> cacheTrgEdges = new HashMap();
    GenerationEventHandler geneHandler = null;
    private HashMap<Node, List<Node>> cachedOutputNodes = new HashMap();
    private HashMap<Node, List<Node>> cachedInputNodes = new HashMap();

    static {
        try {
            MD5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setCurrentGraph(Graph graph) {
        parametersUUID.clear();
        variablesUUID.clear();
        currentGraph = graph;
    }

    public static String MD5(String str) {
        try {
            byte[] array = MD5Digest.digest(str.getBytes("UTF-8"));
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < array.length) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
                ++i;
            }
            return sb.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getLinkInputNodeInfoId(String nodeInfoId) {
        GenerationEventHandler.NodeInfo i = Graph.currentGraph.geneHandler.getNodeInfo(nodeInfoId);
        return i.getInputs().isEmpty() ? null : i.getInputs().iterator().next().getId();
    }

    public void addNode(Node node) {
        this.nodes.add(node);
        this.nodeMap.put(node.actionBaseId, node);
        List<Node> l = this.nodeMapBySrcId.get(node.getSrcId());
        if (l == null) {
            l = new ArrayList<Node>();
            this.nodeMapBySrcId.put(node.getSrcId(), l);
        }
        l.add(node);
        this.edgesCache.put(node, new ArrayList());
        this.cacheTrgEdges.put(node, new ArrayList());
        this.cachedOutputNodes.put(node, new ArrayList());
        this.cachedInputNodes.put(node, new ArrayList());
    }

    public Node getNodeById(String id) {
        return this.nodeMap.get(id);
    }

    public Node getNodeBySrcId(String id) {
        for (Node n : this.nodeMap.values()) {
            if (n == null || !n.getSrcId().equals(id)) continue;
            return n;
        }
        return null;
    }

    public void addEdge(Node source, Node trg) {
        if (trg == null) {
            return;
        }
        Edge e = null;
        e = new Edge(source, trg);
        this.edges.add(e);
        List<Edge> l = this.edgesCache.get(source);
        l.add(e);
        l = this.cacheTrgEdges.get(trg);
        l.add(e);
        this.cachedOutputNodes.get(source).add(trg);
        this.cachedInputNodes.get(trg).add(source);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdge(Node startingPoint) {
        return this.edgesCache.get(startingPoint);
    }

    public void setGlobalVariables(Set<String> xslGlobalVariables) {
        this.globalVariables = xslGlobalVariables;
    }

    public Collection<String> getGlobalVariables() {
        return this.globalVariables;
    }

    public void setRoot(Node root) {
        this.root = root;
    }

    public Node getRoot() {
        return this.root;
    }

    public boolean isStarting(Node n) {
        Boolean b = this.cacheStartingNodes.get(n);
        if (b == null) {
            if (n.isStarting()) {
                b = true;
            } else {
                List<Edge> l = this.cacheTrgEdges.get(n);
                if (!l.isEmpty()) {
                    b = false;
                }
            }
            if (b == null) {
                b = true;
            }
            this.cacheStartingNodes.put(n, b);
        }
        return b;
    }

    public static String handleGenerationEvent(String id, String eventTypeCode, String iterationName) {
        if (Graph.currentGraph.geneHandler == null) {
            Graph.currentGraph.geneHandler = new GenerationEventHandler(currentGraph);
        }
        return Graph.currentGraph.geneHandler.handleEvent(new GenerationEventHandler.GenerationEvent(id, GenerationEventHandler.GenerationEventType.valueOf(eventTypeCode), iterationName));
    }

    public static String getCurrentPath() {
        return Graph.currentGraph.geneHandler.getCurrentPath();
    }

    public static String getCurrentNodeInfoId() {
        return Graph.currentGraph.geneHandler.getCurrentNodeInfo().getId();
    }

    public static List<String> getChildrenInstance(String nodeInfoId) {
        List<String> l = Graph.currentGraph.geneHandler.getChildrenSteps(nodeInfoId);
        return l;
    }

    public static String getNodeId(String nodeInfoId) {
        String s = Graph.currentGraph.geneHandler.getNodeInfo(nodeInfoId).getNode().getBaseId();
        return s;
    }

    public static GenerationEventHandler.NodeInfo getNodeInfo(String nodeInfoId) {
        return Graph.currentGraph.geneHandler.getNodeInfo(nodeInfoId);
    }

    public static boolean isEvaluated(String nodeInfoId) {
        return Graph.currentGraph.geneHandler.isEvaluated(nodeInfoId);
    }

    public static boolean needGeneration(String nodeInfoId) {
        boolean b = Graph.currentGraph.geneHandler.needGeneration(nodeInfoId);
        return b;
    }

    public static String getFirstNodeInfoIdWithRepetition(String fromNodeInfoId) {
        return Graph.currentGraph.geneHandler.getFirstNodeInfoIdWithRepetition(fromNodeInfoId);
    }

    public GenerationEventHandler.NodeInfo getDeliveryGraph() throws Exception {
        return this.geneHandler.getDeliveryGraph();
    }

    public void applySubstitution(Map<String, String> substitutionMap) {
        for (String k : substitutionMap.keySet()) {
            String[] p = k.split("\\.");
            Node n = this.nodeMap.get(p[0]);
            if (n == null) continue;
            if (p[1].equals("condition")) {
                n.conditionCode = substitutionMap.get(k);
                continue;
            }
            if (!p[1].equals("repetitionQuery")) continue;
            n.repetitionQuery = substitutionMap.get(k);
            n.repetitionQueryHash = null;
        }
        this.nodeMapBySrcId.clear();
        this.nodeMapBySrcId = null;
    }

    public static String getProcNodeXPathExpression(String nodeId) {
        return "$p1/" + currentGraph.getNodeById(nodeId).getProcContextPath();
    }

    public List<Node> getInput(Node n) {
        return this.cachedInputNodes.get(n);
    }

    public List<Node> getOutput(Node n) {
        return this.cachedOutputNodes.get(n);
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public static Graph getCurrentGraph() {
        return currentGraph;
    }

    public String getParameterDiagnosticPath(String parameterSrcId) {
        for (Node n : this.nodeMap.values()) {
            if (n.getType() == Type.LINK) continue;
            for (Parameter p : ((Node)n).context.parameter) {
                if (!p.md5Id.equals(parameterSrcId)) continue;
                return String.valueOf(n.getDiagnosticPath()) + "/" + p.name;
            }
        }
        return null;
    }

    public String getXslVariableDiagnosticPath(String xslVariableId) {
        for (Node n : this.nodeMap.values()) {
            if (n.getType() == Type.LINK) continue;
            for (XslVariable v : n.getContext().variables) {
                if (!v.md5Id.equals(xslVariableId)) continue;
                return String.valueOf(n.getDiagnosticPath()) + "/" + v.name;
            }
        }
        return null;
    }

    public List<Node> findByRepetitionQueryHash(String hash) {
        ArrayList<Node> l = new ArrayList<Node>();
        for (Node n : this.nodeMap.values()) {
            if (n.repetitionQueryHash == null || !n.repetitionQueryHash.equals(hash)) continue;
            l.add(n);
        }
        return l;
    }

    public static class Action
    extends Node {
        private String actionCode;
        private String name;
        private boolean starting;
        private String moduleName;
        private String srcId;

        public Action(String id, String name, String generationCondition, String repetitionQuery, String repetitionQueryVar, String repetitionType, boolean starting, ModelInfo modelInfo, Integer generationOrder, String moduleName) {
            super(Type.ACTION, id, generationCondition, repetitionQuery, repetitionQueryVar, repetitionType, modelInfo, generationOrder);
            this.name = name;
            this.starting = starting;
            this.moduleName = moduleName;
        }

        @Override
        public String getSrcId() {
            if (this.srcId == null) {
                for (AltId a : this.getAltId()) {
                    if (!a.origin.equals("compilation")) continue;
                    this.srcId = a.value;
                }
                if (this.srcId == null) {
                    this.srcId = this.getBaseId();
                }
            }
            return this.srcId;
        }

        @Override
        public String getComment() {
            return "Action " + this.getName() + " " + this.getBaseId();
        }

        public String getActionCode() {
            return this.actionCode;
        }

        public void setActionCode(String code) {
            this.actionCode = code;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean isStarting() {
            return this.starting;
        }

        public boolean needParse() {
            return this.actionCode != null && !this.actionCode.trim().isEmpty() && genPattern.matcher(this.actionCode).find();
        }

        @Override
        protected String getDiagnosticName() {
            return this.getName();
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public boolean needParseModuleName() {
            return this.moduleName != null && !this.moduleName.trim().isEmpty() && genPattern.matcher(this.moduleName).find();
        }
    }

    public static class AltId {
        public String origin;
        public String value;

        public AltId(String origin, String value) {
            this.origin = origin;
            this.value = value;
        }
    }

    public static class CodeEvent {
        public String code;

        public CodeEvent(String code) {
            this.code = code;
        }
    }

    public static class Context {
        public List<XslVariable> variables = new ArrayList<XslVariable>();
        public List<MdLink> mdLink = new ArrayList<MdLink>();
        public List<Parameter> parameter = new ArrayList<Parameter>();
        public String stepId;
        public List<String> orderedVarNames = null;
        public Map<String, Object> objs = null;
        public Context parent;
        private boolean sortedVar = false;

        public Context(String id, Context parent) {
            this.stepId = id;
            this.parent = parent;
        }

        public Object getVariable(String varName) {
            return this.objs.get(varName);
        }

        public List<Parameter> getParameters() {
            return this.parameter;
        }

        public boolean isEmpty() {
            return this.mdLink.size() + this.variables.size() == 0;
        }

        public List<XslVariable> getSortedVariables() {
            if (!this.sortedVar) {
                final ArrayList<XslVariable> initialOrder = new ArrayList<XslVariable>(this.variables);
                Collections.sort(this.variables, new Comparator<XslVariable>(){

                    @Override
                    public int compare(XslVariable v1, XslVariable v2) {
                        int r = Integer.valueOf(v1.order).compareTo(v2.order);
                        if (r == 0) {
                            if (v1.fromParameter) {
                                if (!v2.fromParameter) {
                                    return 1;
                                }
                            } else if (v2.fromParameter && !v1.fromParameter) {
                                return -1;
                            }
                            return Integer.valueOf(initialOrder.indexOf(v1)).compareTo(initialOrder.indexOf(v2));
                        }
                        return r;
                    }
                });
                this.sortedVar = true;
            }
            return this.variables;
        }

        public List<String> getMdLinkVariables() {
            HashSet<String> r = new HashSet<String>();
            if (this.parent != null) {
                for (String string : this.parent.getMdLinkVariables()) {
                    r.add(string);
                }
            }
            for (MdLink mdLink : this.mdLink) {
                r.add(mdLink.name);
            }
            for (XslVariable xslVariable : this.variables) {
                r.remove(xslVariable.name);
            }
            ArrayList<String> arrayList = new ArrayList<String>(r);
            Collections.sort(arrayList);
            return arrayList;
        }

        public Parameter getParameter(String paramName) {
            for (Parameter p : this.parameter) {
                if (!p.name.equals(paramName)) continue;
                return p;
            }
            return null;
        }
    }

    public class Edge {
        private Node source;
        private Node trg;

        public Edge(Node source, Node trg) {
            this.source = source;
            this.trg = trg;
        }

        public Node getSource() {
            return this.source;
        }

        public Node getTrg() {
            return this.trg;
        }
    }

    public static enum GenerationMode {
        OK,
        KO,
        OK_KO;


        public boolean match(GenerationMode mode) {
            switch (this) {
                case OK_KO: {
                    return true;
                }
                case KO: {
                    return mode == OK_KO || mode == KO;
                }
                case OK: {
                    return mode == OK_KO || mode == OK;
                }
            }
            return false;
        }
    }

    public static class MdLink {
        public String target;
        public String id;
        public String name;
        public String input;
        public String output;
        public String fault;
        public String publishParameter;
        public boolean visibleInParent = false;

        public MdLink(String target, String id, String name, String input, String output, String fault, String publishParameter, boolean visibleInParent) {
            this.target = target;
            this.id = id;
            this.name = name;
            this.input = input;
            this.output = output;
            this.fault = fault;
            this.publishParameter = publishParameter;
            this.visibleInParent = visibleInParent;
        }
    }

    public static class ModelInfo {
        public String metaInf;
        public String repetitionPublishParameters;
        public String toleratedErrors;
        public String dynamicName;
        public String nbCycles;
        public String restartPoint;
        public String stopBindOnError;
        public String encrypted;
        public String technologie;
        public String semaphoreName;
        public String executionType;
        public String executionCondition;
        public String executionTrigger;
        public String srcId;
        private Boolean needParse = null;
        private Boolean dynamicNameNeedParse = null;
        private Boolean semaphoreNameNeedParse = null;

        public boolean needParse() {
            if (this.needParse == null) {
                this.needParse = this.executionCondition != null && !this.executionCondition.trim().isEmpty() && genPattern.matcher(this.executionCondition).find();
            }
            return this.needParse;
        }

        public ModelInfo cloneAsEmpty() {
            ModelInfo i = new ModelInfo();
            i.dynamicName = this.dynamicName;
            i.encrypted = this.encrypted;
            i.executionCondition = this.executionCondition;
            i.executionTrigger = this.executionTrigger;
            i.executionType = this.executionType;
            i.metaInf = this.metaInf;
            i.nbCycles = this.nbCycles;
            i.repetitionPublishParameters = this.repetitionPublishParameters;
            i.restartPoint = this.restartPoint;
            i.stopBindOnError = this.stopBindOnError;
            i.toleratedErrors = this.toleratedErrors;
            i.technologie = "com.indy.engine.actionCodes.EmptyActionCodeI";
            i.semaphoreName = this.semaphoreName;
            return i;
        }

        public boolean needParse4DynamicName() {
            if (this.dynamicNameNeedParse == null) {
                this.dynamicNameNeedParse = this.dynamicName != null && !this.dynamicName.trim().isEmpty() && genPattern.matcher(this.dynamicName).find();
            }
            return this.dynamicNameNeedParse;
        }

        public boolean needParse4SemaphoreName() {
            if (this.semaphoreNameNeedParse == null) {
                this.semaphoreNameNeedParse = this.semaphoreName != null && !this.semaphoreName.trim().isEmpty() && genPattern.matcher(this.semaphoreName).find();
            }
            return this.semaphoreNameNeedParse;
        }
    }

    public static abstract class Node {
        private String actionBaseId;
        protected String conditionCode;
        private String repetitionQuery;
        private String repetitionVariable;
        private String repetitionType;
        private Node parent;
        private Context context;
        private List<Node> children = new ArrayList<Node>();
        private Type type;
        private List<AltId> altIds = new ArrayList<AltId>();
        protected ModelInfo modelInfo;
        private int generationOrder = Integer.MAX_VALUE;
        private String processContextPath = null;
        private String repetitionQueryHash;
        private Boolean needGen = null;

        public String getDiagnosticPath() {
            StringBuffer b = new StringBuffer();
            if (this.getParent() != null) {
                b.append(this.getParent().getDiagnosticPath());
            }
            b.append("/" + this.getDiagnosticName());
            return b.toString();
        }

        protected abstract String getDiagnosticName();

        public String getProcContextPath() {
            if (this.processContextPath == null) {
                String b = "";
                Node current = this;
                while (current != null) {
                    String s = null;
                    if (current.getType() == Type.LINK) {
                        s = "link";
                        for (Edge e : currentGraph.edges) {
                            if (e.trg != current) continue;
                            current = e.source;
                            break;
                        }
                    } else {
                        s = current.getType() == Type.ACTION ? "actionCode" : (current.getParent() == null ? "proc:process" : "subProcess");
                    }
                    b = b.length() > 0 ? String.valueOf(s) + "[@id='" + current.getBaseId() + "']" + "/" + b : String.valueOf(s) + "[@id='" + current.getBaseId() + "']";
                    current = current.getParent();
                }
                this.processContextPath = b;
            }
            return this.processContextPath;
        }

        public Node(Type type, String id, String generationCondition, String repetitionQuery, String repetitionQueryVar, String repetitionType, ModelInfo modelInfo, Integer generationOrder) {
            this.type = type;
            this.actionBaseId = id;
            if (generationCondition != null && !generationCondition.trim().isEmpty()) {
                this.conditionCode = generationCondition;
            }
            if (repetitionQuery != null && !repetitionQuery.trim().isEmpty()) {
                this.repetitionQuery = repetitionQuery;
            }
            if (repetitionQueryVar != null && !repetitionQueryVar.trim().isEmpty()) {
                this.repetitionVariable = repetitionQueryVar;
            }
            this.repetitionType = repetitionType;
            this.modelInfo = modelInfo;
            if (generationOrder != null) {
                this.generationOrder = generationOrder;
            }
        }

        public abstract String getSrcId();

        public Integer getGenerationOrder() {
            return this.generationOrder;
        }

        public String getRepetitionType() {
            return this.repetitionType;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public String getRepetitionQueryVar() {
            return this.repetitionVariable;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public String getBaseId() {
            return this.actionBaseId;
        }

        public boolean hasCondition() {
            return this.conditionCode != null;
        }

        public String getCondition() {
            return this.conditionCode;
        }

        public String getRepetitionQuery() {
            return this.repetitionQuery;
        }

        public String getRepetitionQueryHash() {
            if (this.repetitionQueryHash == null && this.repetitionQuery != null) {
                this.repetitionQueryHash = Graph.MD5(this.repetitionQuery.trim());
            }
            return this.repetitionQueryHash;
        }

        public Context getContext() {
            return this.context;
        }

        public boolean isMapping() {
            for (AltId a : this.getAltId()) {
                if (!"mapping".equals(a.origin)) continue;
                return true;
            }
            return false;
        }

        public abstract String getComment();

        public boolean isStarting() {
            return false;
        }

        public void setContext(Context context) {
            this.context = context;
        }

        public Type getType() {
            return this.type;
        }

        public void addAltId(AltId event) {
            this.altIds.add(event);
        }

        public List<AltId> getAltId() {
            return this.altIds;
        }

        public ModelInfo getModelInfo() {
            return this.modelInfo;
        }

        public boolean needGeneration() {
            if (this.needGen == null) {
                if (this.getType() != Type.LINK) {
                    for (Parameter p : this.getContext().getParameters()) {
                        if (!p.needGeneration()) continue;
                        this.needGen = true;
                        break;
                    }
                }
                if (this.needGen == null && this.modelInfo.needParse4DynamicName()) {
                    this.needGen = true;
                }
                if (this.needGen == null && this.modelInfo.needParse4SemaphoreName()) {
                    this.needGen = true;
                }
                if (this.needGen == null && this.getType() == Type.ACTION) {
                    this.needGen = ((Action)this).actionCode != null && genPattern.matcher(((Action)this).actionCode).find();
                    if (!this.needGen.booleanValue()) {
                        this.needGen = ((Action)this).needParseModuleName();
                    }
                }
                if (this.needGen == null && this.getType() == Type.LINK) {
                    this.needGen = this.getModelInfo().needParse();
                }
                if (this.needGen == null) {
                    this.needGen = false;
                }
            }
            return this.needGen;
        }

        public Collection<Node> getAllContent() {
            HashSet<Node> l = new HashSet<Node>();
            for (Node c : this.getChildren()) {
                if (!l.add(c)) continue;
                l.addAll(c.getAllContent());
            }
            return l;
        }
    }

    public static class NodeLink
    extends Node {
        private GenerationMode mode;
        private boolean isBind;

        public NodeLink(String id, String generationCondition, GenerationMode mode, boolean isBind, ModelInfo modelInfo) {
            super(Type.LINK, id, generationCondition, null, null, null, modelInfo, null);
            this.mode = mode;
            this.isBind = isBind;
        }

        public boolean isBind() {
            return this.isBind;
        }

        public GenerationMode getMode() {
            return this.mode;
        }

        @Override
        public String getComment() {
            return "Link " + this.getBaseId();
        }

        @Override
        public String getSrcId() {
            return super.getBaseId();
        }

        @Override
        protected String getDiagnosticName() {
            return this.getComment();
        }
    }

    public static class Parameter {
        public String id;
        public String value;
        public String name;
        public String type;
        public String input;
        public String output;
        public String fault;
        public String md5Id;
        private boolean needParse = false;
        Boolean needGen = null;

        public Parameter(String id, String value, String name, String type, String input, String output, String fault) {
            this.id = id;
            this.value = value;
            this.name = name;
            this.type = type;
            this.input = input;
            this.output = output;
            this.fault = fault;
            boolean bl = this.needParse = value != null && !value.trim().isEmpty() && genPattern.matcher(value).find();
            if (this.needParse) {
                String uuid = (String)parametersUUID.get(value);
                if (uuid == null) {
                    uuid = UUID.randomUUID().toString();
                    while (parametersUUID.values().contains(uuid)) {
                        uuid = UUID.randomUUID().toString();
                    }
                    parametersUUID.put(value, uuid);
                }
                this.md5Id = uuid;
            } else {
                this.md5Id = id;
            }
        }

        public boolean needGeneration() {
            if (this.needGen == null) {
                this.needGen = this.value == null || this.value.trim().isEmpty() ? Boolean.valueOf(false) : Boolean.valueOf(genPattern.matcher(this.value).find());
            }
            return this.needGen;
        }

        public boolean needParse() {
            return this.needParse;
        }
    }

    public static class Step
    extends Node {
        private String name;
        private boolean starting;
        private String srcId;

        public Step(String id, String name, String generationCondition, String repetitionQuery, String repetitionQueryVar, String repetitionType, boolean starting, ModelInfo modelInfo, Integer generationOrder) {
            super(Type.PROCESS, id, generationCondition, repetitionQuery, repetitionQueryVar, repetitionType, modelInfo, generationOrder);
            this.name = name;
            this.starting = starting;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getComment() {
            return "Step " + this.getName() + " " + this.getBaseId();
        }

        @Override
        public boolean isStarting() {
            return this.starting;
        }

        @Override
        public String getSrcId() {
            if (this.srcId == null) {
                String candidate = null;
                for (AltId a : this.getAltId()) {
                    if (a.origin.equals("compilation")) {
                        candidate = a.value;
                        continue;
                    }
                    if (!a.origin.equals("processRef")) continue;
                    this.srcId = a.value;
                    break;
                }
                if (this.srcId == null) {
                    this.srcId = candidate;
                }
            }
            return this.srcId;
        }

        @Override
        protected String getDiagnosticName() {
            return this.getName();
        }
    }

    public static enum Type {
        PROCESS,
        ACTION,
        LINK;

    }

    public static class XslVariable {
        public String id;
        public String varType;
        public String code;
        public String name;
        public String metaInf;
        public String md5Id;
        public int order = -1;
        private boolean needParse = false;
        boolean fromParameter;
        public boolean visibleInParent;

        public XslVariable(String id, String varType, String code, String order, String name, boolean fromParameter, boolean visibleInParent) {
            String uuid;
            this.id = id;
            this.varType = varType;
            this.code = code;
            this.fromParameter = fromParameter;
            this.visibleInParent = visibleInParent;
            if (order != null) {
                try {
                    this.order = Integer.valueOf(order);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.name = name;
            this.needParse = varType.equals("xsl");
            if (!this.needParse && varType.equals("xpath") && code != null) {
                this.needParse = code.contains("%x{");
            }
            if ((uuid = (String)variablesUUID.get(code)) == null) {
                uuid = UUID.randomUUID().toString();
                while (variablesUUID.values().contains(uuid)) {
                    uuid = UUID.randomUUID().toString();
                }
                variablesUUID.put(code, uuid);
            }
            this.md5Id = uuid;
        }

        public boolean needParse() {
            return this.needParse;
        }
    }
}

