/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.gene.process.internal;

import com.indy.a.PasswordManagerI;
import com.indy.engine.shared.passwordmanagement.IPasswordManagerDelegate;
import com.indy.xsl.gene.process.Graph;
import com.indy.xsl.gene.process.internal.Messages;
import com.indy.xsl.gene.process.internal.OneProceParser;
import com.semarchy.xdi.engine.common.DeliveryChecksumCertifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;

public class EventHandler {
    Stack<Graph.Context> contexts = new Stack();
    HashMap<String, Graph.Node> nodes = new HashMap();
    List<Graph.Node> disabledNodes = new ArrayList<Graph.Node>();
    HashMap<Graph.Node, Collection<String>> links = new HashMap();
    Stack<Graph.Node> nodeStack = new Stack();
    Collection<Graph.Node> parallelizedRepetitionSteps = new HashSet<Graph.Node>();
    HashMap<Graph.Node, Set<String>> candidates4JoinDummyNodes = new HashMap();
    Graph.Node root = null;
    Set<String> xslGlobalVariables = new HashSet<String>();

    public void handleEvent(Object event) {
        if (event instanceof OneProceParser.EndEvent) {
            if (this.nodeStack.peek().getContext() == null) {
                this.nodeStack.peek().setContext(this.contexts.peek());
            }
            switch (((OneProceParser.EndEvent)event).type) {
                case LINK: {
                    break;
                }
                case PROCESS: 
                case ACTION: {
                    this.contexts.pop();
                }
            }
            this.nodeStack.pop();
        } else if (event instanceof Graph.CodeEvent) {
            ((Graph.Action)this.nodes.get(this.contexts.peek().stepId)).setActionCode(((Graph.CodeEvent)event).code);
            Graph.Parameter p = this.contexts.peek().getParameter("CERTIFICATION_CHECKSUM");
            if (p != null) {
                String _code = ((Graph.CodeEvent)event).code.replace("\r", "").replace("\n", "");
                try {
                    boolean isValid = DeliveryChecksumCertifier.getChecksumHelper((IPasswordManagerDelegate)PasswordManagerI.b).validateCertifiedCheckSum(p.value, _code);
                    if (!isValid) {
                        throw new RuntimeException(String.valueOf(((Graph.Action)this.nodes.get(this.contexts.peek().stepId)).getDiagnosticPath()) + Messages.EventHandler_0);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(String.valueOf(((Graph.Action)this.nodes.get(this.contexts.peek().stepId)).getDiagnosticPath()) + Messages.EventHandler_1, e);
                }
            }
        } else if (event instanceof Graph.XslVariable) {
            if (((Graph.XslVariable)event).visibleInParent && this.contexts.peek().parent != null) {
                this.contexts.peek().parent.variables.add((Graph.XslVariable)event);
            } else {
                this.contexts.peek().variables.add((Graph.XslVariable)event);
            }
            this.xslGlobalVariables.add(((Graph.XslVariable)event).name);
        } else if (event instanceof Graph.Parameter) {
            this.contexts.peek().parameter.add((Graph.Parameter)event);
        } else if (event instanceof Graph.MdLink) {
            if (((Graph.MdLink)event).visibleInParent) {
                if (this.contexts.peek().parent != null) {
                    this.contexts.peek().parent.mdLink.add((Graph.MdLink)event);
                } else {
                    this.contexts.peek().mdLink.add((Graph.MdLink)event);
                }
            } else {
                this.contexts.peek().mdLink.add((Graph.MdLink)event);
            }
            this.xslGlobalVariables.add(((Graph.MdLink)event).name);
        } else if (event instanceof OneProceParser.Event) {
            switch (((OneProceParser.Event)event).type) {
                case ACTION: {
                    this.createNode((OneProceParser.Event)event);
                    this.contexts.push(new Graph.Context(((OneProceParser.Event)event).objectId, this.contexts.isEmpty() ? null : this.contexts.peek()));
                    break;
                }
                case PROCESS: {
                    this.createNode((OneProceParser.Event)event);
                    this.contexts.push(new Graph.Context(((OneProceParser.Event)event).objectId, this.contexts.isEmpty() ? null : this.contexts.peek()));
                    break;
                }
                case LINK: {
                    Graph.Node n = this.nodeStack.peek();
                    this.createNode((OneProceParser.Event)event);
                    this.createLink(this.nodes.get(n.getBaseId()), ((OneProceParser.Event)event).objectId);
                    this.createLink(this.nodes.get(((OneProceParser.Event)event).objectId), ((OneProceParser.Event)event).linkTrgId);
                    if (!this.parallelizedRepetitionSteps.contains(n) || n.getType() == Graph.Type.LINK) break;
                    String couples = String.valueOf(n.getBaseId()) + "+" + ((OneProceParser.Event)event).objectId + "+" + ((OneProceParser.Event)event).linkTrgId;
                    Set<String> l = this.candidates4JoinDummyNodes.get(n);
                    if (l == null) {
                        l = new HashSet<String>();
                        this.candidates4JoinDummyNodes.put(n, l);
                    }
                    l.add(couples);
                }
            }
            if (this.root == null && this.nodeStack.size() == 1 && this.nodeStack.peek().getParent() == null) {
                this.root = this.nodeStack.peek();
            }
        } else if (event instanceof Graph.AltId) {
            Graph.Node n = this.nodeStack.peek();
            n.addAltId((Graph.AltId)event);
        }
    }

    private void createLink(Graph.Node node, String trgId) {
        Collection<String> c = this.links.get(node);
        if (c == null) {
            c = new HashSet<String>();
            this.links.put(node, c);
        }
        c.add(trgId);
    }

    private void createNode(OneProceParser.Event event) {
        Graph.Node parent = this.nodeStack.isEmpty() ? null : this.nodeStack.peek();
        Graph.Node n = null;
        switch (event.type) {
            case ACTION: {
                n = new Graph.Action(event.objectId, event.objectName, event.geneCondition, event.repetitionQuery, event.repetitionQueryVar, event.repetitionType, event.isBeginAction, event.modelInfo, event.generationOrder, event.moduleName);
                break;
            }
            case LINK: {
                n = new Graph.NodeLink(event.objectId, event.geneCondition, event.linkType, event.isBind, event.modelInfo);
                if (parent.getType() == Graph.Type.LINK) break;
                parent = parent.getParent();
                break;
            }
            case PROCESS: {
                n = new Graph.Step(event.objectId, event.objectName, event.geneCondition, event.repetitionQuery, event.repetitionQueryVar, event.repetitionType, event.isBeginAction, event.modelInfo, event.generationOrder);
            }
        }
        if (!event.enabled) {
            this.disabledNodes.add(n);
        }
        this.nodes.put(event.objectId, n);
        this.nodeStack.push(n);
        this.links.put(n, new HashSet());
        if (parent != null) {
            parent.getChildren().add(n);
            n.setParent(parent);
        }
        if (n.getRepetitionQueryVar() != null) {
            this.xslGlobalVariables.add(n.getRepetitionQueryVar());
        }
        if (n.getRepetitionQuery() != null && "Parallelize".equals(n.getRepetitionType())) {
            this.parallelizedRepetitionSteps.add(n);
        }
    }

    public Graph createGraph() {
        GraphBuilder b = new GraphBuilder();
        return b.createGraph();
    }

    class GraphBuilder {
        Graph g = new Graph();
        HashMap<String, Integer> dummyNodeIds = new HashMap();

        GraphBuilder() {
        }

        public Graph createGraph() {
            this.g.setGlobalVariables(EventHandler.this.xslGlobalVariables);
            for (Graph.Node n : EventHandler.this.disabledNodes) {
                try {
                    this.removeNode(n);
                }
                catch (Exception ex) {
                    throw new RuntimeException(String.format(Messages.EventHandler_2, n.getBaseId()), ex);
                }
            }
            ArrayList<Graph.NodeLink> toLinearize = new ArrayList<Graph.NodeLink>();
            for (Graph.Node n : EventHandler.this.nodes.values()) {
                this.g.addNode(n);
                if (n.getType() != Graph.Type.LINK || n.getChildren().isEmpty()) continue;
                toLinearize.add((Graph.NodeLink)n);
            }
            ArrayList<Graph.Node> list = new ArrayList<Graph.Node>();
            list.addAll(EventHandler.this.parallelizedRepetitionSteps);
            Comparator<Graph.Node> comparator = new Comparator<Graph.Node>(){

                @Override
                public int compare(Graph.Node o1, Graph.Node o2) {
                    if (o1 != null && o2 != null) {
                        if (o1.getParent() == o2.getParent()) {
                            return o1.getSrcId().compareTo(o2.getSrcId());
                        }
                        return this.compare(o1.getParent(), o2.getParent());
                    }
                    if (o1 != null && o2 == null) {
                        return 1;
                    }
                    if (o2 != null && o1 == null) {
                        return -1;
                    }
                    return 0;
                }
            };
            Collections.sort(list, comparator);
            for (Graph.Node node : list) {
                Set<String> l = EventHandler.this.candidates4JoinDummyNodes.get(node);
                if (l == null) continue;
                for (String s : l) {
                    String[] p = s.split("\\+");
                    Graph.Node trg = EventHandler.this.nodes.get(p[2]);
                    if (trg == null || trg.getType() == Graph.Type.LINK || !EventHandler.this.parallelizedRepetitionSteps.contains(trg)) continue;
                    String id = Graph.MD5(String.valueOf(node.getSrcId()) + "->" + trg.getSrcId());
                    if (this.dummyNodeIds.get(id) == null) {
                        this.dummyNodeIds.put(id, 0);
                    } else {
                        this.dummyNodeIds.put(id, this.dummyNodeIds.get(id) + 1);
                        id = String.valueOf(id) + "_" + this.dummyNodeIds.get(id);
                    }
                    Graph.Action dummy = new Graph.Action(id, id, null, null, null, null, false, node.getModelInfo().cloneAsEmpty(), node.getGenerationOrder(), null);
                    dummy.setParent(node.getParent());
                    dummy.setContext(new Graph.Context(id, node.getParent().getContext()));
                    EventHandler.this.nodes.put(dummy.getBaseId(), dummy);
                    this.g.addNode(dummy);
                    EventHandler.this.links.put(dummy, new HashSet());
                    node.getParent().getChildren().add(dummy);
                    Graph.NodeLink dummyLink = new Graph.NodeLink(UUID.randomUUID().toString(), null, Graph.GenerationMode.OK_KO, false, new Graph.ModelInfo());
                    dummyLink.setParent(node.getParent());
                    dummyLink.setContext(new Graph.Context(dummyLink.getBaseId(), node.getParent().getContext()));
                    EventHandler.this.nodes.put(dummyLink.getBaseId(), dummyLink);
                    EventHandler.this.links.put(dummyLink, new HashSet());
                    this.g.addNode(dummyLink);
                    node.getParent().getChildren().add(dummyLink);
                    Graph.Node lk = EventHandler.this.nodes.get(p[1]);
                    EventHandler.this.links.get(lk).remove(trg.getBaseId());
                    EventHandler.this.links.get(lk).add(dummy.getBaseId());
                    EventHandler.this.links.get(dummy).add(dummyLink.getBaseId());
                    EventHandler.this.links.get(dummyLink).add(trg.getBaseId());
                }
            }
            for (Graph.NodeLink nodeLink : toLinearize) {
                this.simplify(nodeLink);
            }
            for (Graph.Node node : EventHandler.this.links.keySet()) {
                for (String s : EventHandler.this.links.get(node)) {
                    this.g.addEdge(node, EventHandler.this.nodes.get(s));
                }
            }
            this.g.setRoot(EventHandler.this.root);
            return this.g;
        }

        public Graph.NodeLink createMergeLink(Graph.NodeLink node, Graph.NodeLink node2) {
            String condition = null;
            condition = node.hasCondition() ? (node2.hasCondition() ? "(" + node.getCondition() + ") and (" + node2.getCondition() + ")" : node.getCondition()) : (node2.hasCondition() ? node2.getCondition() : null);
            String uuid = null;
            while (EventHandler.this.nodes.get(uuid = UUID.randomUUID().toString()) != null) {
            }
            Graph.NodeLink link = new Graph.NodeLink(uuid, condition, node.getMode(), node2.isBind(), node2.getModelInfo());
            link.setContext(node.getContext());
            link.setParent(node.getParent());
            node.getParent().getChildren().add(link);
            return link;
        }

        private void removeNode(Graph.Node n) {
            ArrayList<Graph.NodeLink> outgoing = new ArrayList<Graph.NodeLink>();
            for (String s : EventHandler.this.links.get(n)) {
                Graph.Node o = EventHandler.this.nodes.get(s);
                if (o == null) continue;
                outgoing.add((Graph.NodeLink)o);
            }
            ArrayList<Graph.NodeLink> incoming = new ArrayList<Graph.NodeLink>();
            block1: for (Graph.Node k : EventHandler.this.links.keySet()) {
                for (String string : EventHandler.this.links.get(k)) {
                    if (!string.equals(n.getBaseId())) continue;
                    incoming.add((Graph.NodeLink)k);
                    continue block1;
                }
            }
            ArrayList<Graph.NodeLink[]> pair = new ArrayList<Graph.NodeLink[]>(incoming.size() * outgoing.size());
            for (Graph.NodeLink i : incoming) {
                for (Graph.NodeLink o : outgoing) {
                    pair.add(new Graph.NodeLink[]{i, o});
                }
            }
            HashSet<String> toDelete = new HashSet<String>();
            for (Graph.NodeLink[] nodeLinkArray : pair) {
                Graph.NodeLink lk = this.createMergeLink(nodeLinkArray[0], nodeLinkArray[1]);
                EventHandler.this.nodes.put(lk.getBaseId(), lk);
                toDelete.add(nodeLinkArray[0].getBaseId());
                toDelete.add(nodeLinkArray[1].getBaseId());
                EventHandler.this.links.put(lk, new HashSet());
                block6: for (Graph.Node k : EventHandler.this.links.keySet()) {
                    for (String id : EventHandler.this.links.get(k)) {
                        if (!id.equals(nodeLinkArray[0].getBaseId())) continue;
                        EventHandler.this.createLink(k, lk.getBaseId());
                        continue block6;
                    }
                }
                Collection<String> c = EventHandler.this.links.get(nodeLinkArray[1]);
                if (c == null || c.isEmpty()) continue;
                EventHandler.this.createLink(lk, c.iterator().next());
            }
            toDelete.add(n.getBaseId());
            for (Graph.Node node : n.getAllContent()) {
                toDelete.add(node.getBaseId());
            }
            for (String string : toDelete) {
                Graph.Node d = EventHandler.this.nodes.remove(string);
                if (d != null) {
                    EventHandler.this.links.remove(d);
                    if (d.getParent() != null) {
                        d.getParent().getChildren().remove(d);
                        d.setParent(null);
                    }
                }
                for (Collection<String> c : EventHandler.this.links.values()) {
                    c.remove(string);
                }
            }
        }

        private void simplify(Graph.Node n) {
            ArrayList<Graph.Node> l = new ArrayList<Graph.Node>(n.getChildren());
            for (Graph.Node k : l) {
                k.setParent(n.getParent());
                k.getParent().getChildren().add(k);
                this.g.addEdge(n, k);
            }
            n.getChildren().clear();
            for (Graph.Node c : l) {
                this.simplify(c);
            }
        }
    }
}

