/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.gene.process.internal.configuration;

import com.indy.xsl.gene.GenerationMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExternalisationGenerator
implements ContentHandler {
    private HashMap<String, NodeInfo> nodeInfo = new HashMap();
    private AttInfo currentAtt;
    private String[] currentAttValue;
    private Stack<NodeInfo> nodes = new Stack();
    private NodeInfo root = null;
    private GenerationMap generationMap;
    private HashMap<String, AttInfo> externalizedAttributesId = new HashMap();
    private File levelIconsFolder;
    private Set<String> createdIconsLevels = new HashSet<String>();
    private Map<String, URI> levelsIcons;
    private Pattern externalizationRegexPattern;
    private HashMap<String, Collection<String>> inheritedAttributes = new HashMap();
    HashMap<String, Integer> attributesIndex;
    HashMap<String, String> externalizedValuesKeyGen = new HashMap();

    ExternalisationGenerator(GenerationMap generationMap, String stambiaRuntimePath, Map<String, URI> levelsIcons) {
        this.generationMap = generationMap;
        this.levelIconsFolder = new File(String.valueOf(stambiaRuntimePath) + "/build/tmp/wrk2/___internal___/metadata/images");
        this.levelIconsFolder.mkdirs();
        this.levelsIcons = levelsIcons;
    }

    public HashMap<String, Collection<String>> getInheritedAttributes() {
        return this.inheritedAttributes;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String s;
        if (this.nodes.isEmpty()) {
            this.root = new NodeInfo();
            this.nodes.push(this.root);
        } else if (qName.equals("ex:node")) {
            NodeInfo nodeInfo = this.createNodeInfo(atts);
        } else if (qName.equals("ex:attribute")) {
            AttInfo att;
            this.currentAtt = att = this.createAttInfo(atts);
        } else if (localName.equals("value")) {
            if (this.currentAtt != null) {
                String k = atts.getValue("key");
                if (k == null) {
                    this.currentAttValue = new String[]{""};
                } else {
                    String[] stringArray = new String[2];
                    stringArray[1] = k;
                    this.currentAttValue = stringArray;
                }
                this.currentAtt.values.add(this.currentAttValue);
            }
        } else if (qName.equals("ex:inheritedAttribute") && (s = atts.getValue("attributeId")) != null) {
            String[] p = s.split("\\.");
            String nodeId = p[0];
            String attribute = p[1];
            Collection<String> c = this.inheritedAttributes.get(nodeId);
            if (c == null) {
                c = new HashSet<String>();
                this.inheritedAttributes.put(nodeId, c);
            }
            c.add(attribute);
        }
    }

    private NodeInfo createNodeInfo(Attributes atts) {
        NodeInfo res = this.nodeInfo.get(atts.getValue("id"));
        if (res == null) {
            res = new NodeInfo();
            res.defType = atts.getValue("defType");
            res.id = atts.getValue("id");
            res.name = atts.getValue("name");
            res.xmlName = atts.getValue("xmlName");
            this.nodeInfo.put(res.id, res);
            this.nodes.peek().childrenNodes.add(res);
        }
        this.nodes.push(res);
        return res;
    }

    public Set<String> getExternalizedAttributesId() {
        return this.externalizedAttributesId.keySet();
    }

    private AttInfo createAttInfo(Attributes atts) {
        AttInfo res = this.nodes.peek().attributesMap.get(atts.getValue("xmlName"));
        if (res == null) {
            res = new AttInfo();
            res.displayName = atts.getValue("displayName");
            res.type = atts.getValue("type");
            res.xmlName = atts.getValue("xmlName");
            if ("reference".equals(res.type)) {
                return null;
            }
            this.externalizedAttributesId.put(String.valueOf(this.nodes.peek().id) + "." + res.xmlName, res);
            this.nodes.peek().attributeInfos.add(res);
            this.nodes.peek().attributesMap.put(res.xmlName, res);
            return res;
        }
        return null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("ex:node")) {
            this.nodes.pop();
        } else if (localName.equals("value")) {
            this.currentAttValue = null;
        } else if (qName.equals("ex:attribute")) {
            this.currentAtt = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentAttValue != null) {
            this.currentAttValue[0] = this.currentAttValue[0] == null ? new String(ch, start, length) : String.valueOf(this.currentAttValue[0]) + new String(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public void generateConf(XMLStreamWriter writer, HashMap<String, Integer> attributesIndex, String prefix, String suffix) throws SAXException, IOException, XMLStreamException {
        this.attributesIndex = attributesIndex;
        this.externalizationRegexPattern = Pattern.compile("(" + prefix + "([0-9]+)" + suffix + ")");
        for (String s : attributesIndex.keySet()) {
            Integer index = attributesIndex.get(s);
            int i = s.indexOf(".");
            String externalizedKey = "ext." + s.substring(0, i) + ".attribute." + s.substring(i + 1);
            this.externalizedValuesKeyGen.put(String.valueOf(prefix) + index + suffix, externalizedKey);
        }
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement("ex:externalize");
        writer.writeNamespace("ex", "http://www.stambia.com/externalize");
        for (NodeInfo i : this.root.childrenNodes) {
            this.write(i, writer);
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public void prepareExternalization(InputStream wrk1ConfStream) throws Exception {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader saxReader = parser.getXMLReader();
        saxReader.setContentHandler(this);
        BufferedReader reader = new BufferedReader(new InputStreamReader(wrk1ConfStream, "UTF-8"));
        InputSource source = new InputSource(reader);
        try {
            saxReader.parse(source);
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private void write(NodeInfo node, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("ex:node");
        writer.writeAttribute("xmlName", node.xmlName);
        if (node.name != null) {
            writer.writeAttribute("name", node.name);
        }
        writer.writeAttribute("id", node.id);
        writer.writeAttribute("defType", node.defType);
        if (this.createdIconsLevels.add(node.defType)) {
            this.generateLevelIcon(node.defType);
        }
        for (AttInfo attInfo : node.attributeInfos) {
            Integer attributeIndex = this.attributesIndex.get(String.valueOf(node.id) + "." + attInfo.xmlName);
            writer.writeStartElement("ex:attribute");
            writer.writeAttribute("xmlName", attInfo.xmlName);
            writer.writeAttribute("displayName", attInfo.displayName);
            writer.writeAttribute("type", attInfo.type);
            if (attributeIndex != null) {
                writer.writeAttribute("index", "" + attributeIndex);
            }
            for (String[] s : attInfo.values) {
                writer.writeStartElement("value");
                if (s.length > 1) {
                    writer.writeAttribute("key", s[1]);
                }
                if (s[0] != null) {
                    String genValue = this.generationMap.getCode(String.valueOf(node.id) + ".attribute." + attInfo.xmlName);
                    if (genValue == null) {
                        this.generationMap.getCode(String.valueOf(node.id) + ".text." + attInfo.xmlName);
                    }
                    if (genValue != null) {
                        Matcher m = this.externalizationRegexPattern.matcher(genValue);
                        StringBuffer b = new StringBuffer();
                        int cur = 0;
                        while (m.find()) {
                            b.append(genValue.substring(cur, m.start(1)));
                            String ext = m.group(1);
                            String extK = this.externalizedValuesKeyGen.get(ext);
                            String extV = null;
                            if (extK != null) {
                                extV = this.generationMap.getCode(extK);
                            }
                            if (extV == null) {
                                for (String att : this.attributesIndex.keySet()) {
                                    Integer index = this.attributesIndex.get(att);
                                    if (index.intValue() != Integer.valueOf(m.group(2)).intValue()) continue;
                                    extV = this.externalizedAttributesId.get((Object)att).values.get(0)[0];
                                    break;
                                }
                            }
                            if (extV != null) {
                                b.append(extV);
                            } else {
                                b.append(genValue.substring(cur, m.end(1)));
                            }
                            cur = m.end(1);
                        }
                        if (cur < genValue.length()) {
                            b.append(genValue.substring(cur));
                        }
                        genValue = b.toString();
                        writer.writeCData(genValue);
                    } else {
                        writer.writeCData(s[0]);
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        for (NodeInfo nodeInfo : node.childrenNodes) {
            this.write(nodeInfo, writer);
        }
        writer.writeEndElement();
    }

    private void generateLevelIcon(String defType) {
        block23: {
            if (this.levelsIcons == null) {
                return;
            }
            URI uri = this.levelsIcons.get(defType);
            if (uri != null) {
                InputStream is = null;
                OutputStream os = null;
                try {
                    try {
                        is = new BufferedInputStream(uri.toURL().openStream());
                        os = new BufferedOutputStream(new FileOutputStream(String.valueOf(this.levelIconsFolder.getPath()) + "/" + defType + ".png"));
                        byte[] buffer = new byte[2048];
                        int i = -1;
                        while ((i = is.read(buffer)) != -1) {
                            os.write(buffer, 0, i);
                        }
                    }
                    catch (Exception exception) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (os == null) break block23;
                        try {
                            os.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    class AttInfo {
        String xmlName;
        String displayName;
        String type;
        List<String[]> values = new ArrayList<String[]>();

        AttInfo() {
        }
    }

    class NodeInfo {
        String id;
        String xmlName;
        String defType;
        String name;
        List<NodeInfo> childrenNodes = new ArrayList<NodeInfo>();
        List<AttInfo> attributeInfos = new ArrayList<AttInfo>();
        Map<String, AttInfo> attributesMap = new HashMap<String, AttInfo>();

        NodeInfo() {
        }
    }
}

