/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.global;

import com.indy.xsl.DiagnosticException;
import com.indy.xsl.gene.StackedVariableManager;
import com.indy.xsl.gene.process.Graph;
import com.indy.xsl.gene.process.internal.OneProcCompilation;
import com.indy.xsl.global.Messages;
import com.indy.xsl.global.Strings;
import com.indy.xsl.global.Variables;
import com.indy.xsl.global.XPathEvaluatorI;
import com.indy.xsl.global.XSLException;
import com.indy.xsl.global.Xpath;
import com.indy.xsl.global.XpathCache;
import com.indy.xsl.parser.PatternParser;
import com.indy.xsl.saxon.extension.impl.Configuration4Generation;
import com.indy.xsl.sqlparser.ColunmVisitor;
import com.indy.xsl.sqlparser.FunctionParser;
import com.indy.xsl.sqlparser.LightParser;
import com.indy.xsl.sqlparser.OuterModificator;
import com.indy.xsl.sqlparser.RemoveAndRestoreVarTags;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathEvaluator;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Functions {
    public static final Functions INSTANCE = new Functions();
    private static Map<String, String> memoryCache;
    public static NodeInfo mapper;
    private static Map<String, String> memoryCache2;
    private static Map<String, String> memoryCache3;
    static final Pattern PATTERN_XPATH_VARIABLE;
    private static final HashMap<Configuration, XPathEvaluatorI> evaluatorWithControllerMap;
    private static final HashMap<Configuration, XPathEvaluatorI> evaluatorWithoutControllerMap;
    static Map<String, NodeInfo> mapLevel;
    public static TreeMap<String, String> xpathPatternMapper;
    public static TreeMap<String, NodeInfo> xpathExpressionCache;
    private static TreeMap<String, List> refCache;
    static Map<DocumentInfo, Map<String, List>> cachedObjectsByIds;

    static {
        PATTERN_XPATH_VARIABLE = Pattern.compile("\\$[a-zA-Z0-9_]*");
        evaluatorWithControllerMap = new HashMap();
        evaluatorWithoutControllerMap = new HashMap();
        mapLevel = new TreeMap<String, NodeInfo>();
        cachedObjectsByIds = new HashMap<DocumentInfo, Map<String, List>>();
    }

    public static void setMapper(NodeInfo _mapper) {
        mapper = _mapper;
    }

    public static String parseSubstitionFunction(String str) {
        return FunctionParser.INSTANCE.parse(str);
    }

    public static void parseXpathExpression(String expression) throws XPathExpressionException {
        XPathEvaluatorI xei = new XPathEvaluatorI(new Configuration());
        xei.initNamespaces();
        xei.setXPathVariableResolver(v -> null);
        xei.compile2(expression, true);
    }

    public static boolean isNode(ValueRepresentation value) {
        return !(value instanceof StringValue) && !(value instanceof Orphan);
    }

    public static NodeInfo parseXslExpression(String expression) throws XPathException {
        Builder b;
        expression = "<root xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:proc=\"http://www.example.org/proc\" xmlns:deliv=\"http://www.stambia.com/deliv\" xmlns:jStr=\"java:com.indy.xsl.StringI\" xmlns:rdbms=\"http://www.example.org/rdbms\" xmlns:mdj=\"java:com.indy.xsl.global.Functions\" xmlns:mdv=\"java:com.indy.xsl.global.Variables\" xmlns:tech=\"http://www.stambia.com/tech\" xmlns:saxon=\"http://saxon.sf.net/\" >" + expression;
        expression = String.valueOf(expression) + "</root>";
        Configuration c = new Configuration();
        Controller controller = new Controller(c);
        StringReader sr = new StringReader(expression);
        InputSource is = new InputSource(sr);
        is.setSystemId("jiiji");
        SAXSource source = new SAXSource(is);
        source.setSystemId("jiiji");
        Builder s = b = controller.makeBuilder();
        source = AugmentedSource.makeAugmentedSource((Source)source);
        ((AugmentedSource)source).setStripSpace(4);
        if (controller.getExecutable().stripsInputTypeAnnotations()) {
            s = controller.getConfiguration().getAnnotationStripper((Receiver)s);
        }
        try {
            Sender sender = new Sender(controller.makePipelineConfiguration());
            sender.send((Source)source, (Receiver)s);
            NodeInfo node = b.getCurrentRoot();
            b.reset();
            return node;
        }
        catch (XPathException err) {
            throw new XPathException((Throwable)err);
        }
    }

    public static void setMemoryCache(Map<String, String> map) {
        memoryCache = map;
    }

    public static void setMemoryCache2(Map<String, String> map) {
        memoryCache2 = map;
    }

    public static void setMemoryCache3(Map<String, String> map) {
        memoryCache3 = map;
    }

    public static String addFilterOuterWord(String expression, String outerWOrd, List<String> aliasList) throws XSLException, ParseException {
        String result = expression;
        try {
            result = OuterModificator.addFilterOuterWord(expression, outerWOrd, aliasList);
        }
        catch (Exception e) {
            throw new XSLException(String.format("Failed to add outer word on filter expression %s.", expression), e);
        }
        return result;
    }

    public static String addJoinOuterWord(String expression, String outerWOrd, String innerAlias, String outerAlias) throws JSQLParserException, ParseException, XSLException {
        String result = expression;
        try {
            result = OuterModificator.addJoinOuterWord(expression, outerWOrd, innerAlias, outerAlias);
        }
        catch (Exception e) {
            throw new XSLException(String.format("Failed to add outer word on join expression %s.", expression), e);
        }
        return result;
    }

    public static List xpath(XPathContext c, ValueRepresentation context) throws XPathExpressionException, XPathException, TransformerException, XSLException, URISyntaxException {
        return Functions.xpath(c, context, null);
    }

    public static List xpath(XPathContext c, ValueRepresentation context, String code) throws XPathExpressionException, XPathException, TransformerException, XSLException, URISyntaxException {
        return Xpath.call(c, context, code);
    }

    public static List xpath(XPathContext c, ValueRepresentation context, String motif, ValueRepresentation param1) throws XPathExpressionException, TransformerException, XSLException, URISyntaxException {
        return Xpath.call(c, context, motif, param1);
    }

    public static List xpath(XPathContext c, ValueRepresentation context, String motif, ValueRepresentation param1, ValueRepresentation param2) throws XPathExpressionException, TransformerException, XSLException, URISyntaxException {
        return Xpath.call(c, context, motif, param1, param2);
    }

    public static String processJavaTransform(String string) {
        return new String(string);
    }

    public static List findMetaDataRef(NodeInfo context, String name) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, null);
        return Functions.findMetaDataRef(context, name, e);
    }

    public static List getMdRef(XPathContext context, NodeInfo node, String mdLinkName) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(node, context != null ? context.getController() : null);
        return Functions.findMetaDataRef(context, node, mdLinkName, e);
    }

    @Deprecated
    public static List findMetaDataRef(NodeInfo context, String name, XPathEvaluator e) throws XPathExpressionException, TransformerException, URISyntaxException {
        return Functions.findMetaDataRef(null, context, name, e);
    }

    public static List findMetaDataRef(XPathContext ctx, NodeInfo context, String name, XPathEvaluator e) throws XPathExpressionException, TransformerException, URISyntaxException {
        String localName = name.replaceAll("\\$", "");
        NodeInfo metaDataLink = (NodeInfo)e.evaluate("ancestor-or-self::*[exists(metaDataLink[@name='" + localName + "'])][1]/metaDataLink[@name='" + localName + "'][1]", (Object)context, XPathConstants.NODE);
        if (metaDataLink != null) {
            List retour = Functions.getMetaDataRef(ctx, metaDataLink);
            return retour;
        }
        return null;
    }

    public static List getMetaDataRef(XPathContext ctx, NodeInfo metaDataLink) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(metaDataLink, ctx == null ? null : ctx.getController());
        String file = e.evaluate("substring-before(@target,'#')", metaDataLink);
        String id = e.evaluate("substring-after(@target,'#')", metaDataLink);
        return Functions.getRef(ctx, metaDataLink, file, id, e);
    }

    public static List getMdRef(XPathContext c, NodeInfo metaDataLink) throws XPathExpressionException, TransformerException, URISyntaxException {
        return Functions.getMetaDataRef(c, metaDataLink);
    }

    public static List first(XPathContext c) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator((NodeInfo)c.getContextItem(), c.getController());
        NodeInfo metaDataLink = (NodeInfo)e.evaluate("ancestor-or-self::*/metaDataLink[1]", c.getContextItem(), XPathConstants.NODE);
        if (metaDataLink != null) {
            return Functions.getMetaDataRef(c, metaDataLink);
        }
        return null;
    }

    public static List first(XPathContext c, NodeInfo context) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, null);
        NodeInfo metaDataLink = (NodeInfo)e.evaluate("ancestor-or-self::*/metaDataLink[1]", context, XPathConstants.NODE);
        if (metaDataLink != null) {
            return Functions.getMetaDataRef(c, metaDataLink);
        }
        return null;
    }

    public static List getRef(XPathContext cts, NodeInfo context, String path) throws XPathExpressionException, XPathException, TransformerException, URISyntaxException {
        if (path.indexOf("#") > -1) {
            String file = path;
            file = Functions.findURIByMemoryCache(file);
            file = file.substring(0, file.indexOf("#"));
            String id = path.substring(path.indexOf("#") + 1, path.length());
            return Functions.getRef(cts, context, file, id, Functions.getXPathEvaluator(context, cts == null ? null : cts.getController()));
        }
        return null;
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, XPathVariableResolver xPathVariableResolver) throws XPathException, XPathExpressionException, XSLException {
        return (List)Functions.evaluate(c, context, expr, XPathConstants.NODESET, xPathVariableResolver);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr) throws XPathException, XPathExpressionException, XSLException {
        return (List)Functions.evaluate(c, context, expr, XPathConstants.NODESET);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, null, null, null, null, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, null, null, null, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, null, null, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, null, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, p5, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, p5, p6, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6, ValueRepresentation p7) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, p5, p6, p7, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6, ValueRepresentation p7, ValueRepresentation p8) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, p5, p6, p7, p8, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, final ValueRepresentation p1, final ValueRepresentation p2, final ValueRepresentation p3, final ValueRepresentation p4, final ValueRepresentation p5, final ValueRepresentation p6, final ValueRepresentation p7, final ValueRepresentation p8, final ValueRepresentation p9) throws XPathException, XPathExpressionException, XSLException {
        return (List)Functions.evaluate(c, context, expr, XPathConstants.NODESET, new XPathVariableResolver(){

            @Override
            public Object resolveVariable(QName variableName) {
                String v = variableName.getLocalPart();
                if (v.equals("p1")) {
                    return p1;
                }
                if (v.equals("p2")) {
                    return p2;
                }
                if (v.equals("p3")) {
                    return p3;
                }
                if (v.equals("p4")) {
                    return p4;
                }
                if (v.equals("p5")) {
                    return p5;
                }
                if (v.equals("p6")) {
                    return p6;
                }
                if (v.equals("p7")) {
                    return p7;
                }
                if (v.equals("p8")) {
                    return p8;
                }
                if (v.equals("p9")) {
                    return p9;
                }
                return null;
            }
        });
    }

    public static String evaluateXPathVariableExpression(XPathContext ctx, String expression) {
        String s = new String(expression);
        StringBuilder buf = new StringBuilder();
        Matcher m = PATTERN_XPATH_VARIABLE.matcher(s);
        int lastIndex = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            buf.append(s.substring(lastIndex, start));
            lastIndex = end;
            String varName = s.substring(start, end);
            StringBuilder b = new StringBuilder(varName);
            int i = end;
            Character c = null;
            while (i < s.length() && !Character.isWhitespace((c = Character.valueOf(s.charAt(i++))).charValue())) {
                b.append(c);
            }
            try {
                List l = Functions.evaluate(ctx, (NodeInfo)ctx.getContextItem(), b.toString());
                if (l != null && !l.isEmpty()) {
                    for (Object o : l) {
                        if (o instanceof NodeInfo) {
                            buf.append(((NodeInfo)o).getStringValue());
                            continue;
                        }
                        buf.append(o.toString());
                    }
                    if (c != null && i < s.length()) {
                        buf.append(c);
                    }
                } else {
                    buf.append(s.substring(start));
                }
            }
            catch (Exception ex) {
                buf.append(s.substring(start));
            }
            s = s.substring(i);
            m.reset(s);
            lastIndex = 0;
        }
        return buf.toString();
    }

    public static Object evaluate(XPathContext c, NodeInfo context, String expr, QName mode) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, mode, null);
    }

    public static boolean evaluateCondition(XPathContext c, NodeInfo oneProcNode, Object expr) throws XPathException, XSLException {
        try {
            Object o = Functions._evaluate(c, oneProcNode, (String)expr, XPathConstants.BOOLEAN, null, false);
            if (o instanceof AtomicValue) {
                return ((AtomicValue)o).effectiveBooleanValue();
            }
            return o != null;
        }
        catch (Throwable ex) {
            Graph.Node n = null;
            try {
                String nodeId = (String)Functions._evaluate(c, (NodeInfo)c.getContextItem(), "@srcId", XPathConstants.STRING, null, true);
                n = Graph.getCurrentGraph().getNodeBySrcId(nodeId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (n != null) {
                throw new DiagnosticException(String.format(Messages.Functions_0, n.getDiagnosticPath()), ex);
            }
            if (ex instanceof XPathException) {
                throw (XPathException)ex;
            }
            if (ex instanceof XSLException) {
                throw (XSLException)ex;
            }
            throw new XPathException(ex);
        }
    }

    public static XPathEvaluatorI getXPathEvaluator(NodeInfo context, Controller controller) throws XPathException {
        if (controller != null) {
            XPathEvaluatorI evaluatorWithController = evaluatorWithControllerMap.get(context.getConfiguration());
            if (evaluatorWithController == null) {
                evaluatorWithController = new XPathEvaluatorI((Source)context);
                evaluatorWithController.initNamespaces();
                evaluatorWithController.setXPathVariableResolver(new EvaluationVariableResolver());
                evaluatorWithController.initControler(controller);
                evaluatorWithControllerMap.put(context.getConfiguration(), evaluatorWithController);
            }
            if (evaluatorWithController.controller != controller) {
                evaluatorWithController.initControler(controller);
            }
            return evaluatorWithController;
        }
        XPathEvaluatorI evaluatorWithoutController = evaluatorWithoutControllerMap.get(context.getConfiguration());
        evaluatorWithoutController = null;
        if (evaluatorWithoutController == null) {
            evaluatorWithoutController = new XPathEvaluatorI((Source)context);
            evaluatorWithoutController.initNamespaces();
            evaluatorWithoutController.setXPathVariableResolver(new EvaluationVariableResolver());
            evaluatorWithoutControllerMap.put(context.getConfiguration(), evaluatorWithoutController);
        }
        return evaluatorWithoutController;
    }

    public static Object _evaluate(XPathContext c, NodeInfo context, String expr, QName mode, XPathVariableResolver xPathVariableResolver, boolean doJavaConversion) throws XPathException, XSLException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, c.getController());
        try {
            ((EvaluationVariableResolver)e.getXPathVariableResolver()).pushContext(c, context, c.getStackFrame(), xPathVariableResolver);
            Object object = e.evaluate2(expr, context, mode, doJavaConversion);
            ((EvaluationVariableResolver)e.getXPathVariableResolver()).popContext();
            return object;
        }
        catch (Throwable throwable) {
            try {
                ((EvaluationVariableResolver)e.getXPathVariableResolver()).popContext();
                throw throwable;
            }
            catch (XPathExpressionException e1) {
                String id = Navigator.getAttributeValue((NodeInfo)context, null, (String)"id");
                XSLException ex = new XSLException(String.format(Messages.Functions_4, expr, e1.getCause(), context.getBaseURI(), id), e1);
                throw ex;
            }
        }
    }

    public static Object evaluate(XPathContext c, NodeInfo context, String expr, QName mode, XPathVariableResolver xPathVariableResolver) throws XPathException, XPathExpressionException, XSLException {
        return Functions._evaluate(c, context, expr, mode, xPathVariableResolver, true);
    }

    private static String findURIByMemoryCache(String uri) throws XPathExpressionException {
        String tmp = uri;
        if (tmp != null && tmp.contains("#") && memoryCache != null) {
            if (tmp.contains("fileId=")) {
                tmp = tmp.substring(tmp.indexOf("fileId=") + 7);
            }
            if (tmp.contains("$")) {
                tmp = tmp.substring(0, tmp.indexOf("$"));
            } else if (tmp.contains("?")) {
                tmp = tmp.substring(0, tmp.indexOf("?"));
            }
            String retour = memoryCache.get(tmp);
            if (retour != null) {
                return retour;
            }
        }
        return uri;
    }

    public static String findURIByFileId(String id) {
        return memoryCache2.get(id);
    }

    public static String findURIByFileId(String id, boolean absoluth) {
        if (absoluth) {
            return memoryCache2.get(id);
        }
        return memoryCache3.get(id);
    }

    public static List getMultiRef(XPathContext cts, NodeInfo context, String path) throws XPathExpressionException, XPathException, TransformerException, URISyntaxException {
        ArrayList list = new ArrayList();
        List list2 = Functions.getRef(cts, context, path);
        list.addAll(list2);
        if (list2.size() == 1) {
            NodeInfo tmp = (NodeInfo)list2.get(0);
            XPathEvaluatorI e = Functions.getXPathEvaluator(tmp, null);
            String sourceId = e.evaluate("@sourceId", tmp);
            String targetId = e.evaluate("@targetId", tmp);
            if (sourceId != null) {
                list.addAll(Functions.getRef(cts, tmp, sourceId));
            } else if (targetId != null) {
                list.addAll(Functions.getRef(cts, tmp, targetId));
            }
        }
        return list;
    }

    public static List getRef(XPathContext c, NodeInfo context) throws XPathExpressionException, XPathException, TransformerException, URISyntaxException {
        if (context.getStringValue() != null && !context.getStringValue().isEmpty()) {
            String str = context.getStringValue();
            if (str.indexOf("#") > -1) {
                if (str.indexOf("#") > 0) {
                    return Functions.getRef(c, context, str);
                }
                return Functions.getLocalRef(c, context, str.substring(1));
            }
            return Functions.getLocalRef(c, context, context.getStringValue());
        }
        return null;
    }

    public static List getNodeByExp(XPathContext ctx, NodeInfo context, String expressions) throws XPathExpressionException, TransformerException, URISyntaxException {
        StringTokenizer st = new StringTokenizer(expressions, ";");
        while (st.hasMoreTokens()) {
            String expr = st.nextToken();
            XPathEvaluatorI e = Functions.getXPathEvaluator(context, null);
            String value = e.evaluate(expr, context);
            if (value == null || value.indexOf("#") <= -1) continue;
            return Functions.getRef(ctx, context, value);
        }
        ArrayList<NodeInfo> list2 = new ArrayList<NodeInfo>();
        list2.add(context);
        return list2;
    }

    public static List getLevel(XPathContext ctx, NodeInfo context) throws XPathExpressionException, TransformerException {
        String defType = Navigator.getAttributeValue((NodeInfo)context, null, (String)"defType");
        return Functions.getLevel(ctx, context, defType);
    }

    public static List getLevel(XPathContext ctx, NodeInfo context, String defType) throws XPathExpressionException, TransformerException {
        String key;
        NodeInfo level;
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, ctx == null ? null : ctx.getController());
        if (defType == null) {
            defType = e.evaluate("@defType", context);
        }
        if ((level = mapLevel.get(key = String.valueOf(defType) + "/" + context.getBaseURI())) != null && level.getConfiguration().isCompatible(context.getConfiguration())) {
            ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
            list.add(level);
            return list;
        }
        List result = (List)e.evaluate("/md/*/level[@code='" + defType + "'][1]", context, XPathConstants.NODESET);
        if (result.size() == 1) {
            mapLevel.put(key, (NodeInfo)result.get(0));
        }
        return result;
    }

    public static List getLevelByRef(XPathContext ctx, NodeInfo context, String defType) throws XPathExpressionException, TransformerException, URISyntaxException {
        String str;
        NodeInfo level;
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, ctx == null ? null : ctx.getController());
        if (defType == null || defType.equals("")) {
            defType = e.evaluate("@defType", context);
        }
        if ((level = mapLevel.get(defType)) != null && level.getConfiguration().isCompatible(context.getConfiguration())) {
            ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
            list.add(level);
            return list;
        }
        List result = (List)e.evaluate("/*/level[@code='" + defType + "'][1]", context, XPathConstants.NODESET);
        if (result != null && result.isEmpty() && (str = e.evaluate("ancestor-or-self::*/@md:ref[1]", context)) != null && (result = Functions.getRef(null, context, str)) != null && !result.isEmpty()) {
            return Functions.getLevelByRef(ctx, (NodeInfo)result.get(0), defType);
        }
        if (result != null && result.size() == 1) {
            mapLevel.put(defType, (NodeInfo)result.get(0));
        }
        return result;
    }

    public static List getAncestorOrSelf(XPathContext ctx, NodeInfo context, String expression) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, ctx == null ? null : ctx.getController());
        List result = (List)e.evaluate("ancestor-or-self::" + expression, context, XPathConstants.NODESET);
        if (result.size() == 0) {
            String str = e.evaluate("ancestor-or-self::*/@md:ref[1]", context);
            if (str == null || str.equals("")) {
                str = e.evaluate("ancestor-or-self::*/@ref[1]", context);
            }
            if (str != null && (result = Functions.getRef(ctx, context, str)) != null && result.size() > 0) {
                return Functions.getAncestorOrSelf(ctx, (NodeInfo)result.get(0), expression);
            }
        }
        return result;
    }

    public static List getRef(XPathContext ctx, NodeInfo context, String file, String id, XPathEvaluator e) throws XPathExpressionException, TransformerException, URISyntaxException {
        file = file.replace(" ", "%20");
        String documentKey = Functions.getDocumentKey(context, file);
        if (refCache != null) {
            List tmp = refCache.get(String.valueOf(id) + "#" + documentKey);
            if (tmp != null && !tmp.isEmpty() && !((NodeInfo)tmp.get(0)).getConfiguration().isCompatible(context.getConfiguration())) {
                tmp = null;
                refCache.remove(String.valueOf(id) + "#" + documentKey);
            }
            if (tmp != null) {
                return tmp;
            }
        }
        DocumentInfo doc = null;
        TransformerException error = null;
        try {
            doc = Functions.document(ctx, context, file);
        }
        catch (TransformerException transformerEx) {
            error = transformerEx;
        }
        if (doc != null) {
            List result = Functions.getLocalRef(ctx, (NodeInfo)doc, id);
            if (result == null) {
                return null;
            }
            if (refCache != null) {
                refCache.put(String.valueOf(id) + "#" + documentKey, result);
            }
            return result;
        }
        return null;
    }

    public static void clear() {
        cachedObjectsByIds.clear();
        evaluatorWithControllerMap.clear();
        evaluatorWithoutControllerMap.clear();
        cachedObjectsByIds.clear();
    }

    public static List getLocalRef(XPathContext ctx, NodeInfo context, String id) throws XPathExpressionException, TransformerException {
        if (id != null && !id.isEmpty()) {
            List o;
            Map<String, List> m = cachedObjectsByIds.get(context.getDocumentRoot());
            if (m == null) {
                m = new HashMap<String, List>();
                cachedObjectsByIds.put(context.getDocumentRoot(), m);
            }
            if ((o = m.get(id)) == null) {
                List result;
                XPathEvaluatorI e = Functions.getXPathEvaluator(context, ctx == null ? null : ctx.getController());
                if (id.contains("?")) {
                    id = id.substring(0, id.indexOf("?"));
                }
                o = result = (List)e.evaluate("//*[@id='" + id + "'][1]", context, XPathConstants.NODESET);
                m.put(id, result);
            }
            return o;
        }
        return null;
    }

    public static String variableToMetaDataLink(NodeInfo context, String string) throws XPathException, XPathExpressionException {
        StringBuilder retour = new StringBuilder();
        try {
            Pattern pDeb = Pattern.compile("\\$[^\\$/]*/");
            Matcher mDeb = pDeb.matcher(string);
            int lastFin = 0;
            while (mDeb.find()) {
                int iDeb = mDeb.start();
                int iFin = mDeb.end();
                retour.append(string.substring(lastFin, iDeb));
                String temp = string.substring(iDeb + 1, iFin - 1);
                retour.append("indyF:findMetaDataRef(//,'" + temp + "')/");
                lastFin = iFin;
            }
            retour.append(string.substring(lastFin, string.length() - 1));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return retour.toString();
    }

    public static String formatNowDate(String format) {
        return new SimpleDateFormat(format).format(new Date());
    }

    public static String translateExpToXsl(String string) {
        String _return = string;
        HashSet<String> ht = new HashSet<String>();
        ht.add("INS");
        ht.add("UPD");
        ht.add("TRG");
        ht.add("WRK");
        ht.add("SRC");
        ht.add("UK");
        ht.add("PK");
        ht.add("REW");
        ht.add("MAP");
        for (String elt : ht) {
            String elt2 = "%" + elt + "%";
            String elt3 = "\u00a43\u00a4";
            _return = _return.replaceAll("'" + elt + "'", elt3);
            String elt4 = "\u00a44\u00a4";
            _return = _return.replaceAll("\\[" + elt + "\\]", elt4);
            _return = _return.replaceAll(elt, elt2);
            _return = _return.replaceAll("!" + elt2, "not([" + elt + "])");
            _return = _return.replaceAll("!\\(" + elt2 + "\\)", "not([" + elt + "])");
            _return = _return.replaceAll("NOT " + elt2, "not([" + elt + "])");
            _return = _return.replaceAll(elt2, " [" + elt + "] ");
            _return = _return.replaceAll(elt3, "'" + elt + "'");
            _return = _return.replaceAll(elt4, "[" + elt + "]");
        }
        _return = _return.replaceAll(" AND ", " and ");
        _return = _return.replaceAll(" OR ", " or ");
        return _return;
    }

    public static String addFileScheme(String path) throws URISyntaxException {
        String path2 = path.replace('\\', '/');
        if (path2.indexOf(":") == 1) {
            return "file:/" + path2;
        }
        if (path2.startsWith("file:/")) {
            return path2;
        }
        if (path2.startsWith("/")) {
            return "file:" + URLEncoder.encode(path2.replace("%20", " ")).replace("%2F", "/").replace("+", "%20");
        }
        return "file:/" + URLEncoder.encode(path2.replace("%20", " ")).replace("%2F", "/").replace("+", "%20");
    }

    public static URI pathToURI(String path) throws URISyntaxException {
        return new URI(OneProcCompilation.formatURI(Functions.addFileScheme(path)));
    }

    public static String relativize2(String src, String trg) {
        String[] part1 = src.split("/");
        String[] part2 = trg.split("/");
        int proof1 = part1.length;
        int proof2 = part2.length;
        int start = 0;
        int i = 0;
        while (i < proof1 - 1) {
            if (part2.length > i) {
                if (!part2[i].equals(part1[i])) break;
                ++start;
            }
            ++i;
        }
        String retour = "";
        int i2 = start;
        while (i2 < proof1 - 1) {
            retour = String.valueOf(retour) + "../";
            ++i2;
        }
        String retour2 = part2[start];
        int i3 = start + 1;
        while (i3 < proof2) {
            retour2 = String.valueOf(retour2) + "/" + part2[i3];
            ++i3;
        }
        return String.valueOf(retour) + retour2;
    }

    public static String relativizeURI(String _src, String _trg) throws URISyntaxException {
        String[] part2;
        URI srcURI = new URI(OneProcCompilation.formatURI(_src)).normalize();
        URI trgURI = new URI(OneProcCompilation.formatURI(_trg)).normalize();
        String src = srcURI.toASCIIString();
        String trg = trgURI.toASCIIString();
        src = src.substring(5);
        trg = trg.substring(5);
        String str = null;
        String[] part1 = src.split("/");
        int min = part1.length > (part2 = trg.split("/")).length ? part2.length : part1.length;
        String common = "/";
        int i = 0;
        while (i < min - 1) {
            if (!part1[i].equals(part2[i])) break;
            if (!part1[i].equals("")) {
                common = String.valueOf(common) + part1[i] + "/";
            }
            ++i;
        }
        src = src.substring(common.length());
        src = src.substring(0, src.lastIndexOf("/") + 1);
        trg = trg.substring(common.length());
        src = src.replaceAll("[^/]+/", "../");
        str = new URI(String.valueOf(src) + trg).normalize().getPath();
        return str;
    }

    public static String relativize(String path1, String path2) throws URISyntaxException {
        URI uri = Functions.pathToURI(path1);
        URI uri2 = Functions.pathToURI(path2);
        URI retour = uri2.relativize(uri);
        return retour.toString();
    }

    public static String normalizeURI(String path1) throws URISyntaxException {
        URI uri = Functions.pathToURI(path1.replaceAll(" ", "%20")).normalize();
        return uri.toString();
    }

    public static String resolveURI(String uri) {
        return OneProcCompilation.unformatURI(uri);
    }

    public static Document pathToDocument(String path) throws ParserConfigurationException, SAXException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));){
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder.parse(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List getFileLines(String path) throws IOException, URISyntaxException {
        URI uri = Functions.pathToURI(path.replace(" ", "%20"));
        File file = new File(uri);
        FileReader freader = new FileReader(file);
        Throwable throwable = null;
        Object var5_6 = null;
        try (LineNumberReader lnreader = new LineNumberReader(freader);){
            String line = "";
            ArrayList<String> retour = new ArrayList<String>();
            while ((line = lnreader.readLine()) != null) {
                retour.add(line);
            }
            return retour;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getFileInfo(String path, String infoName) throws URISyntaxException {
        URI uri = Functions.pathToURI(path.replace(" ", "%20").replace("//", "/").replace("\\\\", "/"));
        if (infoName.equals("name")) {
            return new File(uri).getName();
        }
        if (infoName.equals("exists")) {
            return new File(uri).exists() ? "true" : "false";
        }
        if (infoName.equals("parent")) {
            return new File(uri).getParent();
        }
        if (infoName.equals("extension")) {
            String str = new File(uri).getName();
            return str.lastIndexOf(".") > -1 ? str.substring(str.lastIndexOf(".") + 1) : "";
        }
        return null;
    }

    public static String resolveExpressionPath(String refPath, String vExpression) {
        String ret = "";
        int j = 0;
        int nextJ = 0;
        while ((j = vExpression.indexOf("${", nextJ)) != -1) {
            String _refPath = refPath;
            if (j == -1) continue;
            ret = String.valueOf(ret) + vExpression.substring(nextJ, j);
            nextJ = vExpression.indexOf("}", j);
            if (nextJ == -1) continue;
            String paramName = vExpression.substring(j + 2, nextJ);
            while (paramName.indexOf("../") != -1) {
                _refPath = _refPath.indexOf(".") != -1 ? _refPath.substring(0, _refPath.lastIndexOf(".")) : "";
                paramName = paramName.substring(3);
            }
            if (!_refPath.equals("")) {
                _refPath = String.valueOf(_refPath) + ".";
            }
            ret = String.valueOf(ret) + "${" + _refPath + paramName + "}";
            ++nextJ;
        }
        ret = ret.equals("") ? vExpression : String.valueOf(ret) + vExpression.substring(nextJ, vExpression.length());
        return ret;
    }

    public static String[] variableList$(String vExpression) {
        return Functions.variableList(vExpression, "\\$\\{", 2, "[^{^}]*", "\\}\\$", 2);
    }

    public static String[] variableListAll(String vExpression) {
        return Functions.variableList(vExpression, "(\\$|%|#)\\{", 0, "[^{^}]*", "\\}(\\$|%|#)", 0);
    }

    public static String[] variableList(String vExpression, String start, int startTrimLength, String middle, String end, int endTrimLength) {
        Pattern pDeb = Pattern.compile(String.valueOf(start) + middle + end);
        Matcher mDeb = pDeb.matcher(vExpression);
        ArrayList<String> vars = new ArrayList<String>();
        while (mDeb.find()) {
            int iDeb = mDeb.start();
            int iFin = mDeb.end();
            vars.add(vExpression.substring(iDeb + startTrimLength, iFin - endTrimLength));
        }
        String[] retour = new String[vars.size()];
        vars.toArray(retour);
        return retour;
    }

    public static String[] distinctVariableList(String vExpression) {
        Pattern pDeb = Pattern.compile("\\$\\{[^}]*\\}\\$");
        Matcher mDeb = pDeb.matcher(vExpression);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (mDeb.find()) {
            int iDeb = mDeb.start();
            int iFin = mDeb.end();
            hashMap.put(vExpression.substring(iDeb + 2, iFin - 2), "true");
        }
        String[] retour = new String[hashMap.size()];
        hashMap.keySet().toArray(retour);
        return retour;
    }

    public static String concatVariable(String vExp) {
        return Functions.concatVariable(vExp, "\\$", "");
    }

    public static String concatVariable(String vExp, String startMark, String endMark) {
        String str;
        LightParser lp = new LightParser(vExp);
        lp.parse();
        String ret = str = lp.remove();
        Pattern pDeb = Pattern.compile(String.valueOf(startMark) + "[_:A-Za-z][-._:A-Za-z0-9]*" + endMark);
        Matcher mDeb = pDeb.matcher(str);
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (mDeb.find()) {
            int iDeb = mDeb.start();
            int iFin = mDeb.end();
            String match = str.substring(iDeb + startMark.replace("\\", "").length(), iFin - endMark.replace("\\", "").length());
            if (map.get(match) != null) continue;
            String tmp = "\u00a4\u00a4\u00a4VAR" + i++ + "\u00a4\u00a4\u00a4";
            map.put(tmp, match);
            ret = ret.replaceFirst(String.valueOf(startMark) + match + endMark, tmp);
        }
        ret = lp.restore(ret, true);
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String replacement = "',\\$" + value + ",'";
            ret = ret.replaceAll(key, replacement);
        }
        ret = map.size() > 0 ? "concat('" + ret + "')" : "'" + ret + "'";
        ret = ret.replaceAll(LightParser.dollarReplace, "\\$");
        return ret;
    }

    public static String[] motifList(String vExpression, String pattern) {
        if (vExpression != null) {
            Pattern pDeb = Pattern.compile(pattern);
            Matcher mDeb = pDeb.matcher(vExpression);
            ArrayList<String> vars = new ArrayList<String>();
            while (mDeb.find()) {
                int iDeb = mDeb.start();
                int iFin = mDeb.end();
                vars.add(vExpression.substring(iDeb + 1, iFin - 1));
            }
            String[] retour = new String[vars.size()];
            vars.toArray(retour);
            return retour;
        }
        return new String[0];
    }

    public static String resolveExpressionValue(NodeInfo node) throws XPathException, XPathExpressionException {
        String[] list;
        String vExpression;
        XPathEvaluatorI e = Functions.getXPathEvaluator(node, null);
        String ret = vExpression = node.getStringValue();
        String[] stringArray = list = Functions.variableList$(vExpression);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String paramName = stringArray[n2];
            String value = e.evaluate("ancestor::*/parameter[@name='" + paramName + "'][1]/@value", node);
            if (value != null && value.equals("")) {
                value = "";
            }
            if (value != null) {
                value = value.replaceAll("\\$", "\u00b5\u00a4\u00b5\u00a4");
                ret = ret.replaceAll("\\$\\{" + paramName + "\\}\\$", value);
                ret = ret.replaceAll("\u00b5\u00a4\u00b5\u00a4", "\\$");
            }
            ++n2;
        }
        return ret;
    }

    public static String resolveExpressionValueBack(NodeInfo node) {
        String vExpression = node.getStringValue();
        if (vExpression != null) {
            try {
                XPathFactory xpf = XPathFactory.newInstance("http://saxon.sf.net/jaxp/xpath/om");
                XPath xpe = xpf.newXPath();
                System.err.println("Loaded XPath Provider " + xpe.getClass().getName());
                NodeInfo doc = node;
                String ret = "";
                int j = 0;
                int nextJ = 0;
                while ((j = vExpression.indexOf("${", nextJ)) != -1) {
                    XPathExpression findParam;
                    String temp;
                    if (j == -1) continue;
                    ret = String.valueOf(ret) + vExpression.substring(nextJ, j);
                    nextJ = vExpression.indexOf("}", j);
                    if (nextJ == -1) continue;
                    String paramName = vExpression.substring(j + 2, nextJ);
                    String path = "";
                    if (paramName.indexOf("/") != -1) {
                        path = paramName.substring(0, paramName.lastIndexOf("/") + 1);
                        paramName = paramName.substring(paramName.lastIndexOf("/") + 1);
                    }
                    if ((temp = (findParam = xpe.compile(path = String.valueOf(path) + "ancestor::*/parameter[@name='" + paramName + "'][1]/@value")).evaluate(doc)).equals("")) {
                        temp = "None";
                    }
                    ret = String.valueOf(ret) + temp;
                    ++nextJ;
                }
                ret = ret.equals("") ? vExpression : String.valueOf(ret) + vExpression.substring(nextJ, vExpression.length());
                return ret;
            }
            catch (XPathExpressionException | XPathFactoryConfigurationException e1) {
                e1.printStackTrace();
            }
        }
        return "None";
    }

    /*
     * Loose catch block
     */
    public static String includeFile(String relativePath, String currentPath) throws URISyntaxException, IOException {
        String path = String.valueOf(currentPath) + relativePath;
        path = OneProcCompilation.formatURI(path);
        URI uri = new URI(path);
        uri = uri.normalize();
        File file = new File(uri);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream fis = new FileInputStream(file);){
            String string;
            BufferedInputStream bis;
            Throwable throwable2;
            block30: {
                throwable2 = null;
                Object var9_12 = null;
                bis = new BufferedInputStream(fis);
                StringBuilder sb = new StringBuilder();
                Throwable throwable3 = null;
                Object var13_18 = null;
                try (InputStreamReader isr = new InputStreamReader((InputStream)bis, System.getProperty("file.encoding"));){
                    int count = 0;
                    char[] chars = new char[8192];
                    int position = 0;
                    do {
                        sb.append(chars, position, count);
                        position = count;
                    } while ((count = isr.read(chars)) != -1);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
                string = sb.toString();
                if (bis == null) break block30;
                bis.close();
            }
            return string;
            {
                catch (Throwable throwable5) {
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                        } else if (throwable2 != throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
    }

    public static String getTechFileName(String fileName) {
        Pattern pDeb = Pattern.compile(".[^.]*.md");
        Matcher mDeb = pDeb.matcher(fileName);
        String mdBasedFile = null;
        if (mDeb.find()) {
            mdBasedFile = fileName.substring(mDeb.start() + 1, mDeb.end());
            mdBasedFile = mdBasedFile.replaceFirst("md", "tech");
        }
        return mdBasedFile;
    }

    public static List getPrecFiles(String fileName) {
        ArrayList<String> array = new ArrayList<String>();
        Pattern pDeb = Pattern.compile(".[^.]*.");
        Matcher mDeb = pDeb.matcher(fileName);
        while (mDeb.find()) {
            String file = fileName.substring(mDeb.start());
            array.add(0, file);
        }
        array.remove(0);
        array.set(0, ((String)array.get(0)).replaceFirst("md", "tech"));
        array.remove(0);
        return array;
    }

    public static String[] split(String str, String regex) {
        return Strings.split(str, regex);
    }

    public static int countOf(String str, String exp) {
        return Strings.countOf(str, exp);
    }

    public static String replace(String str, String target, String replacement) {
        return Strings.replace(str, target, replacement);
    }

    public static String replaceAll(String str, String target, String replacement) {
        return Strings.replaceAll(str, target, replacement);
    }

    public static String replaceAll3(String src, String start, String newStart, String middle, String newMiddle, String end, String newEnd) {
        return Strings.replaceAll3(src, start, newStart, middle, newMiddle, end, newEnd);
    }

    public static String replaceAll(String src, String[] regexp, String[] replacement) {
        return Strings.replaceAll(src, regexp, replacement);
    }

    public static String replaceAll2(String src, String regex1, String regex2, String replacement) {
        return Strings.replaceAll2(src, regex1, regex2, replacement);
    }

    public static NodeInfo xpathCache(XPathContext c, NodeInfo convertFile, String query) throws XPathExpressionException {
        return XpathCache.xpathCache(c, convertFile, query);
    }

    public static NodeInfo xpathCache(XPathContext c, String query) throws XPathExpressionException {
        return XpathCache.xpathCache(c, query);
    }

    public static NodeInfo getNode(XPathContext c, String name) throws XPathExpressionException {
        return XpathCache.getNode(c, name);
    }

    public static NodeInfo putNode(XPathContext c, String name, NodeInfo nodeInfo) throws XPathExpressionException {
        return XpathCache.putNode(c, name, nodeInfo);
    }

    public static void resetXpathCache() {
        XpathCache.resetXpathCache();
    }

    private static String getDocumentKey(NodeInfo context, String file) throws URISyntaxException {
        URI BaseUri = Functions.pathToURI(context.getBaseURI());
        URI uri2 = BaseUri.resolve(OneProcCompilation.formatURI(file));
        return uri2.toString().replace("%5B", "[").replace("%5D", "]").replace("%25", "%");
    }

    public static DocumentInfo document(XPathContext ctx, NodeInfo context, String file) throws URISyntaxException, TransformerException {
        String documentKey = Functions.getDocumentKey(context, file);
        URI uri = new URI(OneProcCompilation.formatURI(documentKey));
        File fileToRead = new File(uri);
        DocumentInfo doc = null;
        if (!fileToRead.exists() && context.getConfiguration() instanceof Configuration4Generation) {
            fileToRead = new File(new URI(String.valueOf(uri.toString()) + ".tmp"));
            file = String.valueOf(file) + ".tmp";
            documentKey = Functions.getDocumentKey(context, file);
        }
        if ((doc = context.getConfiguration().getGlobalDocumentPool().find(documentKey)) == null && ctx != null) {
            doc = ctx.getController().getDocumentPool().find(documentKey);
        }
        if (doc == null) {
            Source source = context.getConfiguration().getURIResolver().resolve(file, context.getBaseURI());
            try {
                doc = context.getConfiguration().buildDocument(source);
            }
            catch (Exception ex) {
                throw new TransformerException(ex);
            }
        }
        if (doc != null) {
            context.getConfiguration().getGlobalDocumentPool().add(doc, documentKey);
        }
        return doc;
    }

    public static String markColunm(String selectPart, int mode) throws Exception {
        return ColunmVisitor.markColumn(selectPart, mode);
    }

    public static void resetXpathPatternMapper() {
        xpathPatternMapper = null;
    }

    public static void resetXpathExpressionCache() {
        xpathExpressionCache = new TreeMap();
    }

    public static void resetRefCache() {
        refCache = new TreeMap();
    }

    public static void resetMapLevel() {
        mapLevel = new TreeMap<String, NodeInfo>();
    }

    public static String pattern(XPathContext c, String pattern) {
        return Functions.pattern(c, pattern, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1) {
        return Functions.pattern(c, pattern, p1, null, null, null, null, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2) {
        return Functions.pattern(c, pattern, p1, p2, null, null, null, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3) {
        return Functions.pattern(c, pattern, p1, p2, p3, null, null, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, null, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, p5, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, p5, p6, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6, ValueRepresentation p7) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, p5, p6, p7, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6, ValueRepresentation p7, ValueRepresentation p8) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, p5, p6, p7, p8, null);
    }

    public static String pattern(XPathContext c, String pattern, XPathVariableResolver xPathVariableResolver) {
        if (pattern != null && !pattern.equals("")) {
            String value;
            String code;
            String[] list;
            RemoveAndRestoreVarTags rarsc = new RemoveAndRestoreVarTags(pattern);
            pattern = rarsc.remove();
            String startAcc = "\u00a4\u20ac\u20ac\u00a4";
            String endAcc = "\u00a4\u00a3\u00a3\u00a4";
            String startCroch = "\u00a4\u20ac\u00a3\u00a4";
            String endCroch = "\u00a4\u00a3\u20ac\u00a4";
            pattern = pattern.replaceAll("\\{\\{", startAcc);
            pattern = pattern.replaceAll("\\}\\}", endAcc);
            String[] stringArray = list = Functions.motifList(pattern, "\\{[^}]*\\}");
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                code = stringArray[n2];
                List _value = null;
                if (c.getContextItem() instanceof NodeInfo) {
                    try {
                        _value = Functions.evaluate(c, (NodeInfo)c.getContextItem(), code, xPathVariableResolver);
                    }
                    catch (XSLException | XPathExpressionException | XPathException e) {
                        e.printStackTrace();
                    }
                }
                value = "";
                if (_value instanceof List) {
                    for (Object elt : (List)_value) {
                        if (elt instanceof ValueRepresentation) {
                            try {
                                value = String.valueOf(value) + ((ValueRepresentation)elt).getStringValue();
                            }
                            catch (XPathException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        value = String.valueOf(value) + elt.toString();
                    }
                } else if (_value instanceof String) {
                    value = (String)((Object)_value);
                } else if (_value != null) {
                    value = _value.toString();
                }
                value = value.replaceAll("\\[", startCroch);
                value = value.replaceAll("\\]", endCroch);
                pattern = Functions.replaceAll(pattern, "\\{" + Functions.replaceRegexpString(code) + "\\}", value);
                ++n2;
            }
            pattern = pattern.replaceAll("\\[\\[", startCroch);
            pattern = pattern.replaceAll("\\]\\]", endCroch);
            stringArray = list = Functions.motifList(pattern, "\\[[^]]*\\]");
            n = list.length;
            n2 = 0;
            while (n2 < n) {
                code = stringArray[n2];
                List _list = null;
                if (c.getContextItem() instanceof NodeInfo) {
                    try {
                        _list = Functions.evaluate(c, (NodeInfo)c.getContextItem(), "mdj:xpath(.,'[" + code + "]')");
                    }
                    catch (XSLException | XPathExpressionException | XPathException e) {
                        e.printStackTrace();
                    }
                }
                value = _list != null && _list.size() > 0 ? _list.get(0) : "";
                String tmp = value.toString();
                pattern = Functions.replaceAll(pattern, "\\[" + Functions.replaceRegexpString(code) + "\\]", tmp);
                ++n2;
            }
            pattern = rarsc.restore(pattern);
            pattern = pattern.replaceAll(startAcc, "{");
            pattern = pattern.replaceAll(endAcc, "}");
            pattern = pattern.replaceAll(startCroch, "[");
            pattern = pattern.replaceAll(endCroch, "]");
        }
        return pattern;
    }

    public static String pattern(XPathContext c, String pattern, final ValueRepresentation p1, final ValueRepresentation p2, final ValueRepresentation p3, final ValueRepresentation p4, final ValueRepresentation p5, final ValueRepresentation p6, final ValueRepresentation p7, final ValueRepresentation p8, final ValueRepresentation p9) {
        return Functions.pattern(c, pattern, p1 != null || p2 != null || p3 != null || p4 != null ? new XPathVariableResolver(){

            @Override
            public Object resolveVariable(QName variableName) {
                String v = variableName.getLocalPart();
                if (v.equals("p1")) {
                    return p1;
                }
                if (v.equals("p2")) {
                    return p2;
                }
                if (v.equals("p3")) {
                    return p3;
                }
                if (v.equals("p4")) {
                    return p4;
                }
                if (v.equals("p5")) {
                    return p5;
                }
                if (v.equals("p6")) {
                    return p6;
                }
                if (v.equals("p7")) {
                    return p7;
                }
                if (v.equals("p8")) {
                    return p8;
                }
                if (v.equals("p9")) {
                    return p9;
                }
                return null;
            }
        } : null);
    }

    public static String patternTest(XPathContext c, String pattern) {
        if (pattern != null && !pattern.equals("")) {
            String[] list;
            RemoveAndRestoreVarTags rarsc = new RemoveAndRestoreVarTags(pattern);
            pattern = rarsc.remove();
            String startAcc = "\u00a4\u20ac\u20ac\u00a4";
            String endAcc = "\u00a4\u00a3\u00a3\u00a4";
            String startCroch = "\u00a4\u20ac\u00a3\u00a4";
            String endCroch = "\u00a4\u00a3\u20ac\u00a4";
            pattern = pattern.replaceAll("\\{\\{", startAcc);
            pattern = pattern.replaceAll("\\}\\}", endAcc);
            String value = "";
            for (Object o : PatternParser.parse(pattern, 1)) {
                if (o instanceof PatternParser.Other) {
                    value = String.valueOf(value) + ((PatternParser.Other)o).getStr();
                    continue;
                }
                List _value = null;
                if (c.getContextItem() instanceof NodeInfo) {
                    try {
                        _value = Functions.evaluate(c, (NodeInfo)c.getContextItem(), ((PatternParser.Block)o).getStr());
                    }
                    catch (XPathException e) {
                        e.printStackTrace();
                    }
                    catch (XPathExpressionException e) {
                        e.printStackTrace();
                    }
                    catch (XSLException e) {
                        e.printStackTrace();
                    }
                }
                String tmp = "";
                if (_value instanceof List) {
                    for (Object elt : (List)_value) {
                        if (elt instanceof ValueRepresentation) {
                            try {
                                tmp = String.valueOf(tmp) + ((ValueRepresentation)elt).getStringValue();
                            }
                            catch (XPathException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        tmp = String.valueOf(tmp) + elt.toString();
                    }
                } else if (_value instanceof String) {
                    tmp = (String)((Object)_value);
                } else if (_value != null) {
                    tmp = _value.toString();
                }
                tmp = tmp.replaceAll("\\[", startCroch);
                tmp = tmp.replaceAll("\\]", endCroch);
                value = String.valueOf(value) + tmp;
            }
            pattern = value;
            pattern = pattern.replaceAll("\\[\\[", startCroch);
            pattern = pattern.replaceAll("\\]\\]", endCroch);
            String[] stringArray = list = Functions.motifList(pattern, "\\[[^]]*\\]");
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                List _list = null;
                if (c.getContextItem() instanceof NodeInfo) {
                    try {
                        _list = Functions.evaluate(c, (NodeInfo)c.getContextItem(), "mdj:xpath(.,'[" + code + "]')");
                    }
                    catch (XSLException | XPathExpressionException | XPathException e) {
                        e.printStackTrace();
                    }
                }
                String _value = _list != null && _list.size() > 0 ? _list.get(0) : "";
                String tmp = _value.toString();
                pattern = Functions.replaceAll(pattern, "\\[" + Functions.replaceRegexpString(code) + "\\]", tmp);
                ++n2;
            }
            pattern = rarsc.restore(pattern);
            pattern = pattern.replaceAll(startAcc, "{");
            pattern = pattern.replaceAll(endAcc, "}");
            pattern = pattern.replaceAll(startCroch, "[");
            pattern = pattern.replaceAll(endCroch, "]");
        }
        return pattern;
    }

    public static String replaceRegexpString(String string) {
        if (string != null) {
            int i = 0;
            ArrayList list = new ArrayList();
            char[] ch = string.toCharArray();
            String result = "";
            while (i < string.length()) {
                char c = string.charAt(i);
                String tmp = "";
                if ((tmp = String.valueOf(tmp) + c).matches("\\[|\\]|\\}|\\{|\\(|\\)|\\+|\\*|\\.|\\^|\\$|\\?")) {
                    result = String.valueOf(result) + "\\";
                }
                result = String.valueOf(result) + c;
                ++i;
            }
            return result;
        }
        return null;
    }

    public static String reduceUUID(String uuid) {
        long l = ByteBuffer.wrap(uuid.getBytes()).getLong();
        return Long.toString(l, 36);
    }

    public static String toJavaProperties(NodeInfo context) throws Exception {
        String s;
        Properties prop = new Properties();
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, null);
        for (Object o : (Collection)e.evaluate("@*", context, XPathConstants.NODESET)) {
            s = ((NodeInfo)o).getDisplayName();
            String v = ((NodeInfo)o).getStringValue();
            prop.put(s, v);
        }
        for (Object o : (Collection)e.evaluate("*[@position!='']", context, XPathConstants.NODESET)) {
            s = (String)e.evaluate("concat(./name(), '|', @position, '|', @key , '|', ./text())", o, XPathConstants.STRING);
            String[] p = s.split("\\|");
            prop.put(String.valueOf(p[0]) + "." + p[1], p[3]);
            if (p[2].isEmpty()) continue;
            prop.put(String.valueOf(p[0]) + "." + p[1] + ".key", p[2]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        prop.store(bos, null);
        return new String(bos.toByteArray(), "UTF-8");
    }

    public static String formatUriPreservingFragment(String path) {
        String[] p = path.split("#");
        if (p.length > 2) {
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < p.length) {
                if (i == p.length - 1) {
                    b.append("#");
                } else if (i > 0) {
                    b.append("%23");
                }
                b.append(p[i]);
                ++i;
            }
            return b.toString();
        }
        return path;
    }

    private static class EvaluationVariableResolver
    implements XPathVariableResolver {
        Stack<Ctx> stackCtx = new Stack();

        private EvaluationVariableResolver() {
        }

        void pushContext(XPathContext ctx, NodeInfo context, StackFrame stackFrame, XPathVariableResolver r) {
            this.stackCtx.push(new Ctx(ctx, r, stackFrame, context));
        }

        void popContext() {
            this.stackCtx.pop();
        }

        @Override
        public Object resolveVariable(QName variableName) {
            Object result;
            XPathContext xPathCtx = this.stackCtx.peek().ctx;
            NodeInfo context = this.stackCtx.peek().context;
            StackFrame stackFrame = this.stackCtx.peek().stackFrame;
            XPathVariableResolver wrappedResolver = this.stackCtx.peek().wrappedResolver;
            if (wrappedResolver != null && (result = wrappedResolver.resolveVariable(variableName)) != null) {
                return result;
            }
            int i = -1;
            for (QName name : Variables.valueRepresentationMap.keySet()) {
                if (!name.equals(variableName)) continue;
                ValueRepresentation result2 = Variables.valueRepresentationMap.get(variableName);
                return result2;
            }
            for (QName var : stackFrame.getStackFrameMap().getVariableMap()) {
                ++i;
                if (!((Object)var).toString().equals(variableName.toString())) continue;
                ValueRepresentation result3 = stackFrame.getStackFrameValues()[i];
                return result3;
            }
            try {
                List result4 = Functions.getMdRef(xPathCtx, context, variableName.toString());
                if (result4 != null) {
                    return result4;
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            StackedVariableManager.StackedVariable vs = StackedVariableManager.INSTANCE.getVariable(variableName.getLocalPart());
            if (vs != null) {
                return vs.peekValue(false);
            }
            return null;
        }

        private class Ctx {
            private XPathVariableResolver wrappedResolver = null;
            private StackFrame stackFrame;
            private NodeInfo context;
            private XPathContext ctx;

            Ctx(XPathContext ctx, XPathVariableResolver wrappedResolver, StackFrame stackFrame, NodeInfo context) {
                this.ctx = ctx;
                this.wrappedResolver = wrappedResolver;
                this.stackFrame = stackFrame;
                this.context = context;
            }
        }
    }
}

