/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.saxon.extension.impl;

import com.indy.xsl.saxon.extension.impl.StorageKeyProvider;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyAttributeCollection;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.tinytree.extension.IExtensionSupport;

public class AttributeReader
implements IExtensionSupport.IValueResolver {
    private IDelegateExpressionEvaluator evaluator;
    StorageKeyProvider keyProvider;

    public AttributeReader(StorageKeyProvider keyProvider) {
        this.keyProvider = keyProvider;
    }

    public void setEvaluator(IDelegateExpressionEvaluator e) {
        this.evaluator = e;
    }

    public IDelegateExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    public CharSequence readTextNode(TinyTree tree, int nodeNr) {
        int start = tree.getAlphaArray()[nodeNr];
        int len = tree.getBetaArray()[nodeNr];
        CharSequence r = tree.getCharacterBuffer().subSequence(start, start + len);
        if (this.resolveValue(r)) {
            TinyAttributeCollection c = new TinyAttributeCollection(tree, nodeNr - 1);
            int idNr = c.getIndex("", "id");
            String id = c.getValue(idNr);
            String storageKey = String.valueOf(id) + ".text";
            TinyNodeImpl node = tree.getNode(nodeNr - 1);
            r = this.evaluator.evaluateExpression(storageKey, (NodeInfo)node, r.toString());
        }
        return r;
    }

    public CharSequence readAttribute(NodeInfo node, int currentAttributeNodeNr) {
        TinyTree tree = ((IExtensionSupport.ITinyTreeAdapter)node).getTinyTree();
        CharSequence s = tree.getAttributeValueArray()[currentAttributeNodeNr];
        if (this.evaluator != null && s instanceof TinyTree.DelegatedCharSequence) {
            CharSequence r;
            tree.getAttributeValueArray()[currentAttributeNodeNr] = r = this.evaluator.evaluateExpression(this.keyProvider.getStorageKey(node, currentAttributeNodeNr), node, ((TinyTree.DelegatedCharSequence)s).getWrapped());
            return r;
        }
        return tree.getAttributeValueArray()[currentAttributeNodeNr];
    }

    public boolean resolveValue(CharSequence value) {
        return value.toString().contains("%{") || value.toString().contains("%x{");
    }

    public static interface IDelegateExpressionEvaluator {
        public CharSequence evaluateExpression(String var1, NodeInfo var2, CharSequence var3);
    }
}

