/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.saxon.extension.impl;

import com.indy.xsl.saxon.extension.impl.AttributeReader;
import com.indy.xsl.saxon.extension.impl.ExternalizationPlaceHolder;
import com.indy.xsl.saxon.extension.impl.StorageKeyProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.tinytree.extension.IExtensionSupport;

public class Configuration4Generation
extends Configuration
implements IExtensionSupport {
    private static final long serialVersionUID = -7218524648609839201L;
    public static final String EXTERNALIZED_MAP_KEY_PREFIX = "ext.";
    private StorageKeyProvider keyProvider = new StorageKeyProvider();
    private Map<String, String> genValues = null;
    private List<IExtensionSupport.IPlaceHolderListener> listeners = new ArrayList<IExtensionSupport.IPlaceHolderListener>();
    private boolean externalizationMode = false;
    private Matcher matcher = null;
    private AttributeReader attributeReader = new AttributeReader(this.keyProvider);

    public IExtensionSupport.IValueResolver getValueResolver() {
        return this.attributeReader;
    }

    public IExtensionSupport.IAttributePlaceHolder createAttributePlaceHolder() {
        return new ExternalizationPlaceHolder(this, this.keyProvider);
    }

    public void setExternalizedExpressionsRegex(String externalizationRegex) {
        Pattern REGX = Pattern.compile(externalizationRegex);
        this.matcher = REGX.matcher("");
    }

    public boolean isExternalizedValue(CharSequence s) {
        boolean res = false;
        if (this.matcher != null) {
            this.matcher.reset(s);
            res = this.matcher.matches();
        }
        return res;
    }

    public void setGenerationMap4ExternalizedAttributes(Map<String, String> generatedValues) {
        this.genValues = generatedValues;
    }

    public void addListener(IExtensionSupport.IPlaceHolderListener l) {
        this.listeners.add(l);
    }

    public void removeListener(IExtensionSupport.IPlaceHolderListener l) {
        this.listeners.remove(l);
    }

    public void enablePlaceHolderSupport(boolean isExternalizationMode) {
        if (isExternalizationMode != this.externalizationMode) {
            this.externalizationMode = isExternalizationMode;
            for (IExtensionSupport.IPlaceHolderListener l : this.listeners) {
                l.handlePlaceHolderSupportEnabled(isExternalizationMode);
            }
        }
    }

    public boolean isExternalizationMode() {
        return this.externalizationMode;
    }

    public String getGeneratedValueForKey(String key) {
        return this.genValues.get(key);
    }
}

