/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.saxon.extension.impl;

import com.indy.xsl.saxon.extension.impl.Configuration4Generation;
import com.indy.xsl.saxon.extension.impl.StorageKeyProvider;
import java.util.HashMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.tinytree.extension.IExtensionSupport;

public class ExternalizationPlaceHolder
implements IExtensionSupport.IAttributePlaceHolder {
    private HashMap<Integer, ExternalizedCharSequenceHolder> attValues_externalized = new HashMap();
    private TinyTree tinyTree;
    StorageKeyProvider keyProvider;
    Configuration4Generation conf;

    public ExternalizationPlaceHolder(Configuration4Generation conf, StorageKeyProvider keyProvider) {
        this.keyProvider = keyProvider;
        this.conf = conf;
    }

    public void registerAttribute(int parent, int attributeNumber, CharSequence value) {
        this.attValues_externalized.put(attributeNumber, new ExternalizedCharSequenceHolder(parent, attributeNumber, value));
        if (this.conf.isExternalizationMode()) {
            this.applyOn(attributeNumber, true);
        }
    }

    private void applyOn(Integer attributeNumber, boolean enabled) {
        Object seq = null;
        ExternalizedCharSequenceHolder h = this.attValues_externalized.get(attributeNumber);
        if (h != null) {
            if (enabled) {
                seq = h.toEvaluteAttributeValue;
                if (seq == null) {
                    seq = h.externalizedAttributeValue;
                }
                TinyNodeImpl n = this.tinyTree.getNode(h.nodeNr);
                String s = this.keyProvider.getStorageKey((NodeInfo)n, attributeNumber);
                String generated = ((Configuration4Generation)this.tinyTree.getConfiguration()).getGeneratedValueForKey("ext." + s);
                if (generated != null) {
                    seq = generated;
                }
            } else {
                seq = h.externalizedAttributeValue;
            }
            this.tinyTree.getAttributeValueArray()[attributeNumber.intValue()] = seq;
        }
    }

    public void apply(boolean enabled) {
        for (Integer attributeNr : this.attValues_externalized.keySet()) {
            this.applyOn(attributeNr, enabled);
        }
    }

    public boolean handleValue(CharSequence value) {
        return this.conf.isExternalizedValue(value);
    }

    public void setTinyTree(TinyTree tinyTree) {
        this.tinyTree = tinyTree;
    }

    class ExternalizedCharSequenceHolder {
        CharSequence externalizedAttributeValue;
        TinyTree.DelegatedCharSequence toEvaluteAttributeValue;
        int nodeNr;
        int attributeNr;

        protected ExternalizedCharSequenceHolder(int nodeNr, int attributeNr, CharSequence externalizedAttributeValue) {
            this.nodeNr = nodeNr;
            this.attributeNr = attributeNr;
            this.externalizedAttributeValue = externalizedAttributeValue;
            this.toEvaluteAttributeValue = new TinyTree.DelegatedCharSequence(externalizedAttributeValue);
        }
    }
}

