/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.sql;

import com.indy.xsl.sql.Messages;
import com.indy.xsl.sql.ResultSetManager;
import java.util.HashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sql.SQLQuery;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class SQLResultSet
extends SQLQuery {
    Expression resultSetManager;
    boolean disable = false;
    private String name;
    private Expression filters;

    public void prepareAttributes() throws XPathException {
        String disableAtt;
        String resultSetAtt = this.getAttributeValue("", "resultSetManager");
        if (resultSetAtt == null) {
            this.reportAbsence("resultSetManager");
        } else {
            this.resultSetManager = this.makeExpression(resultSetAtt);
        }
        String filtersAtt = this.getAttributeValue("", "filters");
        if (filtersAtt != null) {
            this.filters = this.makeExpression(filtersAtt);
        }
        this.name = this.getAttributeValue("", "name");
        if (this.name == null) {
            this.compileError(Messages.SQLResultSet_0);
        }
        if ((disableAtt = this.getAttributeValue("", "disable-output-escaping")) != null) {
            if (disableAtt.equals("yes")) {
                this.disable = true;
            } else if (disableAtt.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.resultSetManager = this.typeCheck("resultSetManager", this.resultSetManager);
    }

    public Expression compile(Executable exec) throws XPathException {
        if (this.filters != null) {
            return new QueryInstruction(this.resultSetManager, this.name, this.filters, this.disable);
        }
        return new QueryInstruction(this.resultSetManager, this.name, this.disable);
    }

    private static class QueryInstruction
    extends SimpleExpression {
        public static final int RESULTSETS = 0;
        public static final int FILTERS = 1;
        int options;
        private String name;

        public QueryInstruction(Expression resultSets, String name, Expression filters, boolean disable) {
            Expression[] sub = new Expression[]{resultSets, filters};
            this.setArguments(sub);
            this.name = name;
            this.options = disable ? 1 : 0;
        }

        public QueryInstruction(Expression resultSets, String name, boolean disable) {
            Expression[] sub = new Expression[]{resultSets};
            this.setArguments(sub);
            this.name = name;
            this.options = disable ? 1 : 0;
        }

        public int getImplementationMethod() {
            return 4;
        }

        public String getExpressionType() {
            return "sql:resultSet";
        }

        public void process(XPathContext context) throws XPathException {
            Item _filters;
            Controller controller = context.getController();
            String str = "";
            Item _resultSetManager = this.arguments[0].evaluateItem(context);
            Object obj = ((ObjectValue)_resultSetManager).getObject();
            if (!(_resultSetManager instanceof ObjectValue) || !(((ObjectValue)_resultSetManager).getObject() instanceof ResultSetManager)) {
                XPathException de = new XPathException(Messages.SQLResultSet_1);
                de.setXPathContext(context);
                throw de;
            }
            ResultSetManager resultSetManager = (ResultSetManager)((ObjectValue)_resultSetManager).getObject();
            HashMap<String, String> filtersMap = new HashMap<String, String>();
            if (this.arguments.length > 1 && (_filters = this.arguments[1].evaluateItem(context)) instanceof TinyNodeImpl) {
                AxisIterator ai = ((TinyNodeImpl)_filters).iterateAxis((byte)3);
                while (ai.next() != null) {
                    Item item = ai.current();
                    String alias = Navigator.getAttributeValue((NodeInfo)((NodeInfo)item), null, (String)"alias");
                    String value = Navigator.getAttributeValue((NodeInfo)((NodeInfo)item), null, (String)"value");
                    filtersMap.put(alias, value);
                }
            }
        }
    }
}

