/*
 * Decompiled with CFR 0.152.
 */
package com.indy.xsl.sqlparser;

import com.indy.xsl.sqlparser.FunctionParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ExpressionParser {
    Stack<ExpressionTree> stack = new Stack();
    boolean hasReadUDF = false;

    public ExpressionTree createExpressionTree(String code) {
        this.hasReadUDF = false;
        Lexer lexer = new Lexer(code);
        Token token = null;
        ExpressionTree root = new ExpressionTree(token, Type.Root);
        this.stack = new Stack();
        this.stack.push(root);
        while ((token = lexer.read()) != null) {
            this.createNode(token);
        }
        return root;
    }

    private void createNode(Token token) {
        ExpressionTree current = this.stack.peek();
        current.addChildren(token);
    }

    private String formatCode(String code, Map<String, String> prefixReplacement) {
        ExpressionTree expressionTree = this.createExpressionTree(code);
        UDFVisitor v = new UDFVisitor(this.hasReadUDF, prefixReplacement);
        return v.accept(expressionTree);
    }

    public boolean containsUDF() {
        return this.hasReadUDF;
    }

    public static void main(String[] args) {
        block13: {
            InputStream is = ExpressionParser.class.getClassLoader().getResourceAsStream("sqlParserTestCases/udf_test.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        HashMap<String, String> m = new HashMap<String, String>();
                        System.out.println(FunctionParser.INSTANCE.parse(line, m));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (reader == null) break block13;
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static enum Event {
        FUNCTION_OPEN,
        CLOSE,
        STRING,
        DATA,
        SEPARATOR,
        WHITESPACE,
        OPEN_PARENTHESIS,
        OPEN_GEN_BLOCK,
        CLOSE_GEN_BLOCK;

    }

    public class ExpressionTree {
        List<ExpressionTree> children = new ArrayList<ExpressionTree>();
        ExpressionTree parent;
        Token token;
        Type type;

        ExpressionTree(Token token, Type type) {
            this.token = token;
            this.type = type;
        }

        public ExpressionTree(Token token) {
            this.token = token;
            switch (token.event) {
                case CLOSE_GEN_BLOCK: {
                    this.type = Type.Block;
                    break;
                }
                case DATA: {
                    this.type = Type.Data;
                    break;
                }
                case STRING: {
                    this.type = Type.String;
                    break;
                }
                case FUNCTION_OPEN: {
                    if (token.isUDF) {
                        this.type = Type.Udf;
                        break;
                    }
                    this.type = Type.Function;
                    break;
                }
                case OPEN_PARENTHESIS: {
                    this.type = Type.Group;
                    break;
                }
                case SEPARATOR: {
                    this.type = Type.Parameter;
                }
                default: {
                    this.type = Type.Unknown;
                }
            }
        }

        private void addChildren(ExpressionTree c) {
            if (c.type == Type.Data && !this.children.isEmpty() && this.children.get((int)(this.children.size() - 1)).type == Type.Data) {
                this.children.get((int)(this.children.size() - 1)).token.val = String.valueOf(this.children.get((int)(this.children.size() - 1)).token.val) + c.token.val;
                return;
            }
            c.parent = this;
            this.children.add(c);
        }

        boolean supportChildren() {
            return this.type != Type.Block && this.type != Type.Data;
        }

        public void addChildren(Token token) {
            if (token.event == Event.OPEN_GEN_BLOCK) {
                return;
            }
            if (token.event == Event.STRING) {
                if (!ExpressionParser.this.stack.isEmpty() && ExpressionParser.this.stack.peek().type == Type.String) {
                    ExpressionTree expressionTree = ExpressionParser.this.stack.pop();
                } else if (!ExpressionParser.this.stack.isEmpty()) {
                    if (ExpressionParser.this.stack.peek().type == Type.Function || ExpressionParser.this.stack.peek().type == Type.Udf) {
                        ExpressionTree c = new ExpressionTree(null, Type.Parameter);
                        ExpressionParser.this.stack.peek().addChildren(c);
                        ExpressionParser.this.stack.push(c);
                        c.addChildren(token);
                    } else {
                        ExpressionTree c = new ExpressionTree(token);
                        ExpressionParser.this.stack.peek().addChildren(c);
                        if (c.supportChildren()) {
                            ExpressionParser.this.stack.push(c);
                        }
                    }
                }
            } else if (token.event == Event.CLOSE) {
                if (!ExpressionParser.this.stack.isEmpty()) {
                    ExpressionTree t;
                    while (!ExpressionParser.this.stack.peek().isClosable()) {
                        t = ExpressionParser.this.stack.pop();
                        if (ExpressionParser.this.stack.isEmpty()) break;
                    }
                    if (!ExpressionParser.this.stack.isEmpty()) {
                        t = ExpressionParser.this.stack.pop();
                    }
                }
            } else if (token.event == Event.SEPARATOR) {
                if (!ExpressionParser.this.stack.isEmpty()) {
                    while (ExpressionParser.this.stack.peek().type != Type.Function && ExpressionParser.this.stack.peek().type != Type.Udf && ExpressionParser.this.stack.peek().type != Type.Group) {
                        ExpressionTree t = ExpressionParser.this.stack.pop();
                        if (ExpressionParser.this.stack.isEmpty()) break;
                    }
                    ExpressionTree c = new ExpressionTree(null, Type.Parameter);
                    if (!ExpressionParser.this.stack.isEmpty()) {
                        ExpressionParser.this.stack.peek().addChildren(c);
                    }
                    ExpressionParser.this.stack.push(c);
                }
            } else if (this.type == Type.Function || this.type == Type.Udf) {
                ExpressionTree c = new ExpressionTree(null, Type.Parameter);
                if (!ExpressionParser.this.stack.isEmpty()) {
                    ExpressionParser.this.stack.peek().addChildren(c);
                }
                ExpressionParser.this.stack.push(c);
                c.addChildren(token);
            } else {
                ExpressionTree c = new ExpressionTree(token);
                if (!ExpressionParser.this.stack.isEmpty()) {
                    ExpressionParser.this.stack.peek().addChildren(c);
                }
                if (c.supportChildren()) {
                    ExpressionParser.this.stack.push(c);
                }
            }
        }

        private boolean isClosable() {
            return this.type == Type.Function || this.type == Type.Udf || this.type == Type.Group;
        }

        public String toGraph() {
            StringBuffer b = new StringBuffer();
            for (ExpressionTree t : this.children) {
                b.append("\"" + (Object)((Object)this.type) + "(" + this.toString() + ")" + "\"->\"" + (Object)((Object)t.type) + "(" + t.toString() + ")" + "\"\n");
            }
            for (ExpressionTree t : this.children) {
                b.append(t.toGraph());
            }
            String label = this.type.name();
            if (this.token != null) {
                label = String.valueOf(label) + "-" + this.token.val;
            }
            b.append("\"" + (Object)((Object)this.type) + "(" + this.toString() + ")" + "\"[label=\"" + label + "\"]\n");
            return b.toString();
        }

        public Type getType() {
            return this.type;
        }

        public Token getToken() {
            return this.token;
        }

        public List<ExpressionTree> getChildren() {
            return this.children;
        }
    }

    static enum FUNCTION_TYPE {
        NONE,
        REGULAR,
        UDF;

    }

    private class Lexer {
        private LinkedList<Token> readTokens = new LinkedList();
        private char previousChar;
        private String data;
        private int curIndex;
        private boolean inString = false;
        StringBuffer buf = new StringBuffer();

        public Lexer(String data) {
            this.data = data;
        }

        protected void handleBuffer() {
            if (this.buf.length() > 0) {
                this.readTokens.add(new Token(this.buf.toString(), Event.DATA, this.curIndex - 1));
                this.buf = new StringBuffer();
            }
        }

        /*
         * Unable to fully structure code
         */
        public Token read() {
            if (this.readTokens.isEmpty()) ** GOTO lbl120
            return this.readTokens.poll();
lbl-1000:
            // 1 sources

            {
                currentChar = this.data.charAt(this.curIndex++);
                block0 : switch (currentChar) {
                    case '\'': {
                        if (this.previousChar == '\'') {
                            this.buf.append(currentChar);
                            break;
                        }
                        if (this.curIndex < this.data.length() && this.data.charAt(this.curIndex) == '\'') {
                            this.buf.append(currentChar);
                            break;
                        }
                        this.handleBuffer();
                        this.readTokens.add(new Token(this.buf.toString(), Event.STRING, this.curIndex));
                        this.inString = this.inString == false;
                        break;
                    }
                    case '(': {
                        if (this.inString) {
                            this.buf.append(currentChar);
                            break;
                        }
                        functionType = FUNCTION_TYPE.NONE;
                        functionType = this.isBufferFunction();
                        if (functionType != FUNCTION_TYPE.NONE) {
                            spaces = new StringBuffer();
                            s = this.buf.toString();
                            lastFirstJIdentifier = -1;
                            i = s.lastIndexOf("::") - 1;
                            while (i >= 0) {
                                c = s.charAt(i);
                                if (c == '$' || c == '\u00a4' || !Character.isJavaIdentifierPart(c) && !Character.isJavaIdentifierStart(c)) break;
                                lastFirstJIdentifier = i--;
                            }
                            if (lastFirstJIdentifier < 0) {
                                this.handleBuffer();
                                this.readTokens.add(new Token(this.buf.toString(), Event.OPEN_PARENTHESIS, this.curIndex));
                                break;
                            }
                            spaces.append(s.substring(0, lastFirstJIdentifier));
                            s = s.substring(lastFirstJIdentifier);
                            if (spaces.length() > 0) {
                                this.readTokens.add(new Token(spaces.toString(), Event.DATA, this.curIndex - s.length()));
                                this.readTokens.add(new Token(s, Event.FUNCTION_OPEN, this.curIndex));
                            } else {
                                this.readTokens.add(new Token(this.buf.toString(), Event.FUNCTION_OPEN, this.curIndex));
                            }
                            v0 = this.readTokens.getLast().isUDF = functionType == FUNCTION_TYPE.UDF;
                            if (functionType == FUNCTION_TYPE.UDF) {
                                ExpressionParser.this.hasReadUDF = true;
                            }
                            this.buf = new StringBuffer();
                            break;
                        }
                        this.handleBuffer();
                        this.readTokens.add(new Token(this.buf.toString(), Event.OPEN_PARENTHESIS, this.curIndex));
                        break;
                    }
                    case ')': {
                        if (this.inString) {
                            this.buf.append(currentChar);
                            break;
                        }
                        this.handleBuffer();
                        this.readTokens.add(new Token(this.buf.toString(), Event.CLOSE, this.curIndex));
                        break;
                    }
                    case ',': {
                        if (this.inString) {
                            this.buf.append(currentChar);
                            break;
                        }
                        if (this.previousChar == '\\') {
                            this.buf.append(currentChar);
                            break;
                        }
                        this.handleBuffer();
                        this.readTokens.add(new Token(null, Event.SEPARATOR, this.curIndex));
                        break;
                    }
                    case '%': {
                        if (this.curIndex + 2 < this.data.length()) {
                            startBlock = this.data.substring(this.curIndex, this.curIndex + 2);
                            if (startBlock.endsWith("x{")) {
                                this.handleBuffer();
                                this.readTokens.add(new Token(this.buf.toString(), Event.OPEN_GEN_BLOCK, this.curIndex));
                                this.curIndex += 2;
                                while (this.curIndex < this.data.length()) {
                                    if ((currentChar = this.data.charAt(this.curIndex++)) == '}') {
                                        if (this.curIndex + 2 <= this.data.length()) {
                                            end = this.data.substring(this.curIndex, this.curIndex + 2);
                                            if (!"x%".equals(end)) continue;
                                            this.readTokens.add(new Token(this.buf.toString(), Event.CLOSE_GEN_BLOCK, this.curIndex));
                                            this.buf = new StringBuffer();
                                            this.curIndex += 2;
                                            break block0;
                                        }
                                        this.buf.append(currentChar);
                                        continue;
                                    }
                                    this.buf.append(currentChar);
                                }
                                break;
                            }
                            this.buf.append(currentChar);
                            break;
                        }
                        this.buf.append(currentChar);
                        break;
                    }
                    default: {
                        if (Character.isWhitespace(currentChar)) {
                            this.handleBuffer();
                        }
                        this.buf.append(currentChar);
                    }
                }
                this.previousChar = currentChar;
lbl120:
                // 2 sources

                ** while (this.curIndex < this.data.length() && this.readTokens.isEmpty())
            }
lbl121:
            // 1 sources

            this.handleBuffer();
            return this.readTokens.isEmpty() != false ? null : this.readTokens.poll();
        }

        private FUNCTION_TYPE isBufferFunction() {
            String startFunc = ".*[_A-Za-z][_A-Za-z0-9]*::[_A-Za-z][_A-Za-z0-9]*";
            String startNormalFunc = "[_:A-Za-z][-._:A-Za-z0-9]*";
            String s = this.buf.toString().trim();
            if (!s.isEmpty()) {
                if (s.matches(startFunc)) {
                    return FUNCTION_TYPE.UDF;
                }
                if (s.matches(startNormalFunc)) {
                    return FUNCTION_TYPE.REGULAR;
                }
            }
            return FUNCTION_TYPE.NONE;
        }
    }

    public class Token {
        String val;
        Event event;
        int tokenStartPosition = -1;
        public boolean isUDF = false;

        Token(String val, Event event, int tokenStartPosition) {
            this.val = val;
            this.event = event;
            this.tokenStartPosition = tokenStartPosition;
        }

        public String getValue() {
            return this.val;
        }
    }

    public static enum Type {
        String,
        Data,
        Block,
        Function,
        Udf,
        Parameter,
        Group,
        Root,
        Unknown;

    }

    class UDFVisitor {
        boolean stringOpened = false;
        StringBuffer b = new StringBuffer();
        boolean hasUDF;
        Map<String, String> prefixReplacement;

        UDFVisitor(boolean hasUDF, Map<String, String> prefixReplacement) {
            this.hasUDF = hasUDF;
            this.prefixReplacement = prefixReplacement;
        }

        String accept(ExpressionTree tree) {
            if (this.hasUDF) {
                this.b.append("concat(");
            }
            for (ExpressionTree c : tree.children) {
                this.visit3(c);
                if (!this.hasUDF || tree.children.indexOf(c) >= tree.children.size() - 1) continue;
                if (this.stringOpened) {
                    this.stringOpened = false;
                    this.b.append("'");
                }
                this.b.append(",");
            }
            if (this.stringOpened) {
                this.stringOpened = false;
                this.b.append("'");
            }
            if (this.hasUDF && tree.children.size() == 1) {
                this.b.append(", ''");
            }
            if (this.hasUDF) {
                this.b.append(")");
            }
            return this.b.toString();
        }

        void visit3(ExpressionTree tree) {
            if (tree.type != Type.Block && tree.type != Type.Udf) {
                if (tree.type == Type.Parameter) {
                    if (tree.parent.type == Type.Udf) {
                        if (this.stringOpened) {
                            this.stringOpened = false;
                            this.b.append("'");
                        }
                    } else if (!this.stringOpened) {
                        this.stringOpened = false;
                        this.b.append("'");
                    }
                } else if (!this.stringOpened) {
                    this.stringOpened = true;
                    this.b.append("'");
                }
            }
            if (tree.type == Type.Block) {
                this.b.append("%x{" + tree.token.val + "}x%");
            } else if (tree.type == Type.Udf) {
                if (this.stringOpened) {
                    this.stringOpened = false;
                    this.b.append("',");
                }
                this.b.append(String.valueOf(this.replaceUDFPrefix(tree.token.val)) + "(./ref:container()");
                for (ExpressionTree c : tree.children) {
                    this.visit3(c);
                }
                this.b.append(")");
            } else if (tree.type == Type.Parameter) {
                Integer udfConcatParemeterNumber = null;
                if (tree.parent.type == Type.Udf) {
                    ExpressionParser.this.stack.push(tree);
                    if (this.stringOpened) {
                        this.stringOpened = false;
                        this.b.append("'");
                    }
                    ArrayList<Boolean> l = new ArrayList<Boolean>();
                    udfConcatParemeterNumber = 0;
                    for (ExpressionTree c : tree.children) {
                        if (c.type == Type.Block) continue;
                        l.add(c.type == Type.Udf);
                    }
                    int i = 0;
                    while (i < l.size()) {
                        if (((Boolean)l.get(i)).booleanValue()) {
                            udfConcatParemeterNumber = udfConcatParemeterNumber + 1;
                        } else if (i == 0) {
                            udfConcatParemeterNumber = udfConcatParemeterNumber + 1;
                        } else if (l.get(i - 1) != l.get(i)) {
                            udfConcatParemeterNumber = udfConcatParemeterNumber + 1;
                        }
                        ++i;
                    }
                    this.b.append(",");
                    this.b.append("concat(");
                } else if (tree.parent.children.indexOf(tree) != 0) {
                    this.b.append(",");
                }
                for (ExpressionTree c : tree.children) {
                    this.visit3(c);
                }
                if (tree.parent.type == Type.Udf) {
                    if (this.stringOpened) {
                        this.stringOpened = false;
                        this.b.append("'");
                    }
                    if (udfConcatParemeterNumber == 1) {
                        this.b.append(", ''");
                    }
                    this.b.append(")");
                    ExpressionParser.this.stack.pop();
                }
            } else if (tree.type == Type.String) {
                if (!this.stringOpened) {
                    this.stringOpened = true;
                    this.b.append("'");
                }
                this.b.append("''");
                for (ExpressionTree c : tree.children) {
                    this.visit3(c);
                }
                this.b.append("''");
            } else if (tree.type == Type.Group) {
                if (!this.stringOpened) {
                    this.stringOpened = true;
                    this.b.append("'");
                }
                this.b.append("(");
                for (ExpressionTree c : tree.children) {
                    this.visit3(c);
                }
                if (!this.stringOpened) {
                    this.stringOpened = true;
                    this.b.append(",'");
                }
                this.b.append(")");
            } else if (tree.type == Type.Function) {
                this.b.append(String.valueOf(tree.token.val) + "(");
                for (ExpressionTree c : tree.children) {
                    this.visit3(c);
                }
                if (!this.stringOpened) {
                    this.stringOpened = true;
                    this.b.append(",'");
                }
                this.b.append(")");
            } else if (tree.type == Type.Data) {
                if (this.stringOpened) {
                    this.b.append(tree.token.val.replace("'", "''"));
                } else {
                    this.b.append(tree.token.val);
                }
            }
        }

        private String replaceUDFPrefix(String val) {
            String replacement;
            int i = val.indexOf("::");
            String prefix = val.substring(0, i);
            if (this.prefixReplacement != null && (replacement = this.prefixReplacement.get(prefix)) != null) {
                return String.valueOf(replacement) + val.substring(i + 2);
            }
            return val.replace("::", ":");
        }
    }
}

