/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.resource;

import com.indy.ui.common.resource.IResourceCompatibility;
import com.stambia.ui.resource.Activator;
import com.stambia.ui.resource.Resource;
import com.stambia.ui.resource.ResourceCompatibilityTrackerCustomizer;
import com.stambia.ui.resource.ResourceListenerManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ResourcePluginStambia
extends AbstractUIPlugin {
    private static String XDI_ANALYTICS_RESSOURCES_FOLDER_NAME = ".stambiaWebApp";
    public static String USERS_FOLDER_NAME = "users";
    public static String XDI_ANALYTICS_LOGS_FILE_NAME = "stambia.logs";
    public static String XDI_ANALYTICS_LOG_DIRECTORY = "internal/log";
    private static String XDI_ANALYTICS_NAVIGATOR_FOLDER_NAME = "navigator";
    private static String XDI_ANALYTICS_JDBC_DRIVER_FOLDER_NAME = "jdbc";
    private static String XDI_ANALYTICS_REPOSITORIES_FOLDER_NAME = "repositories";
    private static String XDI_ANALYTICS_DOCUMENTATION_FOLDER_NAME = "documentation";
    private static String ENABLE_ROLE_CODE;
    private static IPath XDI_ANALYTICS_WEBAPP_HOME;
    private static IPath XDI_ANALYTICS_WEBAPP_TEMP;
    private static Map<String, ImageDescriptor> repoMetadataImg;
    public static final String PLUGIN_ID = "com.indy.ui.resource";
    private static ResourcePluginStambia plugin;
    boolean isInit = false;
    private ServiceTracker serviceTracker;
    boolean XDI_ANALYTICS_WEBAPP_TEMP_IsSet = false;
    ResourceListenerManager resourceListenerManager = new ResourceListenerManager();

    private void init() {
        if (!this.isInit) {
            try {
                IPath envRootPath = Resource.getCompatibility().getRootEnvironmentPath();
                if (envRootPath != null) {
                    XDI_ANALYTICS_WEBAPP_HOME = envRootPath;
                    XDI_ANALYTICS_RESSOURCES_FOLDER_NAME = null;
                } else {
                    XDI_ANALYTICS_WEBAPP_HOME = this.getStateLocation();
                }
                if (!this.getStambiaJdbcDriverPath().toFile().exists()) {
                    this.getStambiaJdbcDriverPath().toFile().mkdir();
                }
                System.out.println("Analytics Webapp Home: " + XDI_ANALYTICS_WEBAPP_HOME);
                this.isInit = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ENABLE_ROLE_CODE = System.getProperty("stambia.enableRoleCode") != null ? System.getProperty("stambia.enableRoleCode") : "l4z52fpma12c";
    }

    public ImageDescriptor getRepoMetadataImage(String code) {
        return null;
    }

    public void registerNewRepoMetadataImage(File file) {
        String key = file.getName();
        int idx = key.lastIndexOf(".");
        if (idx != -1) {
            key = key.substring(0, idx);
        }
        try {
            repoMetadataImg.put(key, ImageDescriptor.createFromURL((URL)file.toURI().toURL()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Activator.forceStart();
        this.serviceTracker = new ServiceTracker(context, IResourceCompatibility.class, (ServiceTrackerCustomizer)new ResourceCompatibilityTrackerCustomizer(context));
        this.serviceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceTracker.close();
        this.serviceTracker = null;
        plugin = null;
        super.stop(context);
    }

    public static ResourcePluginStambia getDefault() {
        plugin.init();
        return plugin;
    }

    public IPath getStambiaWebAppHome() {
        return XDI_ANALYTICS_WEBAPP_HOME;
    }

    public IPath getStambiaWebAppTemp() {
        if (!this.XDI_ANALYTICS_WEBAPP_TEMP_IsSet) {
            XDI_ANALYTICS_WEBAPP_TEMP = this.getStambiaIPath().append("temp");
            this.XDI_ANALYTICS_WEBAPP_TEMP_IsSet = true;
        }
        return XDI_ANALYTICS_WEBAPP_TEMP;
    }

    public String getENABLE_ROLE_CODE() {
        return ENABLE_ROLE_CODE;
    }

    public String getStambiaPath(String path) {
        return this.getStambiaIPath().append(path).toOSString();
    }

    public String getStambiaPath() {
        return this.getStambiaIPath().toOSString();
    }

    public IPath getStambiaUserNavigatorPath(String userId) {
        return this.getStambiaUserPath(userId).append(XDI_ANALYTICS_NAVIGATOR_FOLDER_NAME);
    }

    public IPath getStambiaNavigatorPath() {
        return this.getStambiaIPath().append(XDI_ANALYTICS_NAVIGATOR_FOLDER_NAME);
    }

    public IPath getStambiaJdbcDriverPath() {
        return this.getStambiaIPath().append(XDI_ANALYTICS_JDBC_DRIVER_FOLDER_NAME);
    }

    private IPath getStambiaRepositoriesPath() {
        return this.getStambiaIPath().append(XDI_ANALYTICS_REPOSITORIES_FOLDER_NAME);
    }

    public IPath getStambiaDocumentationPath() {
        return this.getStambiaWebAppTemp().append(XDI_ANALYTICS_DOCUMENTATION_FOLDER_NAME);
    }

    public IPath getStambiaRepositoriesFilesPath() {
        return this.getStambiaRepositoriesPath().append("files");
    }

    public IPath getStambiaRepositoriesDataPath(String repositoryId) {
        return this.getStambiaRepositoriesPath().append("data").append(repositoryId);
    }

    public IPath getStambiaRepositoriesResourcesImagesPath() {
        return this.getStambiaRepositoriesPath().append("resources").append("images");
    }

    public IPath getStambiaRepositoriesProcessPath(String repositoryId, String processId) {
        return this.getStambiaRepositoriesDataPath(repositoryId).append("processes").append(processId);
    }

    public IPath getStambiaRepositoriesDeliveriesPath(String repositoryId, String processId) {
        return this.getStambiaRepositoriesProcessPath(repositoryId, processId).append("deliveries");
    }

    public IPath getStambiaRepositoriesDeliveryPath(String repositoryId, String processId, String deliveryId) {
        return this.getStambiaRepositoriesProcessPath(repositoryId, processId).append("deliveries").append(String.valueOf(deliveryId) + ".deliv");
    }

    public IPath getStambiaRepositoriesPackageDirectoryPath(String repositoryId, String processId, String packageId) {
        return this.getStambiaRepositoriesProcessPath(repositoryId, processId).append("packages").append(packageId);
    }

    public IPath getStambiaRepositoriesPackageDirectoryPath(String repositoryId) {
        return this.getStambiaRepositoriesDataPath(repositoryId).append("tmp");
    }

    public ResourceListenerManager getResourceListenerManager() {
        return this.resourceListenerManager;
    }

    public IPath getStambiaRepositoriesPackageZipPath(String repositoryId, String processId, String packageId) {
        return this.getStambiaRepositoriesPackageDirectoryPath(repositoryId, processId, packageId).append("package.zip");
    }

    public IPath getStambiaRepositoriesPackageZipPath(String packageId) {
        File repPath = this.getStambiaRepositoriesPath().append("data").toFile();
        if (repPath.exists()) {
            File[] fileArray = repPath.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File repos = fileArray[n2];
                File process = new File(repos, "processes");
                if (process.exists()) {
                    File[] fileArray2 = process.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File processes = fileArray2[n4];
                        File packages = new File(processes, "packages");
                        if (packages.exists()) {
                            File[] fileArray3 = packages.listFiles();
                            int n5 = fileArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                File pck = fileArray3[n6];
                                if (pck.getName().equals(packageId)) {
                                    return new Path(pck.getPath()).append("package.zip");
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public IPath getStambiaPackageDocumentationPath(String packageId, String processId) {
        return this.getStambiaDocumentationPath().append(packageId).append(String.valueOf(processId) + ".zip");
    }

    public IPath getStambiaUserPath(String userId) {
        if (userId != null) {
            return this.getStambiaUsersPath().append(userId);
        }
        return null;
    }

    public IPath getStambiaIPath() {
        if (XDI_ANALYTICS_RESSOURCES_FOLDER_NAME != null) {
            return this.getStambiaWebAppHome().append(XDI_ANALYTICS_RESSOURCES_FOLDER_NAME);
        }
        return this.getStambiaWebAppHome();
    }

    public IPath getStambiaUsersPath() {
        return this.getStambiaIPath().append(USERS_FOLDER_NAME);
    }

    public IPath getStambiaLogDirectoryIPath() {
        return new Path(this.getStambiaPath(XDI_ANALYTICS_LOG_DIRECTORY));
    }
}

