/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.tools;

import com.indy.engine.common.tools.Messages;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class ProcessWrapper {
    Thread threadIn;
    Thread threadError;
    private Process process;
    private Charset charset = Charset.defaultCharset();
    private int inputLimitSize;
    private int errorLimitSize;
    private StringBuffer inputStringBuffer;
    private StringBuffer errorStringBuffer;
    private OutputStream outputStream;
    private OutputStream errorOutputStream;
    private String inputReaderThreadName;
    private String errorReaderThreadName;
    private long timeout = -1L;
    private Thread timeoutThread;
    boolean isAlive = false;
    boolean isTimeout = false;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setInputReaderThreadName(String name) {
        this.inputReaderThreadName = name;
    }

    public void setErrorReaderThreadName(String name) {
        this.errorReaderThreadName = name;
    }

    protected ProcessWrapper(Process proc) {
        this.process = proc;
    }

    public static ProcessWrapper wrap(Process proc) {
        return new ProcessWrapper(proc);
    }

    public void setInputStringBuffer(StringBuffer input, int limit) {
        this.inputLimitSize = limit;
        this.inputStringBuffer = input;
    }

    public void setErrorStringBuffer(StringBuffer error, int limit) {
        this.errorStringBuffer = error;
        this.errorLimitSize = limit;
    }

    public void setInputOutputStream(OutputStream output, int limit) {
        this.inputLimitSize = limit;
        this.outputStream = output;
    }

    public void setErrorOutputStream(OutputStream output, int limit) {
        this.errorLimitSize = limit;
        this.errorOutputStream = output;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public int waitFor() throws InterruptedException {
        this.startTimeoutThread();
        this.startReaderThreads();
        return this.waitForAndEndThreads();
    }

    public void startTimeoutThread() {
        this.isAlive = true;
        if (this.timeout > -1L) {
            this.timeoutThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(ProcessWrapper.this.timeout);
                        if (ProcessWrapper.this.isAlive) {
                            ProcessWrapper.this.process.destroy();
                            ProcessWrapper.this.isTimeout = true;
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
            this.timeoutThread.setName("ProcessWrapper Timeout Thread");
            this.timeoutThread.start();
        }
    }

    public void startReaderThreads() {
        this.threadError = null;
        this.threadIn = null;
        if (this.inputStringBuffer != null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        if (this.errorStringBuffer != null) {
            this.errorOutputStream = new ByteArrayOutputStream();
        }
        this.threadIn = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(ProcessWrapper.this.process.getInputStream(), ProcessWrapper.this.charset));
                try {
                    try {
                        int data = reader.read();
                        long l = 0L;
                        while (data != -1) {
                            if ((ProcessWrapper.this.inputLimitSize == -1 || ++l <= (long)ProcessWrapper.this.inputLimitSize) && ProcessWrapper.this.outputStream != null) {
                                OutputStream outputStream = ProcessWrapper.this.outputStream;
                                synchronized (outputStream) {
                                    ProcessWrapper.this.outputStream.write(data);
                                }
                            }
                            data = reader.read();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        if (this.inputReaderThreadName != null) {
            this.threadIn.setName(this.inputReaderThreadName);
        }
        this.threadIn.start();
        this.threadError = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(ProcessWrapper.this.process.getErrorStream(), ProcessWrapper.this.charset));
                try {
                    try {
                        int data = reader.read();
                        long l = 0L;
                        while (data != -1) {
                            if ((ProcessWrapper.this.errorLimitSize == -1 || ++l <= (long)ProcessWrapper.this.errorLimitSize) && ProcessWrapper.this.errorOutputStream != null) {
                                OutputStream outputStream = ProcessWrapper.this.errorOutputStream;
                                synchronized (outputStream) {
                                    ProcessWrapper.this.errorOutputStream.write(data);
                                }
                            }
                            data = reader.read();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        if (this.errorReaderThreadName != null) {
            this.threadError.setName(this.errorReaderThreadName);
        }
        this.threadError.start();
    }

    public int waitForAndEndThreads() throws InterruptedException {
        try {
            int ret = this.process.waitFor();
            this.threadError.join();
            this.threadIn.join();
            if (this.isTimeout) {
                throw new InterruptedException(String.valueOf(Messages.getString("ProcessWrapper.0")) + this.timeout + Messages.getString("ProcessWrapper.1"));
            }
            if (this.inputStringBuffer != null) {
                this.inputStringBuffer.append(this.outputStream.toString());
            }
            if (this.errorStringBuffer != null) {
                this.errorStringBuffer.append(this.errorOutputStream.toString());
            }
            int n = ret;
            return n;
        }
        finally {
            try {
                if (this.threadError != null && this.threadError.isAlive()) {
                    this.threadError.interrupt();
                }
                if (this.threadIn != null && this.threadIn.isAlive()) {
                    this.threadIn.interrupt();
                }
                this.isAlive = false;
                if (this.inputStringBuffer != null) {
                    this.outputStream.close();
                }
                if (this.errorStringBuffer != null) {
                    this.errorOutputStream.close();
                }
                if (this.timeoutThread != null) {
                    this.timeoutThread.interrupt();
                    this.timeoutThread = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Process proc = Runtime.getRuntime().exec("cmd /c startdelivery.bat -name long", null, new File("D:\\work\\stambiaRuntime - S17\\"));
        StringBuffer in = new StringBuffer();
        StringBuffer err = new StringBuffer();
        ProcessWrapper pw = ProcessWrapper.wrap(proc);
        pw.setErrorStringBuffer(err, -1);
        pw.setInputStringBuffer(in, 100);
        pw.waitFor();
        System.out.print(in.toString());
        System.out.print(err.toString());
    }

    public void destroy() {
        this.process.destroy();
    }

    public boolean isProcessAlive() {
        return this.process != null && this.process.isAlive();
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public OutputStream getErrorOutputStream() {
        return this.errorOutputStream;
    }
}

