/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.actionCodes.convert;

import com.indy.engine.core.actionCodes.convert.AbstractParser;
import com.indy.engine.core.actionCodes.convert.Messages;
import com.indy.engine.core.api.impl.CellMapProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcReaderProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcWriterProperties;
import com.indy.runtime.api.ICellReader;
import com.indy.runtime.api.ICellWriter;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;

public class JdbcConverter
extends JdbcWriterProperties {
    public static void convertBoolean(PreparedStatement stmt, int nColumn, boolean b, boolean wasNull, int _targetColType, JdbcWriterProperties conv) throws SQLException {
        int targetColType;
        int n = targetColType = conv != null && conv.setDisableImplicitConversion ? 1111 : _targetColType;
        if (wasNull) {
            JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
        } else if (targetColType == 4 || targetColType == 5 || targetColType == -6 || targetColType == -5) {
            if (b) {
                stmt.setInt(nColumn, 1);
            } else {
                stmt.setInt(nColumn, 0);
            }
        } else if (targetColType == 2 || targetColType == 3) {
            if (b) {
                stmt.setBigDecimal(nColumn, new BigDecimal(1));
            } else {
                stmt.setBigDecimal(nColumn, new BigDecimal(0));
            }
        } else if (targetColType == -15 || targetColType == -9 || targetColType == 12 || targetColType == -16 || targetColType == -1 || targetColType == 1) {
            if (b) {
                stmt.setString(nColumn, "true");
            } else {
                stmt.setString(nColumn, "false");
            }
        } else {
            stmt.setBoolean(nColumn, b);
        }
    }

    public static void convertString(PreparedStatement stmt, int nColumn, String str, boolean wasNull, int targetColType, JdbcWriterProperties con) throws SQLException {
        JdbcConverter.convertString(stmt, nColumn, str, wasNull, targetColType, false, con);
    }

    public static void convertString(PreparedStatement stmt, int nColumn, String str, boolean wasNull, int _targetColType, boolean nString, JdbcWriterProperties conv) throws SQLException {
        int targetColType;
        int n = targetColType = conv != null && conv.setDisableImplicitConversion ? 1111 : _targetColType;
        if (str == null && conv != null && conv.useSetNullMethodOnly) {
            JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
        } else {
            switch (targetColType) {
                case 16: {
                    if (str == null) {
                        JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
                        break;
                    }
                    if (str.toLowerCase().equals("true") || str.equals("1")) {
                        stmt.setBoolean(nColumn, true);
                        break;
                    }
                    if (str.toLowerCase().equals("false") || str.equals("0")) {
                        stmt.setBoolean(nColumn, false);
                        break;
                    }
                    throw new SQLException(String.valueOf(Messages.getString("JdbcConverter.0")) + str + Messages.getString("JdbcConverter.1") + str + Messages.getString("JdbcConverter.2"));
                }
                case -6: 
                case 4: 
                case 5: {
                    if (str == null) {
                        JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
                        break;
                    }
                    if (str.equalsIgnoreCase("true")) {
                        stmt.setInt(nColumn, 1);
                        break;
                    }
                    if (str.equalsIgnoreCase("false")) {
                        stmt.setInt(nColumn, 0);
                        break;
                    }
                    stmt.setInt(nColumn, Integer.valueOf(str));
                    break;
                }
                case 2: 
                case 3: {
                    if (str == null) {
                        stmt.setBigDecimal(nColumn, null);
                        break;
                    }
                    stmt.setBigDecimal(nColumn, BigDecimal.valueOf(Double.valueOf(str)));
                    break;
                }
                default: {
                    if (nString && (conv == null || !conv.setNVarcharAsVarchar)) {
                        try {
                            stmt.setNString(nColumn, str);
                        }
                        catch (AbstractMethodError e) {
                            stmt.setString(nColumn, str);
                        }
                        break;
                    }
                    stmt.setString(nColumn, str);
                }
            }
        }
    }

    public static void setNull(PreparedStatement stmt, int index, int targetColType, JdbcWriterProperties con) throws SQLException {
        try {
            stmt.setNull(index, targetColType);
        }
        catch (SQLException e) {
            if (con == null || !con.useSetNullMethodOnly) {
                stmt.setObject(index, null);
            }
            throw e;
        }
    }

    public static void convertInteger(PreparedStatement stmt, int nColumn, int i, boolean wasNull, int _targetColType, JdbcWriterProperties conv) throws SQLException {
        int targetColType;
        int n = targetColType = conv != null && conv.setDisableImplicitConversion ? 1111 : _targetColType;
        if (wasNull) {
            JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
            return;
        }
        switch (targetColType) {
            case -7: 
            case 16: {
                if (i == 0) {
                    stmt.setBoolean(nColumn, false);
                } else if (i == 1) {
                    stmt.setBoolean(nColumn, true);
                }
                return;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, String.valueOf(i));
                return;
            }
        }
        stmt.setInt(nColumn, i);
    }

    public static void convertShort(PreparedStatement stmt, int nColumn, short i, boolean wasNull, int _targetColType, JdbcWriterProperties conv) throws SQLException {
        int targetColType;
        int n = targetColType = conv != null && conv.setDisableImplicitConversion ? 1111 : _targetColType;
        if (wasNull) {
            JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
            return;
        }
        switch (targetColType) {
            case -7: 
            case 16: {
                if (i == 0) {
                    stmt.setBoolean(nColumn, false);
                } else if (i == 1) {
                    stmt.setBoolean(nColumn, true);
                }
                return;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, String.valueOf(i));
                return;
            }
        }
        stmt.setShort(nColumn, i);
    }

    public static void convertLong(PreparedStatement stmt, int nColumn, long i, boolean wasNull, int _targetColType, JdbcWriterProperties conv) throws SQLException {
        int targetColType;
        int n = targetColType = conv != null && conv.setDisableImplicitConversion ? 1111 : _targetColType;
        if (wasNull) {
            JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
            return;
        }
        switch (targetColType) {
            case -7: 
            case 16: {
                if (i == 0L) {
                    stmt.setBoolean(nColumn, false);
                } else if (i == 1L) {
                    stmt.setBoolean(nColumn, true);
                }
                return;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, String.valueOf(i));
                return;
            }
        }
        stmt.setLong(nColumn, i);
    }

    public static void convertDouble(PreparedStatement stmt, int nColumn, double i, boolean wasNull, int _targetColType, JdbcWriterProperties conv) throws SQLException {
        int targetColType;
        int n = targetColType = conv != null && conv.setDisableImplicitConversion ? 1111 : _targetColType;
        if (wasNull) {
            JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
            return;
        }
        switch (targetColType) {
            case -7: 
            case 16: {
                if (i == 0.0) {
                    stmt.setBoolean(nColumn, false);
                } else if (i == 1.0) {
                    stmt.setBoolean(nColumn, true);
                }
                return;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, String.valueOf(i));
                return;
            }
            case 6: {
                stmt.setFloat(nColumn, Double.valueOf(i).floatValue());
                break;
            }
            default: {
                stmt.setDouble(nColumn, i);
            }
        }
    }

    public static void convertFloat(PreparedStatement stmt, int nColumn, float i, boolean wasNull, int _targetColType, JdbcWriterProperties conv) throws SQLException {
        int targetColType;
        int n = targetColType = conv != null && conv.setDisableImplicitConversion ? 1111 : _targetColType;
        if (wasNull) {
            JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
            return;
        }
        switch (targetColType) {
            case -7: 
            case 16: {
                if (i == 0.0f) {
                    stmt.setBoolean(nColumn, false);
                } else if (i == 1.0f) {
                    stmt.setBoolean(nColumn, true);
                }
                return;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, String.valueOf(i));
                return;
            }
        }
        stmt.setFloat(nColumn, i);
    }

    public static void convertNumber(PreparedStatement stmt, int nColumn, Number i, boolean wasNull, int _targetColType, JdbcWriterProperties converter) throws SQLException {
        int targetColType = converter != null && converter.setDisableImplicitConversion ? 1111 : _targetColType;
        switch (targetColType) {
            case -7: 
            case 16: {
                if (i == null) {
                    JdbcConverter.setNull(stmt, nColumn, _targetColType, converter);
                    break;
                }
                if (i.byteValue() == 0) {
                    stmt.setBoolean(nColumn, false);
                    break;
                }
                if (i.byteValue() != 1) break;
                stmt.setBoolean(nColumn, true);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                if (i == null) {
                    if (converter != null && converter.useSetNullMethodOnly) {
                        JdbcConverter.setNull(stmt, nColumn, _targetColType, converter);
                        break;
                    }
                    stmt.setString(nColumn, null);
                    break;
                }
                stmt.setString(nColumn, String.valueOf(i));
                break;
            }
            default: {
                if (i == null) {
                    JdbcConverter.setNull(stmt, nColumn, _targetColType, converter);
                    break;
                }
                if (i instanceof BigInteger) {
                    stmt.setLong(nColumn, i.longValue());
                    break;
                }
                stmt.setBigDecimal(nColumn, (BigDecimal)i);
            }
        }
    }

    public static void convertTimeStamp(PreparedStatement stmt, int nColumn, Timestamp ts, boolean wasNull, int _targetColType, JdbcWriterProperties converter) throws SQLException {
        int targetColType;
        int n = targetColType = converter != null && converter.setDisableImplicitConversion ? 1111 : _targetColType;
        if (ts == null && converter != null && converter.useSetNullMethodOnly) {
            JdbcConverter.setNull(stmt, nColumn, _targetColType, converter);
        } else if (targetColType == 91) {
            if (ts == null) {
                stmt.setDate(nColumn, null);
            } else {
                stmt.setDate(nColumn, new Date(ts.getTime()));
            }
        } else {
            stmt.setTimestamp(nColumn, ts);
        }
    }

    public static void convertDate(PreparedStatement stmt, int nColumn, Date dt, boolean wasNull, int _targetColType, JdbcWriterProperties conv) throws SQLException {
        int targetColType;
        int n = targetColType = conv != null && conv.setDisableImplicitConversion ? 1111 : _targetColType;
        if (targetColType == 93 || conv != null && conv.setDateAsTimestamp) {
            if (dt == null) {
                if (conv != null && conv.useSetNullMethodOnly) {
                    JdbcConverter.setNull(stmt, nColumn, _targetColType, conv);
                } else {
                    stmt.setTimestamp(nColumn, null);
                }
            } else {
                stmt.setTimestamp(nColumn, new Timestamp(dt.getTime()));
            }
        } else {
            stmt.setDate(nColumn, dt);
        }
    }

    public static void setJavaObjectToJdbc(PreparedStatement ps, ParameterMetaData metadata, int index, Object value, AbstractParser parser, JdbcWriterProperties conv) throws SQLException, EngineExceptionI {
        int targetColType = 1111;
        if (metadata != null) {
            try {
                targetColType = metadata.getParameterType(index);
            }
            catch (Exception e) {
                targetColType = 1111;
            }
        }
        JdbcConverter.setJavaObjectToJdbc(ps, targetColType, index, value, parser, conv);
    }

    public static void setJavaObjectToJdbc(PreparedStatement ps, int targetColType, int index, Object value, JdbcWriterProperties conv) throws SQLException, EngineExceptionI {
        if (value == null) {
            if (conv != null && conv.useSetNullMethodOnly) {
                JdbcConverter.setNull(ps, index, targetColType, conv);
            } else {
                ps.setObject(index, null);
            }
        } else if (value instanceof String) {
            JdbcConverter.convertString(ps, index, (String)value, false, targetColType, conv);
        } else if (value instanceof Timestamp) {
            JdbcConverter.convertTimeStamp(ps, index, (Timestamp)value, false, targetColType, conv);
        } else if (value instanceof Time) {
            JdbcConverter.convertTime(ps, index, (Time)value, false, targetColType, conv);
        } else if (value instanceof Date) {
            JdbcConverter.convertDate(ps, index, (Date)value, false, targetColType, conv);
        } else if (value instanceof Boolean) {
            JdbcConverter.convertBoolean(ps, index, (Boolean)value, false, targetColType, conv);
        } else if (value instanceof Double) {
            JdbcConverter.convertDouble(ps, index, (Double)value, false, targetColType, conv);
        } else if (value instanceof Integer) {
            JdbcConverter.convertInteger(ps, index, (Integer)value, false, targetColType, conv);
        } else if (value instanceof BigInteger) {
            JdbcConverter.convertNumber(ps, index, (BigInteger)value, false, targetColType, conv);
        } else if (value instanceof BigDecimal) {
            JdbcConverter.convertNumber(ps, index, (BigDecimal)value, false, targetColType, conv);
        } else {
            JdbcConverter.convertObject(ps, index, value, false, targetColType, conv);
        }
    }

    public static void setJavaObjectToJdbc(PreparedStatement ps, ParameterMetaData metadata, int index, Object value, JdbcWriterProperties conv) throws SQLException, EngineExceptionI {
        int targetColType = 1111;
        if (metadata != null) {
            try {
                targetColType = metadata.getParameterType(index);
            }
            catch (Exception e) {
                targetColType = 1111;
            }
        }
        JdbcConverter.setJavaObjectToJdbc(ps, targetColType, index, value, conv);
    }

    public static void convertTime(PreparedStatement stmt, int nColumn, Time time, boolean b, Integer targetColType, JdbcWriterProperties conv) throws SQLException {
        if (time == null) {
            if (conv != null && conv.useSetNullMethodOnly) {
                JdbcConverter.setNull(stmt, nColumn, targetColType, conv);
            } else {
                stmt.setTime(nColumn, null);
            }
        } else {
            stmt.setTime(nColumn, time);
        }
    }

    public static void convertClob(PreparedStatement stmt, int nColumn, Clob clob, boolean b, Integer targetColType, boolean nclob, JdbcWriterProperties conv) throws SQLException {
        if (clob == null) {
            if (conv != null && conv.useSetNullMethodOnly) {
                JdbcConverter.setNull(stmt, nColumn, targetColType, conv);
            } else if (nclob) {
                stmt.setNClob(nColumn, (NClob)null);
            } else {
                try {
                    stmt.setClob(nColumn, (Clob)null);
                }
                catch (SQLException e) {
                    try {
                        stmt.setNull(nColumn, 2005);
                    }
                    catch (SQLException e2) {
                        throw e;
                    }
                }
            }
        } else if (nclob) {
            try {
                stmt.setNCharacterStream(nColumn, clob.getCharacterStream());
            }
            catch (SQLFeatureNotSupportedException e) {
                try {
                    String tmp = ((NClob)clob).getSubString(1L, (int)clob.length());
                    stmt.setNString(nColumn, tmp);
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    throw e;
                }
            }
        } else {
            try {
                stmt.setCharacterStream(nColumn, clob.getCharacterStream());
            }
            catch (SQLFeatureNotSupportedException e) {
                try {
                    String tmp = clob.getSubString(1L, (int)clob.length());
                    stmt.setString(nColumn, tmp);
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    throw e;
                }
            }
        }
    }

    public static void convertBlob(PreparedStatement stmt, int nColumn, Blob blob, boolean b, Integer targetColType, JdbcWriterProperties conv) throws SQLException {
        if (blob == null) {
            if (conv != null && conv.useSetNullMethodOnly) {
                JdbcConverter.setNull(stmt, nColumn, targetColType, conv);
            } else {
                stmt.setBlob(nColumn, (Blob)null);
            }
        } else {
            try {
                stmt.setBinaryStream(nColumn, blob.getBinaryStream());
            }
            catch (ClassCastException cce) {
                stmt.setBytes(nColumn, blob.getBytes(1L, (int)blob.length()));
            }
        }
    }

    public static void convertBytes(PreparedStatement stmt, int nColumn, byte[] bytes, boolean b, Integer targetColType, JdbcWriterProperties conv) throws SQLException {
        if (bytes == null) {
            if (conv != null && conv.useSetNullMethodOnly) {
                JdbcConverter.setNull(stmt, nColumn, targetColType, conv);
            } else {
                stmt.setBytes(nColumn, null);
            }
        } else {
            stmt.setBytes(nColumn, bytes);
        }
    }

    public static void convertObject(PreparedStatement stmt, int nColumn, Object object, boolean b, Integer targetColType, JdbcWriterProperties conv) throws SQLException {
        if (object == null) {
            if (conv != null && conv.useSetNullMethodOnly) {
                JdbcConverter.setNull(stmt, nColumn, targetColType, conv);
            } else {
                stmt.setObject(nColumn, null);
            }
        } else {
            stmt.setObject(nColumn, object);
        }
    }

    public static void convertByte(PreparedStatement ps, int index, Byte value, boolean wasNull, int targetColType, JdbcWriterProperties conv) throws SQLException {
        if (wasNull) {
            JdbcConverter.setNull(ps, index, targetColType, conv);
        } else {
            ps.setByte(index, value);
        }
    }

    public static void setJavaObjectToJdbc(PreparedStatement ps, int targetColType, int index, Object value, AbstractParser parser, JdbcWriterProperties conv) throws SQLException {
        if (value == null) {
            if (conv != null && conv.useSetNullMethodOnly) {
                JdbcConverter.setNull(ps, index, targetColType, conv);
            } else {
                ps.setObject(index, null);
            }
        } else {
            parser.setJdbcStatement(ps, index, value, value == null, targetColType, conv);
        }
    }

    public static ICellReader<ResultSet> getResultSetCellReader(CellMapProperties mapProperties, JdbcReaderProperties sourceProperties) throws Exception {
        return (ICellReader)JdbcConverter.getReadWrite(true, mapProperties, sourceProperties, null);
    }

    public static ICellWriter<PreparedStatement> getPreparedStatementCellWriter(CellMapProperties mapProperties, JdbcWriterProperties targetProperties) throws Exception {
        return (ICellWriter)JdbcConverter.getReadWrite(false, mapProperties, null, targetProperties);
    }

    private static Object getReadWrite(boolean reader, final CellMapProperties mapProperties, final JdbcReaderProperties sourceProperties, final JdbcWriterProperties targetProperties) throws Exception {
        try {
            switch (mapProperties.sourceType) {
                case -7: 
                case 16: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                boolean b = resultSet.getBoolean(mapProperties.sourceIndex);
                                try {
                                    if (resultSet.wasNull()) {
                                        return null;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return b;
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertBoolean(statement, mapProperties.targetIndex, value == null ? false : (Boolean)value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case -15: 
                case -9: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                try {
                                    return resultSet.getNString(mapProperties.sourceIndex);
                                }
                                catch (AbstractMethodError e) {
                                    return resultSet.getString(mapProperties.sourceIndex);
                                }
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertString(statement, mapProperties.targetIndex, (String)value, false, mapProperties.targetType, true, targetProperties);
                        }
                    };
                }
                case -16: 
                case -1: 
                case 1: 
                case 12: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getString(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertString(statement, mapProperties.targetIndex, (String)value, false, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 91: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                if (!sourceProperties.getDateAsTimestamp) {
                                    return resultSet.getDate(mapProperties.sourceIndex);
                                }
                                return resultSet.getTimestamp(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            if (sourceProperties != null) {
                                if (sourceProperties.getDateAsTimestamp) {
                                    JdbcConverter.convertTimeStamp(statement, mapProperties.targetIndex, (Timestamp)value, false, mapProperties.targetType, targetProperties);
                                } else {
                                    JdbcConverter.convertDate(statement, mapProperties.targetIndex, (Date)value, false, mapProperties.targetType, targetProperties);
                                }
                            } else if (value instanceof Timestamp) {
                                JdbcConverter.convertTimeStamp(statement, mapProperties.targetIndex, (Timestamp)value, false, mapProperties.targetType, targetProperties);
                            } else {
                                JdbcConverter.convertDate(statement, mapProperties.targetIndex, (Date)value, false, mapProperties.targetType, targetProperties);
                            }
                        }
                    };
                }
                case 92: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getTime(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertTime(statement, mapProperties.targetIndex, (Time)value, false, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 93: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getTimestamp(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertTimeStamp(statement, mapProperties.targetIndex, (Timestamp)value, false, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 2: 
                case 3: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getBigDecimal(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertNumber(statement, mapProperties.targetIndex, (Number)value, false, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 8: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                double d = resultSet.getDouble(mapProperties.sourceIndex);
                                try {
                                    if (resultSet.wasNull()) {
                                        return null;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return d;
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertDouble(statement, mapProperties.targetIndex, value == null ? 0.0 : (Double)value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 6: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                float f = resultSet.getFloat(mapProperties.sourceIndex);
                                try {
                                    if (resultSet.wasNull()) {
                                        return null;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return Float.valueOf(f);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertFloat(statement, mapProperties.targetIndex, value == null ? 0.0f : ((Float)value).floatValue(), value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 7: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                float f = resultSet.getFloat(mapProperties.sourceIndex);
                                try {
                                    if (resultSet.wasNull()) {
                                        return null;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return Float.valueOf(f);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertFloat(statement, mapProperties.targetIndex, value == null ? 0.0f : ((Float)value).floatValue(), value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 4: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                int i = resultSet.getInt(mapProperties.sourceIndex);
                                try {
                                    if (resultSet.wasNull()) {
                                        return null;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return i;
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertInteger(statement, mapProperties.targetIndex, value == null ? 0 : (Integer)value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case -5: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                long l = resultSet.getLong(mapProperties.sourceIndex);
                                try {
                                    if (resultSet.wasNull()) {
                                        return null;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return l;
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertLong(statement, mapProperties.targetIndex, value == null ? 0L : (Long)value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case -6: 
                case 5: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                short s = resultSet.getShort(mapProperties.sourceIndex);
                                try {
                                    if (resultSet.wasNull()) {
                                        return null;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return s;
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertShort(statement, mapProperties.targetIndex, value == null ? (short)0 : (Short)value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 2011: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getNClob(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertClob(statement, mapProperties.targetIndex, (NClob)value, false, mapProperties.targetType, true, targetProperties);
                        }
                    };
                }
                case 2005: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getClob(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertClob(statement, mapProperties.targetIndex, (Clob)value, false, mapProperties.targetType, false, targetProperties);
                        }
                    };
                }
                case 2004: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                switch (mapProperties.targetType) {
                                    case -4: 
                                    case -3: 
                                    case -2: {
                                        return resultSet.getBytes(mapProperties.sourceIndex);
                                    }
                                }
                                return resultSet.getBlob(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            switch (mapProperties.targetType) {
                                case -4: 
                                case -3: 
                                case -2: {
                                    JdbcConverter.convertBytes(statement, mapProperties.targetIndex, (byte[])value, false, mapProperties.targetType, targetProperties);
                                    break;
                                }
                                default: {
                                    JdbcConverter.convertBlob(statement, mapProperties.targetIndex, (Blob)value, false, mapProperties.targetType, targetProperties);
                                }
                            }
                        }
                    };
                }
                case 2006: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getRef(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            statement.setRef(mapProperties.targetIndex, (Ref)value);
                        }
                    };
                }
                case 2003: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getArray(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            statement.setArray(mapProperties.targetIndex, (Array)value);
                        }
                    };
                }
                case -4: 
                case -3: 
                case -2: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getBytes(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertBytes(statement, mapProperties.targetIndex, (byte[])value, false, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 1111: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getObject(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertObject(statement, mapProperties.targetIndex, value, false, mapProperties.targetType, targetProperties);
                        }
                    };
                }
            }
            if (reader) {
                return new ICellReader<ResultSet>(){

                    @Override
                    public Object read(ResultSet resultSet) throws SQLException {
                        Object o = resultSet.getObject(mapProperties.sourceIndex);
                        if (o != null && (o.getClass().getName().equals("oracle.sql.TIMESTAMPTZ") || o.getClass().getName().equals("oracle.sql.TIMESTAMPLTZ"))) {
                            return resultSet.getTimestamp(mapProperties.sourceIndex);
                        }
                        return o;
                    }
                };
            }
            return new ICellWriter<PreparedStatement>(){

                @Override
                public void write(PreparedStatement statement, Object value) throws SQLException {
                    boolean isTimeStamp;
                    boolean bl = isTimeStamp = value != null && (value.getClass().getName().equals("oracle.sql.TIMESTAMPTZ") || value.getClass().getName().equals("oracle.sql.TIMESTAMPLTZ") || value.getClass().getName().equals("java.sql.Timestamp"));
                    if (isTimeStamp) {
                        JdbcConverter.convertTimeStamp(statement, mapProperties.targetIndex, (Timestamp)value, false, mapProperties.targetType, targetProperties);
                    } else {
                        JdbcConverter.convertObject(statement, mapProperties.targetIndex, value, false, mapProperties.targetType, targetProperties);
                    }
                }
            };
        }
        catch (Throwable e) {
            throw new Exception(String.valueOf(Messages.getString("JdbcConverter.3")) + mapProperties.sourceIndex, e);
        }
    }

    @Deprecated
    private static int addStatementValue(int nColumn, ResultSet rSet, int rSetCol, PreparedStatement stmt, int srcType, int targetColType, boolean getDateAsTimestamp, JdbcWriterProperties conv) throws EngineExceptionI {
        int ret = 0;
        try {
            switch (srcType) {
                case -7: 
                case 16: {
                    boolean b = rSet.getBoolean(rSetCol);
                    boolean wasNull = false;
                    try {
                        wasNull = rSet.wasNull();
                    }
                    catch (Exception e) {
                        wasNull = false;
                    }
                    JdbcConverter.convertBoolean(stmt, nColumn, b, wasNull, targetColType, conv);
                    break;
                }
                case -15: 
                case -9: {
                    String nstr = null;
                    try {
                        nstr = rSet.getNString(rSetCol);
                    }
                    catch (AbstractMethodError e) {
                        nstr = rSet.getString(rSetCol);
                    }
                    JdbcConverter.convertString(stmt, nColumn, nstr, false, targetColType, true, conv);
                    break;
                }
                case -16: 
                case -1: 
                case 1: 
                case 12: {
                    JdbcConverter.convertString(stmt, nColumn, rSet.getString(rSetCol), false, targetColType, conv);
                    break;
                }
                case 91: {
                    if (!getDateAsTimestamp) {
                        Date dt = rSet.getDate(rSetCol);
                        JdbcConverter.convertDate(stmt, nColumn, dt, false, targetColType, conv);
                        break;
                    }
                    Timestamp ts = rSet.getTimestamp(rSetCol);
                    JdbcConverter.convertTimeStamp(stmt, nColumn, ts, false, targetColType, conv);
                    break;
                }
                case 92: {
                    JdbcConverter.convertTime(stmt, nColumn, rSet.getTime(rSetCol), false, targetColType, conv);
                    break;
                }
                case 93: {
                    JdbcConverter.convertTimeStamp(stmt, nColumn, rSet.getTimestamp(rSetCol), false, targetColType, conv);
                    break;
                }
                case 2: 
                case 3: {
                    JdbcConverter.convertNumber(stmt, nColumn, rSet.getBigDecimal(rSetCol), false, targetColType, conv);
                    break;
                }
                case 6: 
                case 8: {
                    double d = rSet.getDouble(rSetCol);
                    boolean wasNull = false;
                    try {
                        wasNull = rSet.wasNull();
                    }
                    catch (Exception e) {
                        wasNull = false;
                    }
                    JdbcConverter.convertDouble(stmt, nColumn, d, wasNull, targetColType, conv);
                    break;
                }
                case 7: {
                    float f = rSet.getFloat(rSetCol);
                    boolean wasNull = false;
                    try {
                        wasNull = rSet.wasNull();
                    }
                    catch (Exception e) {
                        wasNull = false;
                    }
                    JdbcConverter.convertFloat(stmt, nColumn, f, wasNull, targetColType, conv);
                    break;
                }
                case 4: {
                    int i = rSet.getInt(rSetCol);
                    boolean wasNull = false;
                    try {
                        wasNull = rSet.wasNull();
                    }
                    catch (Exception e) {
                        wasNull = false;
                    }
                    JdbcConverter.convertInteger(stmt, nColumn, i, wasNull, targetColType, conv);
                    break;
                }
                case -5: {
                    long l = rSet.getLong(rSetCol);
                    boolean wasNull = false;
                    try {
                        wasNull = rSet.wasNull();
                    }
                    catch (Exception e) {
                        wasNull = false;
                    }
                    JdbcConverter.convertLong(stmt, nColumn, l, wasNull, targetColType, conv);
                    break;
                }
                case -6: 
                case 5: {
                    short s = rSet.getShort(rSetCol);
                    boolean wasNull = false;
                    try {
                        wasNull = rSet.wasNull();
                    }
                    catch (Exception e) {
                        wasNull = false;
                    }
                    JdbcConverter.convertShort(stmt, nColumn, s, wasNull, targetColType, conv);
                    break;
                }
                case 2011: {
                    JdbcConverter.convertClob(stmt, nColumn, rSet.getNClob(rSetCol), false, targetColType, true, conv);
                    break;
                }
                case 2005: {
                    JdbcConverter.convertClob(stmt, nColumn, rSet.getClob(rSetCol), false, targetColType, false, conv);
                    break;
                }
                case 2004: {
                    if (targetColType == -4 || targetColType == -2 || targetColType == -3) {
                        JdbcConverter.convertBytes(stmt, nColumn, rSet.getBytes(rSetCol), false, targetColType, conv);
                        break;
                    }
                    JdbcConverter.convertBlob(stmt, nColumn, rSet.getBlob(rSetCol), false, targetColType, conv);
                    break;
                }
                case 2006: {
                    stmt.setRef(nColumn, rSet.getRef(rSetCol));
                    break;
                }
                case 2003: {
                    stmt.setArray(nColumn, rSet.getArray(rSetCol));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    JdbcConverter.convertBytes(stmt, nColumn, rSet.getBytes(rSetCol), false, targetColType, conv);
                    break;
                }
                case 1111: {
                    JdbcConverter.convertObject(stmt, nColumn, rSet.getObject(rSetCol), false, targetColType, conv);
                    break;
                }
                default: {
                    Object o = rSet.getObject(rSetCol);
                    if (o != null && o.getClass().getName().equals("oracle.sql.TIMESTAMPTZ")) {
                        JdbcConverter.convertTimeStamp(stmt, nColumn, rSet.getTimestamp(rSetCol), false, targetColType, conv);
                        break;
                    }
                    JdbcConverter.convertObject(stmt, nColumn, o, false, targetColType, conv);
                    break;
                }
            }
        }
        catch (Throwable e) {
            throw new EngineExceptionI(String.valueOf(Messages.getString("JdbcConverter.4")) + rSetCol + Messages.getString("JdbcConverter.5") + nColumn, e);
        }
        return ret;
    }
}

