/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.api.impl;

import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.api.impl.CellMapProperties;
import com.indy.engine.core.api.impl.Messages;
import com.indy.engine.core.api.impl.jdbc.JdbcWriterProperties;
import com.indy.runtime.api.IBindWriter;
import com.indy.runtime.api.ICellWriter;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JdbcBindWriter
implements IBindWriter {
    public static final String JDBC_PREPARED_STATEMENT = "PreparedStatement";
    public static final String JDBC_BATCH_SIZE = "batchSize";
    public static final String JDBC_SOURCE_DATATYPES = "sourceDatatypes";
    public static final String JDBC_DATE_AS_TIMESTAMPS = "setDateAsTimestamp";
    public static final String JDBC_USE_SET_NULL = "useSetNullMethodOnly";
    public static final String JDBC_NVARCHAR_AS_VARCHAR = "setNVarcharAsVarchar";
    private static final Object JDBC_DISABLE_IMPLICIT_CONVERSION = "disableImplicitConversion";
    private PreparedStatement statement;
    private int batchSize = 1;
    private int total = 0;
    private int current = 0;
    private boolean setDateHasTimestamp = false;
    private boolean linePrepared = false;
    private boolean prepare = false;
    private int[] sourceDatatypes = null;
    private int[] targetDatatypes = null;
    private Boolean useSetNullMethodOnly;
    private boolean setNVarcharAsVarchar = false;
    private boolean setDisableImplicitConversion = false;
    private ICellWriter<PreparedStatement>[] cells;

    @Override
    public void setParameter(String key, Object value) {
        if (JDBC_PREPARED_STATEMENT.equals(key)) {
            this.statement = (PreparedStatement)value;
        }
        if (JDBC_BATCH_SIZE.equals(key)) {
            this.batchSize = (Integer)value;
        }
        if (JDBC_SOURCE_DATATYPES.equals(key)) {
            this.sourceDatatypes = (int[])value;
        }
        if (JDBC_DATE_AS_TIMESTAMPS.equals(key)) {
            this.setDateHasTimestamp = (Boolean)value;
        }
        if (JDBC_USE_SET_NULL.equals(key)) {
            this.useSetNullMethodOnly = (Boolean)value;
        }
        if (JDBC_NVARCHAR_AS_VARCHAR.equals(key)) {
            this.setNVarcharAsVarchar = (Boolean)value;
        }
        if (JDBC_DISABLE_IMPLICIT_CONVERSION.equals(key)) {
            this.setDisableImplicitConversion = (Boolean)value;
        }
    }

    @Override
    public void prepare() throws Exception {
        if (this.statement == null) {
            throw new Exception(String.valueOf(Messages.getString("JdbcBindWriter.0")) + JDBC_PREPARED_STATEMENT + Messages.getString("JdbcBindWriter.1"));
        }
        if (this.sourceDatatypes == null) {
            throw new Exception(String.valueOf(Messages.getString("JdbcBindWriter.2")) + JDBC_SOURCE_DATATYPES + Messages.getString("JdbcBindWriter.3"));
        }
        ParameterMetaData pmd = this.statement.getParameterMetaData();
        this.targetDatatypes = new int[pmd.getParameterCount()];
        int i = 0;
        while (i < pmd.getParameterCount()) {
            try {
                this.targetDatatypes[this.targetDatatypes.length - 1] = pmd.getParameterType(i + 1);
            }
            catch (Exception e) {
                this.targetDatatypes[this.targetDatatypes.length - 1] = 1111;
            }
            ++i;
        }
        if (this.targetDatatypes.length != this.sourceDatatypes.length) {
            throw new Exception(String.valueOf(Messages.getString("JdbcBindWriter.4")) + this.sourceDatatypes.length + Messages.getString("JdbcBindWriter.5") + this.targetDatatypes.length + Messages.getString("JdbcBindWriter.6"));
        }
        JdbcWriterProperties jwp = new JdbcWriterProperties();
        jwp.setDateAsTimestamp = this.setDateHasTimestamp;
        jwp.useSetNullMethodOnly = this.useSetNullMethodOnly;
        jwp.setNVarcharAsVarchar = this.setNVarcharAsVarchar;
        jwp.setDisableImplicitConversion = this.setDisableImplicitConversion;
        this.cells = new ICellWriter[this.targetDatatypes.length];
        int i2 = 0;
        while (i2 < this.targetDatatypes.length) {
            CellMapProperties cmp = new CellMapProperties();
            cmp.sourceIndex = i2 + 1;
            cmp.sourceType = this.sourceDatatypes[i2];
            cmp.targetIndex = i2 + 1;
            cmp.targetType = this.targetDatatypes[i2];
            this.cells[i2] = JdbcConverter.getPreparedStatementCellWriter(cmp, jwp);
            ++i2;
        }
        this.prepare = true;
    }

    @Override
    public boolean writeNext() throws SQLException {
        if (!this.prepare) {
            throw new SQLException(Messages.getString("JdbcBindWriter.7"));
        }
        if (!this.linePrepared) {
            this.linePrepared = true;
            ++this.current;
        } else {
            this.statement.addBatch();
            this.batch(false);
            ++this.current;
        }
        return true;
    }

    private void batch(boolean force) throws SQLException {
        if (!force && this.current < this.batchSize) {
            return;
        }
        this.statement.executeBatch();
        this.total += this.current;
        this.current = 0;
    }

    @Override
    public void close() throws Exception {
        this.batch(true);
        this.statement = null;
    }

    @Override
    public void setValue(int index, Object value) throws Exception {
        if (!this.linePrepared) {
            throw new SQLException(Messages.getString("JdbcBindWriter.8"));
        }
        this.cells[index].write(this.statement, value);
    }

    @Override
    public int[] getDataType() throws Exception {
        return this.targetDatatypes;
    }

    @Override
    public int getDataType(int index) throws Exception {
        return this.targetDatatypes[index];
    }
}

