/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.common.objects;

import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.Serializable;

public class VariableI
implements Serializable {
    private static final long serialVersionUID = 479351951136415679L;
    private String name = null;
    private String value = null;
    private String type = null;
    private boolean realTimeReport = false;
    private String source = null;
    private Object cumulativeValue = null;

    public VariableI() {
        this.realTimeReport = false;
    }

    public VariableI(String pName, String pValue, String pSource, String pType, boolean pIndyType) {
        this.name = pName;
        this.value = pValue;
        this.type = pType;
        this.source = pSource;
        this.realTimeReport = pIndyType;
    }

    public VariableI(String pName, String pValue, String pType, boolean pIndyType) {
        this.name = pName;
        this.source = this.value = pValue;
        this.type = pType;
        this.realTimeReport = pIndyType;
    }

    public VariableI(String pName, String pValue, String pType, boolean pIndyType, boolean isCumulative) {
        this.name = pName;
        this.source = this.value = pValue;
        this.type = pType;
        this.realTimeReport = pIndyType;
        if (isCumulative) {
            if (this.type.equals("Integer")) {
                this.cumulativeValue = Integer.valueOf(pValue);
            } else if (this.type.equals("Long")) {
                this.cumulativeValue = Long.valueOf(pValue);
            } else if (this.type.equals("Float")) {
                this.cumulativeValue = Double.valueOf(pValue);
            }
        }
    }

    public VariableI(String pName, String pValue, String pType) {
        this.name = pName;
        this.source = this.value = pValue;
        this.type = pType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public Object getTypedValue() {
        try {
            if (this.getType().equals("Integer")) {
                return Integer.valueOf(this.value);
            }
            if (this.getType().equals("Long")) {
                return Long.valueOf(this.value);
            }
            if (this.getType().equals("Float")) {
                return Double.valueOf(this.value);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void cumulValue() {
        if (this.value != null) {
            try {
                if (this.cumulativeValue == null) {
                    if (this.type.equals("Integer")) {
                        this.cumulativeValue = Integer.valueOf(this.value);
                    } else if (this.type.equals("Long")) {
                        this.cumulativeValue = Long.valueOf(this.value);
                    } else if (this.type.equals("Float")) {
                        this.cumulativeValue = Double.valueOf(this.value);
                    }
                } else if (this.type.equals("Integer")) {
                    this.cumulativeValue = (Integer)this.cumulativeValue + Integer.valueOf(this.value);
                } else if (this.type.equals("Long")) {
                    this.cumulativeValue = (Long)this.cumulativeValue + Long.valueOf(this.value);
                } else if (this.type.equals("Float")) {
                    this.cumulativeValue = (Double)this.cumulativeValue + Double.valueOf(this.value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setValue(String pValue, boolean cumulative) {
        if (cumulative) {
            try {
                if (this.cumulativeValue == null) {
                    if (this.type.equals("Integer")) {
                        this.cumulativeValue = Integer.valueOf(pValue);
                    } else if (this.type.equals("Long")) {
                        this.cumulativeValue = Long.valueOf(pValue);
                    } else if (this.type.equals("Float")) {
                        this.cumulativeValue = Double.valueOf(pValue);
                    }
                } else if (this.type.equals("Integer")) {
                    this.cumulativeValue = (Integer)this.cumulativeValue + Integer.valueOf(pValue);
                } else if (this.type.equals("Long")) {
                    this.cumulativeValue = (Long)this.cumulativeValue + Long.valueOf(pValue);
                } else if (this.type.equals("Float")) {
                    this.cumulativeValue = (Double)this.cumulativeValue + Double.valueOf(pValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.source = pValue;
        this.value = pValue;
    }

    public void setValue(String pValue) {
        this.source = pValue;
        this.value = pValue;
    }

    public void setValueOnly(String pValue) {
        this.value = pValue;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRealTimeReport() {
        return this.realTimeReport;
    }

    public void setRealTimeReport(boolean realTimeReport) {
        this.realTimeReport = realTimeReport;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Object getCumulativeValue() {
        return this.cumulativeValue;
    }

    public void setCumulativeValue(Object cumulativeValue) {
        this.cumulativeValue = cumulativeValue;
    }

    public void clear() throws EngineExceptionI {
        try {
            this.name = null;
            this.value = null;
            this.type = null;
            this.source = null;
            this.cumulativeValue = null;
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
    }

    public String toString() {
        String ret = null;
        ret = "Variable : \tName:" + this.name + "\n" + "\tValue:" + this.value + "\n" + "\tType:" + this.type + "\n";
        return ret;
    }

    public void modify(String newValue) {
        this.value = newValue;
    }
}

