/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.main.action.variable;

import com.indy.engine.core.common.VariablePublicationMode;
import com.indy.engine.core.common.objects2.Variable;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VariableContainer {
    long cumulVar = 0L;
    long cumulStat = 0L;
    long cumulAggr = 0L;
    String containerName;
    String containerPath;
    VariableContainer parent;
    Map<String, VariableContainer> containers = Collections.synchronizedMap(new HashMap());
    Map<String, Variable> variables = Collections.synchronizedMap(new HashMap());
    Map<String, Variable> numericVariables = Collections.synchronizedMap(new HashMap());
    VariableContainer root;
    String lock = new String("");
    public static final String IS_SELECTED = "";
    Map<String, AggregateNumeric> aggregates = Collections.synchronizedMap(new HashMap());
    Variable.VariableListener variableListener = new Variable.VariableListener(){

        @Override
        public void variableChanged(Variable var, long value, long oldValue, boolean update) {
            if (var.getValue() != null) {
                VariableContainer.this.updateAggregate(var.getShortName(), var.getType(), value, oldValue, update ? 1 : 0);
            }
        }

        @Override
        public boolean isDisposed() {
            return VariableContainer.this.isDisposed;
        }
    };
    boolean isDisposed = false;

    public String getContainerPath() {
        return this.containerPath;
    }

    public VariableContainer(String containerName, VariableContainer parent) {
        this.containerName = containerName;
        this.parent = parent;
        this.root = parent == null ? this : parent.getRootContainer();
        this.containerPath = parent != null ? String.valueOf(parent.getContainerPath()) + containerName + "/" : IS_SELECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Variable> findAllVariable(Selector selector) {
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        Map<String, Object> map = this.variables;
        synchronized (map) {
            for (Variable variable : this.variables.values()) {
                String key = selector.selectReturnKey(variable);
                if (key != null && key == IS_SELECTED) {
                    key = variable.getName();
                }
                if (key == null) continue;
                result.put(key, variable);
            }
        }
        map = this.containers;
        synchronized (map) {
            for (VariableContainer container : this.containers.values()) {
                result.putAll(container.findAllVariable(selector));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanLocalVariable(Scaner scaner) throws EngineExceptionI {
        Map<String, Variable> map = this.variables;
        synchronized (map) {
            for (Variable variable : this.variables.values()) {
                scaner.scan(variable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanAllVariable(Scaner scaner) throws EngineExceptionI {
        Map<String, Object> map = this.variables;
        synchronized (map) {
            for (Variable variable : this.variables.values()) {
                scaner.scan(variable);
            }
        }
        map = this.containers;
        synchronized (map) {
            for (VariableContainer container : this.containers.values()) {
                container.scanAllVariable(scaner);
            }
        }
    }

    public Variable getLocalVariable(String name) {
        if (this.variables != null) {
            Variable v = this.variables.get(name);
            if (v == null && name != null && name.startsWith("CORE_HTTP_REQUEST_HEADER_")) {
                return this.variables.get(name.toUpperCase());
            }
            return v;
        }
        return null;
    }

    public VariableContainer getRootContainer() {
        return this.root;
    }

    private void addLocalVariable(Variable var, boolean updateExeIfExists) {
        Variable existsVar = null;
        if (!updateExeIfExists) {
            existsVar = this.variables.get(var.getShortName());
            if (existsVar != null) {
                if (existsVar.getVariablePublicationMode() == VariablePublicationMode.STATIC) {
                    existsVar.setOriginalSourceModified(true);
                }
                existsVar.setValue(var.getValue());
                var = existsVar;
            }
        } else {
            this.removeLocalVariable(var.getShortName());
        }
        this.variables.put(var.getShortName(), var);
        if (var.isNumeric() && !var.isCore()) {
            this.numericVariables.put(var.getShortName(), var);
            if (var instanceof Variable) {
                Variable _var = var;
                _var.setVariableListener(this.variableListener);
            }
        }
    }

    public void addVariable(Variable v) {
        this.addVariable(v, false);
    }

    public void addVariable(Variable var, boolean updateExeIfExists) {
        VariableContainer container = this.getRootContainer().getVariableContainer(var.getName());
        if (container != null) {
            container.addLocalVariable(var, updateExeIfExists);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAggregate(String name, String type, long value, long oldValue, int mode) {
        boolean changed = false;
        Map<String, AggregateNumeric> map = this.aggregates;
        synchronized (map) {
            if (mode < 2) {
                AggregateNumeric aggr = this.aggregates.get(name);
                if (aggr == null) {
                    aggr = new AggregateNumeric(name, type);
                    aggr.addValue(value);
                    this.aggregates.put(name, aggr);
                    changed = true;
                } else if (value != oldValue) {
                    if (mode == 1) {
                        aggr.removeValue(oldValue);
                    }
                    aggr.addValue(value);
                    changed = true;
                }
            } else {
                AggregateNumeric aggr = this.aggregates.get(name);
                if (aggr != null) {
                    aggr.removeValue(oldValue);
                }
                changed = true;
            }
        }
        if (changed && this.parent != null) {
            this.parent.updateAggregate(name, type, value, oldValue, mode);
        }
    }

    private String[] split(String var) {
        if (var != null && var.length() > 0) {
            String _var = var.startsWith("/") ? (var.length() > 1 ? var.substring(1) : null) : var;
            return _var.split("/");
        }
        return new String[0];
    }

    private VariableContainer getVariableContainer(String varPath) {
        String[] parts = this.split(varPath);
        return this.getContainer(parts, 0, 0);
    }

    public VariableContainer getActionVariableContainer(String actPath) {
        String[] parts = this.split(actPath);
        return this.getContainer(parts, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariableContainer getContainer(String[] parts, int index, int stop) {
        if (parts.length + stop <= index + 1) {
            return this;
        }
        String containerName = null;
        try {
            containerName = parts[index];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VariableContainer vc = null;
        Map<String, VariableContainer> map = this.containers;
        synchronized (map) {
            vc = this.containers.get(containerName);
            if (vc == null) {
                vc = new VariableContainer(containerName, this);
                this.containers.put(containerName, vc);
            }
        }
        return vc.getContainer(parts, index + 1, stop);
    }

    public Variable getAbsolutVariable(String name) {
        VariableContainer root = this.getRootContainer();
        return root.getRelativeVariable(name);
    }

    public Variable getRelativeVariable(String varName) {
        String[] parts = this.split(varName);
        VariableContainer container = this.getContainer(parts, 0, 0);
        if (container.variables != null) {
            return container.getLocalVariable(parts[parts.length - 1]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Variable> getAllCopiedLocalVariables(Selector selector) {
        if (this.variables != null) {
            HashMap<String, Variable> map = new HashMap<String, Variable>();
            Map<String, Variable> map2 = this.variables;
            synchronized (map2) {
                for (Variable variable : this.variables.values()) {
                    String key = variable.getName();
                    if (selector != null && (key = selector.selectReturnKey(variable)) != null && key == IS_SELECTED) {
                        key = variable.getName();
                    }
                    if (key == null) continue;
                    map.put(key, variable);
                }
            }
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateAllVariable(Evaluator evaluator) throws EngineExceptionI {
        ArrayList<Variable> list;
        Map<String, Variable> map = this.variables;
        synchronized (map) {
            list = new ArrayList<Variable>(this.variables.values());
        }
        if (this.aggregates.size() > 0) {
            for (AggregateNumeric aggr : this.aggregates.values()) {
                aggr.resetCurrent();
            }
        }
        for (Variable var : list) {
            String varSource = var.getSource();
            if (varSource == null) continue;
            String varExpr = evaluator.evaluate(varSource);
            var.setValueOnly(varExpr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AggregateNumeric> aggregateNumeric(AggregateSelector selector) {
        HashMap<String, AggregateNumeric> map = new HashMap<String, AggregateNumeric>();
        Map<String, AggregateNumeric> map2 = this.aggregates;
        synchronized (map2) {
            for (AggregateNumeric aggr : this.aggregates.values()) {
                if (selector == null) {
                    map.put(aggr.name, aggr);
                    continue;
                }
                if (!selector.select(this, aggr)) continue;
                map.put(aggr.name, aggr);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Variable> getAllCopiedVariables(Selector selector) {
        Map<String, Variable> map = null;
        Map<String, Variable> tmp = this.getAllCopiedLocalVariables(selector);
        if (tmp != null && tmp.size() > 0) {
            map = tmp;
        }
        Map<String, VariableContainer> map2 = this.containers;
        synchronized (map2) {
            for (VariableContainer container : this.containers.values()) {
                tmp = container.getAllCopiedVariables(selector);
                if (tmp == null || tmp.size() <= 0) continue;
                if (map != null) {
                    map.putAll(tmp);
                    continue;
                }
                map = tmp;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception {
        if (!this.isDisposed) {
            Map<String, Object> map;
            if (this.variables != null) {
                map = this.variables;
                synchronized (map) {
                    for (Variable var : this.variables.values()) {
                        var.clear();
                    }
                    this.variables.clear();
                    this.variables = null;
                }
            }
            if (this.numericVariables != null) {
                this.numericVariables.clear();
            }
            this.numericVariables = null;
            if (this.containers != null) {
                map = this.containers;
                synchronized (map) {
                    for (VariableContainer container : this.containers.values()) {
                        container.clear();
                    }
                    this.containers.clear();
                    this.containers = null;
                }
            }
            this.parent = null;
            if (this.aggregates != null) {
                this.aggregates.clear();
            }
            this.aggregates = null;
            this.isDisposed = true;
            this.variableListener = null;
        }
    }

    public void removeAbsolutVariable(String varName) {
        VariableContainer root = this.getRootContainer();
        root.removeRelativeVariable(varName);
    }

    public void removeRelativeVariable(String varName) {
        String[] parts = this.split(varName);
        VariableContainer container = this.getContainer(parts, 0, 0);
        container.removeLocalVariable(parts[parts.length - 1]);
    }

    private void removeLocalVariable(String localName) {
        if (this.variables != null) {
            Variable old = this.variables.get(localName);
            if (old == null && localName != null && localName.startsWith("CORE_HTTP_REQUEST_HEADER_")) {
                old = this.variables.get(localName.toUpperCase());
            }
            if (old != null) {
                if (old.isNumeric()) {
                    this.updateAggregate(old.getName(), null, 0L, old.getLongValue(), 2);
                }
                try {
                    old.clear();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.variables.remove(localName);
        }
        if (this.numericVariables != null) {
            this.numericVariables.remove(localName);
        }
    }

    public Variable addLocalVariable(String pName, Object pValue, String pType, boolean isRealTimeReport, boolean isCumulative, boolean replace) {
        String _type;
        String _value;
        Variable var = this.getLocalVariable(pName);
        if (var != null && !replace) {
            return null;
        }
        String string = _value = pValue != null ? pValue.toString() : null;
        String string2 = pType != null ? pType : (_type = pValue != null ? pValue.getClass().getSimpleName() : "String");
        if (var == null) {
            var = new Variable(String.valueOf(this.containerPath) + pName, _value, _type, isRealTimeReport, isCumulative);
            this.addLocalVariable(var, false);
        } else {
            var.setValue(_value, isCumulative);
            var.setRealTimeReport(isRealTimeReport);
            var.setType(_type);
        }
        return var;
    }

    public class AggregateNumeric {
        AggregateNumeric current;
        boolean isLeaf = false;
        String name;
        int count = 0;
        String type;
        long maxValue = 0L;
        long minValue = 0L;
        long sumValue = 0L;
        boolean localIsSet = false;
        long localValue = 0L;

        public AggregateNumeric(String shortName, String type) {
            this.name = shortName;
            this.type = type;
        }

        public AggregateNumeric getCurrent() {
            if (this.current == null) {
                return this;
            }
            return this.current;
        }

        public void resetCurrent() {
            this.current = new AggregateNumeric(this.getName(), this.getType());
        }

        public void addValue(long addValue) {
            if (this.current != null) {
                this.current.addValue(addValue - this.localValue);
            }
            ++this.count;
            this.sumValue += addValue;
            if (this.minValue > addValue) {
                this.minValue = addValue;
            }
            if (this.maxValue < addValue) {
                this.maxValue = addValue;
            }
            this.localValue = addValue;
            this.localIsSet = true;
        }

        public void removeValue(long value) {
            this.sumValue -= value;
            if (this.current != null) {
                this.current.removeValue(value - this.localValue);
            }
        }

        public String getName() {
            return this.name;
        }

        public long getSum() {
            return this.sumValue;
        }

        public long getAvg() {
            return this.sumValue / (long)this.count;
        }

        public int getCount() {
            return this.count;
        }

        public long getMin() {
            return this.minValue;
        }

        public long getMax() {
            return this.maxValue;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "AggregateNumeric [current=" + this.current + ", isLeaf=" + this.isLeaf + ", name=" + this.name + ", count=" + this.count + ", type=" + this.type + ", maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", sumValue=" + this.sumValue + ", localIsSet=" + this.localIsSet + ", localValue=" + this.localValue + "]";
        }
    }

    public static interface AggregateSelector {
        public boolean select(VariableContainer var1, AggregateNumeric var2);
    }

    public static interface Evaluator {
        public String evaluate(String var1) throws EngineExceptionI;
    }

    public static interface Scaner {
        public void scan(Variable var1) throws EngineExceptionI;
    }

    public static interface Selector {
        public String selectReturnKey(Variable var1);
    }
}

