/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json.impl;

import com.indy.engine.core.IJsonUtils;
import com.indy.runtime.json.JsonEventWriter;
import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.JsonUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public class JsonUtilsService
implements IJsonUtils {
    @Override
    public void serializeFromJavaObject(Object o, OutputStream os, String encoding) throws XMLStreamException {
        JsonEventWriter jew = new JsonEventWriter(os, encoding);
        JsonNode.serialize(o, jew);
        jew.close();
    }

    @Override
    public void serializeFromJavaObject(Object o, OutputStream os) throws XMLStreamException {
        this.serializeFromJavaObject(o, os, "UTF-8");
    }

    @Override
    public Object deserializeToJavaObject(InputStream is, String encoding) throws Exception {
        return JsonUtils.jsonNodeToObject(is, encoding);
    }

    @Override
    public Object deserializeToJavaObject(InputStream is, String encoding, Map<String, Object> properties) throws Exception {
        return JsonUtils.jsonNodeToObject(is, encoding, properties, false);
    }

    @Override
    public Object deserializeToJavaObject(InputStream is) throws Exception {
        return this.deserializeToJavaObject(is, "UTF-8");
    }

    @Override
    public void jsonStreamToXmlStream(InputStream is, String string, OutputStream os, String string2, Map prop) throws Exception {
        boolean b = prop != null && prop.get("ADD_PROCESSING_ENCODING_INSTRUCTION") != null && (Boolean)prop.get("ADD_PROCESSING_ENCODING_INSTRUCTION") != false;
        JsonUtils.convertJsonToXml(is, os, string, string2, b);
    }

    @Override
    public void jsonStreamToXMLEventWriter(InputStream is, String string, XMLEventWriter writer, String string2, Map<String, Object> prop) throws Exception {
        boolean b = prop != null && prop.get("ADD_PROCESSING_ENCODING_INSTRUCTION") != null && (Boolean)prop.get("ADD_PROCESSING_ENCODING_INSTRUCTION") != false;
        JsonUtils.convertJsonToXml(is, writer, string, string2, b, false, null, "1.0");
    }

    @Override
    public Object createRealObjectWithGenericalObject(Object source, Class targetClass) throws Exception {
        return JsonUtils.createObjectWithAnnotation(source, targetClass);
    }

    @Override
    public Object createGenericalObjectWithRealObject(Object source) throws Exception {
        return JsonUtils.serializeObjectWithAnnotation(source);
    }
}

