/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.json;

import com.indy.engine.actionCodes.json.Messages;
import com.indy.engine.core.actionCodes.json.internal.AbstractJSONEvent;
import com.indy.engine.core.actionCodes.json.internal.JSONAttribute;
import com.indy.engine.core.actionCodes.json.internal.JSONCharacter;
import com.indy.engine.core.actionCodes.json.internal.JSONEndDocument;
import com.indy.engine.core.actionCodes.json.internal.JSONEndElement;
import com.indy.engine.core.actionCodes.json.internal.JSONStartDocument;
import com.indy.engine.core.actionCodes.json.internal.JSONStartElement;
import com.indy.engine.core.actionCodes.json.internal.JsonXmlReader;
import com.indy.engine.core.actionCodes.json.internal.JsonXmlReader2;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class JsonEventReader
implements XMLEventReader {
    private JsonXmlReader reader;
    private JsonXmlReader.JsonObject currentJson;
    private XMLEvent currentEvent;
    private JsonXmlReader.JsonObject nextJson;
    private XMLEvent nextEvent;
    private String positionAttribteName = "order";

    public JsonEventReader(InputStream is) throws Exception {
        this(is, null, "order");
    }

    public JsonEventReader(InputStream is, String anonymousTagName, String positionAttribteName) throws Exception {
        if (positionAttribteName != null || positionAttribteName.trim().isEmpty()) {
            this.positionAttribteName = positionAttribteName.trim();
        }
        this.reader = new JsonXmlReader2(is, anonymousTagName, this.positionAttribteName);
    }

    @Override
    public Object next() {
        try {
            return this.nextTag();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void remove() {
    }

    private XMLEvent createEvent(JsonXmlReader.JsonObject jo) throws XMLStreamException {
        AbstractJSONEvent res = null;
        switch (this.currentJson.getEventType()) {
            case 10: {
                res = new JSONAttribute(this.positionAttribteName, jo);
                break;
            }
            case 4: {
                res = new JSONCharacter(jo);
                break;
            }
            case 8: {
                res = new JSONEndDocument(jo);
                break;
            }
            case 2: {
                res = new JSONEndElement(jo);
                break;
            }
            case 7: {
                res = new JSONStartDocument(jo);
                break;
            }
            case 1: {
                res = new JSONStartElement(jo);
                break;
            }
            default: {
                res = null;
                throw new XMLStreamException(String.valueOf(Messages.getString("JsonEventReader.0")) + jo.getEventType() + Messages.getString("JsonEventReader.1"));
            }
        }
        return res;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.nextEvent != null) {
            this.currentJson = this.nextJson;
            this.currentEvent = this.nextEvent;
        } else {
            try {
                this.currentJson = this.reader.readNext();
                this.currentEvent = this.createEvent(this.currentJson);
            }
            catch (Exception ex) {
                throw new XMLStreamException(ex);
            }
        }
        return this.currentEvent;
    }

    @Override
    public boolean hasNext() {
        return this.nextEvent != null || this.reader != null && this.reader.hasNext();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        if (this.nextEvent != null) {
            return this.nextEvent;
        }
        try {
            this.nextJson = this.reader.readNext();
            this.nextEvent = this.createEvent(this.nextJson);
            return this.nextEvent;
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public String getElementText() throws XMLStreamException {
        throw new XMLStreamException();
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        return this.nextEvent();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.reader.close();
        }
        catch (Exception e) {
            throw new XMLStreamException(e.getMessage(), e);
        }
        this.reader = null;
    }
}

