/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.utils;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.utils.Constant;
import com.indy.engine.actionCodes.utils.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;

public class InOutTemporaryFile {
    File inFile;
    File outFile;
    File temporaryFile;
    InputStream inputStream;
    OutputStream outputStream;
    ActionCodeTypeI action;

    public InOutTemporaryFile(ActionCodeTypeI action) {
        this.action = action;
    }

    public void prepare(ResultSet sourceRSet) throws FileNotFoundException, EngineExceptionI {
        String inputFile = this.action.getLocalStringBindedParameter(sourceRSet, "IN_FILE_NAME");
        if (inputFile.startsWith("<tempDir>")) {
            String tempFolder = this.action.getStringParameter(String.valueOf(this.action.runtimeContext.VAR_PREFIXE) + Constant.VAR_CORE_TEMPORARY_FOLDER);
            File _tempFolder = new File(tempFolder);
            if (!_tempFolder.exists()) {
                _tempFolder.mkdirs();
            }
            inputFile = _tempFolder + "/" + inputFile.substring(9);
        }
        this.inFile = new File(inputFile);
        String outputFile = this.action.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_NAME", inputFile);
        if (outputFile.startsWith("<tempDir>")) {
            String tempFolder = this.action.getStringParameter(String.valueOf(this.action.runtimeContext.VAR_PREFIXE) + Constant.VAR_CORE_TEMPORARY_FOLDER);
            File _tempFolder = new File(tempFolder);
            if (!_tempFolder.exists()) {
                _tempFolder.mkdirs();
            }
            outputFile = String.valueOf(tempFolder) + "/" + outputFile.substring(9);
        }
        this.outFile = new File(outputFile);
        this.temporaryFile = new File(String.valueOf(this.outFile.getParent()) + "/" + new Long(System.currentTimeMillis()).toString() + ".temp." + this.outFile.getName());
    }

    public void initInput() throws FileNotFoundException {
        this.inputStream = new FileInputStream(this.inFile);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void initOuput() throws FileNotFoundException {
        this.outputStream = new FileOutputStream(this.temporaryFile);
    }

    public void finalizeOutput() throws IOException, EngineExceptionI {
        this.close();
        if (this.temporaryFile != null && this.temporaryFile.exists()) {
            if (this.outFile.exists() && !this.outFile.delete()) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("InOutTemporaryFile.0")) + this.outFile.getAbsolutePath());
            }
            this.temporaryFile.renameTo(this.outFile);
            this.outFile = null;
            this.temporaryFile = null;
        }
    }

    public void close() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        finally {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
    }

    public File getTemporaryFile() {
        return this.temporaryFile;
    }
}

