/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.actionCodes.json.internal;

import com.indy.engine.core.actionCodes.json.internal.JsonObjectException;
import com.indy.engine.core.actionCodes.json.internal.JsonXmlReader2;
import com.indy.engine.core.actionCodes.json.internal.Messages;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class JsonXmlReader {
    BufferedReader bufferedReader;
    protected static final char START_OBJECT = '{';
    protected static final char END_OBJECT = '}';
    protected static final char STRING = '\"';
    protected static final char PAIR_SEPARATOR = ':';
    protected static final char OBJECT_SEPARATOR = ',';
    protected static final char START_ARRAY = '[';
    protected static final char END_ARRAY = ']';
    protected static final char ESCAPE_CHAR = '\\';
    private static final String[] literals = new String[]{"null", "true", "false"};
    protected int countQuote = 0;
    protected int charCount = 0;
    protected int lineCount = 0;
    protected int columnCount = 0;
    protected boolean allRead = false;

    public JsonXmlReader(InputStream is) {
        this.bufferedReader = new BufferedReader(new InputStreamReader(is));
    }

    public abstract JsonObject readNext() throws Exception;

    public boolean hasNext() {
        return !this.allRead;
    }

    public void close() throws Exception {
        this.bufferedReader.close();
    }

    public static void main(String[] args) {
        String s = "{    \"glossary\": {        \"title\": \"example glossary\",\"GlossDiv\": {            \"title\": \"S\",\"GlossList\": {                \"GlossEntry\": {                    \"ID\": \"SGML\",\"SortAs\": \"SGML\",\"GlossTerm\": \"Standard Generalized Markup Language\",\"Acronym\": \"SGML\",\"Abbrev\": \"ISO 8879:1986\",\"GlossDef\": {                        \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\",\"GlossSeeAlso\": \"GML\"                    },\"GlossSee\": [{\"a\":1, \"valid\" : [true,false]}, {\"b\":1, \"valid\" : [true,false]}]               }            }        }    }}";
        String sNoLIteral = "{    \"glossary\": {        \"title\": \"example glossary\",\"GlossDiv\": {            \"title\": \"S\",\"GlossList\": {                \"GlossEntry\": {                    \"ID\": \"SGML\",\"SortAs\": \"SGML\",\"GlossTerm\": \"Standard Generalized Markup Language\",\"Acronym\": \"SGML\",\"Abbrev\": \"ISO 8879:1986\",\"GlossDef\": {                        \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\",\"GlossSeeAlso\": \"GML\"                    },\"GlossSee\": [{\"a\":\"1\", \"valid\" : [\"true\",\"false\"]}, {\"b\":\"1\", \"valid\" : [\"true\",\"false\"]}]               }            }        }    }}";
        String sArray = "{    \"glossary\": {        \"title\": \"example glossary\",\"GlossDiv\": {            \"title\": \"S\",\"GlossList\": {                \"GlossEntry\": {                    \"ID\": \"SGML\",\"SortAs\": \"SGML\",\"GlossTerm\": \"Standard Generalized Markup Language\",\"Acronym\": \"SGML\",\"Abbrev\": \"ISO 8879:1986\",\"GlossDef\": {                        \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\",\"GlossSeeAlso\": [\"GML\", \"XML\"]},\"GlossSee\": \"markup\"                }            }        }    }}";
        String sArray2 = "{    \"glossary\": {        \"title\": \"example glossary\",\"GlossDiv\": {            \"title\": \"S\",\"GlossList\": {                \"GlossEntry\": {                    \"ID\": \"SGML\",\"SortAs\": \"SGML\",\"GlossTerm\": \"Standard Generalized Markup Language\",\"Acronym\": \"SGML\",\"Abbrev\": \"ISO 8879:1986\",\"GlossDef\": {                        \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\",\"GlossSeeAlso\": [{\"GML\":\"ff\",\"dd\":\"dd\"}, {\"XML\":\"ff\",\"dd\":\"dd\"}]},\"GlossSee\": \"markup\"                }            }        }    }}";
        String sArray3 = "{    \"glossary\": {        \"title\": \"example glossary\",\"GlossDiv\": {            \"title\": \"S\",\"GlossList\": {                \"GlossEntry\": {                    \"ID\": \"SGML\",\"SortAs\": \"SGML\",\"GlossTerm\": \"Standard Generalized Markup Language\",\"Acronym\": \"SGML\",\"Abbrev\": \"ISO 8879:1986\",\"GlossDef\": {                        \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\",\"GlossSeeAlso\": [{\"GML\":\"ff\",\"dd\":\"dd\"}, \"XML\"]},\"GlossSee\": \"markup\"                }            }        }    }}";
        String sArray4 = "{    \"glossary\": {        \"title\": \"example glossary\",\"GlossDiv\": {            \"title\": \"S\",\"GlossList\": {                \"GlossEntry\": {                    \"ID\": \"SGML\",\"SortAs\": \"SGML\",\"GlossTerm\": \"Standard Generalized Markup Language\",\"Acronym\": \"SGML\",\"Abbrev\": \"ISO 8879:1986\",\"GlossDef\": {                        \"para\": \"A meta-markup language, used to create markup languages such as DocBook.\",\"GlossSeeAlso\": [15,z15,false, true]},\"GlossSee\": \"markup\"                }            }        }    }}";
        JsonObject o = null;
        try {
            JsonXmlReader2 r = new JsonXmlReader2(new ByteArrayInputStream(s.getBytes("UTF-8")), "unknown", "order");
            while (((JsonXmlReader)r).hasNext()) {
                o = ((JsonXmlReader)r).readNext();
                System.out.println(String.valueOf(o.getType()) + ":" + o.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public char[] asCharArray(JsonObject o) throws Exception {
        return o.getName().toCharArray();
    }

    public static class JsonObject {
        int eventType;
        String name;
        boolean isLiteral = false;
        int columnCount;
        int lineCount;
        int charNumber;
        int attributePosition;

        public JsonObject(int eventType, String name, boolean isLiteral, int columnCount, int lineCount, int charNumber) throws JsonObjectException {
            this.eventType = eventType;
            this.name = name;
            this.isLiteral = isLiteral;
            this.columnCount = columnCount;
            this.lineCount = lineCount;
            this.charNumber = charNumber;
            if (isLiteral) {
                this.checkLiteral();
            }
        }

        public JsonObject(int eventType, String name, boolean isLiteral, int columnCount, int lineCount, int charNumber, int pos) throws JsonObjectException {
            this(eventType, name, isLiteral, columnCount, lineCount, charNumber);
            this.attributePosition = pos;
        }

        private void checkLiteral() throws JsonObjectException {
            String[] stringArray = literals;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(this.name)) {
                    return;
                }
                ++n2;
            }
            try {
                Double.valueOf(this.name);
                return;
            }
            catch (Exception exception) {
                throw new JsonObjectException(Messages.getString("JsonXmlReader.0"), this.name, this.charNumber, this.lineCount, this.columnCount);
            }
        }

        public int getEventType() {
            return this.eventType;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLiteral() {
            return this.isLiteral;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public int getCharNumber() {
            return this.charNumber;
        }

        public int getAttributePosition() {
            return this.attributePosition;
        }

        String getType() {
            switch (this.eventType) {
                case 2: {
                    return "END_ELEMENT";
                }
                case 4: {
                    return "CHARACTERS";
                }
                case 8: {
                    return "END_DOCUMENT";
                }
                case 6: {
                    return "SPACE";
                }
                case 7: {
                    return "START_DOCUMENT";
                }
                case 1: {
                    return "START_ELEMENT";
                }
            }
            return "unknown";
        }
    }
}

