/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.common;

import com.indy.engine.core.common.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class CommonUtils {
    static CommonUtils INSTANCE = new CommonUtils();
    static FileMaskApi fileMaskApi = new FileMaskApi();

    public static void main2(String[] args) {
        List<File> files = fileMaskApi.getFile("d:/**/*.*");
        long l = Integer.valueOf("25") * 24 * 60 * 60 * 1000;
        int i = 999999999;
        List<String> list = CommonUtils.splitCommaExpression("(1,2), (a(1,2),3),1", 0);
        for (String str : list) {
            List<String> list2 = CommonUtils.splitCommaExpression(str, 1);
            for (String str2 : list2) {
                List<String> list3 = CommonUtils.splitCommaExpression(str2, 1);
            }
        }
    }

    public static Group splitGroupExpression(String str) {
        if (str != null) {
            Group mainGroup;
            Group currentGroup = mainGroup = INSTANCE.new Group();
            Pattern pDeb2 = Pattern.compile("((')|(\\()|(\\))|(,)|([A-Za-z0-9]\\())");
            Matcher mDeb2 = pDeb2.matcher(str);
            int deb = 0;
            int mode = 0;
            int p = 0;
            while (mDeb2.find()) {
                int strD = mDeb2.start(2);
                int parenthD = mDeb2.start(3);
                int parenthE = mDeb2.start(4);
                int comma = mDeb2.start(5);
                int funcD = mDeb2.start(6);
                if (mode == 0) {
                    String str2;
                    if (strD > -1) {
                        mode = -1;
                        continue;
                    }
                    if (funcD > -1) {
                        mode = 1;
                        continue;
                    }
                    if (parenthD > -1) {
                        ++p;
                        System.out.println("sub Group");
                        str2 = str.substring(deb, parenthD);
                        deb = parenthD + 1;
                        continue;
                    }
                    if (parenthE > -1) {
                        --p;
                        System.out.println("end Group");
                        str2 = str.substring(deb, parenthE);
                        if (!str2.isEmpty()) {
                            currentGroup.addGroup().current = str2;
                        }
                        deb = parenthE + 1;
                        continue;
                    }
                    if (comma <= -1) continue;
                    str2 = str.substring(deb, comma);
                    if (!str2.isEmpty()) {
                        currentGroup.addGroup().current = str2;
                    }
                    System.out.println("end Group");
                    deb = comma + 1;
                    continue;
                }
                if (mode == -1 && strD > -1) {
                    mode = 0;
                    continue;
                }
                if (mode > 0 && parenthE > -1) {
                    --mode;
                    continue;
                }
                if (mode <= 0 || parenthD <= -1) continue;
                ++mode;
            }
            if (deb > 0) {
                currentGroup.addGroup().current = str.substring(deb);
            } else {
                currentGroup.current = str;
            }
            return mainGroup;
        }
        return null;
    }

    public static void main(String[] args) {
        String regex = "\\/\\*[\\s\\S]*?\\*\\/|([^:]|^)\\/\\/.*$";
        String s = "// comments at the beginning of the file are removed\n\n/*\nBlock comments are removed - easy peasy 'eee\\''\n\t\t/* eee \n*/\n\n/* */\n'eee'\nhttps://urls.are.preserved.for.you// and comments after them are removed\nasdfasdf// the comment can bump right up to text\nasdfasdf;// ...or a semicolon.\n\n{\n   foo:// you will need a parser to remove this comment b/c it smells like a URL\n\t    \"bar\",// ...but not this one\n\tboo: // ...or this one\n\t\t\"who\"\n}";
        Pattern pDeb2 = Pattern.compile(regex);
        Matcher mDeb2 = pDeb2.matcher(s);
        while (mDeb2.find()) {
            System.out.println(s.substring(mDeb2.start(0), mDeb2.end(0)));
        }
    }

    public static List<String> splitCommaExpression(String str) {
        List<String> l = null;
        if (str.contains("/*")) {
            ArrayList<String> comments = new ArrayList<String>();
            String replacement = "__zorglubCkrrmsblrrp__";
            String regex = "\\/\\*[\\s\\S]*?\\*\\/|([^:]|^)\\/\\/.*$";
            Pattern pDeb2 = Pattern.compile(regex);
            Matcher mDeb2 = pDeb2.matcher(str);
            StringBuffer b = new StringBuffer();
            int cur = 0;
            while (mDeb2.find()) {
                b.append(str.substring(cur, mDeb2.start(0)));
                cur = mDeb2.end(0);
                comments.add(str.substring(mDeb2.start(0), mDeb2.end(0)));
                b.append(replacement);
            }
            if (cur < str.length()) {
                b.append(str.substring(cur));
            }
            l = CommonUtils.splitCommaExpression(b.toString(), 0);
            ArrayList<String> res = new ArrayList<String>(l.size());
            try {
                int i = 0;
                for (String s : l) {
                    while (s.contains(replacement)) {
                        s = s.replace(replacement, (CharSequence)comments.get(i++));
                    }
                    res.add(s);
                }
                return res;
            }
            catch (Exception ex) {
                return CommonUtils.splitCommaExpression(str, 0);
            }
        }
        l = CommonUtils.splitCommaExpression(str, 0);
        return l;
    }

    public static List<String> splitCommaExpression(String str, int _mode) {
        if (str != null) {
            Pattern pDeb2 = Pattern.compile("((')|(\\()|(\\))|(,))");
            String _str = null;
            _str = _mode == 1 ? ((_str = str.trim()).startsWith("(") && _str.endsWith(")") ? _str.substring(1, _str.length() - 1) : str) : str;
            Matcher mDeb2 = pDeb2.matcher(_str);
            ArrayList<String> list = new ArrayList<String>();
            int deb = 0;
            int mode = 0;
            while (mDeb2.find()) {
                int strD = mDeb2.start(2);
                int parenthD = mDeb2.start(3);
                int parenthE = mDeb2.start(4);
                int comma = mDeb2.start(5);
                if (mode == 0) {
                    if (strD > -1) {
                        mode = -1;
                        continue;
                    }
                    if (parenthD > -1) {
                        mode = 1;
                        continue;
                    }
                    if (comma <= -1) continue;
                    list.add(_str.substring(deb, comma));
                    deb = comma + 1;
                    continue;
                }
                if (mode == -1 && strD > -1) {
                    mode = 0;
                    continue;
                }
                if (mode > 0 && parenthE > -1) {
                    --mode;
                    continue;
                }
                if (mode <= 0 || parenthD <= -1) continue;
                ++mode;
            }
            if (deb > 0) {
                list.add(_str.substring(deb));
            } else {
                list.add(_str);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean existsTable(Connection jdbcConnection, String sTableName, String sqlSchemaName) throws EngineExceptionI {
        return CommonUtils.existsTable(jdbcConnection, String.valueOf(sqlSchemaName) + sTableName);
    }

    public static boolean existsField(Connection jdbcConnection, String sqlSchemaName, String tableName, String field) {
        return CommonUtils.existsField(jdbcConnection, String.valueOf(sqlSchemaName) + tableName, field);
    }

    public static boolean existsField(Connection jdbcConnection, String fullName, String field) {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = jdbcConnection.createStatement();
            rs = st.executeQuery("SELECT " + field + " FROM " + fullName);
            return true;
        }
        catch (Exception exception) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean existsTable(Connection jdbcConnection, String fullName) throws EngineExceptionI {
        Statement st = null;
        ResultSet rs = null;
        try {
            try {
                st = jdbcConnection.createStatement();
                rs = st.executeQuery("SELECT 1 FROM " + fullName);
            }
            catch (Exception e) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public static byte[] compressByteArray(byte[] b, int level) throws IOException {
        Deflater compressor = new Deflater(level);
        compressor.setInput(b);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(b.length);
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int bytesCompressed = compressor.deflate(buffer);
            bos.write(buffer, 0, bytesCompressed);
            try {
                bos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bos.toByteArray();
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static String inputStreamToString(InputStream stream, String charsetName) throws IOException {
        BufferedReader br = charsetName != null ? new BufferedReader(new InputStreamReader(stream, charsetName)) : new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        br.close();
        return sb.toString();
    }

    public static String inputStreamToString(InputStream stream) throws IOException {
        return CommonUtils.inputStreamToString(stream, null);
    }

    public static String readerToString(Reader reader) throws IOException {
        int numCharsRead;
        char[] charBuffer = new char[8192];
        StringBuilder builder = new StringBuilder();
        while ((numCharsRead = reader.read(charBuffer, 0, charBuffer.length)) != -1) {
            builder.append(charBuffer, 0, numCharsRead);
        }
        return builder.toString();
    }

    public static byte[] unCompressByteArray(byte[] b) throws IOException, DataFormatException {
        Inflater unCompressor = new Inflater();
        unCompressor.setInput(b);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while (!unCompressor.finished()) {
            int bytesCompressed = unCompressor.inflate(buffer);
            bos.write(buffer, 0, bytesCompressed);
            try {
                bos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        unCompressor.end();
        return bos.toByteArray();
    }

    public static Map transformPurgeMap(Map<String, Object> rules) throws Exception {
        String size = (String)rules.get("size");
        String unit = (String)rules.get("unit");
        Map mapSessionName = (Map)rules.get("purgeSessionName");
        Map mapSessionId = (Map)rules.get("purgeSessionId");
        List statusList = (List)rules.get("purgeStatusList");
        String tmp = "purge param: size[%s] unit[%s] host[%s] port[%s] param[%s]";
        String currentRuntime = (String)rules.get("currentRuntime");
        long l = 0L;
        int nbSessions = -1;
        if (unit.equals("day")) {
            l = Long.valueOf(size) * 24L * 60L * 60L * 1000L;
        } else if (unit.equals("hour")) {
            l = Long.valueOf(size) * 60L * 60L * 1000L;
        } else if (unit.equals("minute")) {
            l = Long.valueOf(size) * 60L * 1000L;
        } else if (unit.equals("session")) {
            nbSessions = Integer.valueOf(size);
        } else {
            throw new Exception(String.valueOf(Messages.getString("CommonUtils.0")) + unit);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (nbSessions == -1) {
            Date date = new Date(System.currentTimeMillis() - l);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z");
            map.put("untilDate", date);
        } else {
            map.put("nbSessions", nbSessions);
        }
        if (mapSessionName != null) {
            map.put("sessionName", mapSessionName);
        }
        if (mapSessionId != null) {
            map.put("sessionId", mapSessionId);
        }
        if (statusList != null && statusList.size() > 0) {
            map.put("statusList", statusList);
        }
        if (currentRuntime != null) {
            map.put("currentRuntime", true);
        }
        return map;
    }

    public static String detectXmlCharsetEncoding(InputStream in) throws IOException {
        if (in != null && in.markSupported()) {
            in.mark(512);
            byte[] buffer = new byte[512];
            int read = in.read(buffer, 0, buffer.length);
            Charset cs = Charset.forName(System.getProperty("file.encoding"));
            String s = new String(buffer, 0, read, cs);
            int pos = s.indexOf("encoding");
            String ret = null;
            if (pos > -1) {
                int delim = 39;
                int start = s.indexOf(39, pos);
                if (start == -1) {
                    delim = 34;
                    start = s.indexOf(34, pos);
                }
                if (start == -1) {
                    throw new IOException(Messages.getString("CommonUtils.1"));
                }
                int end = s.indexOf(delim, start + 1);
                if (end == -1) {
                    throw new IOException(Messages.getString("CommonUtils.2"));
                }
                ret = s.substring(start + 1, end);
            }
            in.reset();
            return ret;
        }
        return null;
    }

    public static List<File> getFile(String masks, String separator) {
        return fileMaskApi.getFile(masks.split(separator));
    }

    private static class FileMaskApi {
        private FileMaskApi() {
        }

        void fillStack(File file, List<File> stack) {
            if (file != null && (file.getPath().contains("*") || file.getPath().contains("?") || file.exists())) {
                this.fillStack(file.getParentFile(), stack);
                stack.add(file);
            }
        }

        public String replaceWildCharsWithGroups(String wild) {
            StringBuffer buffer = new StringBuffer();
            char[] chars = wild.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == '*') {
                    buffer.append("(.*)");
                } else if (chars[i] == '?') {
                    buffer.append("(.)");
                } else if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                    buffer.append('\\').append(chars[i]);
                } else {
                    buffer.append(chars[i]);
                }
                ++i;
            }
            return buffer.toString();
        }

        void getAllRecursDir(File dir, List<File> list, List<File> excludes) {
            if (dir.isDirectory() && (excludes == null || !excludes.contains(dir))) {
                list.add(dir);
                if (dir.listFiles() != null) {
                    File[] fileArray = dir.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        this.getAllRecursDir(child, list, excludes);
                        ++n2;
                    }
                }
            }
        }

        void fillList2(File parentRealFile, Level parentLevel, List<File> list, int index, boolean recursive, List<File> excludes) {
            if (parentRealFile == null) {
                ++index;
                for (Level child : parentLevel.level.values()) {
                    this.fillList2(child.file, child, list, index, recursive, excludes);
                }
                return;
            }
            if (excludes != null && excludes.contains(parentRealFile)) {
                return;
            }
            if (!parentRealFile.exists()) {
                return;
            }
            if (parentLevel.isLeaf) {
                list.add(parentRealFile);
                return;
            }
            if (!parentLevel.isLeaf && parentRealFile.isDirectory()) {
                for (Level childLevel : parentLevel.level.values()) {
                    File childRealFile = new File(parentRealFile, childLevel.file.getName());
                    String name = childRealFile.getName();
                    if (name == null) continue;
                    if (name.equals("**")) {
                        ArrayList<File> allDirs = new ArrayList<File>();
                        this.getAllRecursDir(parentRealFile, allDirs, excludes);
                        for (File dir : allDirs) {
                            this.fillList2(dir, childLevel, list, index, true, excludes);
                        }
                        continue;
                    }
                    if (name.indexOf(42) > -1 || name.indexOf(63) > -1) {
                        String pattern = this.replaceWildCharsWithGroups(name);
                        if (parentRealFile.listFiles() == null) continue;
                        File[] fileArray = parentRealFile.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File _file = fileArray[n2];
                            if (_file.getName().matches(pattern)) {
                                this.fillList2(_file, childLevel, list, index, recursive, excludes);
                            }
                            ++n2;
                        }
                        continue;
                    }
                    this.fillList2(childRealFile, childLevel, list, index, recursive, excludes);
                }
            }
        }

        void fillRoot(Level root, List<List<File>> stacks) {
            for (List<File> stack : stacks) {
                Level current = root;
                int i = -1;
                for (File fi : stack) {
                    ++i;
                    Level l = current.level.get(fi.getName());
                    if (l == null) {
                        l = new Level();
                        l.file = fi;
                        if (i + 1 == stack.size()) {
                            l.isLeaf = true;
                        }
                        current.level.put(fi.getName(), l);
                    }
                    current = l;
                }
            }
        }

        List<File> getFile(String ... mask) {
            ArrayList<List<File>> stacks = new ArrayList<List<File>>();
            ArrayList<List<File>> excludes = new ArrayList<List<File>>();
            String[] stringArray = mask;
            int n = mask.length;
            int n2 = 0;
            while (n2 < n) {
                String _mask = stringArray[n2];
                boolean exclude = (_mask = _mask.trim()).startsWith("exclude::");
                if (exclude) {
                    _mask = _mask.substring(9);
                }
                ArrayList<File> stack = new ArrayList<File>();
                File f = new File(_mask);
                this.fillStack(f, stack);
                if (exclude) {
                    excludes.add(stack);
                } else {
                    stacks.add(stack);
                }
                ++n2;
            }
            Level root = new Level();
            this.fillRoot(root, stacks);
            Level rootExclude = new Level();
            this.fillRoot(rootExclude, excludes);
            ArrayList<File> _excludes = new ArrayList<File>();
            this.fillList2(null, rootExclude, _excludes, -1, false, null);
            ArrayList<File> list = new ArrayList<File>();
            this.fillList2(null, root, list, -1, false, _excludes);
            return list;
        }
    }

    class Group {
        Group parent;
        List<Group> children = new ArrayList<Group>();
        String current;
        String code;

        Group() {
        }

        Group addGroup() {
            Group group = new Group();
            group.parent = this;
            this.children.add(group);
            return group;
        }

        public String toString() {
            if (this.current != null && !this.current.isEmpty()) {
                return this.current;
            }
            String str = "(";
            int i = 0;
            while (i < this.children.size()) {
                Group grp = this.children.get(i);
                if (i > 0) {
                    str = String.valueOf(str) + ",";
                }
                str = String.valueOf(str) + grp.toString();
                ++i;
            }
            str = String.valueOf(str) + ")";
            return str;
        }
    }

    static class Level {
        Map<String, Level> level = new HashMap<String, Level>();
        File file;
        boolean isLeaf;

        Level() {
        }
    }
}

