/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.externalvalueresolver;

import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.core.externalvalueresolver.Messages;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.shared.configuration.externalvalueresolver.ExternalValueResolverConfiguration;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;

public class ExternalValueResolverManager {
    public static final String PREFIX_PROPERTY = "PREFIX_PROPERTY";
    public static final String CLASS_PROPERTY = "CLASS_PROPERTY";
    public static ExternalValueResolverManager INSTANCE = new ExternalValueResolverManager();
    private List<ResolverWrapper> resolvers = new ArrayList<ResolverWrapper>();
    Comparator<ResolverWrapper> compare = new Comparator<ResolverWrapper>(){

        @Override
        public int compare(ResolverWrapper o1, ResolverWrapper o2) {
            String prefixa = o1.prefix;
            prefixa = prefixa != null ? prefixa : "";
            String prefixb = o2.prefix;
            prefixb = prefixb != null ? prefixb : "";
            int c = prefixa.length() - prefixb.length();
            if (c == 0) {
                return prefixa.compareTo(prefixb);
            }
            return c * -1;
        }
    };
    static final String valueWord = "ext";
    public static final String startExternalValue = "%ext{";
    public static final String endExternalValue = "}ext%";
    static final int secretOffset = "}ext%".length();

    public static boolean needResolution(String ... value) {
        if (value != null) {
            String[] stringArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.contains(startExternalValue)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected ExternalValueResolverManager() {
    }

    protected ClassLoader getConfigurationClassLoader() throws Exception {
        return this.getModuleClassLoader("internal");
    }

    public void init(String runtimeEngineParametersLocation) throws Exception {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getConfigurationClassLoader());
            ExternalValueResolverConfiguration provider = ExternalValueResolverConfiguration.load((String)runtimeEngineParametersLocation);
            if (provider != null && provider.getConfigurations() != null) {
                for (IPluginFactory.IPluginConfiguration cnf : provider.getConfigurations()) {
                    this.createResolver(cnf);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected ClassLoader getModuleClassLoader(String classLoaderName) throws ClassLoaderServiceProvider.ClassLoaderServiceException, Exception {
        return ClassLoaderServiceProvider.INSTANCE.getClassLoader(classLoaderName);
    }

    protected IPluginFactory.IRelativePathResolver getRelativePathResolver() {
        return null;
    }

    private void createResolver(IPluginFactory.IPluginConfiguration cnf) throws Exception {
        if (cnf.getModuleProvider() == null) {
            throw new Exception(String.format(Messages.getString("ExternalValueResolverManager.0"), "module", cnf.getProperty("prefix")));
        }
        if (cnf.getPluginFactoryClassName() == null) {
            throw new Exception(String.format(Messages.getString("ExternalValueResolverManager.1"), "class", cnf.getProperty("prefix")));
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.getModuleClassLoader(cnf.getModuleProvider());
        Class<?> clzz = classLoader.loadClass(cnf.getPluginFactoryClassName());
        try {
            LogManager.getLogger(ExternalValueResolverManager.class).debug(String.format(Messages.getString("ExternalValueResolverManager.2"), cnf.getPluginFactoryClassName(), cnf.getProperty("prefix")));
            Thread.currentThread().setContextClassLoader(classLoader);
            IPluginFactory factory = (IPluginFactory)clzz.newInstance();
            IExternalValueResolverPlugin plugin = (IExternalValueResolverPlugin)factory.createPlugin(cnf, this.getRelativePathResolver());
            ResolverWrapper rw = new ResolverWrapper();
            rw.resolver = plugin;
            rw.prefix = cnf.getProperty("prefix");
            for (ResolverWrapper _resolver : this.resolvers) {
                if (this.compare.compare(_resolver, rw) != 0) continue;
                throw new Exception(Messages.getString("ExternalValueResolverManager.3"));
            }
            this.resolvers.add(rw);
            if (this.resolvers.size() > 1) {
                Collections.sort(this.resolvers, this.compare);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    public void addResolver(String prefix, IExternalValueResolverPlugin resolver) throws Exception {
        LogManager.getLogger(ExternalValueResolverManager.class).debug(String.format(Messages.getString("ExternalValueResolverManager.4"), resolver.getClass(), prefix));
        ResolverWrapper rw = new ResolverWrapper();
        rw.resolver = resolver;
        rw.prefix = prefix;
        for (ResolverWrapper _resolver : this.resolvers) {
            if (this.compare.compare(_resolver, rw) != 0) continue;
            throw new Exception(Messages.getString("ExternalValueResolverManager.5"));
        }
        this.resolvers.add(rw);
        if (this.resolvers.size() > 1) {
            Collections.sort(this.resolvers, this.compare);
        }
    }

    private byte[] getValue(String stringKey) throws IExternalValueResolverPlugin.ExternalValueResolverException {
        if (this.resolvers.isEmpty()) {
            throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.6"), stringKey));
        }
        for (ResolverWrapper resolver : this.resolvers) {
            if (resolver.prefix != null) {
                if (!stringKey.startsWith(resolver.prefix)) continue;
                String key = stringKey.substring(resolver.prefix.length());
                return this.doResolve(resolver, key, stringKey);
            }
            return this.doResolve(resolver, stringKey, stringKey);
        }
        throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.7"), stringKey));
    }

    private byte[] doResolve(ResolverWrapper resolver, String key, String aliasedKey) throws IExternalValueResolverPlugin.ExternalValueResolverException {
        IExternalValueResolverPlugin.Value value = null;
        try {
            value = resolver.resolver.getvalue(key, IExternalValueResolverPlugin.SecurityLevel.level2);
        }
        catch (Exception ex) {
            throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.8"), aliasedKey, ex.getMessage()));
        }
        if (value.errorMessage != null) {
            throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.9"), aliasedKey, value.errorMessage));
        }
        return value.data;
    }

    public int indexOf(String str) {
        if (str != null) {
            return str.indexOf(startExternalValue);
        }
        return -1;
    }

    public String replace(String str) throws IExternalValueResolverPlugin.ExternalValueResolverException {
        int i = this.indexOf(str);
        if (i > -1) {
            return this.replace(str, i);
        }
        return str;
    }

    public String replace(String str, int firstIndex) throws IExternalValueResolverPlugin.ExternalValueResolverException {
        StringBuilder sb = null;
        int start = -1;
        int end = -1;
        int last = 0;
        do {
            if (start == -1) {
                sb = new StringBuilder();
                start = firstIndex;
                end = str.indexOf(endExternalValue);
            } else {
                start = str.indexOf(startExternalValue, last);
                end = str.indexOf(endExternalValue, last);
            }
            if (start <= -1 || end <= -1) continue;
            if (start < end) {
                sb.append(str.substring(last, start));
                String stringKey = str.substring(start + secretOffset, end);
                byte[] value = this.getValue(stringKey);
                try {
                    sb.append(new String(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IExternalValueResolverPlugin.ExternalValueResolverException("Unsupported UTF-8 on key " + stringKey);
                }
                last = end + secretOffset;
                continue;
            }
            throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.10"), str));
        } while (start > -1);
        if (sb != null) {
            if (last <= str.length()) {
                sb.append(str.substring(last, str.length()));
            }
            return sb.toString();
        }
        return str;
    }

    class ResolverWrapper {
        IExternalValueResolverPlugin resolver;
        String prefix;

        ResolverWrapper() {
        }
    }
}

