/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.main.connections.impl;

import com.indy.engine.core.main.connections.RuntimeConnection;
import com.indy.engine.core.main.connections.RuntimeDatasource;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DefaultRuntimeDataSource<T>
implements RuntimeDatasource<T> {
    private Map<String, RuntimeConnection<T>> connectionMap = new ConcurrentHashMap<String, RuntimeConnection<T>>();
    private final Function<String, RuntimeConnection<T>> computeMapFunction;

    public DefaultRuntimeDataSource(Function<String, RuntimeConnection<T>> computeMapFunction) {
        this.computeMapFunction = computeMapFunction;
    }

    @Override
    public final RuntimeConnection<T> getConnection(String name) throws EngineExceptionI {
        try {
            return this.connectionMap.computeIfAbsent(name, this.computeMapFunction);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof EngineExceptionI) {
                throw (EngineExceptionI)e.getCause();
            }
            throw e;
        }
    }
}

