/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.repository;

import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;

public class DeliveryRepositoryPluginUtils {
    public static final void main(IDeliveryRepositoryPlugin repository, String deliveryName, IDeliveryRepositoryInfo deliveryRepositoryInfo) throws Exception {
        Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> deliveries = repository.getDeliveriesInfo(true);
        System.out.println("deliveries : " + DeliveryRepositoryPluginUtils.deliveriesToString(deliveries.values()));
        IDeliveryRepositoryPlugin.DeliveryInfo info = repository.getDeliveryInfo(deliveryName);
        System.out.println("exist : " + (info != null));
    }

    public static final String deliveriesToString(Collection<IDeliveryRepositoryPlugin.DeliveryInfo> deliveries) {
        StringBuffer str = new StringBuffer("size=").append(deliveries.size());
        for (IDeliveryRepositoryPlugin.DeliveryInfo delivery : deliveries) {
            str.append("\n\t").append(delivery);
        }
        return str.toString();
    }

    public static final void writeDelivery(File file, InputStream inputStream) throws Exception {
        OutputStream outputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream bufferedOutputStream = null;
        try {
            int len;
            bufferedInputStream = new BufferedInputStream(inputStream);
            outputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > 0) {
                ((BufferedOutputStream)bufferedOutputStream).write(buffer, 0, len);
            }
            outputStream.flush();
            ((BufferedOutputStream)bufferedOutputStream).flush();
        }
        finally {
            if (bufferedOutputStream != null) {
                try {
                    bufferedOutputStream.close();
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }
}

