/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.repository;

import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface IDeliveryRepositoryPlugin {
    public File getDeliveryContent(DeliveryInfo var1) throws Exception;

    public Map<String, DeliveryInfo> getDeliveriesInfo(boolean var1) throws Exception;

    public DeliveryInfo getDeliveryInfo(String var1) throws Exception;

    public DeliveryInfo putDelivery(InputStream var1, String var2) throws Exception;

    public void removeDelivery(String var1) throws Exception;

    public IDeliveryRepositoryInfo getInfos();

    public void setCacheFolder(File var1);

    public static final class DeliveryDelta
    implements IDeliveryDelta {
        private Set<String> created = new HashSet<String>();
        private Set<String> updated = new HashSet<String>();
        private Set<String> removed = new HashSet<String>();

        @Override
        public final Set<String> getCreatedOrUpdated() {
            HashSet<String> createdOrUpdated = new HashSet<String>(this.created);
            createdOrUpdated.addAll(this.updated);
            return createdOrUpdated;
        }

        @Override
        public final Set<String> getCreated() {
            return this.created;
        }

        @Override
        public final Set<String> getUpdated() {
            return this.updated;
        }

        @Override
        public final Set<String> getRemoved() {
            return this.removed;
        }

        public final String toString() {
            return "created=" + this.created + " updated=" + this.updated + " removed=" + this.removed;
        }
    }

    public static final class DeliveryInfo {
        private String name;
        private String version;
        private String id;
        private long lastModified;
        private File File;

        public final String getName() {
            return this.name;
        }

        public final String getVersion() {
            return this.version;
        }

        public final String getId() {
            return this.id;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public final String toString() {
            return "name=" + this.name + " id=" + this.id + " version=" + this.version + " lastModified=" + this.lastModified;
        }

        public File getFile() {
            return this.File;
        }

        public void setFile(File file) {
            this.File = file;
        }
    }

    public static interface IDeliveryDelta {
        public Set<String> getCreatedOrUpdated();

        public Set<String> getCreated();

        public Set<String> getUpdated();

        public Set<String> getRemoved();
    }

    public static enum Status {
        exists,
        identical,
        notexists;

    }
}

