/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.rest.dto.schedule;

import com.indy.engine.core.common.objects2.IEngineScheduleDetail;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ScheduleDto {
    private String scheduleName;
    private String jobName;
    private String triggerName;
    private String sessionName;
    private String deliveryName;
    private String purgeSize;
    private String purgeUnit;
    private String triggerState;
    private String cronExpression;
    private String configuration;
    private String host;
    private Integer port;
    private Integer repeatCount = 0;
    private Long repeatInterval = 0L;
    private Integer executionType = 0;
    private Date startTime;
    private Date endTime;
    private Date nextExecution;
    private Date lastExecution;
    private List<ScheduleDto> scheduleList;

    public ScheduleDto(Map<String, Object> map) {
        ArrayList schedList = (ArrayList)map.get("listSchedules");
        if (schedList != null) {
            this.scheduleList = schedList.stream().map(ScheduleDto::new).collect(Collectors.toList());
        }
        this.scheduleName = (String)map.get("scheduleName");
        this.jobName = (String)map.get("jobName");
        this.triggerName = (String)map.get("triggerName");
        this.sessionName = (String)map.get("sessionName");
        this.deliveryName = (String)map.get("deliveryName");
        this.purgeSize = (String)map.get("purgeSize");
        this.purgeUnit = (String)map.get("purgeUnit");
        this.triggerState = (String)map.get("triggerState");
        this.cronExpression = (String)map.get("cronExpression");
        this.configuration = (String)map.get("configuration");
        this.host = (String)map.get("host");
        this.port = map.get("port") != null ? Integer.valueOf(Integer.parseInt((String)map.get("port"))) : null;
        this.repeatCount = (Integer)map.get("repeatCount");
        this.repeatInterval = (Long)map.get("repeatInterval");
        this.executionType = (Integer)map.get("executionType");
        this.startTime = (Date)map.get("startTime");
        this.endTime = (Date)map.get("endTime");
        this.nextExecution = (Date)map.get("nextExecution");
        this.lastExecution = (Date)map.get("lastExecution");
    }

    public ScheduleDto() {
    }

    public ScheduleDto(IEngineScheduleDetail esd) {
        this.scheduleName = esd.getScheduleName();
        this.jobName = esd.getJobName();
        this.triggerName = esd.getTriggerName();
        this.sessionName = esd.getSessionName();
        this.deliveryName = esd.getDeliveryName();
        this.purgeSize = esd.getPurgeSize();
        this.purgeUnit = esd.getPurgeUnit();
        this.triggerState = esd.getTriggerState();
        this.cronExpression = esd.getConfiguration();
        this.configuration = esd.getConfiguration();
        this.host = esd.getHost();
        this.port = esd.getPort();
        this.repeatCount = esd.getRepeatCount();
        this.repeatInterval = esd.getRepeatInterval();
        this.executionType = esd.getExecutionType();
        this.startTime = esd.getStartTime();
        this.endTime = esd.getEndTime();
        this.nextExecution = esd.getNextExecution();
        this.lastExecution = esd.getLastExecution();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scheduleName", this.scheduleName);
        map.put("jobName", this.jobName);
        map.put("triggerName", this.triggerName);
        map.put("sessionName", this.sessionName);
        map.put("deliveryName", this.deliveryName);
        map.put("purgeSize", this.purgeSize);
        map.put("purgeUnit", this.purgeUnit);
        map.put("triggerState", this.triggerState);
        map.put("cronExpression", this.cronExpression);
        map.put("configuration", this.configuration);
        map.put("host", this.host);
        map.put("port", this.port);
        map.put("repeatCount", this.repeatCount);
        map.put("repeatInterval", this.repeatInterval);
        map.put("executionType", this.executionType);
        map.put("startTime", this.startTime);
        map.put("endTime", this.endTime);
        map.put("nextExecution", this.nextExecution);
        map.put("lastExecution", this.lastExecution);
        if (this.scheduleList != null) {
            map.put("listSchedules", this.scheduleList.stream().map(ScheduleDto::toMap).collect(Collectors.toList()));
        }
        return map;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getDeliveryName() {
        return this.deliveryName;
    }

    public void setDeliveryName(String deliveryName) {
        this.deliveryName = deliveryName;
    }

    public String getPurgeSize() {
        return this.purgeSize;
    }

    public void setPurgeSize(String purgeSize) {
        this.purgeSize = purgeSize;
    }

    public String getPurgeUnit() {
        return this.purgeUnit;
    }

    public void setPurgeUnit(String purgeUnit) {
        this.purgeUnit = purgeUnit;
    }

    public String getTriggerState() {
        return this.triggerState;
    }

    public void setTriggerState(String triggerState) {
        this.triggerState = triggerState;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Long getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(Long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public Integer getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(Integer executionType) {
        this.executionType = executionType;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getNextExecution() {
        return this.nextExecution;
    }

    public void setNextExecution(Date nextExecution) {
        this.nextExecution = nextExecution;
    }

    public Date getLastExecution() {
        return this.lastExecution;
    }

    public void setLastExecution(Date lastExecution) {
        this.lastExecution = lastExecution;
    }
}

