/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.file;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class DelimitedFileWriter {
    String encoding = "UTF-8";
    String stringDelimiter = "\"";
    String stringDelimiterReplacment = "\"\"";
    String rowSeparator = "\n";
    String rowSeparatorReplacment = null;
    String fieldSeparator = ",";
    String stringNullReplacment = "";
    String stringEmptyReplacment = "";
    Writer writer;
    boolean recordEnded = true;
    int numField;
    int numLine;
    long fileSize;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setStringDelimiter(String stringDelimiter, String stringDelimiterReplacment) {
        this.stringDelimiter = stringDelimiter;
        this.stringDelimiterReplacment = stringDelimiterReplacment;
    }

    public void setRowSeparator(String rowSeparator, String rowSeparatorReplacment) {
        this.rowSeparator = rowSeparator;
        this.rowSeparatorReplacment = rowSeparatorReplacment;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setStringNullReplacment(String stringNullReplacment) {
        this.stringNullReplacment = stringNullReplacment;
    }

    public void setStringEmptyReplacment(String stringEmptyReplacment) {
        this.stringEmptyReplacment = stringEmptyReplacment;
    }

    public DelimitedFileWriter(OutputStream os) throws UnsupportedEncodingException {
        this.writer = new OutputStreamWriter(os, this.encoding);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void writeString(String value) throws IOException {
        if (value == null) {
            value = this.stringNullReplacment;
        }
        if (value.isEmpty()) {
            value = this.stringEmptyReplacment;
        }
        if (this.stringDelimiter != null) {
            if (this.stringDelimiterReplacment != null) {
                String str = value.replace(this.stringDelimiter, this.stringDelimiterReplacment);
                this.writeField(String.valueOf(this.stringDelimiter) + str + this.stringDelimiter);
            } else {
                this.writeField(String.valueOf(this.stringDelimiter) + value + this.stringDelimiter);
            }
        } else {
            this.writeField(value);
        }
    }

    public void writeBytes(byte[] bytes, String encoding) throws IOException {
        if (encoding != null) {
            this.writeString(new String(bytes, encoding));
        } else {
            this.writeString(new String(bytes));
        }
    }

    public void endRecord() throws IOException {
        if (this.numField > 0) {
            this._write(this.rowSeparator);
        }
        this.numField = 0;
    }

    private void writeField(String str) throws IOException {
        if (this.numField > 0) {
            this._write(this.fieldSeparator);
        }
        if (this.rowSeparatorReplacment != null) {
            this._write(str.replace(this.rowSeparator, this.rowSeparatorReplacment));
        } else {
            this._write(str);
        }
        ++this.numField;
    }

    public static void main(String[] args) {
        System.out.println("\n".replace("\n", "\\\\n"));
    }

    private void _write(String str) throws IOException {
        this.writer.write(str);
        this.fileSize += (long)str.length();
    }
}

