/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.hierarchy;

import com.indy.engine.actionCodes.utils.BidiMap;
import com.indy.runtime.hierarchy.HierarchyEvent;
import com.indy.runtime.hierarchy.HierarchyEventFactory;
import com.indy.runtime.hierarchy.HierarchyEventWriter;
import com.indy.runtime.hierarchy.IXMLConverter;
import com.indy.runtime.hierarchy.Messages;
import com.indy.runtime.hierarchy.event.EndDocumentEvent;
import com.indy.runtime.hierarchy.event.EndElementEvent;
import com.indy.runtime.hierarchy.event.StartDocumentEvent;
import com.indy.runtime.hierarchy.event.StartElementEvent;
import com.indy.runtime.json.JsonConstants;
import com.indy.runtime.xml.AbstractXMLEventReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public abstract class HierarchyEventReader {
    final XMLEventFactory eventFactory = XMLEventFactory.newFactory();
    Stack<HierarchyEvent> containerStack = new Stack();
    List<XMLEvent> xmlEventStack = new ArrayList<XMLEvent>();

    public abstract HierarchyEvent nextHierarchyEvent() throws Exception;

    void fill(StartElementEvent event, boolean isRoot, IXMLConverter converter) throws Exception {
        Attribute attr;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String data = null;
        if (event.getType() != Integer.MIN_VALUE) {
            attr = this.eventFactory.createAttribute(JsonConstants.XML_TYPE, converter.getTypeName(event.getType()));
            attributes.add(attr);
        }
        if (event.isNull()) {
            attr = this.eventFactory.createAttribute(JsonConstants.XML_NIL, "true");
            attributes.add(attr);
        } else if (event.getStringData() != null) {
            data = event.getStringData();
        } else if (event.getData() != null) {
            data = converter.printData(event.getType(), event.getData());
        }
        this.xmlEventStack.add(this.eventFactory.createStartElement("", null, event.name, attributes.iterator(), Collections.EMPTY_LIST.iterator()));
        if (data != null) {
            this.xmlEventStack.add(this.eventFactory.createCharacters(data));
        }
        if (isRoot) {
            this.xmlEventStack.add(this.eventFactory.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        }
    }

    void fill(EndElementEvent event) {
        this.xmlEventStack.add(this.eventFactory.createEndElement("", null, event.name));
    }

    private void fill(EndDocumentEvent asEndDocumentEvent) {
        this.xmlEventStack.add(this.eventFactory.createEndDocument());
    }

    private void fill(StartDocumentEvent asStartDocumentEvent) {
        this.xmlEventStack.add(this.eventFactory.createStartDocument());
    }

    public static void main(String[] args) throws Exception {
        final BidiMap map = new BidiMap();
        map.put((Object)1, "string");
        map.put((Object)2, "array");
        map.put((Object)3, "record");
        map.put((Object)4, "int");
        map.put((Object)5, "long");
        map.put((Object)6, "bytes");
        map.put((Object)7, "float");
        map.put((Object)8, "boolean");
        map.put((Object)9, "double");
        IXMLConverter converter = new IXMLConverter(){

            @Override
            public String printData(int type, Object data) {
                switch (type) {
                    case 4: {
                        return DatatypeConverter.printInt((int)((Integer)data));
                    }
                    case 1: {
                        return DatatypeConverter.printString((String)((String)data));
                    }
                    case 5: {
                        return DatatypeConverter.printLong((long)((Long)data));
                    }
                    case 6: {
                        return DatatypeConverter.printBase64Binary((byte[])((byte[])data));
                    }
                    case 7: {
                        return DatatypeConverter.printFloat((float)((Float)data).floatValue());
                    }
                    case 8: {
                        return DatatypeConverter.printBoolean((boolean)((Boolean)data));
                    }
                    case 9: {
                        return DatatypeConverter.printDouble((double)((Double)data));
                    }
                }
                return null;
            }

            @Override
            public Object parseData(int type, String data) {
                switch (type) {
                    case 4: {
                        return DatatypeConverter.parseInt((String)data);
                    }
                    case 1: {
                        return DatatypeConverter.parseString((String)data);
                    }
                    case 5: {
                        return DatatypeConverter.parseLong((String)data);
                    }
                    case 6: {
                        return DatatypeConverter.parseBase64Binary((String)data);
                    }
                    case 7: {
                        return Float.valueOf(DatatypeConverter.parseFloat((String)data));
                    }
                    case 8: {
                        return DatatypeConverter.parseBoolean((String)data);
                    }
                    case 9: {
                        return DatatypeConverter.parseDouble((String)data);
                    }
                }
                return null;
            }

            @Override
            public String getTypeName(int type) {
                return (String)map.getTo(type);
            }

            @Override
            public int getTypeCode(String type) {
                return (Integer)map.getFrom(type);
            }

            @Override
            public boolean isArrayType(int type) {
                return type == 2;
            }

            @Override
            public boolean isDataType(int type) {
                return type != 2 && type != 3;
            }
        };
        HierarchyEventFactory hef = HierarchyEventFactory.newFactory();
        final ArrayList<HierarchyEvent> list = new ArrayList<HierarchyEvent>();
        list.add(hef.createStartDocument());
        list.add(hef.createStartElement("root", Integer.MIN_VALUE, false));
        list.add(hef.createStartElement("records", converter.getTypeCode("array"), true));
        list.add(hef.createStartElement("record", converter.getTypeCode("record"), false));
        list.add(hef.createData("field1", converter.getTypeCode("string"), "hello"));
        list.add(hef.createEndElement("field1"));
        list.add(hef.createData("int", converter.getTypeCode("int"), 1));
        list.add(hef.createEndElement("int"));
        list.add(hef.createData("float", converter.getTypeCode("float"), Float.valueOf(1.0f)));
        list.add(hef.createEndElement("float"));
        list.add(hef.createData("long", converter.getTypeCode("long"), 1L));
        list.add(hef.createEndElement("long"));
        list.add(hef.createData("double", converter.getTypeCode("double"), 1.0));
        list.add(hef.createEndElement("double"));
        list.add(hef.createData("boolean", converter.getTypeCode("boolean"), true));
        list.add(hef.createEndElement("boolean"));
        list.add(hef.createData("bytes", converter.getTypeCode("bytes"), "hello".getBytes()));
        list.add(hef.createEndElement("bytes"));
        list.add(hef.createData("field3", converter.getTypeCode("string"), "hello"));
        list.add(hef.createEndElement("field3"));
        list.add(hef.createData("field3", converter.getTypeCode("string"), "hello"));
        list.add(hef.createEndElement("field3"));
        list.add(hef.createEndElement("record"));
        list.add(hef.createStartElement("record", converter.getTypeCode("record"), false));
        list.add(hef.createData("field1", converter.getTypeCode("string"), "hello"));
        list.add(hef.createEndElement("field1"));
        list.add(hef.createData("field2", converter.getTypeCode("string"), "hello"));
        list.add(hef.createEndElement("field2"));
        list.add(hef.createData("field3", converter.getTypeCode("string"), "hello"));
        list.add(hef.createEndElement("field3"));
        list.add(hef.createData("field3", converter.getTypeCode("string"), "hello"));
        list.add(hef.createEndElement("field3"));
        list.add(hef.createEndElement("record"));
        list.add(hef.createEndElement("records"));
        list.add(hef.createEndElement("root"));
        list.add(hef.createEndDocument());
        final int[] index = new int[]{0};
        XMLEventReader reader = new HierarchyEventReader(){

            @Override
            public HierarchyEvent nextHierarchyEvent() {
                if (index[0] < list.size()) {
                    int n = index[0];
                    index[0] = n + 1;
                    return (HierarchyEvent)list.get(n);
                }
                return null;
            }

            @Override
            public void close() throws XMLStreamException {
            }
        }.creatXMLEventReader(converter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLOutputFactory.newFactory().createXMLEventWriter(baos);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            writer.add(event);
            writer.flush();
        }
        writer.close();
        System.out.println(baos.toString());
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        reader = factory.createXMLEventReader(new ByteArrayInputStream(baos.toByteArray()));
        final ArrayList list2 = new ArrayList();
        HierarchyEventWriter hew = new HierarchyEventWriter(){

            @Override
            public void handle(HierarchyEvent event) {
                if (event != null) {
                    list2.add(event);
                }
            }

            @Override
            public void close() throws XMLStreamException {
            }
        };
        hew.disableFirstRoot = false;
        writer = hew.createXMLEventWriter(converter);
        while (reader.hasNext()) {
            writer.add(reader.nextEvent());
            writer.flush();
        }
        writer.close();
        if (list.size() != list2.size()) {
            throw new Exception(Messages.getString("HierarchyEventReader.0"));
        }
        int i = 0;
        while (i < list.size()) {
            if (!((HierarchyEvent)list.get(i)).equals((HierarchyEvent)list2.get(i))) {
                throw new Exception(Messages.getString("HierarchyEventReader.1"));
            }
            ++i;
        }
        index = new int[]{0};
        reader = new HierarchyEventReader(){

            @Override
            public HierarchyEvent nextHierarchyEvent() {
                if (index[0] < list.size()) {
                    int n = index[0];
                    index[0] = n + 1;
                    return (HierarchyEvent)list.get(n);
                }
                return null;
            }

            @Override
            public void close() throws XMLStreamException {
            }
        }.creatXMLEventReader(converter);
        final ArrayList list22 = new ArrayList();
        HierarchyEventWriter hew2 = new HierarchyEventWriter(){

            @Override
            public void handle(HierarchyEvent event) {
                if (event != null) {
                    list22.add(event);
                }
            }

            @Override
            public void close() throws XMLStreamException {
            }
        };
        hew2.disableFirstRoot = false;
        XMLEventWriter writer2 = hew2.createXMLEventWriter(converter);
        while (reader.hasNext()) {
            writer2.add(reader.nextEvent());
            writer2.flush();
        }
        writer2.close();
        if (list.size() != list22.size()) {
            throw new Exception(Messages.getString("HierarchyEventReader.2"));
        }
        int i2 = 0;
        while (i2 < list.size()) {
            if (!((HierarchyEvent)list.get(i2)).equals((HierarchyEvent)list22.get(i2))) {
                throw new Exception(Messages.getString("HierarchyEventReader.3"));
            }
            ++i2;
        }
    }

    public XMLEventReader creatXMLEventReader(final IXMLConverter converter) throws Exception {
        return new AbstractXMLEventReader(){

            @Override
            protected XMLEvent doNextEvent() throws XMLStreamException {
                HierarchyEvent next;
                if (!HierarchyEventReader.this.xmlEventStack.isEmpty()) {
                    return HierarchyEventReader.this.xmlEventStack.remove(0);
                }
                try {
                    next = HierarchyEventReader.this.nextHierarchyEvent();
                }
                catch (Exception e) {
                    throw new XMLStreamException(e);
                }
                if (next == null) {
                    return null;
                }
                if (next.isStartElementEvent()) {
                    try {
                        HierarchyEventReader.this.fill(next.asStartElementEvent(), HierarchyEventReader.this.containerStack.isEmpty(), converter);
                    }
                    catch (Exception e) {
                        throw new XMLStreamException(e);
                    }
                    HierarchyEventReader.this.containerStack.add(next);
                } else if (next.isEndElementEvent()) {
                    StartElementEvent e = HierarchyEventReader.this.containerStack.pop().asStartElementEvent();
                    if (!HierarchyEvent.objectEquals(e.name, next.asEndElementEvent().name)) {
                        throw new XMLStreamException(Messages.getString("HierarchyEventReader.4"));
                    }
                    HierarchyEventReader.this.fill(next.asEndElementEvent());
                } else if (next.isStartDocumentEvent()) {
                    HierarchyEventReader.this.fill(next.asStartDocumentEvent());
                } else if (next.isEndDocumentEvent()) {
                    HierarchyEventReader.this.fill(next.asEndDocumentEvent());
                }
                if (!HierarchyEventReader.this.xmlEventStack.isEmpty()) {
                    return HierarchyEventReader.this.xmlEventStack.remove(0);
                }
                return null;
            }

            @Override
            public void close() throws XMLStreamException {
                HierarchyEventReader.this.close();
            }
        };
    }

    public abstract void close() throws XMLStreamException;
}

