/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.engine.core.IJsonUtils;
import com.indy.engine.core.json.annotation.DateFormatter;
import com.indy.engine.core.json.annotation.JsonElement;
import com.indy.engine.core.json.annotation.JsonTypeElement;
import com.indy.runtime.json.IDeferedSerialization;
import com.indy.runtime.json.internal.JsonNodeToObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GenericObjectDeserializer {
    private static boolean isTypeAnnotated(Field field) {
        return field.getDeclaringClass().isAnnotationPresent(JsonTypeElement.class);
    }

    private static boolean shouldSerialize(Field field) {
        JsonElement je = field.getAnnotation(JsonElement.class);
        return je != null && !je.deserialiazeOnly() || GenericObjectDeserializer.isTypeAnnotated(field);
    }

    private static boolean shouldDeserialize(Field field) {
        JsonElement je = field.getAnnotation(JsonElement.class);
        return je != null && !je.serialiazeOnly() || GenericObjectDeserializer.isTypeAnnotated(field);
    }

    private static String getJsonName(Field field) {
        JsonElement je = field.getAnnotation(JsonElement.class);
        return je != null ? je.name() : field.getName();
    }

    public static Object serialize(Object v) throws Exception {
        if (v != null) {
            HashMap ret = null;
            Class<?> c = v.getClass();
            Field[] fieldArray = c.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (GenericObjectDeserializer.shouldSerialize(field)) {
                    Object s;
                    HashMap<Object, Object> o;
                    if (ret == null) {
                        ret = new HashMap();
                    }
                    if ((o = field.get(v)) == null) {
                        s = null;
                    } else if (o instanceof Map) {
                        HashMap<Object, Object> map = new HashMap<Object, Object>();
                        for (Map.Entry entry : ((Map)o).entrySet()) {
                            map.put(GenericObjectDeserializer.serialize(entry.getKey()), GenericObjectDeserializer.serialize(entry.getValue()));
                        }
                        s = map;
                    } else if (o instanceof List) {
                        ArrayList list = o instanceof JsonNodeToObject.IterativeValueArrayList ? new JsonNodeToObject.IterativeValueArrayList() : new ArrayList();
                        for (Map.Entry entry : (List)((Object)o)) {
                            list.add(GenericObjectDeserializer.serialize(entry));
                        }
                        s = list;
                    } else if (o instanceof Iterator) {
                        if (o instanceof IDeferedSerialization) {
                            final Iterator ait = (Iterator)((Object)o);
                            Iterator it = new Iterator(){
                                boolean last = false;

                                @Override
                                public boolean hasNext() {
                                    boolean b = ait.hasNext();
                                    return b;
                                }

                                public Object next() {
                                    Object o = ait.next();
                                    try {
                                        return GenericObjectDeserializer.serialize(o);
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            };
                            s = ait;
                        } else {
                            s = o;
                        }
                    } else {
                        s = o.getClass().isEnum() ? ((Object)o).toString() : (o instanceof IJsonUtils.Adapter ? o : GenericObjectDeserializer.serialize(o));
                    }
                    ret.put(GenericObjectDeserializer.getJsonName(field), s);
                }
                ++n2;
            }
            if (ret != null) {
                return ret;
            }
            if (c == Date.class && c.isAnnotationPresent(DateFormatter.class)) {
                SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-DD'T'HH:mm:ss.sssZ");
                return df.format(v);
            }
            return v;
        }
        return v;
    }

    private static void setField(Field field, Object target, Object value) throws Exception {
        boolean isPrivate = !field.isAccessible();
        field.setAccessible(true);
        field.set(target, value);
        field.setAccessible(isPrivate);
    }

    public static Object deserialize(Class clazz, Object v) throws Exception {
        if (v instanceof Map) {
            Map map = (Map)v;
            Object targetObject = clazz.newInstance();
            Class c = clazz;
            if (c.equals(Object.class)) {
                return v;
            }
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value;
                Field field = fieldArray[n2];
                if (GenericObjectDeserializer.shouldDeserialize(field) && (value = map.get(GenericObjectDeserializer.getJsonName(field))) != null) {
                    if (value instanceof Map) {
                        if (field.getType() == Map.class) {
                            Map map1 = (Map)value;
                            HashMap<Object, Object> map2 = new HashMap<Object, Object>();
                            ParameterizedType type = (ParameterizedType)field.getGenericType();
                            Type type1 = type.getActualTypeArguments()[0];
                            Type type2 = type.getActualTypeArguments()[1];
                            for (Map.Entry entry : map1.entrySet()) {
                                map2.put(GenericObjectDeserializer.deserialize((Class)type1, entry.getKey()), GenericObjectDeserializer.deserialize((Class)type2, entry.getValue()));
                            }
                            GenericObjectDeserializer.setField(field, targetObject, map2);
                        } else if (field.getType() == Object.class) {
                            field.set(targetObject, value);
                        } else {
                            GenericObjectDeserializer.setField(field, targetObject, GenericObjectDeserializer.deserialize(field.getType(), value));
                        }
                    } else if (value instanceof List) {
                        ArrayList list = value instanceof JsonNodeToObject.IterativeValueArrayList ? new JsonNodeToObject.IterativeValueArrayList() : new ArrayList();
                        GenericObjectDeserializer.setField(field, targetObject, list);
                        ParameterizedType type = (ParameterizedType)field.getGenericType();
                        Type type2 = type.getActualTypeArguments()[0];
                        for (Object o : (List)value) {
                            list.add(GenericObjectDeserializer.deserialize((Class)type2, o));
                        }
                    } else {
                        Object oo = null;
                        if (field.getType() == Date.class) {
                            Annotation[] aa = field.getAnnotations();
                            if (field.isAnnotationPresent(DateFormatter.class)) {
                                SimpleDateFormat df = new SimpleDateFormat("YYYY-MM-DD'T'HH:mm:ss.sssZ");
                                oo = df.parse((String)value);
                            }
                        } else {
                            oo = GenericObjectDeserializer.deserialize(field.getType(), value);
                        }
                        if (oo != null) {
                            if (field.getType() == List.class) {
                                List list = (List)field.get(targetObject);
                                if (list == null) {
                                    list = new JsonNodeToObject.IterativeValueArrayList();
                                    GenericObjectDeserializer.setField(field, targetObject, list);
                                }
                                list.add(oo);
                            } else {
                                GenericObjectDeserializer.setField(field, targetObject, oo);
                            }
                        }
                    }
                }
                ++n2;
            }
            return targetObject;
        }
        Class c = clazz;
        if (c.isEnum()) {
            Method method = clazz.getMethod("valueOf", String.class);
            return method.invoke(null, v);
        }
        if ((clazz == Boolean.TYPE || clazz == Boolean.class) && v instanceof String) {
            return Boolean.valueOf((String)v);
        }
        return v;
    }

    public static void main(String[] args) throws Exception {
    }
}

