/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.DatatypeConverter;

public class JSonEvent {
    private String name;
    private Type type;
    int bsonDataType = -2;
    public static final int bson_binary_type = 5;
    public static final int bson_double_type = 1;
    public static final int bson_int_type = 8;
    public static final int bson_boolean_type = 16;
    public static final int bson_datetime_type = 9;
    public static final int bson_long_type = 18;
    public static final int bson_javascript_type = 13;
    public static final int bson_javascript_with_scope_type = 15;
    public static final int bson_symbol_type = 14;
    public static final int bson_regex_type = 11;
    public static final int bson_object_id_type = 7;
    public static final int bson_min_key_type = -1;
    public static final int bson_max_key_type = 127;

    public JSonEvent(Type type, String name, int bsonDataType) {
        this.type = type;
        this.name = name;
        this.bsonDataType = bsonDataType;
    }

    public int getBsonDataType() {
        return this.bsonDataType;
    }

    public String getBsonXmlDataType() {
        if (this.getBsonDataType() != -2) {
            switch (this.getBsonDataType()) {
                case 5: {
                    return "binary";
                }
                case 1: {
                    return "double";
                }
                case 8: {
                    return "int";
                }
                case 16: {
                    return "boolean";
                }
                case 9: {
                    return "datetime";
                }
                case 18: {
                    return "long";
                }
                case 13: {
                    return "bson:javaScript";
                }
                case 15: {
                    return "bson:javaScriptWithScope";
                }
                case 14: {
                    return "bson:symbol";
                }
                case 11: {
                    return "bson:regex";
                }
                case 7: {
                    return "bson:objectId";
                }
                case -1: {
                    return "bson:minKey";
                }
                case 127: {
                    return "bson:maxKey";
                }
            }
            return "string";
        }
        return null;
    }

    public String convertToXmlData() {
        if (this.getBsonDataType() != -2) {
            String data = this.getName();
            switch (this.getBsonDataType()) {
                case 5: {
                    return this.getName();
                }
                case 1: {
                    return this.getName();
                }
                case 8: {
                    return this.getName();
                }
                case 16: {
                    return this.getName();
                }
                case 9: {
                    Calendar cal = GregorianCalendar.getInstance();
                    cal.setTime(new Date(Long.valueOf(data)));
                    return DatatypeConverter.printDateTime((Calendar)cal);
                }
                case 18: {
                    return this.getName();
                }
                case 13: {
                    return this.getName();
                }
                case 15: {
                    return this.getName();
                }
                case 14: {
                    return this.getName();
                }
                case 11: {
                    return this.getName();
                }
                case 7: {
                    return this.getName();
                }
                case -1: {
                    return this.getName();
                }
                case 127: {
                    return this.getName();
                }
            }
            return this.getName();
        }
        return this.getName();
    }

    public JSonEvent(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getType().name());
        if (this.getName() != null) {
            b.append(" -> ");
            b.append(this.getName());
        }
        return b.toString();
    }

    public static JSonEvent createStartArray() {
        return new JSonEvent(Type.START_ARRAY, null);
    }

    public static JSonEvent createEndArray() {
        return new JSonEvent(Type.END_ARRAY, null);
    }

    public static JSonEvent createStartObject() {
        return new JSonEvent(Type.START_OBJECT, null);
    }

    public static JSonEvent createEndObject() {
        return new JSonEvent(Type.END_OBJECT, null);
    }

    public static JSonEvent createStartDocument() {
        return new JSonEvent(Type.START_DOCUMENT, null);
    }

    public static JSonEvent createEndDocument() {
        return new JSonEvent(Type.END_DOCUMENT, null);
    }

    public static JSonEvent createMember(String name) {
        return new JSonEvent(Type.MEMBER, name);
    }

    public static JSonEvent createNewLineCharacter() {
        return new JSonEvent(Type.VALUE, "\n");
    }

    public static JSonEvent createString(String value) {
        return new JSonEvent(Type.STRING, value);
    }

    public static JSonEvent createValue(String value) {
        return new JSonEvent(Type.VALUE, value);
    }

    public static JSonEvent createValue(String value, int bsonDataType) {
        return new JSonEvent(Type.VALUE, value, bsonDataType);
    }

    public static JSonEvent createNull() {
        return new JSonEvent(Type.VALUE, "null");
    }

    public static int getBsonDatatype(String name) {
        if (!name.startsWith("$")) {
            name = "$" + name;
        }
        if (name.equals("$binary")) {
            return 5;
        }
        if (name.equals("$date")) {
            return 9;
        }
        if (name.equals("$numberLong")) {
            return 18;
        }
        if (name.equals("$code")) {
            return 13;
        }
        if (name.equals("$maxKey")) {
            return 127;
        }
        if (name.equals("$minKey")) {
            return -1;
        }
        if (name.equals("$oid")) {
            return 7;
        }
        if (name.equals("$symbol")) {
            return 14;
        }
        if (name.equals("$regex")) {
            return 11;
        }
        if (name.equals("$oid")) {
            return 7;
        }
        return -2;
    }

    public static enum Type {
        START_ARRAY,
        END_ARRAY,
        START_ITEM_ARRAY,
        END_ITEM_ARRAY,
        START_OBJECT,
        END_OBJECT,
        MEMBER,
        STRING,
        VALUE,
        END_DOCUMENT,
        START_DOCUMENT;

    }
}

