/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventWriter;
import com.indy.runtime.json.Messages;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

public class JsonEventReader
implements AutoCloseable {
    protected static final char START_OBJECT = '{';
    protected static final char END_OBJECT = '}';
    protected static final char STRING = '\"';
    protected static final char PAIR_SEPARATOR = ':';
    protected static final char OBJECT_SEPARATOR = ',';
    protected static final char START_ARRAY = '[';
    protected static final char END_ARRAY = ']';
    protected static final char ESCAPE_CHAR = '\\';
    protected int countQuote = 0;
    protected long charCount = 0L;
    protected long lineCount = 0L;
    protected long columnCount = 0L;
    private BufferedReader bufferedReader;
    private LinkedList<JSonEvent> currentQueue = null;
    private Stack<JSonEvent> stack = new Stack();
    private JSonEvent previous;
    private boolean rootIsSimple = false;
    protected boolean allRead = false;
    StringBuffer buf = null;
    JsonEventReader replace;
    boolean bsonStyle;
    boolean addArrayRoot;
    private JSonEvent nextEvent;
    JSonEvent bsonPrevious;
    Map<String, String> inputParams = null;

    public JsonEventReader(Reader reader) throws UnsupportedEncodingException {
        this.bufferedReader = new BufferedReader(reader);
    }

    public JsonEventReader(InputStream is, String charsetname) throws UnsupportedEncodingException {
        this.bufferedReader = charsetname != null ? new BufferedReader(new InputStreamReader(is, charsetname)) : new BufferedReader(new InputStreamReader(is));
    }

    private JSonEvent _readNext() throws Exception {
        String val;
        JSonEvent je;
        if (this.replace != null) {
            je = this.replace.readNext();
            if (je.getType() == JSonEvent.Type.START_DOCUMENT) {
                je = this.replace.readNext();
                return je;
            }
            if (je.getType() == JSonEvent.Type.END_DOCUMENT) {
                this.replace.close();
                this.replace = null;
            } else {
                return je;
            }
        }
        je = this.__readNext();
        if (this.inputParams != null && je.getType() == JSonEvent.Type.VALUE && (val = this.inputParams.get(je.getName())) != null) {
            JsonEventReader jer = new JsonEventReader(new ByteArrayInputStream(val.getBytes("UTF-8")), "UTF-8");
            jer.inputParams = new HashMap<String, String>();
            jer.inputParams.putAll(this.inputParams);
            jer.inputParams.remove(je.getName());
            this.replace = jer;
            je = this.readNext();
        }
        return je;
    }

    public void setBsonStyle(boolean bsonStyle) {
        this.bsonStyle = bsonStyle;
    }

    public void setAddArrayRoot(boolean addArrayRoot) {
        this.addArrayRoot = addArrayRoot;
    }

    public JSonEvent readNext() throws Exception {
        if (this.nextEvent != null) {
            JSonEvent je = this.nextEvent;
            this.nextEvent = null;
            return je;
        }
        JSonEvent je = this.___readNext();
        if (this.addArrayRoot) {
            if (je.getType() == JSonEvent.Type.START_DOCUMENT) {
                this.nextEvent = JSonEvent.createStartArray();
                return je;
            }
            if (je.getType() == JSonEvent.Type.END_DOCUMENT) {
                this.nextEvent = je;
                return JSonEvent.createEndArray();
            }
            return je;
        }
        return je;
    }

    public JSonEvent ___readNext() throws Exception {
        if (this.bsonStyle) {
            return this.bsonReadNext();
        }
        return this._readNext();
    }

    public JSonEvent bsonReadNext() throws Exception {
        if (this.bsonPrevious != null) {
            JSonEvent tmp = this.bsonPrevious;
            this.bsonPrevious = null;
            return tmp;
        }
        JSonEvent event = this._readNext();
        if (event.getType() == JSonEvent.Type.START_OBJECT) {
            JSonEvent tmp = event;
            event = this._readNext();
            if (event.getType() == JSonEvent.Type.MEMBER) {
                String name = event.getName();
                if (name.startsWith("$")) {
                    JSonEvent returnEvent;
                    event = this._readNext();
                    String data = event.getName();
                    int dataType = JSonEvent.getBsonDatatype(name);
                    if (dataType == -2) {
                        returnEvent = event;
                    } else if (event.getType() == JSonEvent.Type.VALUE) {
                        returnEvent = JSonEvent.createValue(data, dataType);
                    } else if (event.getType() == JSonEvent.Type.STRING) {
                        returnEvent = JSonEvent.createValue(data, dataType);
                    } else {
                        throw new Exception(Messages.getString("JsonEventReader.0"));
                    }
                    int i = 1;
                    do {
                        if ((event = this._readNext()).getType() == JSonEvent.Type.START_OBJECT) {
                            ++i;
                            continue;
                        }
                        if (event.getType() != JSonEvent.Type.END_OBJECT) continue;
                        --i;
                    } while (i > 0);
                    return returnEvent;
                }
                this.bsonPrevious = event;
                return tmp;
            }
            this.bsonPrevious = event;
            return tmp;
        }
        return event;
    }

    private JSonEvent __readNext() throws Exception {
        if (this.currentQueue == null) {
            this.currentQueue = new LinkedList();
            this.currentQueue.add(JSonEvent.createStartDocument());
        }
        if (this.currentQueue != null && !this.currentQueue.isEmpty()) {
            this.previous = this.currentQueue.poll();
            return this.previous;
        }
        int i = -1;
        while (!this.allRead && (i = this.bufferedReader.read()) != -1) {
            char c = (char)i;
            ++this.charCount;
            if (c == '\n') {
                ++this.lineCount;
                this.columnCount = 1L;
            } else {
                if (this.lineCount == 0L) {
                    ++this.lineCount;
                }
                ++this.columnCount;
            }
            block1 : switch (c) {
                case '\\': {
                    if (this.countQuote % 2 == 0) {
                        throw new BadJsonFormatException(this.lineCount, this.charCount, Messages.getString("JsonEventReader.1"));
                    }
                    i = this.bufferedReader.read();
                    ++this.charCount;
                    c = (char)i;
                    switch (c) {
                        case 'b': {
                            this.buf.append('\b');
                            break block1;
                        }
                        case 'f': {
                            this.buf.append('\f');
                            break block1;
                        }
                        case 'n': {
                            this.buf.append('\n');
                            break block1;
                        }
                        case 'r': {
                            this.buf.append('\r');
                            break block1;
                        }
                        case 't': {
                            this.buf.append('\t');
                            break block1;
                        }
                        case '\\': {
                            this.buf.append('\\');
                            break block1;
                        }
                        case '\"': {
                            this.buf.append('\"');
                            break block1;
                        }
                        case '/': {
                            this.buf.append("/");
                            break block1;
                        }
                        case 'u': {
                            String charInUnicode = "";
                            int j = 0;
                            while (j < 4 && i != -1) {
                                i = this.bufferedReader.read();
                                ++this.charCount;
                                c = (char)i;
                                charInUnicode = String.valueOf(charInUnicode) + c;
                                ++j;
                            }
                            try {
                                Integer code = Integer.parseInt(charInUnicode, 16);
                                if (code != 0) {
                                    char ch = Character.toChars(code)[0];
                                    this.buf.append(ch);
                                    c = ch;
                                    break block1;
                                }
                                this.buf.append("\\u0000");
                                break block1;
                            }
                            catch (NumberFormatException ex) {
                                throw new Exception(String.valueOf(Messages.getString("JsonEventReader.2")) + charInUnicode + Messages.getString("JsonEventReader.3") + this.lineCount + Messages.getString("JsonEventReader.4") + this.charCount, ex);
                            }
                        }
                    }
                    this.buf.append('\\');
                    this.buf.append(c);
                    break;
                }
                case ',': {
                    if (this.countQuote % 2 == 0) {
                        if (this.stack.isEmpty()) {
                            throw new BadJsonFormatException(this.lineCount, this.charCount, Messages.getString("JsonEventReader.5"));
                        }
                        if (this.buf == null) break;
                        this.currentQueue.add(JSonEvent.createValue(this.buf.toString()));
                        this.buf = null;
                        break;
                    }
                    this.buf.append(c);
                    break;
                }
                case ':': {
                    if (this.countQuote % 2 == 0) {
                        if (this.stack.isEmpty() || this.stack.peek().getType() != JSonEvent.Type.START_OBJECT) {
                            throw new BadJsonFormatException(this.lineCount, this.charCount, Messages.getString("JsonEventReader.6"));
                        }
                        if (this.buf == null) break;
                        this.currentQueue.add(JSonEvent.createMember(this.buf.toString()));
                        this.buf = null;
                        break;
                    }
                    this.buf.append(c);
                    break;
                }
                case '[': {
                    if (this.countQuote % 2 == 0) {
                        if (this.rootIsSimple) {
                            throw new BadJsonFormatException(this.lineCount, this.charCount, Messages.getString("JsonEventReader.7"));
                        }
                        if (this.buf != null) {
                            throw new BadJsonFormatException(this.lineCount, this.charCount, Messages.getString("JsonEventReader.8"));
                        }
                        this.currentQueue.add(JSonEvent.createStartArray());
                        this.stack.push(this.currentQueue.peekLast());
                        break;
                    }
                    this.buf.append(c);
                    break;
                }
                case ']': {
                    if (this.countQuote % 2 == 0) {
                        if (this.buf != null) {
                            this.currentQueue.add(JSonEvent.createValue(this.buf.toString()));
                            this.buf = null;
                        }
                        this.currentQueue.add(JSonEvent.createEndArray());
                        this.stack.pop();
                        break;
                    }
                    this.buf.append(c);
                    break;
                }
                case '{': {
                    if (this.countQuote % 2 == 0) {
                        if (this.buf != null) {
                            throw new Exception(Messages.getString("JsonEventReader.9"));
                        }
                        this.currentQueue.add(JSonEvent.createStartObject());
                        this.stack.push(this.currentQueue.peekLast());
                        break;
                    }
                    this.buf.append(c);
                    break;
                }
                case '}': {
                    if (this.countQuote % 2 == 0) {
                        if (this.buf != null) {
                            this.currentQueue.add(JSonEvent.createValue(this.buf.toString()));
                            this.buf = null;
                        }
                        this.currentQueue.add(JSonEvent.createEndObject());
                        this.stack.pop();
                        break;
                    }
                    this.buf.append(c);
                    break;
                }
                case '\"': {
                    if (this.countQuote % 2 == 0) {
                        if (this.buf != null) {
                            throw new Exception(String.valueOf(Messages.getString("JsonEventReader.10")) + this.buf.toString() + Messages.getString("JsonEventReader.11"));
                        }
                        this.buf = new StringBuffer();
                    } else if (this.previous != null && this.previous.getType() == JSonEvent.Type.MEMBER || !this.stack.isEmpty() && this.stack.peek().getType() == JSonEvent.Type.START_ARRAY) {
                        this.currentQueue.add(JSonEvent.createString(this.buf.toString()));
                        this.buf = null;
                    } else if (this.stack.isEmpty()) {
                        this.rootIsSimple = true;
                        this.currentQueue.add(JSonEvent.createString(this.buf.toString()));
                        this.buf = null;
                    }
                    ++this.countQuote;
                    if (this.countQuote % 2 != 0) break;
                    this.countQuote = 0;
                    break;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        if (this.countQuote % 2 != 1) break;
                        this.buf.append(c);
                        break;
                    }
                    if (this.buf == null) {
                        this.buf = new StringBuffer();
                    }
                    this.buf.append(c);
                }
            }
            if (!this.currentQueue.isEmpty()) break;
        }
        if (i == -1) {
            this.allRead = true;
            if (this.buf != null && this.buf.length() > 0) {
                this.currentQueue.add(JSonEvent.createValue(this.buf.toString().trim()));
            }
            this.currentQueue.add(JSonEvent.createEndDocument());
            if (!this.stack.isEmpty()) {
                String message = null;
                message = this.stack.peek().getType() == JSonEvent.Type.START_ARRAY ? Messages.getString("JsonEventReader.12") : (this.stack.peek().getType() == JSonEvent.Type.START_OBJECT ? Messages.getString("JsonEventReader.13") : Messages.getString("JsonEventReader.14"));
                throw new BadJsonFormatException(message);
            }
        }
        this.previous = this.currentQueue.poll();
        return this.previous;
    }

    public boolean hasNext() {
        if (this.bsonStyle) {
            if (this.bsonPrevious != null) {
                return true;
            }
            return this._hasNext();
        }
        return this._hasNext();
    }

    private boolean _hasNext() {
        return !this.allRead || !this.currentQueue.isEmpty();
    }

    @Override
    public void close() throws IOException {
        this.bufferedReader.close();
    }

    public static void main(String[] args) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream("{\"value\":param}".getBytes());
            JsonEventReader eventReader = new JsonEventReader(is, null);
            eventReader.setInputJsonParam("param", "{\"val02\":param2}");
            eventReader.setInputJsonParam("param2", "{\"val02\":param}");
            JsonEventWriter writer = new JsonEventWriter(System.out, null);
            while (eventReader.hasNext()) {
                JSonEvent ev = eventReader.readNext();
                writer.add(ev);
            }
            writer.flush();
            ((InputStream)is).close();
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setInputJsonParam(String string2, String json) {
        if (this.inputParams == null) {
            this.inputParams = new HashMap<String, String>();
        }
        this.inputParams.put(string2, json);
    }

    public void setInputStringParam(String string2, String string3) {
        this.setInputJsonParam(string2, "\"" + string3 + "\"");
    }

    private static class BadJsonFormatException
    extends Exception {
        public BadJsonFormatException(String message) {
            super(message);
        }

        public BadJsonFormatException(long lineCount, long charCount, String message) {
            super(String.valueOf(message) + " at line=" + lineCount + " charPos=" + charCount);
        }
    }
}

