/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonConstants;
import com.indy.runtime.json.JsonEventWriter;
import com.indy.runtime.json.JsonNodeImpl;
import com.indy.runtime.json.JsonUtils;
import com.indy.runtime.json.JsonXmlEventReader;
import com.indy.runtime.json.Messages;
import com.indy.runtime.json.internal.XMLArrayTransformer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class JsonNode {
    public abstract boolean isObject();

    public abstract boolean isArray();

    public abstract boolean isString();

    public abstract boolean isNumber();

    public abstract boolean isBoolean();

    public abstract String getString();

    public abstract Boolean getBoolean();

    public abstract Number getNumber();

    public abstract boolean isNull();

    public abstract int length();

    public abstract JsonNode get(int var1);

    public abstract boolean exists(String var1);

    public abstract Collection<String> keys();

    public abstract JsonNode get(String var1);

    public abstract boolean isNull(String var1);

    public abstract boolean isNull(int var1);

    public abstract void add(JsonNode var1);

    public abstract void add(String var1, JsonNode var2);

    public abstract void setString(String var1);

    public abstract void setBoolean(Boolean var1);

    public abstract void setNumber(Number var1);

    public abstract void setNull();

    public static JsonNode createArrayNode() {
        return new JsonNodeImpl.JsonArray();
    }

    public static JsonNode createObjectNode() {
        return new JsonNodeImpl.JsonObject();
    }

    public static JsonNode createValueNode(Object value) {
        JsonNodeImpl.JsonValue node = new JsonNodeImpl.JsonValue();
        node.value = value;
        return node;
    }

    public static void serialize(JsonNode node, JsonEventWriter writer) throws XMLStreamException {
        if (node.isObject()) {
            writer.add(JSonEvent.createStartObject());
            for (String key : node.keys()) {
                JsonNode child = node.get(key);
                if (child == null) {
                    throw new XMLStreamException(String.valueOf(Messages.getString("JsonNode.0")) + key + Messages.getString("JsonNode.1"));
                }
                writer.add(JSonEvent.createMember(key));
                JsonNode.serialize(child, writer);
            }
            writer.add(JSonEvent.createEndObject());
        } else if (node.isArray()) {
            writer.add(JSonEvent.createStartArray());
            int i = 0;
            while (i < node.length()) {
                JsonNode child = node.get(i);
                JsonNode.serialize(child, writer);
                ++i;
            }
            writer.add(JSonEvent.createEndArray());
        } else if (node.isString()) {
            writer.add(JSonEvent.createString(node.getString()));
        } else if (node.isNull()) {
            writer.add(JSonEvent.createValue("null"));
        } else {
            writer.add(JSonEvent.createValue(node.getString()));
        }
    }

    public static void serialize(Object node, OutputStream outputStream, String charsetName) throws XMLStreamException {
        try (JsonEventWriter jxer = new JsonEventWriter(outputStream, charsetName);){
            JsonNode.serialize(node, jxer);
        }
    }

    public static void serialize(Object node, JsonEventWriter writer) throws XMLStreamException {
        if (node instanceof Date) {
            writer.add(JSonEvent.createValue(String.valueOf(((Date)node).getTime()), 9));
        } else if (node instanceof GregorianCalendar) {
            writer.add(JSonEvent.createValue(String.valueOf(((GregorianCalendar)node).getTime().getTime()), 9));
        } else if (node instanceof Map) {
            writer.add(JSonEvent.createStartObject());
            for (String key : ((Map)node).keySet()) {
                Object child = ((Map)node).get(key);
                writer.add(JSonEvent.createMember(key));
                JsonNode.serialize(child, writer);
            }
            writer.add(JSonEvent.createEndObject());
        } else if (node instanceof List) {
            writer.add(JSonEvent.createStartArray());
            int i = 0;
            while (i < ((List)node).size()) {
                Object child = ((List)node).get(i);
                JsonNode.serialize(child, writer);
                ++i;
            }
            writer.add(JSonEvent.createEndArray());
        } else if (node instanceof String) {
            writer.add(JSonEvent.createString((String)node));
        } else if (node == null) {
            writer.add(JSonEvent.createValue("null"));
        } else {
            writer.add(JSonEvent.createValue(node.toString()));
        }
    }

    public static void serialize(JsonNode node, OutputStream os, String charset) throws XMLStreamException {
        try (JsonEventWriter jxer = new JsonEventWriter(os, charset);){
            JsonNode.serialize(node, jxer);
        }
    }

    public static JsonNode parse(Object node) {
        return JsonUtils.convertObjectToJsonNode(null, node, null);
    }

    public static JsonNode parse(String json, String charset) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(json.getBytes(charset));
        JsonNode node = JsonNode.parse(bais, charset);
        bais.close();
        return node;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonNode parse(InputStream json, String charset) throws Exception {
        void var4_5;
        JsonXmlEventReader jxer = new JsonXmlEventReader(json, charset);
        jxer.setArrayMode(JsonXmlEventReader.ArrayMode.ARRAY_TAG);
        Stack<void> stack = new Stack<void>();
        Object var4_4 = null;
        while (jxer.hasNext()) {
            XMLEvent event = jxer.nextEvent();
            if (event == null) continue;
            if (event.isStartElement()) {
                void var9_11;
                StartElement se = event.asStartElement();
                Attribute type = se.getAttributeByName(JsonConstants.XML_TYPE);
                Attribute nil = se.getAttributeByName(JsonConstants.XML_NIL);
                Object var9_12 = null;
                if (nil != null && nil.getValue().equals("true")) {
                    JsonNodeImpl.JsonValue jv = new JsonNodeImpl.JsonValue();
                    jv.type = -1;
                    JsonNodeImpl.JsonValue jsonValue = jv;
                } else if (type != null) {
                    JsonNodeImpl.JsonValue jv;
                    String lower = type.getValue().toLowerCase();
                    if (lower.equals("string") || lower.equals("qname") || lower.equals("ncname") || lower.equals("name")) {
                        jv = new JsonNodeImpl.JsonValue();
                        jv.type = 0;
                        JsonNodeImpl.JsonValue jsonValue = jv;
                    } else if (lower.equals("int") || lower.equals("integer") || lower.equals("short") || lower.equals("float") || lower.equals("double") || lower.equals("long") || lower.equals("decimal") || lower.equals("byte") || lower.equals("negativeinteger") || lower.equals("nonNegativeinteger") || lower.equals("nonPositiveinteger") || lower.equals("positiveinteger") || lower.equals("unsignedlong") || lower.equals("unsignedint") || lower.equals("unsignedshort") || lower.equals("unsignedbyte")) {
                        jv = new JsonNodeImpl.JsonValue();
                        jv.type = 1;
                        JsonNodeImpl.JsonValue jsonValue = jv;
                    } else if (lower.equals("boolean")) {
                        jv = new JsonNodeImpl.JsonValue();
                        jv.type = 2;
                        JsonNodeImpl.JsonValue jsonValue = jv;
                    } else if (lower.equals("json:object")) {
                        JsonNodeImpl.JsonObject jsonObject = new JsonNodeImpl.JsonObject();
                    } else {
                        if (!lower.equals("json:array")) throw new RuntimeException(Messages.getString("JsonNode.2"));
                        JsonNodeImpl.JsonArray jsonArray = new JsonNodeImpl.JsonArray();
                    }
                } else if (se.getAttributeByName(JsonConstants.JSON_ARRAY) != null) {
                    JsonNodeImpl.JsonArray jsonArray = new JsonNodeImpl.JsonArray();
                } else if (se.getAttributeByName(XMLArrayTransformer.anonymous) == null) {
                    JsonNodeImpl.JsonObject jsonObject = new JsonNodeImpl.JsonObject();
                }
                if (var9_11 == null) throw new RuntimeException(Messages.getString("JsonNode.3"));
                if (var4_5 == null) {
                    void var4_6 = var9_11;
                }
                if (!stack.isEmpty()) {
                    if (((JsonNodeImpl)stack.peek()).isObject()) {
                        JsonNodeImpl.JsonObject parent = (JsonNodeImpl.JsonObject)stack.peek();
                        parent.add(se.getName().toString(), (JsonNode)var9_11);
                    } else if (((JsonNodeImpl)stack.peek()).isArray()) {
                        JsonNodeImpl.JsonArray ja = (JsonNodeImpl.JsonArray)stack.peek();
                        ja.add((JsonNode)var9_11);
                    }
                }
                stack.push(var9_11);
                continue;
            }
            if (event.isCharacters()) {
                JsonNode node = (JsonNode)stack.peek();
                if (!(node instanceof JsonNodeImpl.JsonValue)) throw new RuntimeException(Messages.getString("JsonNode.5"));
                JsonNodeImpl.JsonValue value = (JsonNodeImpl.JsonValue)node;
                if (value.type == 0) {
                    value.setString(event.asCharacters().getData());
                    continue;
                }
                if (value.type == 1) {
                    String data = event.asCharacters().getData();
                    if (data.contains(".")) {
                        value.setNumber(BigDecimal.valueOf(Double.valueOf(event.asCharacters().getData())));
                        continue;
                    }
                    value.setNumber(BigInteger.valueOf(Long.valueOf(event.asCharacters().getData())));
                    continue;
                }
                if (value.type == 2) {
                    value.setBoolean(Boolean.valueOf(event.asCharacters().getData()));
                    continue;
                }
                if (value.type == -1) continue;
                throw new RuntimeException(Messages.getString("JsonNode.4"));
            }
            if (!event.isEndElement()) continue;
            stack.pop();
        }
        return var4_5;
    }

    public abstract Iterator getIterator();
}

