/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.runtime.json.GenericObjectDeserializer;
import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.JsonXmlEventReader;
import com.indy.runtime.json.JsonXmlEventWriter;
import com.indy.runtime.json.internal.JsonNodeToObject;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class JsonUtils {
    static String NameStartChar = "[A-Za-z_]";
    static String NameChar = String.valueOf(NameStartChar) + "|-|\\.|[0-9]";
    static String Name = String.valueOf(NameStartChar) + "(" + NameChar + ")*";

    public static boolean jsonNodeToObject(InputStream is, String encoding, String path, JsonNodeToObject.JsonNodeToObjectHandler handler, Map<String, Object> properties) throws Exception {
        return JsonUtils.jsonNodeToObject(is, encoding, path, handler, properties, false);
    }

    public static boolean jsonNodeToObject(InputStream is, String encoding, String path, JsonNodeToObject.JsonNodeToObjectHandler handler, Map<String, Object> properties, boolean inputXml) throws Exception {
        JsonNodeToObject jnto = new JsonNodeToObject(is, encoding, properties, inputXml);
        return jnto.read(handler, path, null);
    }

    public static boolean jsonNodeToObject(InputStream is, String encoding, String path, JsonNodeToObject.JsonNodeToObjectHandler handler, Map<String, Object> properties, boolean inputXml, Map<String, JsonNodeToObject.JsonNodeToStringHandler> stringHandler) throws Exception {
        JsonNodeToObject jnto = new JsonNodeToObject(is, encoding, properties, inputXml);
        return jnto.read(handler, path, stringHandler);
    }

    public static Object jsonNodeToObject(String str) throws Exception {
        return JsonUtils.jsonNodeToObject(new ByteArrayInputStream(str.getBytes("UTF-8")), "UTF-8");
    }

    public static Object jsonNodeToObject(InputStream is, String encoding) throws Exception {
        return JsonUtils.jsonNodeToObject(is, encoding, Collections.EMPTY_MAP, false);
    }

    public static Object jsonNodeToObject(InputStream is, String encoding, boolean inputXml) throws Exception {
        return JsonUtils.jsonNodeToObject(is, encoding, Collections.EMPTY_MAP, inputXml);
    }

    public static Object jsonNodeToObject(InputStream is, String encoding, Map<String, Object> properties, boolean inputXml) throws Exception {
        JsonNodeToObject jnto = new JsonNodeToObject(is, encoding, properties, inputXml);
        final Object[] obj = new Object[1];
        jnto.read(new JsonNodeToObject.JsonNodeToObjectHandler(){

            @Override
            public void handleNode(Object node) throws IOException {
                obj[0] = node;
            }

            @Override
            public void handleEnd() throws IOException {
            }
        }, "*", null);
        return obj[0];
    }

    public static void convertXmlToJson(InputStream in, OutputStream out, String inEncoding, String outEncoding) throws XMLStreamException, IOException {
        JsonUtils.convertXmlToJson(in, out, inEncoding, outEncoding, 0);
    }

    public static void convertXmlToJson(InputStream in, OutputStream out, String inEncoding, String outEncoding, int startProof) throws XMLStreamException, IOException {
        XMLEventReader reader = null;
        XMLEventWriter writer = null;
        try {
            try {
                XMLInputFactory factory = null;
                try {
                    factory = XMLInputFactory.newFactory();
                }
                catch (NoSuchMethodError e) {
                    factory = XMLInputFactory.newInstance();
                }
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                factory.setProperty("javax.xml.stream.supportDTD", false);
                reader = inEncoding != null ? factory.createXMLEventReader(in, inEncoding) : factory.createXMLEventReader(in);
                writer = new JsonXmlEventWriter(out, outEncoding);
                int proof = -1;
                XMLEventFactory efactory = XMLEventFactory.newFactory();
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    if (event.isStartElement()) {
                        if (++proof < startProof) continue;
                        if (proof == startProof) {
                            writer.add(efactory.createStartDocument());
                        }
                        writer.add(event);
                        continue;
                    }
                    if (event.isEndElement()) {
                        if (proof >= startProof) {
                            writer.add(event);
                            if (proof == startProof) {
                                writer.add(efactory.createEndDocument());
                            }
                        }
                        --proof;
                        continue;
                    }
                    if (event.isStartDocument() || event.isEndDocument()) continue;
                    writer.add(event);
                }
            }
            catch (Exception ex) {
                throw new XMLStreamException(ex);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    static JsonNode convertObjectToJsonNode(JsonNode parent, Object node, String memberName) {
        JsonNode current;
        if (node instanceof List) {
            current = JsonNode.createArrayNode();
            for (Object value : (List)node) {
                JsonUtils.convertObjectToJsonNode(current, value, null);
            }
        } else if (node instanceof Map) {
            current = JsonNode.createObjectNode();
            for (String key : ((Map)node).keySet()) {
                JsonUtils.convertObjectToJsonNode(current, ((Map)node).get(key), key);
            }
        } else {
            current = JsonNode.createValueNode(node);
        }
        if (parent != null) {
            if (memberName != null) {
                parent.add(memberName, current);
            } else {
                parent.add(current);
            }
        }
        return current;
    }

    public static void main(String[] args) throws XMLStreamException, IOException {
        FileInputStream fis = new FileInputStream("D:\\temp\\json\\test.json");
        JsonUtils.convertJsonToXml(fis, System.out, "UTF-8", "UTF-8", false);
    }

    public static void convertJsonToXml(InputStream in, OutputStream out, String inEncoding, String outEncoding, boolean addProcessingInstructionEncoding) throws XMLStreamException, IOException {
        JsonUtils.convertJsonToXml(in, out, inEncoding, outEncoding, addProcessingInstructionEncoding, false, null, "1.0");
    }

    public static void convertJsonToXml(InputStream in, XMLEventWriter writer, String inEncoding, String outEncoding, boolean addProcessingInstructionEncoding, boolean addRootArray, Map<String, String> inputParams, String xmlVersion) throws XMLStreamException, IOException {
        JsonXmlEventReader reader = null;
        try {
            try {
                reader = new JsonXmlEventReader(in, inEncoding);
                if (inputParams != null) {
                    for (String key : inputParams.keySet()) {
                        reader.getReader().setInputJsonParam(key, inputParams.get(key));
                    }
                }
                if (addRootArray) {
                    reader.getReader().setAddArrayRoot(true);
                }
                reader.setArrayMode(JsonXmlEventReader.ArrayMode.ARRAY_TAG);
                reader.setDisableAttributes(false);
                reader.setRootName("root");
                reader.setArrayItemName("e");
                reader.setXmlVersion(xmlVersion);
                if (outEncoding == null || outEncoding.isEmpty()) {
                    if (addProcessingInstructionEncoding) {
                        reader.setEncodingProcessingInstruction(Charset.defaultCharset().name());
                    }
                } else if (addProcessingInstructionEncoding) {
                    reader.setEncodingProcessingInstruction(outEncoding);
                }
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    writer.add(event);
                }
            }
            catch (Exception ex) {
                throw new XMLStreamException(ex);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void convertJsonToXml(InputStream in, OutputStream out, String inEncoding, String outEncoding, boolean addProcessingInstructionEncoding, boolean addRootArray, Map<String, String> inputParams, String xmlVersion) throws XMLStreamException, IOException {
        XMLEventWriter writer;
        if (outEncoding == null || outEncoding.isEmpty()) {
            try {
                writer = XMLOutputFactory.newFactory().createXMLEventWriter(out);
            }
            catch (NoSuchMethodError e) {
                writer = XMLOutputFactory.newInstance().createXMLEventWriter(out);
            }
        } else {
            try {
                writer = XMLOutputFactory.newFactory().createXMLEventWriter(out, outEncoding);
            }
            catch (NoSuchMethodError e) {
                writer = XMLOutputFactory.newInstance().createXMLEventWriter(out, outEncoding);
            }
        }
        JsonUtils.convertJsonToXml(in, writer, inEncoding, outEncoding, addProcessingInstructionEncoding, addRootArray, inputParams, xmlVersion);
    }

    public static boolean checkIfNameIsValid(String name) {
        return name.matches(Name);
    }

    public static String encodeHexString(String sourceText) throws UnsupportedEncodingException {
        String tmp = sourceText;
        byte[] rawData = tmp.getBytes("UTF8");
        StringBuffer hexText = new StringBuffer();
        String initialHex = null;
        int initHexLength = 0;
        int i = 0;
        while (i < rawData.length) {
            int positiveValue = rawData[i] & 0xFF;
            initialHex = Integer.toHexString(positiveValue);
            initHexLength = initialHex.length();
            while (initHexLength++ < 2) {
                hexText.append("0");
            }
            hexText.append(initialHex);
            ++i;
        }
        return hexText.toString().toUpperCase();
    }

    public static String decodeHexString(String hexa) throws UnsupportedEncodingException {
        if (hexa.length() % 2 == 0) {
            String txtInHex = hexa;
            byte[] txtInByte = new byte[txtInHex.length() / 2];
            int j = 0;
            int i = 0;
            while (i < txtInHex.length()) {
                txtInByte[j++] = (byte)Integer.parseInt(txtInHex.substring(i, i + 2), 16);
                i += 2;
            }
            String txt = new String(txtInByte, "UTF8");
            return txt;
        }
        return "";
    }

    public static Object jsonNodeToObject(InputStream is, String encoding, Map map) throws Exception {
        return JsonUtils.jsonNodeToObject(is, encoding, map, false);
    }

    public static Object createObjectWithAnnotation(Object o, Class clazz) throws Exception {
        return GenericObjectDeserializer.deserialize(clazz, o);
    }

    public static Object serializeObjectWithAnnotation(Object source) throws Exception {
        return GenericObjectDeserializer.serialize(source);
    }

    public static void convertJsonToXml(InputStream in, OutputStream out, String inEncoding, String outEncoding, boolean addProcessingInstructionEncoding, Map<String, String> inputParams) throws XMLStreamException, IOException {
        JsonUtils.convertJsonToXml(in, out, inEncoding, outEncoding, addProcessingInstructionEncoding, false, inputParams, "1.0");
    }
}

