/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.xml.internal;

import com.indy.runtime.json.internal.Path;
import com.indy.runtime.utils.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class XmlSplitter {
    BlockingQueue<File> list = new ArrayBlockingQueue<File>(10000);
    Path path;
    InputStream is;
    private int number;
    File workDir;
    Path currentPath = new Path();
    File lastFile = new File("lastFile");
    boolean end;

    public XmlSplitter(InputStream is, String _path, int number, File string) throws XMLStreamException, FactoryConfigurationError {
        this.is = is;
        this.path = new Path(_path, "/");
        this.number = number;
        this.workDir = string;
    }

    public static void main(String[] args) throws FactoryConfigurationError, Exception {
        XmlSplitter split = new XmlSplitter(new FileInputStream("D:\\work\\stambiaRuntime\\samples\\xml\\geography.xml"), "geography/state", 2, new File("D:\\work\\stambiaRuntime\\samples\\xml\\"));
        split.start();
        InputStream is = split.take();
        int i = 0;
        while (is != null) {
            IOUtils.copy(is, new FileOutputStream(new File("D:\\work\\stambiaRuntime\\samples\\xml\\" + ++i + ".xml")));
            is = split.take();
        }
        System.exit(0);
        System.out.println();
    }

    public void start() throws XMLStreamException, IOException, InterruptedException {
        XMLEventWriter writer = null;
        OutputStream os = null;
        XMLEventReader reader = null;
        try {
            XMLInputFactory ifactory = XMLInputFactory.newInstance();
            ifactory.setProperty("javax.xml.stream.supportDTD", false);
            ifactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            reader = ifactory.createXMLEventReader(this.is);
            Stack<XMLEvent> wrapStack = new Stack<XMLEvent>();
            int proof = -1;
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            File current = null;
            boolean before = false;
            int nb = 0;
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (proof == -1) {
                    if (event.isStartElement()) {
                        this.currentPath.addSegment(event.asStartElement().getName().getLocalPart());
                        if (this.currentPath.equals(this.path)) {
                            before = true;
                            proof = 0;
                            if (nb == 0) {
                                current = this.workDir != null ? File.createTempFile("stambia-temp-file-name", ".xml", this.workDir) : File.createTempFile("stambia-temp-file-name", ".xml");
                                current.deleteOnExit();
                                os = new BufferedOutputStream(new FileOutputStream(current));
                                writer = factory.createXMLEventWriter(os);
                                Iterator it = wrapStack.iterator();
                                while (it.hasNext()) {
                                    writer.add((XMLEvent)it.next());
                                }
                            }
                        } else if (!before) {
                            wrapStack.add(event);
                        }
                    } else if (event.isEndElement()) {
                        this.currentPath.removeSegment();
                        if (!before) {
                            wrapStack.add(event);
                        }
                    } else if (!before) {
                        wrapStack.add(event);
                    }
                }
                if (proof <= -1) continue;
                writer.add(event);
                if (event.isEndElement()) {
                    --proof;
                } else if (event.isStartElement()) {
                    ++proof;
                }
                if (proof != 0) continue;
                this.currentPath.removeSegment();
                if (++nb == this.number) {
                    writer.close();
                    os.close();
                    this.list.add(current);
                    nb = 0;
                }
                proof = -1;
            }
            if (nb > 0) {
                writer.close();
                writer = null;
                os.close();
                os = null;
                this.list.add(current);
                nb = 0;
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (os != null) {
                os.close();
            }
            this.list.add(this.lastFile);
            if (reader != null) {
                reader.close();
            }
            if (this.is != null) {
                this.is.close();
            }
        }
    }

    public synchronized InputStream take() throws FileNotFoundException, InterruptedException {
        if (this.end) {
            return null;
        }
        File file = this.list.take();
        if (file == this.lastFile) {
            this.end = true;
            return null;
        }
        return new WrapInputStream(file);
    }

    class WrapInputStream
    extends FileInputStream {
        File file;

        public WrapInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.file.delete();
        }
    }
}

