/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.sap.properties;

import com.indy.addons.sap.Messages;
import com.indy.addons.sap.properties.SapConnectionComposite;
import com.indy.addons.sap.properties.SapReverse;
import com.indy.md.ui.editor.ui.MdControl;
import com.indy.md.ui.editor.ui.ReverseProvider;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.MdReverse;
import com.stambia.md.custom.ReverseEvent;
import com.stambia.md.custom.ReverseListener;
import com.stambia.md.custom.Util;
import com.stambia.md.custom.exception.ReverseException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class SapReverseComposite
extends Composite {
    private Text filter;
    private Composite compoTypes;
    private Label selectedObjectCount;
    private SapReverse sapReverse;
    private final Logger logger = LogManager.getLogger(SapReverseComposite.class);
    int count2 = 0;
    protected boolean isComplete = false;
    private ReverseProvider reverseProvider;
    private MdControl datastores;
    private boolean typeAlreadyDone = false;
    ReverseListener listener = new ReverseListener(){
        MessageConsole console = com.indy.ui.custom.out.Util.findConsole((String)Messages.SapReverseComposite_15);

        public void objectReverseStart(ReverseEvent event) throws ReverseException {
            String msg = String.valueOf(event.objectType) + ": " + event.data;
            if (event.monitor != null) {
                event.monitor.subTask(msg);
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (MessageConsoleStream msc = this.console.newMessageStream();){
                    msc.println(msg);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                SapReverseComposite.this.logger.error("Error while writing in console", (Throwable)e);
            }
        }

        public void reverseStart(ReverseEvent event) throws ReverseException {
            if (event.monitor != null) {
                event.monitor.beginTask(event.objectType, ((Object[])event.data).length);
            }
        }

        public void objectReverseEnd(ReverseEvent event) throws ReverseException {
            if (event.monitor != null) {
                event.monitor.worked(1);
            }
        }
    };

    protected SapReverseComposite(Composite parent, int style) {
        super(parent, style);
        SapReverseComposite composite = this;
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite top = new Composite((Composite)composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        top.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        top.setLayoutData((Object)data);
        this.sapReverse = new SapReverse();
        this.reverseProvider = new ReverseProvider(){

            public MdReverse getMdReverse() {
                SapReverseComposite.this.sapReverse.setNode(this.getParent());
                return SapReverseComposite.this.sapReverse;
            }

            public Object getConnection() throws Exception {
                return SapReverseComposite.this.getConnection();
            }

            public MdNode getParent() {
                return SapReverseComposite.this.getNode();
            }

            public void handleEvent() {
                SapReverseComposite.this.handePageComplete(!((List)SapReverseComposite.this.datastores.getSelection()).isEmpty());
                SapReverseComposite.this.handleEvent();
            }
        };
        this.reverseProvider.getMdReverse().addReverseListener(this.listener);
        new Label(top, 0).setText(Messages.SapReverseComposite_0);
        this.filter = new Text(top, 2048);
        this.filter.setSize(70, 20);
        data = new GridData(768);
        data.widthHint = 20;
        this.filter.setLayoutData((Object)data);
        this.reverseProvider.setFilter(this.filter);
        this.reverseProvider.createRefresh(top);
        this.reverseProvider.createAutoRefresh(top).setEnabled(false);
        this.compoTypes = new Composite((Composite)composite, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        this.compoTypes.setLayout((Layout)layout);
        data = new GridData(4, 0x1000000, true, false);
        this.compoTypes.setLayoutData((Object)data);
        Composite compoSelection = new Composite((Composite)composite, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        compoSelection.setLayout((Layout)layout);
        data = new GridData(4, 0x1000000, true, false);
        compoSelection.setLayoutData((Object)data);
        Button selectAll = new Button(compoSelection, 0);
        selectAll.setText(Messages.SapReverseComposite_3);
        selectAll.setEnabled(false);
        Button deselectAll = new Button(compoSelection, 0);
        deselectAll.setEnabled(false);
        deselectAll.setText(Messages.SapReverseComposite_4);
        final CheckboxTreeViewer ctv = MdControl.createTreeViewer((Composite)composite, (int)8, (boolean)true);
        ctv.addCheckStateListener(event -> {
            ctv.setSubtreeChecked(event.getElement(), event.getChecked());
            MdNode node = (MdNode)event.getElement();
            while (node.eContainer() instanceof MdNode && node.eContainer() != this.getNode()) {
                node = (MdNode)node.eContainer();
                if (!event.getChecked()) {
                    boolean hasChildChecked = false;
                    for (MdNode child : node.getNode()) {
                        hasChildChecked = ctv.getChecked((Object)child);
                        if (hasChildChecked) break;
                    }
                    if (hasChildChecked) break;
                    ctv.setChecked((Object)node, event.getChecked());
                    continue;
                }
                ctv.setChecked((Object)node, event.getChecked());
            }
            this.count2 = ctv.getCheckedElements().length;
            this.refreshCountLabels();
            this.reverseProvider.handleEvent();
        });
        this.datastores = new MdControl(ctv, null, 3){

            public void handleInputChanged(List elements) {
                SapReverseComposite.this.count2 = 0;
                SapReverseComposite.this.refreshCountLabels();
            }
        };
        String[] list2 = new String[]{"com.stambia.appl.sap.component"};
        this.reverseProvider.addControl(this.datastores, list2);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        ctv.getTree().setLayoutData((Object)gridData);
        selectAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TreeItem[] treeItemArray = ctv.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    SapReverseComposite.this.handePageComplete(true);
                    item.setChecked(true);
                    ++n2;
                }
                SapReverseComposite.this.refreshCountLabels();
            }
        });
        deselectAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TreeItem[] treeItemArray = ctv.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    SapReverseComposite.this.handePageComplete(false);
                    item.setChecked(false);
                    ++n2;
                }
                SapReverseComposite.this.count2 = 0;
                SapReverseComposite.this.refreshCountLabels();
            }
        });
        this.selectedObjectCount = new Label((Composite)composite, 0);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 4;
        this.selectedObjectCount.setLayoutData((Object)data);
        this.selectedObjectCount.setText(Messages.SapReverseComposite_1);
    }

    private void refreshCountLabels() {
        this.selectedObjectCount.setText(NLS.bind((String)Messages.SapReverseComposite_2, (Object)Integer.toString(this.count2)));
    }

    public ReverseProvider getReverseProvider() {
        return this.reverseProvider;
    }

    public Object getConnection() throws Exception {
        if (!SapConnectionComposite.isConnected(this.getNode())) {
            SapConnectionComposite.connect(this.getNode(), false, false);
        }
        return this.getNode().getConnection();
    }

    public abstract void handleEvent();

    public abstract void handePageComplete(boolean var1);

    public void reverse(ReverseListener listener, IProgressMonitor monitor) throws ReverseException {
        MdReverse reverse = this.reverseProvider.getMdReverse();
        if (listener != null) {
            reverse.setProgressMonitor(monitor);
        }
        try {
            this.datastores.reverse(reverse, this.getConnection(), this.getNode());
        }
        catch (ReverseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReverseException((Throwable)e);
        }
    }

    public abstract MdNode getNode();

    public void dispose() {
        super.dispose();
        try {
            SapConnectionComposite.disConnect(this.getNode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            try {
                if (!this.typeAlreadyDone) {
                    String[] stringArray = new String[]{"bapi or rfc", "idoc", "table", "data source"};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String type = stringArray[n2];
                        type = type.trim();
                        Button bType = new Button(this.compoTypes, 32);
                        bType.setText(type);
                        bType.setSelection(!type.equals("table") && !type.equals("data source"));
                        this.reverseProvider.addTypeFilter(bType);
                        ++n2;
                    }
                    this.layout();
                    this.typeAlreadyDone = true;
                }
                this.reverseProvider.refreshElements(1, true);
            }
            catch (ReverseException e) {
                this.logger.warn("Error while refreshing elements", (Throwable)e);
            }
        }
        super.setVisible(visible);
    }

    public Text getFilter() {
        return this.filter;
    }

    public void reverse() {
        try {
            MessageConsole console = com.indy.ui.custom.out.Util.findConsole((String)Messages.SapReverseComposite_17);
            console.activate();
            new ProgressMonitorDialog(this.getShell()).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SapReverseComposite.this.reverse(SapReverseComposite.this.listener, monitor);
                    }
                    catch (ReverseException e) {
                        MessageDialog.openError((Shell)SapReverseComposite.this.getShell(), (String)Messages.SapReverseComposite_18, (String)e.getCause().getMessage());
                        SapReverseComposite.this.logger.warn("Error while reversing", (Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            this.logger.warn("Interrupted", (Throwable)e1);
        }
        catch (Exception e) {
            this.logger.warn("Error while reversing", (Throwable)e);
        }
        Attribute attr = Util.getOrCreateAttributeByCode((Configuration)this.getNode(), (String)"com.stambia.appl.sap.server.objectFilter");
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)attr);
        ted.getCommandStack().execute((Command)new SetCommand((EditingDomain)ted, (EObject)attr, (EStructuralFeature)MdPackage.eINSTANCE.getAttribute_Value(), (Object)this.getFilter().getText()));
    }
}

