/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.hive.serde.filedriver;

import com.stambia.hive.serde.filedriver.Messages;
import com.stambia.jdbc.driver.InputStreamResultSet;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputSplit;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hive.common.util.HiveStringUtils;

public class FileDriverRecordReader
implements RecordReader<LongWritable, Text> {
    private char[] charsToEscape;
    private Connection cnx;
    private Statement pst;
    private InputStreamResultSet rs;
    private BufferedInputStream bufferInputStream;
    private FSDataInputStream dataInputStream;
    private StringBuffer sb;
    private long pos;
    private String escapeChar;
    private String nullString;
    private String fieldSeparator;
    private boolean hasEscapeChar;
    private boolean hasNullString;
    private boolean hasFieldSeparator;
    private int numCols;
    private static final SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    private void initFileDriverRecordReader(Path path, long startFile, JobConf jobConf) throws IOException {
        this.sb = new StringBuffer();
        this.pos = startFile;
        FileSystem fs = path.getFileSystem((Configuration)jobConf);
        this.dataInputStream = fs.open(path);
        String query = jobConf.get("stambia.hive.serde.filedriver.query");
        query = query.replace("\\\"", "\"");
        String escapeCharAsString = jobConf.get("stambia.hive.serde.filedriver.escapeChar");
        if (escapeCharAsString == null) {
            this.hasEscapeChar = false;
        } else {
            this.hasEscapeChar = true;
            this.setEscapeChar(new String(HiveStringUtils.hexStringToByte((String)escapeCharAsString)));
        }
        String nullStringAsString = jobConf.get("stambia.hive.serde.filedriver.nullString");
        if (nullStringAsString == null) {
            this.hasNullString = false;
        } else {
            this.hasNullString = true;
            this.setNullString(nullStringAsString);
        }
        String fieldSeparatorAsString = jobConf.get("stambia.hive.serde.filedriver.fieldSeparator");
        if (fieldSeparatorAsString == null) {
            this.hasFieldSeparator = false;
            throw new IOException(Messages.getString("FileDriverRecordReader.0"));
        }
        this.hasFieldSeparator = true;
        this.setFieldSeparator(new String(HiveStringUtils.hexStringToByte((String)fieldSeparatorAsString)));
        if (this.hasEscapeChar()) {
            if (this.hasFieldSeparator()) {
                this.charsToEscape = new char[2];
                this.charsToEscape[0] = this.getEscapeChar().charAt(0);
                this.charsToEscape[1] = this.getFieldSeparator().charAt(0);
            } else {
                this.charsToEscape = new char[1];
                this.charsToEscape[0] = this.getEscapeChar().charAt(0);
            }
        }
        this.bufferInputStream = new BufferedInputStream((InputStream)this.dataInputStream);
        this.bufferInputStream.skip(startFile);
        String jdbcUrl = jobConf.get("stambia.hive.serde.filedriver.url");
        String jdbcDriver = jobConf.get("stambia.hive.serde.filedriver.driver");
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(Messages.getString("FileDriverRecordReader.1") + jdbcDriver + Messages.getString("FileDriverRecordReader.2"));
        }
        try {
            this.cnx = DriverManager.getConnection(jdbcUrl);
            this.pst = this.cnx.createStatement();
            this.rs = (InputStreamResultSet)this.pst.executeQuery(query);
            this.rs.setInputStream(this.bufferInputStream);
            this.numCols = this.rs.getMetaData().getColumnCount();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public FileDriverRecordReader(FileSplit pFileInput, JobConf pJobConf, Reporter pReporter) throws IOException {
        Path path = pFileInput.getPath();
        long startFile = pFileInput.getStart();
        this.initFileDriverRecordReader(path, startFile, pJobConf);
    }

    public FileDriverRecordReader(CombineFileSplit pFileSplit, Configuration pJobConf, Reporter pReporter, Integer idx) throws IOException {
        Path path = pFileSplit.getPaths()[idx];
        long startFile = pFileSplit.getStartOffsets()[idx];
        this.initFileDriverRecordReader(path, startFile, (JobConf)pJobConf);
    }

    public FileDriverRecordReader(BucketizedHiveInputSplit pFileSplit, JobConf pJobConf, Reporter pReporter, Integer idx) throws IOException {
        Path path = pFileSplit.getPath();
        long startFile = pFileSplit.getStart();
        this.initFileDriverRecordReader(path, startFile, pJobConf);
    }

    public void close() throws IOException {
        try {
            this.rs.close();
            this.pst.close();
            this.cnx.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public Text createValue() {
        return new Text();
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    public boolean next(LongWritable key, Text value) throws IOException {
        boolean ret = false;
        key.set(this.getPos());
        this.sb.setLength(0);
        try {
            ret = this.rs.next();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        if (ret) {
            try {
                for (int i = 1; i <= this.numCols; ++i) {
                    this.sb.append(this.formatOutput(this.rs.getObject(i), i));
                    if (i >= this.numCols || !this.hasFieldSeparator()) continue;
                    this.sb.append(this.getFieldSeparator());
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        value.set(this.sb.toString());
        return ret;
    }

    public String formatOutput(Object obj, int jdbcColIndex) {
        if (obj == null) {
            String ret = this.hasNullString() ? this.getNullString() : "";
            return ret;
        }
        String ret = obj instanceof String ? (String)obj : (obj instanceof Timestamp ? timestampFormatter.format((Timestamp)obj) : (obj instanceof Date ? timestampFormatter.format((Date)obj) : obj.toString()));
        if (this.hasEscapeChar()) {
            ret = HiveStringUtils.escapeString((String)ret, (char)this.getEscapeChar().charAt(0), (char[])this.charsToEscape);
        }
        return ret;
    }

    public String getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
    }

    public String getNullString() {
        return this.nullString;
    }

    public boolean hasNullString() {
        return this.hasNullString;
    }

    public boolean hasEscapeChar() {
        return this.hasEscapeChar;
    }

    public boolean hasFieldSeparator() {
        return this.hasFieldSeparator;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }
}

