/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.hive.serde.filedriver;

import com.stambia.hive.serde.filedriver.FileDriverInputFormat;
import com.stambia.hive.serde.filedriver.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.HiveStringUtils;

public class FileDriverStorageHandler
extends DefaultStorageHandler {
    public static final String QUERY_PROPERTY = "stambia.hive.serde.filedriver.query";
    public static final String DRIVER_CLASS_PROPERTY = "stambia.hive.serde.filedriver.driver";
    public static final String DRIVER_URL_PROPERTY = "stambia.hive.serde.filedriver.url";
    public static final String TABLE_NAME_PROPERTY = "stambia.hive.serde.filedriver.tableName";
    public static final String DATABASE_NAME_PROPERTY = "stambia.hive.serde.filedriver.databaseName";
    public static final String ESCAPE_CHAR_PROPERTY = "stambia.hive.serde.filedriver.escapeChar";
    public static final String NULL_STRING_PROPERTY = "stambia.hive.serde.filedriver.nullString";
    public static final String FIELD_SEPARATOR_PROPERTY = "stambia.hive.serde.filedriver.fieldSeparator";

    private void extractInfosFromTableDesc(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tblProps = tableDesc.getProperties();
        String realDatabaseName = this.getRealDatabaseName(tblProps.getProperty(DATABASE_NAME_PROPERTY));
        String realTableName = this.getRealTableName(realDatabaseName, tblProps.getProperty(TABLE_NAME_PROPERTY));
        LazySimpleSerDe.SerDeParameters params = null;
        try {
            params = LazySimpleSerDe.initSerdeParams((Configuration)this.getConf(), (Properties)tableDesc.getProperties(), (String)LazySimpleSerDe.class.getName());
        }
        catch (SerDeException e) {
            throw new RuntimeException(Messages.getString("FileDriverStorageHandler.0"));
        }
        byte[] escapeCharBytes = new byte[]{params.getEscapeChar()};
        byte[] fieldSeparatorBytes = new byte[]{params.getSeparators()[0]};
        Object queryProperty = "";
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        for (Object key : tblProps.keySet()) {
            if (key instanceof String) {
                if (!((String)key).startsWith(QUERY_PROPERTY)) continue;
                String curKey = (String)key;
                sortedMap.put(curKey, tblProps.getProperty(curKey));
                continue;
            }
            throw new RuntimeException(Messages.getString("FileDriverStorageHandler.1"));
        }
        for (String s : sortedMap.keySet()) {
            queryProperty = (String)queryProperty + tblProps.getProperty(s);
        }
        jobProperties.put(QUERY_PROPERTY, (String)queryProperty);
        jobProperties.put(DRIVER_CLASS_PROPERTY, tblProps.getProperty(DRIVER_CLASS_PROPERTY));
        jobProperties.put(DRIVER_URL_PROPERTY, tblProps.getProperty(DRIVER_URL_PROPERTY));
        jobProperties.put(DATABASE_NAME_PROPERTY, realDatabaseName);
        jobProperties.put(TABLE_NAME_PROPERTY, realTableName);
        jobProperties.put(ESCAPE_CHAR_PROPERTY, HiveStringUtils.byteToHexString((byte[])escapeCharBytes));
        jobProperties.put(NULL_STRING_PROPERTY, params.getNullSequence().toString());
        jobProperties.put(FIELD_SEPARATOR_PROPERTY, HiveStringUtils.byteToHexString((byte[])fieldSeparatorBytes));
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        super.configureInputJobProperties(tableDesc, jobProperties);
        HashMap<String, String> computedJobProperties = new HashMap<String, String>();
        this.extractInfosFromTableDesc(tableDesc, computedJobProperties);
        for (String key : computedJobProperties.keySet()) {
            jobProperties.put(key, (String)computedJobProperties.get(key));
        }
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        super.configureTableJobProperties(tableDesc, jobProperties);
        HashMap<String, String> computedJobProperties = new HashMap<String, String>();
        this.extractInfosFromTableDesc(tableDesc, computedJobProperties);
        for (String key : computedJobProperties.keySet()) {
            jobProperties.put(key, (String)computedJobProperties.get(key));
        }
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        super.configureOutputJobProperties(tableDesc, jobProperties);
        HashMap<String, String> computedJobProperties = new HashMap<String, String>();
        this.extractInfosFromTableDesc(tableDesc, computedJobProperties);
        for (String key : computedJobProperties.keySet()) {
            jobProperties.put(key, (String)computedJobProperties.get(key));
        }
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        super.configureJobConf(tableDesc, jobConf);
        HashMap<String, String> computedJobProperties = new HashMap<String, String>();
        this.extractInfosFromTableDesc(tableDesc, computedJobProperties);
        for (String key : computedJobProperties.keySet()) {
            jobConf.set(key, (String)computedJobProperties.get(key));
        }
    }

    public String getRealDatabaseName(String databaseName) {
        List dbList = null;
        try {
            Hive hive = Hive.get();
            dbList = hive.getAllDatabases();
        }
        catch (HiveException e) {
            return null;
        }
        return this.getStringFromListCaseInsensitive(databaseName, dbList);
    }

    public String getRealTableName(String databaseName, String tableName) {
        List tableList = null;
        try {
            Hive hive = Hive.get();
            tableList = hive.getAllTables(databaseName);
        }
        catch (HiveException e) {
            return null;
        }
        return this.getStringFromListCaseInsensitive(tableName, tableList);
    }

    public String getStringFromListCaseInsensitive(String pSearchString, List<String> pList) {
        Pattern pattern = Pattern.compile(pSearchString, 2);
        ListIterator<String> iterator = pList.listIterator();
        while (iterator.hasNext()) {
            String curObject = iterator.next();
            Matcher matcher = pattern.matcher(curObject);
            if (!matcher.matches()) continue;
            return curObject;
        }
        return null;
    }

    public Class<? extends InputFormat<LongWritable, Text>> getInputFormatClass() {
        return FileDriverInputFormat.class;
    }
}

